/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.parse;

import com.espertech.esper.common.internal.compile.stage1.spec.ContextNested;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecCategory;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecCategoryItem;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecCondition;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecConditionCrontab;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecConditionFilter;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecConditionImmediate;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecConditionNever;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecConditionPattern;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecConditionTimePeriod;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecHash;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecHashItem;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecInitiatedTerminated;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecKeyed;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecKeyedItem;
import com.espertech.esper.common.internal.compile.stage1.spec.CreateContextDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.FilterSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.PropertyEvalSpec;
import com.espertech.esper.common.internal.epl.expression.chain.Chainable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.time.node.ExprTimePeriod;
import com.espertech.esper.common.internal.epl.pattern.core.EvalForgeNode;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.compiler.internal.generated.EsperEPL2GrammarParser;
import com.espertech.esper.compiler.internal.parse.ASTChainSpecHelper;
import com.espertech.esper.compiler.internal.parse.ASTConstantHelper;
import com.espertech.esper.compiler.internal.parse.ASTExprHelper;
import com.espertech.esper.compiler.internal.parse.ASTFilterSpecHelper;
import com.espertech.esper.compiler.internal.parse.ASTUtil;
import com.espertech.esper.compiler.internal.parse.ASTWalkException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.Tree;

public class ASTContextHelper {
    public static CreateContextDesc walkCreateContext(EsperEPL2GrammarParser.CreateContextExprContext ctx, Map<Tree, ExprNode> astExprNodeMap, Map<Tree, EvalForgeNode> astPatternNodeMap, PropertyEvalSpec propertyEvalSpec, FilterSpecRaw filterSpec) {
        String contextName = ctx.name.getText();
        EsperEPL2GrammarParser.CreateContextChoiceContext choice = ctx.createContextDetail().createContextChoice();
        ContextSpec contextDetail = choice != null ? ASTContextHelper.walkChoice(choice, astExprNodeMap, astPatternNodeMap, propertyEvalSpec) : ASTContextHelper.walkNested(ctx.createContextDetail().contextContextNested(), astExprNodeMap, astPatternNodeMap, propertyEvalSpec, filterSpec);
        return new CreateContextDesc(contextName, contextDetail);
    }

    private static ContextSpec walkNested(List<EsperEPL2GrammarParser.ContextContextNestedContext> nestedContexts, Map<Tree, ExprNode> astExprNodeMap, Map<Tree, EvalForgeNode> astPatternNodeMap, PropertyEvalSpec propertyEvalSpec, FilterSpecRaw filterSpec) {
        ArrayList<CreateContextDesc> contexts = new ArrayList<CreateContextDesc>(nestedContexts.size());
        for (EsperEPL2GrammarParser.ContextContextNestedContext nestedctx : nestedContexts) {
            ContextSpec contextDetail = ASTContextHelper.walkChoice(nestedctx.createContextChoice(), astExprNodeMap, astPatternNodeMap, propertyEvalSpec);
            CreateContextDesc desc = new CreateContextDesc(nestedctx.name.getText(), contextDetail);
            contexts.add(desc);
        }
        return new ContextNested(contexts);
    }

    private static ContextSpec walkChoice(EsperEPL2GrammarParser.CreateContextChoiceContext ctx, Map<Tree, ExprNode> astExprNodeMap, Map<Tree, EvalForgeNode> astPatternNodeMap, PropertyEvalSpec propertyEvalSpec) {
        if (ctx.START() != null || ctx.INITIATED() != null) {
            Object startEndpoint;
            boolean immediate;
            ExprNode[] distinctExpressions = null;
            if (ctx.createContextDistinct() != null) {
                distinctExpressions = ctx.createContextDistinct().expressionList() == null ? ExprNodeUtilityQuery.EMPTY_EXPR_ARRAY : ASTExprHelper.exprCollectSubNodesPerNode(ctx.createContextDistinct().expressionList().expression(), astExprNodeMap);
            }
            if (ctx.START() != null) {
                immediate = ASTContextHelper.checkNow(ctx.i);
                startEndpoint = immediate ? ContextSpecConditionImmediate.INSTANCE : ASTContextHelper.getContextCondition(ctx.r1, astExprNodeMap, astPatternNodeMap, propertyEvalSpec, false);
            } else {
                immediate = ASTContextHelper.checkNow(ctx.i);
                startEndpoint = ASTContextHelper.getContextCondition(ctx.r1, astExprNodeMap, astPatternNodeMap, propertyEvalSpec, immediate);
            }
            boolean overlapping = ctx.INITIATED() != null;
            ContextSpecCondition endEndpoint = ASTContextHelper.getContextCondition(ctx.r2, astExprNodeMap, astPatternNodeMap, propertyEvalSpec, false);
            return new ContextSpecInitiatedTerminated((ContextSpecCondition)startEndpoint, endEndpoint, overlapping, distinctExpressions);
        }
        if (ctx.PARTITION() != null) {
            List<EsperEPL2GrammarParser.CreateContextPartitionItemContext> partitions = ctx.createContextPartitionItem();
            ArrayList<ContextSpecKeyedItem> rawSpecs = new ArrayList<ContextSpecKeyedItem>();
            for (EsperEPL2GrammarParser.CreateContextPartitionItemContext partition : partitions) {
                FilterSpecRaw filterSpec = ASTFilterSpecHelper.walkFilterSpec(partition.eventFilterExpression(), propertyEvalSpec, astExprNodeMap);
                propertyEvalSpec = null;
                ArrayList<String> propertyNames = new ArrayList<String>();
                List<EsperEPL2GrammarParser.ChainableContext> properties = partition.chainable();
                for (EsperEPL2GrammarParser.ChainableContext property : properties) {
                    String propertyName = ASTUtil.getPropertyName(property, 0);
                    propertyNames.add(propertyName);
                }
                ASTExprHelper.exprCollectSubNodes((Tree)partition, 0, astExprNodeMap);
                rawSpecs.add(new ContextSpecKeyedItem(filterSpec, propertyNames, partition.keywordAllowedIdent() == null ? null : partition.keywordAllowedIdent().getText()));
            }
            List<ContextSpecConditionFilter> optionalInit = null;
            if (ctx.createContextPartitionInit() != null) {
                optionalInit = ASTContextHelper.getContextPartitionInit(ctx.createContextPartitionInit().createContextFilter(), astExprNodeMap);
            }
            ContextSpecCondition optionalTermination = null;
            if (ctx.createContextPartitionTerm() != null) {
                optionalTermination = ASTContextHelper.getContextCondition(ctx.createContextPartitionTerm().createContextRangePoint(), astExprNodeMap, astPatternNodeMap, propertyEvalSpec, false);
            }
            return new ContextSpecKeyed(rawSpecs, optionalInit, optionalTermination);
        }
        if (ctx.COALESCE() != null) {
            String preallocateStr;
            List<EsperEPL2GrammarParser.CreateContextCoalesceItemContext> coalesces = ctx.createContextCoalesceItem();
            ArrayList<ContextSpecHashItem> rawSpecs = new ArrayList<ContextSpecHashItem>(coalesces.size());
            for (EsperEPL2GrammarParser.CreateContextCoalesceItemContext coalesce : coalesces) {
                List<Chainable> chain = ASTChainSpecHelper.getChainables(coalesce.chainable(), astExprNodeMap);
                Chainable func = chain.get(0);
                FilterSpecRaw filterSpec = ASTFilterSpecHelper.walkFilterSpec(coalesce.eventFilterExpression(), propertyEvalSpec, astExprNodeMap);
                propertyEvalSpec = null;
                rawSpecs.add(new ContextSpecHashItem(func, filterSpec));
            }
            String granularity = ctx.g.getText();
            if (!granularity.toLowerCase(Locale.ENGLISH).equals("granularity")) {
                throw ASTWalkException.from("Expected 'granularity' keyword after list of coalesce items, found '" + granularity + "' instead");
            }
            Number num = (Number)ASTConstantHelper.parse((ParseTree)ctx.number());
            String string = preallocateStr = ctx.p != null ? ctx.p.getText() : null;
            if (preallocateStr != null && !preallocateStr.toLowerCase(Locale.ENGLISH).equals("preallocate")) {
                throw ASTWalkException.from("Expected 'preallocate' keyword after list of coalesce items, found '" + preallocateStr + "' instead");
            }
            if (!JavaClassHelper.isNumericNonFP(num.getClass()) || JavaClassHelper.getBoxedType(num.getClass()) == Long.class) {
                throw ASTWalkException.from("Granularity provided must be an int-type number, received " + num.getClass() + " instead");
            }
            return new ContextSpecHash(rawSpecs, num.intValue(), preallocateStr != null);
        }
        if (ctx.createContextGroupItem() != null) {
            List<EsperEPL2GrammarParser.CreateContextGroupItemContext> grps = ctx.createContextGroupItem();
            ArrayList<ContextSpecCategoryItem> items = new ArrayList<ContextSpecCategoryItem>();
            for (EsperEPL2GrammarParser.CreateContextGroupItemContext grp : grps) {
                ExprNode exprNode = ASTExprHelper.exprCollectSubNodes((Tree)grp, 0, astExprNodeMap).get(0);
                String name = grp.i.getText();
                items.add(new ContextSpecCategoryItem(exprNode, name));
            }
            FilterSpecRaw filterSpec = ASTFilterSpecHelper.walkFilterSpec(ctx.eventFilterExpression(), propertyEvalSpec, astExprNodeMap);
            return new ContextSpecCategory(items, filterSpec);
        }
        throw new IllegalStateException("Unrecognized context detail type");
    }

    private static List<ContextSpecConditionFilter> getContextPartitionInit(List<EsperEPL2GrammarParser.CreateContextFilterContext> ctxs, Map<Tree, ExprNode> astExprNodeMap) {
        ArrayList<ContextSpecConditionFilter> filters = new ArrayList<ContextSpecConditionFilter>(ctxs.size());
        for (EsperEPL2GrammarParser.CreateContextFilterContext ctx : ctxs) {
            filters.add(ASTContextHelper.getContextDetailConditionFilter(ctx, null, astExprNodeMap));
        }
        return filters;
    }

    private static ContextSpecCondition getContextCondition(EsperEPL2GrammarParser.CreateContextRangePointContext ctx, Map<Tree, ExprNode> astExprNodeMap, Map<Tree, EvalForgeNode> astPatternNodeMap, PropertyEvalSpec propertyEvalSpec, boolean immediate) {
        if (ctx == null) {
            return ContextSpecConditionNever.INSTANCE;
        }
        if (ctx.crontabLimitParameterSetList() != null) {
            ArrayList<List<ExprNode>> crontabs = new ArrayList<List<ExprNode>>();
            for (EsperEPL2GrammarParser.CrontabLimitParameterSetContext crontabCtx : ctx.crontabLimitParameterSetList().crontabLimitParameterSet()) {
                List<ExprNode> crontab = ASTExprHelper.exprCollectSubNodes((Tree)crontabCtx, 0, astExprNodeMap);
                crontabs.add(crontab);
            }
            return new ContextSpecConditionCrontab(crontabs, immediate);
        }
        if (ctx.patternInclusionExpression() != null) {
            EvalForgeNode evalNode = ASTExprHelper.patternGetRemoveTopNode((Tree)ctx.patternInclusionExpression(), astPatternNodeMap);
            boolean inclusive = false;
            if (ctx.i != null) {
                String ident = ctx.i.getText();
                if (ident != null && !ident.toLowerCase(Locale.ENGLISH).equals("inclusive")) {
                    throw ASTWalkException.from("Expected 'inclusive' keyword after '@', found '" + ident + "' instead");
                }
                inclusive = true;
            }
            return new ContextSpecConditionPattern(evalNode, inclusive, immediate);
        }
        if (ctx.createContextFilter() != null) {
            if (immediate) {
                throw ASTWalkException.from("Invalid use of 'now' with initiated-by stream, this combination is not supported");
            }
            return ASTContextHelper.getContextDetailConditionFilter(ctx.createContextFilter(), propertyEvalSpec, astExprNodeMap);
        }
        if (ctx.AFTER() != null) {
            ExprTimePeriod timePeriod = (ExprTimePeriod)ASTExprHelper.exprCollectSubNodes((Tree)ctx.timePeriod(), 0, astExprNodeMap).get(0);
            return new ContextSpecConditionTimePeriod(timePeriod, immediate);
        }
        throw new IllegalStateException("Unrecognized child type");
    }

    private static ContextSpecConditionFilter getContextDetailConditionFilter(EsperEPL2GrammarParser.CreateContextFilterContext ctx, PropertyEvalSpec propertyEvalSpec, Map<Tree, ExprNode> astExprNodeMap) {
        FilterSpecRaw filterSpecRaw = ASTFilterSpecHelper.walkFilterSpec(ctx.eventFilterExpression(), propertyEvalSpec, astExprNodeMap);
        String asName = ctx.i != null ? ctx.i.getText() : null;
        return new ContextSpecConditionFilter(filterSpecRaw, asName);
    }

    private static boolean checkNow(Token i) {
        if (i == null) {
            return false;
        }
        String ident = i.getText();
        if (!ident.toLowerCase(Locale.ENGLISH).equals("now")) {
            throw ASTWalkException.from("Expected 'now' keyword after '@', found '" + ident + "' instead");
        }
        return true;
    }
}

