/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.parse;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.internal.compile.stage1.spec.ColumnDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.CreateSchemaDesc;
import com.espertech.esper.common.internal.type.ClassIdentifierWArray;
import com.espertech.esper.compiler.internal.generated.EsperEPL2GrammarParser;
import com.espertech.esper.compiler.internal.parse.ASTClassIdentifierHelper;
import com.espertech.esper.compiler.internal.parse.ASTUtil;
import com.espertech.esper.compiler.internal.parse.ASTWalkException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.antlr.v4.runtime.Token;

public class ASTCreateSchemaHelper {
    public static CreateSchemaDesc walkCreateSchema(EsperEPL2GrammarParser.CreateSchemaExprContext ctx) throws EPException {
        CreateSchemaDesc.AssignedType assignedType = CreateSchemaDesc.AssignedType.NONE;
        if (ctx.keyword != null) {
            assignedType = CreateSchemaDesc.AssignedType.parseKeyword((String)ctx.keyword.getText());
        }
        return ASTCreateSchemaHelper.getSchemaDesc(ctx.createSchemaDef(), assignedType);
    }

    private static CreateSchemaDesc getSchemaDesc(EsperEPL2GrammarParser.CreateSchemaDefContext ctx, CreateSchemaDesc.AssignedType assignedType) throws EPException {
        String schemaName = ctx.name.getText();
        List<ColumnDesc> columnTypes = ASTCreateSchemaHelper.getColTypeList(ctx.createColumnList());
        LinkedHashSet<String> typeNames = new LinkedHashSet<String>();
        if (ctx.variantList() != null) {
            List<EsperEPL2GrammarParser.VariantListElementContext> variantCtxs = ctx.variantList().variantListElement();
            for (EsperEPL2GrammarParser.VariantListElementContext variantCtx : variantCtxs) {
                typeNames.add(variantCtx.getText());
            }
        }
        String startTimestamp = null;
        String endTimestamp = null;
        LinkedHashSet<String> inherited = new LinkedHashSet<String>();
        LinkedHashSet<String> copyFrom = new LinkedHashSet<String>();
        if (ctx.createSchemaQual() != null) {
            List<EsperEPL2GrammarParser.CreateSchemaQualContext> qualCtxs = ctx.createSchemaQual();
            for (EsperEPL2GrammarParser.CreateSchemaQualContext qualCtx : qualCtxs) {
                String qualName = qualCtx.i.getText().toLowerCase(Locale.ENGLISH);
                List<String> cols = ASTUtil.getIdentList(qualCtx.columnList());
                if (qualName.toLowerCase(Locale.ENGLISH).equals("inherits")) {
                    inherited.addAll(cols);
                    continue;
                }
                if (qualName.toLowerCase(Locale.ENGLISH).equals("starttimestamp")) {
                    startTimestamp = cols.get(0);
                    continue;
                }
                if (qualName.toLowerCase(Locale.ENGLISH).equals("endtimestamp")) {
                    endTimestamp = cols.get(0);
                    continue;
                }
                if (qualName.toLowerCase(Locale.ENGLISH).equals("copyfrom")) {
                    copyFrom.addAll(cols);
                    continue;
                }
                throw new EPException("Expected 'inherits', 'starttimestamp', 'endtimestamp' or 'copyfrom' keyword after create-schema clause but encountered '" + qualName + "'");
            }
        }
        return new CreateSchemaDesc(schemaName, typeNames, columnTypes, inherited, assignedType, startTimestamp, endTimestamp, copyFrom);
    }

    public static List<ColumnDesc> getColTypeList(EsperEPL2GrammarParser.CreateColumnListContext ctx) {
        if (ctx == null) {
            return Collections.emptyList();
        }
        ArrayList<ColumnDesc> result = new ArrayList<ColumnDesc>(ctx.createColumnListElement().size());
        for (EsperEPL2GrammarParser.CreateColumnListElementContext colctx : ctx.createColumnListElement()) {
            EsperEPL2GrammarParser.ClassIdentifierContext colname = colctx.classIdentifier();
            String name = ASTUtil.unescapeClassIdent(colname);
            ClassIdentifierWArray classIdent = ASTClassIdentifierHelper.walk(colctx.classIdentifierWithDimensions());
            result.add(new ColumnDesc(name, classIdent == null ? null : classIdent.toEPL()));
        }
        return result;
    }

    protected static boolean validateIsPrimitiveArray(Token p) {
        if (p != null) {
            if (!p.getText().toLowerCase(Locale.ENGLISH).equals("primitive")) {
                throw ASTWalkException.from("Column type keyword '" + p.getText() + "' not recognized, expecting '[" + "primitive" + "]'");
            }
            return true;
        }
        return false;
    }
}

