/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.parse;

import com.espertech.esper.common.internal.epl.expression.dot.walk.DotEscaper;
import com.espertech.esper.common.internal.util.StringValue;
import com.espertech.esper.compiler.internal.generated.EsperEPL2GrammarParser;
import com.espertech.esper.compiler.internal.parse.ASTWalkException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASTUtil {
    private static final Logger log = LoggerFactory.getLogger(ASTUtil.class);
    private static final String PROPERTY_ENABLED_AST_DUMP = "ENABLE_AST_DUMP";

    public static List<String> getIdentList(EsperEPL2GrammarParser.ColumnListKeywordAllowedContext ctx) {
        if (ctx == null || ctx.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> parameters = new ArrayList<String>(ctx.keywordAllowedIdent().size());
        for (EsperEPL2GrammarParser.KeywordAllowedIdentContext ident : ctx.keywordAllowedIdent()) {
            parameters.add(ident.getText());
        }
        return parameters;
    }

    public static List<String> getIdentList(EsperEPL2GrammarParser.ColumnListContext ctx) {
        if (ctx == null || ctx.isEmpty()) {
            return Collections.emptyList();
        }
        List<TerminalNode> idents = ctx.IDENT();
        ArrayList<String> parameters = new ArrayList<String>(idents.size());
        for (TerminalNode ident : idents) {
            parameters.add(ident.getText());
        }
        return parameters;
    }

    public static boolean isTerminatedOfType(Tree child, int tokenType) {
        if (!(child instanceof TerminalNode)) {
            return false;
        }
        TerminalNode termNode = (TerminalNode)child;
        return termNode.getSymbol().getType() == tokenType;
    }

    public static int getRuleIndexIfProvided(ParseTree tree) {
        if (!(tree instanceof RuleNode)) {
            return -1;
        }
        RuleNode ruleNode = (RuleNode)tree;
        return ruleNode.getRuleContext().getRuleIndex();
    }

    public static int getAssertTerminatedTokenType(ParseTree child) {
        if (!(child instanceof TerminalNode)) {
            throw ASTWalkException.from("Unexpected exception walking AST, expected terminal node", child.getText());
        }
        TerminalNode term = (TerminalNode)child;
        return term.getSymbol().getType();
    }

    public static String printNode(Tree node) {
        StringWriter buf = new StringWriter();
        PrintWriter writer = new PrintWriter(buf);
        ASTUtil.dumpAST(writer, node, 0);
        return buf.toString();
    }

    public static boolean isRecursiveParentRule(ParserRuleContext ctx, Set<Integer> rulesIds) {
        ParserRuleContext parent = ctx.getParent();
        if (parent == null) {
            return false;
        }
        return rulesIds.contains(parent.getRuleIndex()) || ASTUtil.isRecursiveParentRule(parent, rulesIds);
    }

    public static void dumpAST(Tree ast) {
        if (System.getProperty(PROPERTY_ENABLED_AST_DUMP) != null) {
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            ASTUtil.renderNode(new char[0], ast, printer);
            ASTUtil.dumpAST(printer, ast, 2);
            log.info(".dumpAST ANTLR Tree dump follows...\n" + writer.toString());
        }
    }

    public static void dumpAST(PrintWriter printer, Tree ast, int ident) {
        char[] identChars = new char[ident];
        Arrays.fill(identChars, ' ');
        if (ast == null) {
            ASTUtil.renderNode(identChars, null, printer);
            return;
        }
        for (int i = 0; i < ast.getChildCount(); ++i) {
            Tree node = ast.getChild(i);
            if (node == null) {
                throw new NullPointerException("Null AST node");
            }
            ASTUtil.renderNode(identChars, node, printer);
            ASTUtil.dumpAST(printer, node, ident + 2);
        }
    }

    public static void printTokens(CommonTokenStream tokens) {
        if (log.isDebugEnabled()) {
            List tokenList = tokens.getTokens();
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            for (int i = 0; i < tokens.size(); ++i) {
                Token t = (Token)tokenList.get(i);
                String text = t.getText();
                if (text.trim().length() == 0) {
                    printer.print("'" + text + "'");
                } else {
                    printer.print(text);
                }
                printer.print('[');
                printer.print(t.getType());
                printer.print(']');
                printer.print(" ");
            }
            printer.println();
            log.debug("Tokens: " + writer.toString());
        }
    }

    private static void renderNode(char[] ident, Tree node, PrintWriter printer) {
        printer.print(ident);
        if (node == null) {
            printer.print("NULL NODE");
        } else {
            if (node instanceof ParserRuleContext) {
                ParserRuleContext ctx = (ParserRuleContext)node;
                int ruleIndex = ctx.getRuleIndex();
                String ruleName = EsperEPL2GrammarParser.ruleNames[ruleIndex];
                printer.print(ruleName);
            } else {
                TerminalNode terminal = (TerminalNode)node;
                printer.print(terminal.getSymbol().getText());
                printer.print(" [");
                printer.print(terminal.getSymbol().getType());
                printer.print("]");
            }
            if (node instanceof ParseTree) {
                ParseTree parseTree = (ParseTree)node;
                if (parseTree.getText() == null) {
                    printer.print(" (null value in text)");
                } else if (parseTree.getText().contains("\\")) {
                    int count = 0;
                    for (int i = 0; i < parseTree.getText().length(); ++i) {
                        if (parseTree.getText().charAt(i) != '\\') continue;
                        ++count;
                    }
                    printer.print(" (" + count + " backlashes)");
                }
            }
        }
        printer.println();
    }

    public static String getPropertyName(EsperEPL2GrammarParser.ChainableContext ctx, int startNode) {
        StringBuilder buf = new StringBuilder();
        for (int i = startNode; i < ctx.getChildCount(); ++i) {
            ParseTree tree = ctx.getChild(i);
            buf.append(tree.getText());
        }
        return buf.toString();
    }

    public static String unescapeClassIdent(EsperEPL2GrammarParser.ClassIdentifierContext classIdentCtx) {
        return ASTUtil.unescapeEscapableStr(classIdentCtx.escapableStr(), ".");
    }

    public static String unescapeSlashIdentifier(EsperEPL2GrammarParser.SubstitutionSlashIdentContext ctx) {
        String name = ASTUtil.unescapeEscapableStr(ctx.escapableStr(), "/");
        if (ctx.d != null) {
            name = "/" + name;
        }
        return name;
    }

    private static String unescapeEscapableStr(List<EsperEPL2GrammarParser.EscapableStrContext> ctxs, String delimiterConst) {
        if (ctxs.size() == 1) {
            return StringValue.unescapeBacktick((String)DotEscaper.unescapeDot((String)ctxs.get(0).getText()));
        }
        StringWriter writer = new StringWriter();
        String delimiter = "";
        for (EsperEPL2GrammarParser.EscapableStrContext ctx : ctxs) {
            writer.append(delimiter);
            writer.append(StringValue.unescapeBacktick((String)DotEscaper.unescapeDot((String)ctx.getText())));
            delimiter = delimiterConst;
        }
        return writer.toString();
    }

    public static String getStreamNameUnescapedOptional(EsperEPL2GrammarParser.IdentOrTickedContext ctx) {
        return ctx != null ? StringValue.unescapeBacktick((String)ctx.getText()) : null;
    }
}

