/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.util;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.context.util.ByteArrayProvidingClassLoader;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.compiler.internal.util.CompilableItemPostCompileLatch;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public class CompilableItemPostCompileLatchJson
implements CompilableItemPostCompileLatch {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final Collection<EventType> eventTypes;
    private final ClassLoader parentClassLoader;
    private Map<String, byte[]> moduleBytes;

    public CompilableItemPostCompileLatchJson(Collection<EventType> eventTypes, ClassLoader parentClassLoader) {
        this.eventTypes = eventTypes;
        this.parentClassLoader = parentClassLoader;
    }

    @Override
    public void awaitAndRun() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        for (EventType eventType : this.eventTypes) {
            if (!(eventType instanceof JsonEventType)) continue;
            JsonEventType jsonEventType = (JsonEventType)eventType;
            ByteArrayProvidingClassLoader classLoader = new ByteArrayProvidingClassLoader(this.moduleBytes, this.parentClassLoader);
            jsonEventType.initialize((ClassLoader)classLoader);
        }
    }

    @Override
    public void completed(Map<String, byte[]> moduleBytes) {
        this.moduleBytes = moduleBytes;
        this.latch.countDown();
    }
}

