/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.util;

import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.compile.stage3.ModuleCompileTimeServices;
import com.espertech.esper.compiler.internal.util.CompilableItem;
import com.espertech.esper.compiler.internal.util.CompilableItemResult;
import com.espertech.esper.compiler.internal.util.JaninoCompiler;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;

public class CompileCallable
implements Callable<CompilableItemResult> {
    private final CompilableItem compilableItem;
    private final ModuleCompileTimeServices compileTimeServices;
    private final Semaphore semaphore;
    private final ConcurrentHashMap<String, byte[]> statementBytes;

    CompileCallable(CompilableItem compilableItem, ModuleCompileTimeServices compileTimeServices, Semaphore semaphore, ConcurrentHashMap<String, byte[]> statementBytes) {
        this.compilableItem = compilableItem;
        this.compileTimeServices = compileTimeServices;
        this.semaphore = semaphore;
        this.statementBytes = statementBytes;
    }

    @Override
    public CompilableItemResult call() throws Exception {
        try {
            for (CodegenClass clazz : this.compilableItem.getClasses()) {
                JaninoCompiler.compile(clazz, this.statementBytes, this.statementBytes, this.compileTimeServices);
            }
        }
        catch (Throwable t) {
            CompilableItemResult compilableItemResult = new CompilableItemResult(t);
            return compilableItemResult;
        }
        finally {
            this.semaphore.release();
            this.compilableItem.getPostCompileLatch().completed(this.statementBytes);
        }
        return new CompilableItemResult();
    }
}

