/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.util;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationIDGenerator;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompileException;
import com.espertech.esper.common.internal.compile.stage3.ModuleCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableStmtFields;
import com.espertech.esper.common.internal.context.module.StatementFields;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodForge;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodProvider;
import com.espertech.esper.compiler.internal.util.JaninoCompiler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CompilerHelperFAFQuery {
    public static String compileQuery(FAFQueryMethodForge query, String classPostfix, Map<String, byte[]> moduleBytes, ModuleCompileTimeServices compileTimeServices) throws StatementSpecCompileException {
        String statementFieldsClassName = CodeGenerationIDGenerator.generateClassNameSimple(StatementFields.class, (String)classPostfix);
        CodegenPackageScope packageScope = new CodegenPackageScope(compileTimeServices.getPackageName(), statementFieldsClassName, compileTimeServices.isInstrumented());
        String queryMethodProviderClassName = CodeGenerationIDGenerator.generateClassNameSimple(FAFQueryMethodProvider.class, (String)classPostfix);
        List forgeablesQueryMethod = query.makeForgeables(queryMethodProviderClassName, classPostfix, packageScope);
        ArrayList<StmtClassForgeableStmtFields> forgeables = new ArrayList<StmtClassForgeableStmtFields>(forgeablesQueryMethod);
        forgeables.add(new StmtClassForgeableStmtFields(statementFieldsClassName, packageScope, 0));
        ArrayList<CodegenClass> classes = new ArrayList<CodegenClass>(forgeables.size());
        for (StmtClassForgeable stmtClassForgeable : forgeables) {
            CodegenClass clazz = stmtClassForgeable.forge(true, true);
            classes.add(clazz);
        }
        classes.sort((o1, o2) -> Integer.compare(o1.getClassType().getSortCode(), o2.getClassType().getSortCode()));
        compileTimeServices.getClassProvidedCompileTimeResolver().addTo(moduleBytes);
        for (CodegenClass codegenClass : classes) {
            JaninoCompiler.compile(codegenClass, moduleBytes, moduleBytes, compileTimeServices);
        }
        compileTimeServices.getClassProvidedCompileTimeResolver().removeFrom(moduleBytes);
        return queryMethodProviderClassName;
    }
}

