/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.util;

import com.espertech.esper.common.client.EPCompiled;
import com.espertech.esper.common.client.EPCompiledManifest;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.module.ModuleProperty;
import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationIDGenerator;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassType;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenStackGenerator;
import com.espertech.esper.common.internal.bytecodemodel.util.IdentifierUtil;
import com.espertech.esper.common.internal.compile.stage1.Compilable;
import com.espertech.esper.common.internal.compile.stage1.spec.ExpressionDeclItem;
import com.espertech.esper.common.internal.compile.stage1.spec.ExpressionScriptProvided;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompileException;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompileSyntaxException;
import com.espertech.esper.common.internal.compile.stage3.ModuleCompileTimeServices;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleClassProvidedInitializeSymbol;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleContextInitializeSymbol;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleEventTypeInitializeSymbol;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleExpressionDeclaredInitializeSymbol;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleIndexesInitializeSymbol;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleNamedWindowInitializeSymbol;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleScriptInitializeSymbol;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleTableInitializeSymbol;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleVariableInitializeSymbol;
import com.espertech.esper.common.internal.context.compile.ContextMetaData;
import com.espertech.esper.common.internal.context.module.EPModuleClassProvidedInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleContextInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleEventTypeInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleExprDeclaredInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleIndexInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleNamedWindowInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleScriptInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleTableInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleVariableInitServices;
import com.espertech.esper.common.internal.context.module.ModuleDependenciesRuntime;
import com.espertech.esper.common.internal.context.module.ModuleProvider;
import com.espertech.esper.common.internal.epl.classprovided.core.ClassProvided;
import com.espertech.esper.common.internal.epl.index.compile.IndexCompileTimeKey;
import com.espertech.esper.common.internal.epl.index.compile.IndexDetail;
import com.espertech.esper.common.internal.epl.index.compile.IndexDetailForge;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowMetaData;
import com.espertech.esper.common.internal.epl.script.core.NameAndParamNum;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import com.espertech.esper.common.internal.event.avro.AvroSchemaEventType;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.core.BaseNestableEventType;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.core.TypeBeanOrUnderlying;
import com.espertech.esper.common.internal.event.core.WrapperEventType;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.event.map.MapEventType;
import com.espertech.esper.common.internal.event.path.EventTypeResolver;
import com.espertech.esper.common.internal.event.variant.VariantEventType;
import com.espertech.esper.common.internal.event.xml.BaseXMLEventType;
import com.espertech.esper.common.internal.event.xml.SchemaXMLEventType;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.util.SerializerUtil;
import com.espertech.esper.compiler.client.CompilerOptions;
import com.espertech.esper.compiler.client.EPCompileException;
import com.espertech.esper.compiler.client.EPCompileExceptionItem;
import com.espertech.esper.compiler.client.EPCompileExceptionSyntaxItem;
import com.espertech.esper.compiler.internal.util.CompilableItem;
import com.espertech.esper.compiler.internal.util.CompilerHelperStatementProvider;
import com.espertech.esper.compiler.internal.util.CompilerPool;
import com.espertech.esper.compiler.internal.util.EPCompilerImpl;
import com.espertech.esper.compiler.internal.util.JaninoCompiler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class CompilerHelperModuleProvider {
    private static final int NUM_STATEMENT_NAMES_PER_BATCH = 1000;

    protected static EPCompiled compile(List<Compilable> compilables, String optionalModuleName, Map<ModuleProperty, Object> moduleProperties, ModuleCompileTimeServices compileTimeServices, CompilerOptions compilerOptions) throws EPCompileException {
        EPCompiledManifest manifest;
        ConcurrentHashMap<String, byte[]> moduleBytes = new ConcurrentHashMap<String, byte[]>();
        try {
            manifest = CompilerHelperModuleProvider.compileToBytes(moduleBytes, compilables, optionalModuleName, moduleProperties, compileTimeServices, compilerOptions);
        }
        catch (EPCompileException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new EPCompileException("Unexpected exception compiling module: " + t.getMessage(), t, Collections.emptyList());
        }
        return new EPCompiled(moduleBytes, manifest);
    }

    private static EPCompiledManifest compileToBytes(ConcurrentHashMap<String, byte[]> moduleBytes, List<Compilable> compilables, String optionalModuleName, Map<ModuleProperty, Object> moduleProperties, ModuleCompileTimeServices compileTimeServices, CompilerOptions compilerOptions) throws EPCompileException, IOException {
        String moduleAssignedName = optionalModuleName == null ? UUID.randomUUID().toString() : optionalModuleName;
        String moduleIdentPostfix = IdentifierUtil.getIdentifierMayStartNumeric((String)moduleAssignedName);
        ArrayList<String> statementClassNames = new ArrayList<String>();
        HashSet<String> statementNames = new HashSet<String>();
        ArrayList<EPCompileExceptionItem> exceptions = new ArrayList<EPCompileExceptionItem>();
        ArrayList<EPCompileExceptionItem> postLatchThrowables = new ArrayList<EPCompileExceptionItem>();
        CompilerPool compilerPool = new CompilerPool(compilables.size(), compileTimeServices, moduleBytes);
        try {
            int statementNumber = 0;
            for (Compilable compilable : compilables) {
                String className = null;
                EPCompileExceptionItem exception = null;
                try {
                    CompilableItem compilableItem = CompilerHelperStatementProvider.compileItem(compilable, optionalModuleName, moduleIdentPostfix, statementNumber, statementNames, compileTimeServices, compilerOptions);
                    className = compilableItem.getProviderClassName();
                    compilerPool.submit(statementNumber, compilableItem);
                    try {
                        compilableItem.getPostCompileLatch().awaitAndRun();
                    }
                    catch (Throwable t) {
                        postLatchThrowables.add(new EPCompileExceptionItem(t.getMessage(), t, compilable.toEPL(), compilable.lineNumber()));
                    }
                }
                catch (StatementSpecCompileException ex) {
                    exception = ex instanceof StatementSpecCompileSyntaxException ? new EPCompileExceptionSyntaxItem(ex.getMessage(), ex, ex.getExpression(), compilable.lineNumber()) : new EPCompileExceptionItem(ex.getMessage(), ex, ex.getExpression(), compilable.lineNumber());
                    exceptions.add(exception);
                }
                catch (RuntimeException ex) {
                    exception = new EPCompileExceptionItem(ex.getMessage(), ex, compilable.toEPL(), compilable.lineNumber());
                    exceptions.add(exception);
                }
                if (exception == null) {
                    statementClassNames.add(className);
                }
                ++statementNumber;
            }
        }
        catch (InterruptedException | RuntimeException ex) {
            compilerPool.shutdownNow();
            throw new EPCompileException(ex.getMessage(), ex);
        }
        compilerPool.shutdownCollectResults();
        exceptions.addAll(postLatchThrowables);
        if (!exceptions.isEmpty()) {
            compilerPool.shutdown();
            EPCompileExceptionItem ex = (EPCompileExceptionItem)((Object)exceptions.get(0));
            throw new EPCompileException(ex.getMessage() + " [" + ex.getExpression() + "]", (Throwable)((Object)ex), exceptions);
        }
        String moduleProviderClassName = CompilerHelperModuleProvider.compileModule(optionalModuleName, moduleProperties, statementClassNames, moduleIdentPostfix, moduleBytes, compileTimeServices);
        compileTimeServices.getClassProvidedCompileTimeResolver().removeFrom(moduleBytes);
        for (Map.Entry entry : compileTimeServices.getClassProvidedCompileTimeRegistry().getClasses().entrySet()) {
            moduleBytes.putAll(((ClassProvided)entry.getValue()).getBytes());
        }
        return new EPCompiledManifest("8.5.0", moduleProviderClassName, null, compileTimeServices.getSerdeResolver().isTargetHA());
    }

    private static String compileModule(String optionalModuleName, Map<ModuleProperty, Object> moduleProperties, List<String> statementClassNames, String moduleIdentPostfix, Map<String, byte[]> moduleBytes, ModuleCompileTimeServices compileTimeServices) {
        CodegenPackageScope packageScope = new CodegenPackageScope(compileTimeServices.getPackageName(), null, compileTimeServices.isInstrumented());
        String moduleClassName = CodeGenerationIDGenerator.generateClassNameSimple(ModuleProvider.class, (String)moduleIdentPostfix);
        CodegenClassScope classScope = new CodegenClassScope(true, packageScope, moduleClassName);
        CodegenClassMethods methods = new CodegenClassMethods();
        CodegenMethod getModuleNameMethod = CodegenMethod.makeParentNode(String.class, EPCompilerImpl.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        getModuleNameMethod.getBlock().methodReturn(CodegenExpressionBuilder.constant((Object)optionalModuleName));
        CodegenMethod getModulePropertiesMethod = CodegenMethod.makeParentNode(Map.class, EPCompilerImpl.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        CompilerHelperModuleProvider.makeModuleProperties(moduleProperties, getModulePropertiesMethod);
        CodegenMethod getModuleDependenciesMethod = CodegenMethod.makeParentNode(ModuleDependenciesRuntime.class, EPCompilerImpl.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        getModuleDependenciesMethod.getBlock().methodReturn(compileTimeServices.getModuleDependencies().make((CodegenMethodScope)getModuleDependenciesMethod, classScope));
        CodegenMethod initializeEventTypesMethod = CompilerHelperModuleProvider.makeInitEventTypes(classScope, compileTimeServices);
        ModuleNamedWindowInitializeSymbol symbolsNamedWindowInit = new ModuleNamedWindowInitializeSymbol();
        CodegenMethod initializeNamedWindowsMethod = CodegenMethod.makeParentNode(Void.TYPE, EPCompilerImpl.class, (CodegenSymbolProvider)symbolsNamedWindowInit, (CodegenScope)classScope).addParam(EPModuleNamedWindowInitServices.class, ModuleNamedWindowInitializeSymbol.REF_INITSVC.getRef());
        for (Map.Entry<String, NamedWindowMetaData> entry : compileTimeServices.getNamedWindowCompileTimeRegistry().getNamedWindows().entrySet()) {
            CodegenMethod addNamedWindow = CompilerHelperModuleProvider.registerNamedWindowCodegen(entry, (CodegenMethodScope)initializeNamedWindowsMethod, classScope, symbolsNamedWindowInit);
            initializeNamedWindowsMethod.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)addNamedWindow, (CodegenExpression[])new CodegenExpression[0]));
        }
        ModuleTableInitializeSymbol symbolsTableInit = new ModuleTableInitializeSymbol();
        CodegenMethod codegenMethod = CodegenMethod.makeParentNode(Void.TYPE, EPCompilerImpl.class, (CodegenSymbolProvider)symbolsTableInit, (CodegenScope)classScope).addParam(EPModuleTableInitServices.class, ModuleTableInitializeSymbol.REF_INITSVC.getRef());
        for (Map.Entry entry : compileTimeServices.getTableCompileTimeRegistry().getTables().entrySet()) {
            CodegenMethod addTable = CompilerHelperModuleProvider.registerTableCodegen(entry, (CodegenMethodScope)codegenMethod, classScope, symbolsTableInit);
            codegenMethod.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)addTable, (CodegenExpression[])new CodegenExpression[0]));
        }
        ModuleIndexesInitializeSymbol symbolsIndexInit = new ModuleIndexesInitializeSymbol();
        CodegenMethod codegenMethod2 = CodegenMethod.makeParentNode(Void.TYPE, EPCompilerImpl.class, (CodegenSymbolProvider)symbolsIndexInit, (CodegenScope)classScope).addParam(EPModuleIndexInitServices.class, EPModuleIndexInitServices.REF.getRef());
        for (Map.Entry entry : compileTimeServices.getIndexCompileTimeRegistry().getIndexes().entrySet()) {
            CodegenMethod addIndex = CompilerHelperModuleProvider.registerIndexCodegen(entry, (CodegenMethodScope)codegenMethod2, classScope, symbolsIndexInit);
            codegenMethod2.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)addIndex, (CodegenExpression[])new CodegenExpression[0]));
        }
        ModuleContextInitializeSymbol symbolsContextInit = new ModuleContextInitializeSymbol();
        CodegenMethod codegenMethod3 = CodegenMethod.makeParentNode(Void.TYPE, EPCompilerImpl.class, (CodegenSymbolProvider)symbolsContextInit, (CodegenScope)classScope).addParam(EPModuleContextInitServices.class, ModuleContextInitializeSymbol.REF_INITSVC.getRef());
        for (Map.Entry entry : compileTimeServices.getContextCompileTimeRegistry().getContexts().entrySet()) {
            CodegenMethod addContext = CompilerHelperModuleProvider.registerContextCodegen(entry, codegenMethod3, classScope, symbolsContextInit);
            codegenMethod3.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)addContext, (CodegenExpression[])new CodegenExpression[0]));
        }
        ModuleVariableInitializeSymbol symbolsVariablesInit = new ModuleVariableInitializeSymbol();
        CodegenMethod codegenMethod4 = CodegenMethod.makeParentNode(Void.TYPE, EPCompilerImpl.class, (CodegenSymbolProvider)symbolsVariablesInit, (CodegenScope)classScope).addParam(EPModuleVariableInitServices.class, ModuleVariableInitializeSymbol.REF_INITSVC.getRef());
        for (Map.Entry entry : compileTimeServices.getVariableCompileTimeRegistry().getVariables().entrySet()) {
            CodegenMethod addVariable = CompilerHelperModuleProvider.registerVariableCodegen(entry, (CodegenMethodScope)codegenMethod4, classScope, symbolsVariablesInit);
            codegenMethod4.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)addVariable, (CodegenExpression[])new CodegenExpression[0]));
        }
        ModuleExpressionDeclaredInitializeSymbol symbolsExprDeclaredInit = new ModuleExpressionDeclaredInitializeSymbol();
        CodegenMethod codegenMethod5 = CodegenMethod.makeParentNode(Void.TYPE, EPCompilerImpl.class, (CodegenSymbolProvider)symbolsExprDeclaredInit, (CodegenScope)classScope).addParam(EPModuleExprDeclaredInitServices.class, ModuleExpressionDeclaredInitializeSymbol.REF_INITSVC.getRef());
        for (Map.Entry entry : compileTimeServices.getExprDeclaredCompileTimeRegistry().getExpressions().entrySet()) {
            CodegenMethod addExpression = CompilerHelperModuleProvider.registerExprDeclaredCodegen(entry, codegenMethod5, classScope, symbolsExprDeclaredInit);
            codegenMethod5.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)addExpression, (CodegenExpression[])new CodegenExpression[0]));
        }
        ModuleScriptInitializeSymbol symbolsScriptInit = new ModuleScriptInitializeSymbol();
        CodegenMethod codegenMethod6 = CodegenMethod.makeParentNode(Void.TYPE, EPCompilerImpl.class, (CodegenSymbolProvider)symbolsScriptInit, (CodegenScope)classScope).addParam(EPModuleScriptInitServices.class, ModuleScriptInitializeSymbol.REF_INITSVC.getRef());
        for (Map.Entry entry : compileTimeServices.getScriptCompileTimeRegistry().getScripts().entrySet()) {
            CodegenMethod addScript = CompilerHelperModuleProvider.registerScriptCodegen(entry, (CodegenMethodScope)codegenMethod6, classScope, symbolsScriptInit);
            codegenMethod6.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)addScript, (CodegenExpression[])new CodegenExpression[0]));
        }
        ModuleClassProvidedInitializeSymbol symbolsClassProvidedInit = new ModuleClassProvidedInitializeSymbol();
        CodegenMethod codegenMethod7 = CodegenMethod.makeParentNode(Void.TYPE, EPCompilerImpl.class, (CodegenSymbolProvider)symbolsClassProvidedInit, (CodegenScope)classScope).addParam(EPModuleClassProvidedInitServices.class, ModuleClassProvidedInitializeSymbol.REF_INITSVC.getRef());
        for (Map.Entry entry : compileTimeServices.getClassProvidedCompileTimeRegistry().getClasses().entrySet()) {
            CodegenMethod addClassProvided = CompilerHelperModuleProvider.registerClassProvidedCodegen(entry, (CodegenMethodScope)codegenMethod7, classScope, symbolsClassProvidedInit);
            codegenMethod7.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)addClassProvided, (CodegenExpression[])new CodegenExpression[0]));
        }
        CodegenMethod statementsMethod = CodegenMethod.makeParentNode(List.class, EPCompilerImpl.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        CompilerHelperModuleProvider.makeStatementsMethod(statementsMethod, statementClassNames, classScope);
        CodegenStackGenerator.recursiveBuildStack((CodegenMethod)getModuleNameMethod, (String)"getModuleName", (CodegenClassMethods)methods);
        CodegenStackGenerator.recursiveBuildStack((CodegenMethod)getModulePropertiesMethod, (String)"getModuleProperties", (CodegenClassMethods)methods);
        CodegenStackGenerator.recursiveBuildStack((CodegenMethod)getModuleDependenciesMethod, (String)"getModuleDependencies", (CodegenClassMethods)methods);
        CodegenStackGenerator.recursiveBuildStack((CodegenMethod)initializeEventTypesMethod, (String)"initializeEventTypes", (CodegenClassMethods)methods);
        CodegenStackGenerator.recursiveBuildStack((CodegenMethod)initializeNamedWindowsMethod, (String)"initializeNamedWindows", (CodegenClassMethods)methods);
        CodegenStackGenerator.recursiveBuildStack((CodegenMethod)codegenMethod, (String)"initializeTables", (CodegenClassMethods)methods);
        CodegenStackGenerator.recursiveBuildStack((CodegenMethod)codegenMethod2, (String)"initializeIndexes", (CodegenClassMethods)methods);
        CodegenStackGenerator.recursiveBuildStack((CodegenMethod)codegenMethod3, (String)"initializeContexts", (CodegenClassMethods)methods);
        CodegenStackGenerator.recursiveBuildStack((CodegenMethod)codegenMethod4, (String)"initializeVariables", (CodegenClassMethods)methods);
        CodegenStackGenerator.recursiveBuildStack((CodegenMethod)codegenMethod5, (String)"initializeExprDeclareds", (CodegenClassMethods)methods);
        CodegenStackGenerator.recursiveBuildStack((CodegenMethod)codegenMethod6, (String)"initializeScripts", (CodegenClassMethods)methods);
        CodegenStackGenerator.recursiveBuildStack((CodegenMethod)codegenMethod7, (String)"initializeClassProvided", (CodegenClassMethods)methods);
        CodegenStackGenerator.recursiveBuildStack((CodegenMethod)statementsMethod, (String)"statements", (CodegenClassMethods)methods);
        CodegenClass codegenClass = new CodegenClass(CodegenClassType.MODULEPROVIDER, ModuleProvider.class, moduleClassName, classScope, Collections.emptyList(), null, methods, Collections.emptyList());
        JaninoCompiler.compile(codegenClass, moduleBytes, moduleBytes, compileTimeServices);
        return CodeGenerationIDGenerator.generateClassNameWithPackage((String)compileTimeServices.getPackageName(), ModuleProvider.class, (String)moduleIdentPostfix);
    }

    private static void makeStatementsMethod(CodegenMethod statementsMethod, List<String> statementClassNames, CodegenClassScope classScope) {
        statementsMethod.getBlock().declareVar(List.class, "statements", CodegenExpressionBuilder.newInstance(ArrayList.class, (CodegenExpression[])new CodegenExpression[]{CodegenExpressionBuilder.constant((Object)statementClassNames.size())}));
        if (statementClassNames.size() <= 1000) {
            CompilerHelperModuleProvider.makeStatementsAdd(statementsMethod, statementClassNames);
        } else {
            List lists = CollectionUtil.subdivide(statementClassNames, (int)1000);
            for (List names : lists) {
                CodegenMethod sub = statementsMethod.makeChild(Void.TYPE, CompilerHelperModuleProvider.class, (CodegenScope)classScope).addParam(List.class, "statements");
                CompilerHelperModuleProvider.makeStatementsAdd(sub, names);
                statementsMethod.getBlock().localMethod(sub, new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"statements")});
            }
        }
        statementsMethod.getBlock().methodReturn((CodegenExpression)CodegenExpressionBuilder.ref((String)"statements"));
    }

    private static void makeStatementsAdd(CodegenMethod statementsMethod, Collection<String> statementClassNames) {
        for (String statementClassName : statementClassNames) {
            statementsMethod.getBlock().exprDotMethod((CodegenExpression)CodegenExpressionBuilder.ref((String)"statements"), "add", new CodegenExpression[]{CodegenExpressionBuilder.newInstance((String)statementClassName, (CodegenExpression[])new CodegenExpression[0])});
        }
    }

    private static void makeModuleProperties(Map<ModuleProperty, Object> props, CodegenMethod method) {
        if (props.isEmpty()) {
            method.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(Collections.class, (String)"emptyMap", (CodegenExpression[])new CodegenExpression[0]));
            return;
        }
        if (props.size() == 1) {
            Map.Entry<ModuleProperty, Object> entry = props.entrySet().iterator().next();
            method.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(Collections.class, (String)"singletonMap", (CodegenExpression[])new CodegenExpression[]{CompilerHelperModuleProvider.makeModulePropKey(entry.getKey()), CompilerHelperModuleProvider.makeModulePropValue(entry.getValue())}));
            return;
        }
        method.getBlock().declareVar(Map.class, "props", CodegenExpressionBuilder.newInstance(HashMap.class, (CodegenExpression[])new CodegenExpression[]{CodegenExpressionBuilder.constant((Object)CollectionUtil.capacityHashMap((int)props.size()))}));
        for (Map.Entry<ModuleProperty, Object> entry : props.entrySet()) {
            method.getBlock().exprDotMethod((CodegenExpression)CodegenExpressionBuilder.ref((String)"props"), "put", new CodegenExpression[]{CompilerHelperModuleProvider.makeModulePropKey(entry.getKey()), CompilerHelperModuleProvider.makeModulePropValue(entry.getValue())});
        }
        method.getBlock().methodReturn((CodegenExpression)CodegenExpressionBuilder.ref((String)"props"));
    }

    private static CodegenExpression makeModulePropKey(ModuleProperty key) {
        return CodegenExpressionBuilder.enumValue(ModuleProperty.class, (String)key.name());
    }

    private static CodegenExpression makeModulePropValue(Object value) {
        return SerializerUtil.expressionForUserObject((Object)value);
    }

    private static CodegenMethod registerClassProvidedCodegen(Map.Entry<String, ClassProvided> classProvided, CodegenMethodScope parent, CodegenClassScope classScope, ModuleClassProvidedInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(Void.TYPE, EPCompilerImpl.class, (CodegenScope)classScope);
        method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getClassProvidedCollector", new CodegenExpression[0]).add("registerClass", new CodegenExpression[]{CodegenExpressionBuilder.constant((Object)classProvided.getKey()), classProvided.getValue().make((CodegenMethodScope)method, classScope)}));
        return method;
    }

    private static CodegenMethod registerScriptCodegen(Map.Entry<NameAndParamNum, ExpressionScriptProvided> script, CodegenMethodScope parent, CodegenClassScope classScope, ModuleScriptInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(Void.TYPE, EPCompilerImpl.class, (CodegenScope)classScope);
        method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getScriptCollector", new CodegenExpression[0]).add("registerScript", new CodegenExpression[]{CodegenExpressionBuilder.constant((Object)script.getKey().getName()), CodegenExpressionBuilder.constant((Object)script.getKey().getParamNum()), script.getValue().make((CodegenMethodScope)method, classScope)}));
        return method;
    }

    private static CodegenMethod registerExprDeclaredCodegen(Map.Entry<String, ExpressionDeclItem> expression, CodegenMethod parent, CodegenClassScope classScope, ModuleExpressionDeclaredInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(Void.TYPE, EPCompilerImpl.class, (CodegenScope)classScope);
        ExpressionDeclItem item = expression.getValue();
        byte[] bytes = SerializerUtil.objectToByteArr((Object)item.getOptionalSoda());
        item.setOptionalSodaBytes(() -> bytes);
        method.getBlock().declareVar(ExpressionDeclItem.class, "detail", expression.getValue().make(method, symbols, classScope)).expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getExprDeclaredCollector", new CodegenExpression[0]).add("registerExprDeclared", new CodegenExpression[]{CodegenExpressionBuilder.constant((Object)expression.getKey()), CodegenExpressionBuilder.ref((String)"detail")}));
        return method;
    }

    protected static CodegenMethod makeInitEventTypes(CodegenClassScope classScope, ModuleCompileTimeServices compileTimeServices) {
        ModuleEventTypeInitializeSymbol symbolsEventTypeInit = new ModuleEventTypeInitializeSymbol();
        CodegenMethod initializeEventTypesMethod = CodegenMethod.makeParentNode(Void.TYPE, EPCompilerImpl.class, (CodegenSymbolProvider)symbolsEventTypeInit, (CodegenScope)classScope).addParam(EPModuleEventTypeInitServices.class, ModuleEventTypeInitializeSymbol.REF_INITSVC.getRef());
        for (EventType eventType : compileTimeServices.getEventTypeCompileTimeRegistry().getNewTypesAdded()) {
            CodegenMethod addType = CompilerHelperModuleProvider.registerEventTypeCodegen(eventType, (CodegenMethodScope)initializeEventTypesMethod, classScope, symbolsEventTypeInit);
            initializeEventTypesMethod.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)addType, (CodegenExpression[])new CodegenExpression[0]));
        }
        if (compileTimeServices.getSerdeEventTypeRegistry().isTargetHA()) {
            for (Map.Entry entry : compileTimeServices.getSerdeEventTypeRegistry().getEventTypes().entrySet()) {
                CodegenMethod addSerde = CompilerHelperModuleProvider.registerEventTypeSerdeCodegen((EventType)entry.getKey(), (DataInputOutputSerdeForge)entry.getValue(), (CodegenMethodScope)initializeEventTypesMethod, classScope, symbolsEventTypeInit);
                initializeEventTypesMethod.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)addSerde, (CodegenExpression[])new CodegenExpression[0]));
            }
        }
        return initializeEventTypesMethod;
    }

    private static CodegenMethod registerNamedWindowCodegen(Map.Entry<String, NamedWindowMetaData> namedWindow, CodegenMethodScope parent, CodegenClassScope classScope, ModuleNamedWindowInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(Void.TYPE, EPCompilerImpl.class, (CodegenScope)classScope);
        method.getBlock().declareVar(NamedWindowMetaData.class, "detail", namedWindow.getValue().make(symbols.getAddInitSvc((CodegenMethodScope)method))).expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getNamedWindowCollector", new CodegenExpression[0]).add("registerNamedWindow", new CodegenExpression[]{CodegenExpressionBuilder.constant((Object)namedWindow.getKey()), CodegenExpressionBuilder.ref((String)"detail")}));
        return method;
    }

    private static CodegenMethod registerTableCodegen(Map.Entry<String, TableMetaData> table, CodegenMethodScope parent, CodegenClassScope classScope, ModuleTableInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(Void.TYPE, EPCompilerImpl.class, (CodegenScope)classScope);
        method.getBlock().declareVar(TableMetaData.class, "detail", table.getValue().make(parent, symbols, classScope)).expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getTableCollector", new CodegenExpression[0]).add("registerTable", new CodegenExpression[]{CodegenExpressionBuilder.constant((Object)table.getKey()), CodegenExpressionBuilder.ref((String)"detail")}));
        return method;
    }

    private static CodegenMethod registerIndexCodegen(Map.Entry<IndexCompileTimeKey, IndexDetailForge> index, CodegenMethodScope parent, CodegenClassScope classScope, ModuleIndexesInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(Void.TYPE, EPCompilerImpl.class, (CodegenScope)classScope);
        method.getBlock().declareVar(IndexCompileTimeKey.class, "key", index.getKey().make(symbols.getAddInitSvc((CodegenMethodScope)method))).declareVar(IndexDetail.class, "detail", index.getValue().make((CodegenMethodScope)method, symbols, classScope)).expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getIndexCollector", new CodegenExpression[0]).add("registerIndex", new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"key"), CodegenExpressionBuilder.ref((String)"detail")}));
        return method;
    }

    private static CodegenMethod registerContextCodegen(Map.Entry<String, ContextMetaData> context, CodegenMethod parent, CodegenClassScope classScope, ModuleContextInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(Void.TYPE, EPCompilerImpl.class, (CodegenScope)classScope);
        method.getBlock().declareVar(ContextMetaData.class, "detail", context.getValue().make(symbols.getAddInitSvc((CodegenMethodScope)method))).expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getContextCollector", new CodegenExpression[0]).add("registerContext", new CodegenExpression[]{CodegenExpressionBuilder.constant((Object)context.getKey()), CodegenExpressionBuilder.ref((String)"detail")}));
        return method;
    }

    private static CodegenMethod registerVariableCodegen(Map.Entry<String, VariableMetaData> variable, CodegenMethodScope parent, CodegenClassScope classScope, ModuleVariableInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(Void.TYPE, EPCompilerImpl.class, (CodegenScope)classScope);
        method.getBlock().declareVar(VariableMetaData.class, "detail", variable.getValue().make(symbols.getAddInitSvc((CodegenMethodScope)method))).expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getVariableCollector", new CodegenExpression[0]).add("registerVariable", new CodegenExpression[]{CodegenExpressionBuilder.constant((Object)variable.getKey()), CodegenExpressionBuilder.ref((String)"detail")}));
        return method;
    }

    private static CodegenMethod registerEventTypeCodegen(EventType eventType, CodegenMethodScope parent, CodegenClassScope classScope, ModuleEventTypeInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(Void.TYPE, EPCompilerImpl.class, (CodegenScope)classScope);
        method.getBlock().declareVar(EventTypeMetadata.class, "metadata", eventType.getMetadata().toExpression());
        if (eventType instanceof JsonEventType) {
            JsonEventType jsonEventType = (JsonEventType)eventType;
            method.getBlock().declareVar(LinkedHashMap.class, "props", (CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)CompilerHelperModuleProvider.makePropsCodegen(jsonEventType.getTypes(), (CodegenMethodScope)method, symbols, classScope, () -> jsonEventType.getDeepSuperTypes()), (CodegenExpression[])new CodegenExpression[0]));
            String[] superTypeNames = CompilerHelperModuleProvider.getSupertypeNames((EventType)jsonEventType);
            CodegenExpression detailExpr = jsonEventType.getDetail().toExpression((CodegenMethodScope)method, classScope);
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getEventTypeCollector", new CodegenExpression[0]).add("registerJson", new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"metadata"), CodegenExpressionBuilder.ref((String)"props"), CodegenExpressionBuilder.constant((Object)superTypeNames), CodegenExpressionBuilder.constant((Object)jsonEventType.getStartTimestampPropertyName()), CodegenExpressionBuilder.constant((Object)jsonEventType.getEndTimestampPropertyName()), detailExpr}));
        } else if (eventType instanceof BaseNestableEventType) {
            BaseNestableEventType baseNestable = (BaseNestableEventType)eventType;
            method.getBlock().declareVar(LinkedHashMap.class, "props", (CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)CompilerHelperModuleProvider.makePropsCodegen(baseNestable.getTypes(), (CodegenMethodScope)method, symbols, classScope, () -> baseNestable.getDeepSuperTypes()), (CodegenExpression[])new CodegenExpression[0]));
            String registerMethodName = eventType instanceof MapEventType ? "registerMap" : "registerObjectArray";
            String[] superTypeNames = CompilerHelperModuleProvider.getSupertypeNames((EventType)baseNestable);
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getEventTypeCollector", new CodegenExpression[0]).add(registerMethodName, new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"metadata"), CodegenExpressionBuilder.ref((String)"props"), CodegenExpressionBuilder.constant((Object)superTypeNames), CodegenExpressionBuilder.constant((Object)baseNestable.getStartTimestampPropertyName()), CodegenExpressionBuilder.constant((Object)baseNestable.getEndTimestampPropertyName())}));
        } else if (eventType instanceof WrapperEventType) {
            WrapperEventType wrapper = (WrapperEventType)eventType;
            method.getBlock().declareVar(EventType.class, "inner", EventTypeUtility.resolveTypeCodegen((EventType)((WrapperEventType)eventType).getUnderlyingEventType(), (CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)));
            method.getBlock().declareVar(LinkedHashMap.class, "props", (CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)CompilerHelperModuleProvider.makePropsCodegen(wrapper.getUnderlyingMapType().getTypes(), (CodegenMethodScope)method, symbols, classScope, () -> wrapper.getUnderlyingMapType().getDeepSuperTypes()), (CodegenExpression[])new CodegenExpression[0]));
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getEventTypeCollector", new CodegenExpression[0]).add("registerWrapper", new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"metadata"), CodegenExpressionBuilder.ref((String)"inner"), CodegenExpressionBuilder.ref((String)"props")}));
        } else if (eventType instanceof BeanEventType) {
            BeanEventType beanType = (BeanEventType)eventType;
            CodegenExpression superTypes = CompilerHelperModuleProvider.makeSupertypes(beanType.getSuperTypes(), symbols.getAddInitSvc((CodegenMethodScope)method));
            CodegenExpression deepSuperTypes = CompilerHelperModuleProvider.makeDeepSupertypes(beanType.getDeepSuperTypesAsSet(), (CodegenMethodScope)method, symbols, classScope);
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getEventTypeCollector", new CodegenExpression[0]).add("registerBean", new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"metadata"), CodegenExpressionBuilder.constant((Object)beanType.getUnderlyingType()), CodegenExpressionBuilder.constant((Object)beanType.getStartTimestampPropertyName()), CodegenExpressionBuilder.constant((Object)beanType.getEndTimestampPropertyName()), superTypes, deepSuperTypes}));
        } else if (eventType instanceof SchemaXMLEventType && ((SchemaXMLEventType)eventType).getRepresentsFragmentOfProperty() != null) {
            SchemaXMLEventType xmlType = (SchemaXMLEventType)eventType;
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getEventTypeCollector", new CodegenExpression[0]).add("registerXML", new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"metadata"), CodegenExpressionBuilder.constant((Object)xmlType.getRepresentsFragmentOfProperty()), CodegenExpressionBuilder.constant((Object)xmlType.getRepresentsOriginalTypeName())}));
        } else if (eventType instanceof BaseXMLEventType) {
            BaseXMLEventType xmlType = (BaseXMLEventType)eventType;
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getEventTypeCollector", new CodegenExpression[0]).add("registerXMLNewType", new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"metadata"), xmlType.getConfigurationEventTypeXMLDOM().toExpression((CodegenMethodScope)method, classScope)}));
        } else if (eventType instanceof AvroSchemaEventType) {
            AvroSchemaEventType avroType = (AvroSchemaEventType)eventType;
            String[] superTypeNames = CompilerHelperModuleProvider.getSupertypeNames((EventType)avroType);
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getEventTypeCollector", new CodegenExpression[0]).add("registerAvro", new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"metadata"), CodegenExpressionBuilder.constant((Object)avroType.getSchema().toString()), CodegenExpressionBuilder.constant((Object)superTypeNames)}));
        } else if (eventType instanceof VariantEventType) {
            VariantEventType variantEventType = (VariantEventType)eventType;
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getEventTypeCollector", new CodegenExpression[0]).add("registerVariant", new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"metadata"), EventTypeUtility.resolveTypeArrayCodegen((EventType[])variantEventType.getVariants(), (CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)), CodegenExpressionBuilder.constant((Object)variantEventType.isVariantAny())}));
        } else {
            throw new IllegalStateException("Event type '" + eventType + "' cannot be registered");
        }
        return method;
    }

    private static String[] getSupertypeNames(EventType eventType) {
        if (eventType.getSuperTypes() != null && eventType.getSuperTypes().length > 0) {
            String[] superTypeNames = new String[eventType.getSuperTypes().length];
            for (int i = 0; i < eventType.getSuperTypes().length; ++i) {
                superTypeNames[i] = eventType.getSuperTypes()[i].getName();
            }
            return superTypeNames;
        }
        return new String[0];
    }

    private static CodegenMethod registerEventTypeSerdeCodegen(EventType eventType, DataInputOutputSerdeForge serdeForge, CodegenMethodScope parent, CodegenClassScope classScope, ModuleEventTypeInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(Void.TYPE, EPCompilerImpl.class, (CodegenScope)classScope);
        method.getBlock().declareVar(EventTypeMetadata.class, "metadata", eventType.getMetadata().toExpression()).declareVar(EventTypeResolver.class, "resolver", CodegenExpressionBuilder.exprDotMethod((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method), (String)"getEventTypeResolver", (CodegenExpression[])new CodegenExpression[0])).declareVar(DataInputOutputSerde.class, "serde", serdeForge.codegen(method, classScope, (CodegenExpression)CodegenExpressionBuilder.ref((String)"resolver")));
        method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getEventTypeCollector", new CodegenExpression[0]).add("registerSerde", new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"metadata"), CodegenExpressionBuilder.ref((String)"serde"), CodegenExpressionBuilder.constant((Object)eventType.getUnderlyingType())}));
        return method;
    }

    private static CodegenExpression makeDeepSupertypes(Set<EventType> deepSuperTypes, CodegenMethodScope parent, ModuleEventTypeInitializeSymbol symbols, CodegenClassScope classScope) {
        if (deepSuperTypes == null || deepSuperTypes.isEmpty()) {
            return CodegenExpressionBuilder.staticMethod(Collections.class, (String)"emptySet", (CodegenExpression[])new CodegenExpression[0]);
        }
        if (deepSuperTypes.size() == 1) {
            return CodegenExpressionBuilder.staticMethod(Collections.class, (String)"singleton", (CodegenExpression[])new CodegenExpression[]{EventTypeUtility.resolveTypeCodegen((EventType)deepSuperTypes.iterator().next(), (CodegenExpression)symbols.getAddInitSvc(parent))});
        }
        CodegenMethod method = parent.makeChild(Set.class, CompilerHelperModuleProvider.class, (CodegenScope)classScope);
        method.getBlock().declareVar(Set.class, "dst", CodegenExpressionBuilder.newInstance(LinkedHashSet.class, (CodegenExpression[])new CodegenExpression[]{CodegenExpressionBuilder.constant((Object)CollectionUtil.capacityHashMap((int)deepSuperTypes.size()))}));
        for (EventType eventType : deepSuperTypes) {
            method.getBlock().exprDotMethod((CodegenExpression)CodegenExpressionBuilder.ref((String)"dst"), "add", new CodegenExpression[]{EventTypeUtility.resolveTypeCodegen((EventType)eventType, (CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method))});
        }
        method.getBlock().methodReturn((CodegenExpression)CodegenExpressionBuilder.ref((String)"dst"));
        return CodegenExpressionBuilder.localMethod((CodegenMethod)method, (CodegenExpression[])new CodegenExpression[0]);
    }

    private static CodegenExpression makeSupertypes(EventType[] superTypes, CodegenExpressionRef initSvcRef) {
        if (superTypes == null || superTypes.length == 0) {
            return CodegenExpressionBuilder.constantNull();
        }
        CodegenExpression[] expressions = new CodegenExpression[superTypes.length];
        for (int i = 0; i < superTypes.length; ++i) {
            expressions[i] = EventTypeUtility.resolveTypeCodegen((EventType)superTypes[i], (CodegenExpression)initSvcRef);
        }
        return CodegenExpressionBuilder.newArrayWithInit(EventType.class, (CodegenExpression[])expressions);
    }

    private static CodegenMethod makePropsCodegen(Map<String, Object> types, CodegenMethodScope parent, ModuleEventTypeInitializeSymbol symbols, CodegenClassScope classScope, Supplier<Iterator<EventType>> deepSuperTypes) {
        CodegenMethod method = parent.makeChild(LinkedHashMap.class, CompilerHelperModuleProvider.class, (CodegenScope)classScope);
        symbols.getAddInitSvc((CodegenMethodScope)method);
        method.getBlock().declareVar(LinkedHashMap.class, "props", CodegenExpressionBuilder.newInstance(LinkedHashMap.class, (CodegenExpression[])new CodegenExpression[0]));
        for (Map.Entry<String, Object> entry : types.entrySet()) {
            CodegenExpression innerTypeExpr;
            EventType innerType;
            CodegenExpression typeResolver;
            boolean propertyOfSupertype = CompilerHelperModuleProvider.isPropertyOfSupertype(deepSuperTypes, entry.getKey());
            if (propertyOfSupertype) continue;
            Object type = entry.getValue();
            if (type instanceof Class) {
                typeResolver = CodegenExpressionBuilder.enumValue((Class)((Class)entry.getValue()), (String)"class");
            } else if (type instanceof EventType) {
                innerType = (EventType)type;
                typeResolver = EventTypeUtility.resolveTypeCodegen((EventType)innerType, (CodegenExpression)ModuleEventTypeInitializeSymbol.REF_INITSVC);
            } else if (type instanceof EventType[]) {
                innerType = (EventType)type;
                CodegenExpression typeExpr = EventTypeUtility.resolveTypeCodegen((EventType)innerType[0], (CodegenExpression)ModuleEventTypeInitializeSymbol.REF_INITSVC);
                typeResolver = CodegenExpressionBuilder.newArrayWithInit(EventType.class, (CodegenExpression[])new CodegenExpression[]{typeExpr});
            } else if (type == null) {
                typeResolver = CodegenExpressionBuilder.constantNull();
            } else if (type instanceof TypeBeanOrUnderlying) {
                innerType = ((TypeBeanOrUnderlying)type).getEventType();
                innerTypeExpr = EventTypeUtility.resolveTypeCodegen((EventType)innerType, (CodegenExpression)ModuleEventTypeInitializeSymbol.REF_INITSVC);
                typeResolver = CodegenExpressionBuilder.newInstance(TypeBeanOrUnderlying.class, (CodegenExpression[])new CodegenExpression[]{innerTypeExpr});
            } else if (type instanceof TypeBeanOrUnderlying[]) {
                innerType = ((TypeBeanOrUnderlying[])type)[0].getEventType();
                innerTypeExpr = EventTypeUtility.resolveTypeCodegen((EventType)innerType, (CodegenExpression)ModuleEventTypeInitializeSymbol.REF_INITSVC);
                typeResolver = CodegenExpressionBuilder.newArrayWithInit(TypeBeanOrUnderlying.class, (CodegenExpression[])new CodegenExpression[]{CodegenExpressionBuilder.newInstance(TypeBeanOrUnderlying.class, (CodegenExpression[])new CodegenExpression[]{innerTypeExpr})});
            } else if (type instanceof Map) {
                typeResolver = CodegenExpressionBuilder.localMethod((CodegenMethod)CompilerHelperModuleProvider.makePropsCodegen((Map)type, parent, symbols, classScope, null), (CodegenExpression[])new CodegenExpression[0]);
            } else {
                throw new IllegalStateException("Unrecognized type '" + type + "'");
            }
            method.getBlock().exprDotMethod((CodegenExpression)CodegenExpressionBuilder.ref((String)"props"), "put", new CodegenExpression[]{CodegenExpressionBuilder.constant((Object)entry.getKey()), typeResolver});
        }
        method.getBlock().methodReturn((CodegenExpression)CodegenExpressionBuilder.ref((String)"props"));
        return method;
    }

    private static boolean isPropertyOfSupertype(Supplier<Iterator<EventType>> deepSuperTypes, String key) {
        if (deepSuperTypes == null) {
            return false;
        }
        Iterator<EventType> deepSuperTypesIterator = deepSuperTypes.get();
        while (deepSuperTypesIterator.hasNext()) {
            EventType type = deepSuperTypesIterator.next();
            if (!type.isProperty(key)) continue;
            return true;
        }
        return false;
    }
}

