/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.util;

import com.espertech.esper.common.client.EPCompiled;
import com.espertech.esper.common.client.EPCompilerPathable;
import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.configuration.Configuration;
import com.espertech.esper.common.client.configuration.ConfigurationException;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeMeta;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerExpression;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInAggregationFunction;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInAggregationMultiFunction;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInDateTimeMethod;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInEnumMethod;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerSerde;
import com.espertech.esper.common.client.serde.SerdeProvider;
import com.espertech.esper.common.client.serde.SerdeProviderFactory;
import com.espertech.esper.common.client.serde.SerdeProviderFactoryContext;
import com.espertech.esper.common.client.util.ClassForNameProvider;
import com.espertech.esper.common.internal.collection.PathException;
import com.espertech.esper.common.internal.collection.PathRegistry;
import com.espertech.esper.common.internal.collection.PathRegistryObjectType;
import com.espertech.esper.common.internal.compile.stage1.CompilerServices;
import com.espertech.esper.common.internal.compile.stage1.spec.ExpressionDeclItem;
import com.espertech.esper.common.internal.compile.stage1.spec.ExpressionScriptProvided;
import com.espertech.esper.common.internal.compile.stage1.spec.PluggableObjectCollection;
import com.espertech.esper.common.internal.compile.stage1.spec.PluggableObjectRegistry;
import com.espertech.esper.common.internal.compile.stage1.spec.PluggableObjectRegistryImpl;
import com.espertech.esper.common.internal.compile.stage3.ModuleAccessModifierService;
import com.espertech.esper.common.internal.compile.stage3.ModuleCompileTimeServices;
import com.espertech.esper.common.internal.context.compile.ContextCollector;
import com.espertech.esper.common.internal.context.compile.ContextCollectorImpl;
import com.espertech.esper.common.internal.context.compile.ContextCompileTimeRegistry;
import com.espertech.esper.common.internal.context.compile.ContextCompileTimeResolver;
import com.espertech.esper.common.internal.context.compile.ContextCompileTimeResolverImpl;
import com.espertech.esper.common.internal.context.compile.ContextMetaData;
import com.espertech.esper.common.internal.context.module.EPModuleClassProvidedInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleClassProvidedInitServicesImpl;
import com.espertech.esper.common.internal.context.module.EPModuleContextInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleContextInitServicesImpl;
import com.espertech.esper.common.internal.context.module.EPModuleEventTypeInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleEventTypeInitServicesImpl;
import com.espertech.esper.common.internal.context.module.EPModuleExprDeclaredInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleExprDeclaredInitServicesImpl;
import com.espertech.esper.common.internal.context.module.EPModuleIndexInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleIndexInitServicesImpl;
import com.espertech.esper.common.internal.context.module.EPModuleNamedWindowInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleNamedWindowInitServicesImpl;
import com.espertech.esper.common.internal.context.module.EPModuleScriptInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleScriptInitServicesImpl;
import com.espertech.esper.common.internal.context.module.EPModuleTableInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleTableInitServicesImpl;
import com.espertech.esper.common.internal.context.module.EPModuleVariableInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleVariableInitServicesImpl;
import com.espertech.esper.common.internal.context.module.EventTypeCompileTimeRegistry;
import com.espertech.esper.common.internal.context.module.ModuleDependenciesCompileTime;
import com.espertech.esper.common.internal.context.module.ModuleProviderCLPair;
import com.espertech.esper.common.internal.context.module.ModuleProviderUtil;
import com.espertech.esper.common.internal.context.util.ParentClassLoader;
import com.espertech.esper.common.internal.epl.classprovided.compiletime.ClassProvidedCollectorCompileTime;
import com.espertech.esper.common.internal.epl.classprovided.compiletime.ClassProvidedCompileTimeRegistry;
import com.espertech.esper.common.internal.epl.classprovided.compiletime.ClassProvidedCompileTimeResolver;
import com.espertech.esper.common.internal.epl.classprovided.compiletime.ClassProvidedCompileTimeResolverImpl;
import com.espertech.esper.common.internal.epl.classprovided.core.ClassProvided;
import com.espertech.esper.common.internal.epl.classprovided.core.ClassProvidedCollector;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredCollectorCompileTime;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredCompileTimeRegistry;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredCompileTimeResolver;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredCompileTimeResolverImpl;
import com.espertech.esper.common.internal.epl.expression.declared.core.ExprDeclaredCollector;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacusFactory;
import com.espertech.esper.common.internal.epl.historical.database.connection.DatabaseConfigServiceCompileTime;
import com.espertech.esper.common.internal.epl.historical.database.connection.DatabaseConfigServiceImpl;
import com.espertech.esper.common.internal.epl.index.compile.IndexCollector;
import com.espertech.esper.common.internal.epl.index.compile.IndexCollectorCompileTime;
import com.espertech.esper.common.internal.epl.index.compile.IndexCompileTimeRegistry;
import com.espertech.esper.common.internal.epl.namedwindow.compile.NamedWindowCompileTimeRegistry;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowCollector;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowCollectorImpl;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowCompileTimeResolver;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowCompileTimeResolverImpl;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowMetaData;
import com.espertech.esper.common.internal.epl.pattern.core.PatternObjectHelper;
import com.espertech.esper.common.internal.epl.pattern.core.PatternObjectResolutionService;
import com.espertech.esper.common.internal.epl.pattern.core.PatternObjectResolutionServiceImpl;
import com.espertech.esper.common.internal.epl.script.compiletime.ScriptCollectorCompileTime;
import com.espertech.esper.common.internal.epl.script.compiletime.ScriptCompileTimeRegistry;
import com.espertech.esper.common.internal.epl.script.compiletime.ScriptCompileTimeResolver;
import com.espertech.esper.common.internal.epl.script.compiletime.ScriptCompileTimeResolverImpl;
import com.espertech.esper.common.internal.epl.script.core.ScriptCollector;
import com.espertech.esper.common.internal.epl.table.compiletime.TableCompileTimeRegistry;
import com.espertech.esper.common.internal.epl.table.compiletime.TableCompileTimeResolver;
import com.espertech.esper.common.internal.epl.table.compiletime.TableCompileTimeResolverImpl;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.epl.table.core.TableCollector;
import com.espertech.esper.common.internal.epl.table.core.TableCollectorImpl;
import com.espertech.esper.common.internal.epl.util.EPCompilerPathableImpl;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableCompileTimeRegistry;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableCompileTimeResolver;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableCompileTimeResolverImpl;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import com.espertech.esper.common.internal.epl.variable.core.VariableCollector;
import com.espertech.esper.common.internal.epl.variable.core.VariableCollectorImpl;
import com.espertech.esper.common.internal.epl.variable.core.VariableRepositoryPreconfigured;
import com.espertech.esper.common.internal.epl.variable.core.VariableUtil;
import com.espertech.esper.common.internal.event.avro.EventTypeAvroHandler;
import com.espertech.esper.common.internal.event.avro.EventTypeAvroHandlerFactory;
import com.espertech.esper.common.internal.event.bean.core.BeanEventTypeRepoUtil;
import com.espertech.esper.common.internal.event.bean.core.BeanEventTypeStemService;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactoryPrivate;
import com.espertech.esper.common.internal.event.bean.service.EventTypeRepositoryBeanTypeUtil;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactoryCompileTime;
import com.espertech.esper.common.internal.event.core.EventTypeCompileTimeResolver;
import com.espertech.esper.common.internal.event.core.EventTypeNameResolver;
import com.espertech.esper.common.internal.event.eventtypefactory.EventTypeFactory;
import com.espertech.esper.common.internal.event.eventtypefactory.EventTypeFactoryImpl;
import com.espertech.esper.common.internal.event.eventtyperepo.EventTypeRepository;
import com.espertech.esper.common.internal.event.eventtyperepo.EventTypeRepositoryAvroTypeUtil;
import com.espertech.esper.common.internal.event.eventtyperepo.EventTypeRepositoryImpl;
import com.espertech.esper.common.internal.event.eventtyperepo.EventTypeRepositoryMapTypeUtil;
import com.espertech.esper.common.internal.event.eventtyperepo.EventTypeRepositoryOATypeUtil;
import com.espertech.esper.common.internal.event.eventtyperepo.EventTypeRepositoryVariantStreamUtil;
import com.espertech.esper.common.internal.event.eventtyperepo.EventTypeRepositoryXMLTypeUtil;
import com.espertech.esper.common.internal.event.json.compiletime.JsonEventTypeUtility;
import com.espertech.esper.common.internal.event.path.EventTypeCollector;
import com.espertech.esper.common.internal.event.path.EventTypeCollectorImpl;
import com.espertech.esper.common.internal.event.path.EventTypeResolver;
import com.espertech.esper.common.internal.event.path.EventTypeResolverImpl;
import com.espertech.esper.common.internal.event.xml.XMLFragmentEventTypeFactory;
import com.espertech.esper.common.internal.serde.compiletime.eventtype.SerdeEventTypeCompileTimeRegistry;
import com.espertech.esper.common.internal.serde.compiletime.eventtype.SerdeEventTypeCompileTimeRegistryImpl;
import com.espertech.esper.common.internal.serde.compiletime.resolve.SerdeCompileTimeResolver;
import com.espertech.esper.common.internal.serde.compiletime.resolve.SerdeCompileTimeResolverImpl;
import com.espertech.esper.common.internal.serde.compiletime.resolve.SerdeCompileTimeResolverNonHA;
import com.espertech.esper.common.internal.serde.runtime.event.EventSerdeFactory;
import com.espertech.esper.common.internal.serde.runtime.event.EventSerdeFactoryDefault;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceCompileTime;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceCompileTimeImpl;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.TransientConfigurationResolver;
import com.espertech.esper.common.internal.view.core.ViewEnumHelper;
import com.espertech.esper.common.internal.view.core.ViewResolutionService;
import com.espertech.esper.common.internal.view.core.ViewResolutionServiceImpl;
import com.espertech.esper.compiler.client.CompilerArguments;
import com.espertech.esper.compiler.client.CompilerOptions;
import com.espertech.esper.compiler.client.CompilerPath;
import com.espertech.esper.compiler.client.EPCompileException;
import com.espertech.esper.compiler.internal.util.CompilerServicesImpl;
import com.espertech.esper.compiler.internal.util.ModuleAccessModifierServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class CompilerHelperServices {
    protected static ModuleCompileTimeServices getCompileTimeServices(CompilerArguments arguments, String moduleName, Set<String> moduleUses, boolean isFireAndForget) throws EPCompileException {
        try {
            return CompilerHelperServices.getServices(arguments, moduleName, moduleUses, isFireAndForget);
        }
        catch (EPCompileException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new EPCompileException("Failed compiler startup: " + t.getMessage(), t, Collections.emptyList());
        }
    }

    private static ModuleCompileTimeServices getServices(CompilerArguments arguments, String moduleName, Set<String> moduleUses, boolean isFireAndForget) throws EPCompileException {
        Configuration configuration = arguments.getConfiguration();
        CompilerPath path = arguments.getPath();
        CompilerOptions options = arguments.getOptions();
        ClasspathImportServiceCompileTime classpathImportServiceCompileTime = CompilerHelperServices.makeClasspathImportService(configuration);
        ParentClassLoader classLoaderParent = new ParentClassLoader(classpathImportServiceCompileTime.getClassLoader());
        Map resolvedBeanEventTypes = BeanEventTypeRepoUtil.resolveBeanEventTypes((Map)configuration.getCommon().getEventTypeNames(), (ClasspathImportService)classpathImportServiceCompileTime);
        BeanEventTypeStemService beanEventTypeStemService = BeanEventTypeRepoUtil.makeBeanEventTypeStemService((Configuration)configuration, (Map)resolvedBeanEventTypes, (EventBeanTypedEventFactory)EventBeanTypedEventFactoryCompileTime.INSTANCE);
        EventTypeRepositoryImpl eventTypeRepositoryPreconfigured = new EventTypeRepositoryImpl(true);
        EventTypeCompileTimeRegistry eventTypeCompileRegistry = new EventTypeCompileTimeRegistry((EventTypeRepository)eventTypeRepositoryPreconfigured);
        BeanEventTypeFactoryPrivate beanEventTypeFactoryPrivate = new BeanEventTypeFactoryPrivate((EventBeanTypedEventFactory)EventBeanTypedEventFactoryCompileTime.INSTANCE, (EventTypeFactory)EventTypeFactoryImpl.INSTANCE, beanEventTypeStemService);
        VariableRepositoryPreconfigured variableRepositoryPreconfigured = new VariableRepositoryPreconfigured();
        PathRegistry pathEventTypes = new PathRegistry(PathRegistryObjectType.EVENTTYPE);
        PathRegistry pathNamedWindows = new PathRegistry(PathRegistryObjectType.NAMEDWINDOW);
        PathRegistry pathTables = new PathRegistry(PathRegistryObjectType.TABLE);
        PathRegistry pathContexts = new PathRegistry(PathRegistryObjectType.CONTEXT);
        PathRegistry pathVariables = new PathRegistry(PathRegistryObjectType.VARIABLE);
        PathRegistry pathExprDeclared = new PathRegistry(PathRegistryObjectType.EXPRDECL);
        PathRegistry pathScript = new PathRegistry(PathRegistryObjectType.SCRIPT);
        PathRegistry pathClassProvided = new PathRegistry(PathRegistryObjectType.CLASSPROVIDED);
        if (path.getCompilerPathables() != null) {
            for (EPCompilerPathable pathable : path.getCompilerPathables()) {
                EPCompilerPathableImpl impl = (EPCompilerPathableImpl)pathable;
                pathVariables.mergeFrom(impl.getVariablePathRegistry());
                pathEventTypes.mergeFrom(impl.getEventTypePathRegistry());
                pathExprDeclared.mergeFrom(impl.getExprDeclaredPathRegistry());
                pathNamedWindows.mergeFrom(impl.getNamedWindowPathRegistry());
                pathTables.mergeFrom(impl.getTablePathRegistry());
                pathContexts.mergeFrom(impl.getContextPathRegistry());
                pathScript.mergeFrom(impl.getScriptPathRegistry());
                pathClassProvided.mergeFrom(impl.getClassProvidedPathRegistry());
                eventTypeRepositoryPreconfigured.mergeFrom(impl.getEventTypePreconfigured());
                variableRepositoryPreconfigured.mergeFrom(impl.getVariablePreconfigured());
                JsonEventTypeUtility.addJsonUnderlyingClass((PathRegistry)pathEventTypes, (ParentClassLoader)classLoaderParent);
            }
        }
        EventTypeRepositoryBeanTypeUtil.buildBeanTypes((BeanEventTypeStemService)beanEventTypeStemService, (EventTypeRepositoryImpl)eventTypeRepositoryPreconfigured, (Map)resolvedBeanEventTypes, (BeanEventTypeFactoryPrivate)beanEventTypeFactoryPrivate, (Map)configuration.getCommon().getEventTypesBean());
        EventTypeRepositoryMapTypeUtil.buildMapTypes((EventTypeRepositoryImpl)eventTypeRepositoryPreconfigured, (Map)configuration.getCommon().getMapTypeConfigurations(), (Map)configuration.getCommon().getEventTypesMapEvents(), (Map)configuration.getCommon().getEventTypesNestableMapEvents(), (BeanEventTypeFactory)beanEventTypeFactoryPrivate, (ClasspathImportService)classpathImportServiceCompileTime);
        EventTypeRepositoryOATypeUtil.buildOATypes((EventTypeRepositoryImpl)eventTypeRepositoryPreconfigured, (Map)configuration.getCommon().getObjectArrayTypeConfigurations(), (Map)configuration.getCommon().getEventTypesNestableObjectArrayEvents(), (BeanEventTypeFactory)beanEventTypeFactoryPrivate, (ClasspathImportService)classpathImportServiceCompileTime);
        XMLFragmentEventTypeFactory xmlFragmentEventTypeFactory = new XMLFragmentEventTypeFactory((BeanEventTypeFactory)beanEventTypeFactoryPrivate, eventTypeCompileRegistry, (EventTypeNameResolver)eventTypeRepositoryPreconfigured);
        EventTypeRepositoryXMLTypeUtil.buildXMLTypes((EventTypeRepositoryImpl)eventTypeRepositoryPreconfigured, (Map)configuration.getCommon().getEventTypesXMLDOM(), (BeanEventTypeFactory)beanEventTypeFactoryPrivate, (XMLFragmentEventTypeFactory)xmlFragmentEventTypeFactory, (ClasspathImportService)classpathImportServiceCompileTime);
        EventTypeAvroHandler eventTypeAvroHandler = EventTypeAvroHandlerFactory.resolve((ClasspathImportService)classpathImportServiceCompileTime, (ConfigurationCommonEventTypeMeta.AvroSettings)configuration.getCommon().getEventMeta().getAvroSettings(), (String)"com.espertech.esper.common.internal.avro.core.EventTypeAvroHandlerImpl");
        EventTypeRepositoryAvroTypeUtil.buildAvroTypes((EventTypeRepositoryImpl)eventTypeRepositoryPreconfigured, (Map)configuration.getCommon().getEventTypesAvro(), (EventTypeAvroHandler)eventTypeAvroHandler, (EventBeanTypedEventFactory)beanEventTypeFactoryPrivate.getEventBeanTypedEventFactory());
        EventTypeRepositoryVariantStreamUtil.buildVariantStreams((EventTypeRepositoryImpl)eventTypeRepositoryPreconfigured, (Map)configuration.getCommon().getVariantStreams(), (EventTypeFactory)EventTypeFactoryImpl.INSTANCE);
        VariableUtil.configureVariables((VariableRepositoryPreconfigured)variableRepositoryPreconfigured, (Map)configuration.getCommon().getVariables(), (ClasspathImportService)classpathImportServiceCompileTime, (EventBeanTypedEventFactory)EventBeanTypedEventFactoryCompileTime.INSTANCE, (EventTypeRepositoryImpl)eventTypeRepositoryPreconfigured, (BeanEventTypeFactory)beanEventTypeFactoryPrivate);
        int deploymentNumber = -1;
        for (EPCompiled unit : path.getCompileds()) {
            ++deploymentNumber;
            ModuleProviderCLPair provider = ModuleProviderUtil.analyze((EPCompiled)unit, (ClassLoader)classLoaderParent, (PathRegistry)pathClassProvided);
            String unitModuleName = provider.getModuleProvider().getModuleName();
            LinkedHashMap moduleTypes = new LinkedHashMap();
            EventTypeResolverImpl eventTypeResolver = new EventTypeResolverImpl(moduleTypes, pathEventTypes, (EventTypeNameResolver)eventTypeRepositoryPreconfigured, beanEventTypeFactoryPrivate, (EventSerdeFactory)EventSerdeFactoryDefault.INSTANCE);
            EventTypeCollectorImpl eventTypeCollector = new EventTypeCollectorImpl(moduleTypes, (BeanEventTypeFactory)beanEventTypeFactoryPrivate, provider.getClassLoader(), (EventTypeFactory)EventTypeFactoryImpl.INSTANCE, beanEventTypeStemService, (EventTypeNameResolver)eventTypeResolver, xmlFragmentEventTypeFactory, eventTypeAvroHandler, (EventBeanTypedEventFactory)EventBeanTypedEventFactoryCompileTime.INSTANCE, (ClasspathImportService)classpathImportServiceCompileTime);
            try {
                provider.getModuleProvider().initializeEventTypes((EPModuleEventTypeInitServices)new EPModuleEventTypeInitServicesImpl((EventTypeCollector)eventTypeCollector, (EventTypeResolver)eventTypeResolver));
            }
            catch (Throwable e) {
                throw new EPException(e);
            }
            JsonEventTypeUtility.addJsonUnderlyingClass(moduleTypes, (ParentClassLoader)classLoaderParent, null);
            HashMap moduleNamedWindows = new HashMap();
            NamedWindowCollectorImpl namedWindowCollector = new NamedWindowCollectorImpl(moduleNamedWindows);
            try {
                provider.getModuleProvider().initializeNamedWindows((EPModuleNamedWindowInitServices)new EPModuleNamedWindowInitServicesImpl((NamedWindowCollector)namedWindowCollector, (EventTypeResolver)eventTypeResolver));
            }
            catch (Throwable e) {
                throw new EPException(e);
            }
            HashMap moduleTables = new HashMap();
            TableCollectorImpl tableCollector = new TableCollectorImpl(moduleTables);
            try {
                provider.getModuleProvider().initializeTables((EPModuleTableInitServices)new EPModuleTableInitServicesImpl((TableCollector)tableCollector, (EventTypeResolver)eventTypeResolver));
            }
            catch (Throwable e) {
                throw new EPException(e);
            }
            IndexCollectorCompileTime indexCollector = new IndexCollectorCompileTime(moduleNamedWindows, moduleTables, pathNamedWindows, pathTables);
            try {
                provider.getModuleProvider().initializeIndexes((EPModuleIndexInitServices)new EPModuleIndexInitServicesImpl((IndexCollector)indexCollector));
            }
            catch (Throwable e) {
                throw new EPException(e);
            }
            HashMap moduleContexts = new HashMap();
            ContextCollectorImpl contextCollector = new ContextCollectorImpl(moduleContexts);
            try {
                provider.getModuleProvider().initializeContexts((EPModuleContextInitServices)new EPModuleContextInitServicesImpl((ContextCollector)contextCollector, (EventTypeResolver)eventTypeResolver));
            }
            catch (Throwable e) {
                throw new EPException(e);
            }
            HashMap moduleVariables = new HashMap();
            VariableCollectorImpl variableCollector = new VariableCollectorImpl(moduleVariables);
            try {
                provider.getModuleProvider().initializeVariables((EPModuleVariableInitServices)new EPModuleVariableInitServicesImpl((VariableCollector)variableCollector, (EventTypeResolver)eventTypeResolver));
            }
            catch (Throwable e) {
                throw new EPException(e);
            }
            HashMap moduleExprDeclareds = new HashMap();
            ExprDeclaredCollectorCompileTime exprDeclaredCollector = new ExprDeclaredCollectorCompileTime(moduleExprDeclareds);
            try {
                provider.getModuleProvider().initializeExprDeclareds((EPModuleExprDeclaredInitServices)new EPModuleExprDeclaredInitServicesImpl((ExprDeclaredCollector)exprDeclaredCollector));
            }
            catch (Throwable e) {
                throw new EPException(e);
            }
            HashMap moduleScripts = new HashMap();
            ScriptCollectorCompileTime scriptCollector = new ScriptCollectorCompileTime(moduleScripts);
            try {
                provider.getModuleProvider().initializeScripts((EPModuleScriptInitServices)new EPModuleScriptInitServicesImpl((ScriptCollector)scriptCollector));
            }
            catch (Throwable e) {
                throw new EPException(e);
            }
            HashMap moduleClassProvideds = new HashMap();
            ClassProvidedCollectorCompileTime classProvidedCollector = new ClassProvidedCollectorCompileTime(moduleClassProvideds, (ClassLoader)classLoaderParent);
            try {
                provider.getModuleProvider().initializeClassProvided((EPModuleClassProvidedInitServices)new EPModuleClassProvidedInitServicesImpl((ClassProvidedCollector)classProvidedCollector));
            }
            catch (Throwable e) {
                throw new EPException(e);
            }
            String deploymentId = "D" + deploymentNumber;
            try {
                for (Map.Entry type : moduleTypes.entrySet()) {
                    if (!((EventType)type.getValue()).getMetadata().getAccessModifier().isNonPrivateNonTransient()) continue;
                    pathEventTypes.add(type.getKey(), unitModuleName, type.getValue(), deploymentId);
                }
                for (Map.Entry entry : moduleNamedWindows.entrySet()) {
                    if (!((NamedWindowMetaData)entry.getValue()).getEventType().getMetadata().getAccessModifier().isNonPrivateNonTransient()) continue;
                    pathNamedWindows.add(entry.getKey(), unitModuleName, entry.getValue(), deploymentId);
                }
                for (Map.Entry entry : moduleTables.entrySet()) {
                    if (!((TableMetaData)entry.getValue()).getTableVisibility().isNonPrivateNonTransient()) continue;
                    pathTables.add(entry.getKey(), unitModuleName, entry.getValue(), deploymentId);
                }
                for (Map.Entry entry : moduleContexts.entrySet()) {
                    if (!((ContextMetaData)entry.getValue()).getContextVisibility().isNonPrivateNonTransient()) continue;
                    pathContexts.add(entry.getKey(), unitModuleName, entry.getValue(), deploymentId);
                }
                for (Map.Entry entry : moduleVariables.entrySet()) {
                    if (!((VariableMetaData)entry.getValue()).getVariableVisibility().isNonPrivateNonTransient()) continue;
                    pathVariables.add(entry.getKey(), unitModuleName, entry.getValue(), deploymentId);
                }
                for (Map.Entry entry : moduleExprDeclareds.entrySet()) {
                    if (!((ExpressionDeclItem)entry.getValue()).getVisibility().isNonPrivateNonTransient()) continue;
                    pathExprDeclared.add(entry.getKey(), unitModuleName, entry.getValue(), deploymentId);
                }
                for (Map.Entry entry : moduleScripts.entrySet()) {
                    if (!((ExpressionScriptProvided)entry.getValue()).getVisibility().isNonPrivateNonTransient()) continue;
                    pathScript.add(entry.getKey(), unitModuleName, entry.getValue(), deploymentId);
                }
                for (Map.Entry entry : moduleClassProvideds.entrySet()) {
                    if (!((ClassProvided)entry.getValue()).getVisibility().isNonPrivateNonTransient()) continue;
                    pathClassProvided.add(entry.getKey(), unitModuleName, entry.getValue(), deploymentId);
                }
            }
            catch (PathException ex) {
                throw new EPCompileException("Invalid path: " + ex.getMessage(), ex, Collections.emptyList());
            }
        }
        ModuleDependenciesCompileTime moduleDependencies = new ModuleDependenciesCompileTime();
        EventTypeCompileTimeResolver eventTypeCompileTimeResolver = new EventTypeCompileTimeResolver(moduleName, moduleUses, eventTypeCompileRegistry, eventTypeRepositoryPreconfigured, pathEventTypes, moduleDependencies, isFireAndForget);
        NamedWindowCompileTimeRegistry namedWindowCompileTimeRegistry = new NamedWindowCompileTimeRegistry();
        NamedWindowCompileTimeResolverImpl namedWindowCompileTimeResolver = new NamedWindowCompileTimeResolverImpl(moduleName, moduleUses, namedWindowCompileTimeRegistry, pathNamedWindows, moduleDependencies, isFireAndForget);
        ContextCompileTimeRegistry contextCompileTimeRegistry = new ContextCompileTimeRegistry();
        ContextCompileTimeResolverImpl contextCompileTimeResolver = new ContextCompileTimeResolverImpl(moduleName, moduleUses, contextCompileTimeRegistry, pathContexts, moduleDependencies, isFireAndForget);
        VariableCompileTimeRegistry variableCompileTimeRegistry = new VariableCompileTimeRegistry();
        VariableCompileTimeResolverImpl variableCompileTimeResolver = new VariableCompileTimeResolverImpl(moduleName, moduleUses, variableRepositoryPreconfigured, variableCompileTimeRegistry, pathVariables, moduleDependencies, isFireAndForget);
        ExprDeclaredCompileTimeRegistry exprDeclaredCompileTimeRegistry = new ExprDeclaredCompileTimeRegistry();
        ExprDeclaredCompileTimeResolverImpl exprDeclaredCompileTimeResolver = new ExprDeclaredCompileTimeResolverImpl(moduleName, moduleUses, exprDeclaredCompileTimeRegistry, pathExprDeclared, moduleDependencies, isFireAndForget);
        HashMap localTables = new HashMap();
        TableCompileTimeRegistry tableCompileTimeRegistry = new TableCompileTimeRegistry(localTables);
        TableCompileTimeResolverImpl tableCompileTimeResolver = new TableCompileTimeResolverImpl(moduleName, moduleUses, tableCompileTimeRegistry, pathTables, moduleDependencies, isFireAndForget);
        ScriptCompileTimeRegistry scriptCompileTimeRegistry = new ScriptCompileTimeRegistry();
        ScriptCompileTimeResolverImpl scriptCompileTimeResolver = new ScriptCompileTimeResolverImpl(moduleName, moduleUses, scriptCompileTimeRegistry, pathScript, moduleDependencies, isFireAndForget);
        ClassProvidedCompileTimeRegistry classProvidedCompileTimeRegistry = new ClassProvidedCompileTimeRegistry();
        ClassProvidedCompileTimeResolverImpl classProvidedCompileTimeResolver = new ClassProvidedCompileTimeResolverImpl(moduleName, moduleUses, classProvidedCompileTimeRegistry, pathClassProvided, moduleDependencies, isFireAndForget);
        PluggableObjectCollection plugInViews = new PluggableObjectCollection();
        plugInViews.addViews(configuration.getCompiler().getPlugInViews(), configuration.getCompiler().getPlugInVirtualDataWindows(), classpathImportServiceCompileTime);
        PluggableObjectRegistryImpl viewRegistry = new PluggableObjectRegistryImpl(new PluggableObjectCollection[]{ViewEnumHelper.getBuiltinViews(), plugInViews});
        ViewResolutionServiceImpl viewResolutionService = new ViewResolutionServiceImpl((PluggableObjectRegistry)viewRegistry);
        PluggableObjectCollection plugInPatternObj = new PluggableObjectCollection();
        plugInPatternObj.addPatternObjects(configuration.getCompiler().getPlugInPatternObjects(), classpathImportServiceCompileTime);
        plugInPatternObj.addObjects(PatternObjectHelper.getBuiltinPatternObjects());
        PatternObjectResolutionServiceImpl patternResolutionService = new PatternObjectResolutionServiceImpl(plugInPatternObj);
        IndexCompileTimeRegistry indexCompileTimeRegistry = new IndexCompileTimeRegistry(new HashMap());
        ModuleAccessModifierServiceImpl moduleVisibilityRules = new ModuleAccessModifierServiceImpl(options, configuration.getCompiler().getByteCode());
        DatabaseConfigServiceImpl databaseConfigServiceCompileTime = new DatabaseConfigServiceImpl(configuration.getCommon().getDatabaseReferences(), (ClasspathImportService)classpathImportServiceCompileTime);
        CompilerServicesImpl compilerServices = new CompilerServicesImpl();
        boolean targetHA = configuration.getClass().getName().endsWith("ConfigurationHA");
        SerdeEventTypeCompileTimeRegistryImpl serdeEventTypeRegistry = new SerdeEventTypeCompileTimeRegistryImpl(targetHA);
        SerdeCompileTimeResolverNonHA serdeResolver = targetHA ? CompilerHelperServices.makeSerdeResolver(configuration.getCompiler().getSerde(), configuration.getCommon().getTransientConfiguration()) : SerdeCompileTimeResolverNonHA.INSTANCE;
        return new ModuleCompileTimeServices((CompilerServices)compilerServices, configuration, classProvidedCompileTimeRegistry, (ClassProvidedCompileTimeResolver)classProvidedCompileTimeResolver, contextCompileTimeRegistry, (ContextCompileTimeResolver)contextCompileTimeResolver, beanEventTypeStemService, beanEventTypeFactoryPrivate, (DatabaseConfigServiceCompileTime)databaseConfigServiceCompileTime, classpathImportServiceCompileTime, exprDeclaredCompileTimeRegistry, (ExprDeclaredCompileTimeResolver)exprDeclaredCompileTimeResolver, eventTypeAvroHandler, eventTypeCompileRegistry, eventTypeCompileTimeResolver, eventTypeRepositoryPreconfigured, isFireAndForget, indexCompileTimeRegistry, moduleDependencies, (ModuleAccessModifierService)moduleVisibilityRules, (NamedWindowCompileTimeResolver)namedWindowCompileTimeResolver, namedWindowCompileTimeRegistry, classLoaderParent, (PatternObjectResolutionService)patternResolutionService, scriptCompileTimeRegistry, (ScriptCompileTimeResolver)scriptCompileTimeResolver, (SerdeEventTypeCompileTimeRegistry)serdeEventTypeRegistry, (SerdeCompileTimeResolver)serdeResolver, tableCompileTimeRegistry, (TableCompileTimeResolver)tableCompileTimeResolver, variableCompileTimeRegistry, (VariableCompileTimeResolver)variableCompileTimeResolver, (ViewResolutionService)viewResolutionService, xmlFragmentEventTypeFactory);
    }

    protected static ClasspathImportServiceCompileTime makeClasspathImportService(Configuration configuration) {
        TimeAbacus timeAbacus = TimeAbacusFactory.make((TimeUnit)configuration.getCommon().getTimeSource().getTimeUnit());
        ConfigurationCompilerExpression expression = configuration.getCompiler().getExpression();
        ClasspathImportServiceCompileTimeImpl classpathImportService = new ClasspathImportServiceCompileTimeImpl(configuration.getCommon().getTransientConfiguration(), timeAbacus, configuration.getCommon().getEventTypeAutoNamePackages(), expression.getMathContext(), expression.isExtendedAggregation(), configuration.getCompiler().getLanguage().isSortUsingCollator());
        try {
            for (String importName : configuration.getCommon().getImports()) {
                classpathImportService.addImport(importName);
            }
            for (String importName : configuration.getCommon().getAnnotationImports()) {
                classpathImportService.addAnnotationImport(importName);
            }
            for (ConfigurationCompilerPlugInAggregationFunction config : configuration.getCompiler().getPlugInAggregationFunctions()) {
                classpathImportService.addAggregation(config.getName(), config);
            }
            for (ConfigurationCompilerPlugInAggregationFunction config : configuration.getCompiler().getPlugInAggregationMultiFunctions()) {
                classpathImportService.addAggregationMultiFunction((ConfigurationCompilerPlugInAggregationMultiFunction)config);
            }
            for (ConfigurationCompilerPlugInAggregationFunction config : configuration.getCompiler().getPlugInSingleRowFunctions()) {
                classpathImportService.addSingleRow(config.getName(), config.getFunctionClassName(), config.getFunctionMethodName(), config.getValueCache(), config.getFilterOptimizable(), config.isRethrowExceptions(), config.getEventTypeName());
            }
            for (ConfigurationCompilerPlugInAggregationFunction config : configuration.getCompiler().getPlugInDateTimeMethods()) {
                classpathImportService.addPlugInDateTimeMethod(config.getName(), (ConfigurationCompilerPlugInDateTimeMethod)config);
            }
            for (ConfigurationCompilerPlugInAggregationFunction config : configuration.getCompiler().getPlugInEnumMethods()) {
                classpathImportService.addPlugInEnumMethod(config.getName(), (ConfigurationCompilerPlugInEnumMethod)config);
            }
        }
        catch (ClasspathImportException ex) {
            throw new ConfigurationException("Error configuring compiler: " + ex.getMessage(), (Throwable)ex);
        }
        return classpathImportService;
    }

    private static SerdeCompileTimeResolver makeSerdeResolver(ConfigurationCompilerSerde config, Map<String, Object> transientConfiguration) {
        SerdeProviderFactoryContext context = new SerdeProviderFactoryContext();
        List providers = null;
        if (config.getSerdeProviderFactories() != null) {
            for (String factory : config.getSerdeProviderFactories()) {
                try {
                    SerdeProviderFactory instance = (SerdeProviderFactory)JavaClassHelper.instantiate(SerdeProviderFactory.class, (String)factory, (ClassForNameProvider)TransientConfigurationResolver.resolveClassForNameProvider(transientConfiguration));
                    SerdeProvider provider = instance.getProvider(context);
                    if (provider == null) {
                        throw new ConfigurationException("Binding provider factory '" + factory + "' returned a null value");
                    }
                    if (providers == null) {
                        providers = new ArrayList();
                    }
                    providers.add(provider);
                }
                catch (RuntimeException ex) {
                    throw new ConfigurationException("Binding provider factory '" + factory + "' failed to initialize: " + ex.getMessage(), (Throwable)ex);
                }
            }
        }
        if (providers == null) {
            providers = Collections.emptyList();
        }
        return new SerdeCompileTimeResolverImpl(providers, config.isEnableExtendedBuiltin(), config.isEnableSerializable(), config.isEnableExternalizable(), config.isEnableSerializationFallback());
    }
}

