/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.util;

import com.espertech.esper.common.internal.epl.expression.core.ExprSubstitutionNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CompilerHelperValidator {
    public static void verifySubstitutionParams(List<ExprSubstitutionNode> substitutionParameters) throws ExprValidationException {
        if (substitutionParameters.isEmpty()) {
            return;
        }
        HashMap<String, Class> named = new HashMap<String, Class>();
        ArrayList<Class> unnamed = new ArrayList<Class>();
        for (ExprSubstitutionNode node : substitutionParameters) {
            if (node.getOptionalName() != null) {
                String name = node.getOptionalName();
                Class existing = (Class)named.get(name);
                if (existing == null) {
                    named.put(name, node.getResolvedType());
                    continue;
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface((Class)node.getResolvedType(), (Class)existing)) continue;
                throw new ExprValidationException("Substitution parameter '" + name + "' incompatible type assignment between types '" + existing.getName() + "' and '" + node.getResolvedType().getName() + "'");
            }
            unnamed.add(node.getResolvedType());
        }
        if (!unnamed.isEmpty() && !named.isEmpty()) {
            throw new ExprValidationException("Inconsistent use of substitution parameters, expecting all substitutions to either all provide a name or provide no name");
        }
    }
}

