/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.util;

import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.compile.stage3.ModuleCompileTimeServices;
import com.espertech.esper.common.internal.context.util.ByteArrayProvidingClassLoader;
import com.espertech.esper.compiler.internal.util.CodeGenerationUtil;
import com.espertech.esper.compiler.internal.util.CodegenClassGenerator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Map;
import org.codehaus.janino.ClassLoaderIClassLoader;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.util.ClassFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaninoCompiler {
    private static final Logger log = LoggerFactory.getLogger(JaninoCompiler.class);

    protected static void compile(CodegenClass clazz, Map<String, byte[]> classpath, Map<String, byte[]> output, ModuleCompileTimeServices compileTimeServices) {
        boolean withCodeLogging = compileTimeServices.getConfiguration().getCompiler().getLogging().isEnableCode();
        String code = CodegenClassGenerator.compile(clazz);
        JaninoCompiler.compileInternal(code, clazz.getClassName(), classpath, output, withCodeLogging, (ClassLoader)compileTimeServices.getParentClassLoader(), true);
    }

    protected static void compile(String code, String filenameWithoutExtension, Map<String, byte[]> classpath, Map<String, byte[]> output, ModuleCompileTimeServices compileTimeServices) {
        boolean withCodeLogging = compileTimeServices.getConfiguration().getCompiler().getLogging().isEnableCode();
        JaninoCompiler.compileInternal(code, filenameWithoutExtension, classpath, output, withCodeLogging, (ClassLoader)compileTimeServices.getParentClassLoader(), false);
    }

    private static void compileInternal(String code, String classNameForFile, Map<String, byte[]> classpath, Map<String, byte[]> output, boolean withCodeLogging, ClassLoader classLoader, boolean withErrorLogging) {
        try {
            String optionalFileName = null;
            if (Boolean.getBoolean("org.codehaus.janino.source_debugging.enable")) {
                boolean created;
                File file;
                String dirName = System.getProperty("org.codehaus.janino.source_debugging.dir");
                if (dirName == null) {
                    dirName = System.getProperty("java.io.tmpdir");
                }
                if (!(file = new File(dirName, classNameForFile + ".java")).exists() && !(created = file.createNewFile())) {
                    throw new RuntimeException("Failed to created file '" + file + "'");
                }
                try (FileWriter writer = null;){
                    writer = new FileWriter(file);
                    PrintWriter print = new PrintWriter(writer);
                    print.write(code);
                    print.close();
                }
                file.deleteOnExit();
                optionalFileName = file.getAbsolutePath();
            }
            Scanner scanner = new Scanner(optionalFileName, (InputStream)new ByteArrayInputStream(code.getBytes("UTF-8")), "UTF-8");
            ByteArrayProvidingClassLoader cl = new ByteArrayProvidingClassLoader(classpath, classLoader);
            UnitCompiler unitCompiler = new UnitCompiler(new Parser(scanner).parseAbstractCompilationUnit(), (IClassLoader)new ClassLoaderIClassLoader((ClassLoader)cl));
            ClassFile[] classFiles = unitCompiler.compileUnit(true, true, true);
            for (int i = 0; i < classFiles.length; ++i) {
                output.put(classFiles[i].getThisClassName(), classFiles[i].toByteArray());
            }
            if (withCodeLogging) {
                log.info("Code:\n" + CodeGenerationUtil.codeWithLineNum(code));
            }
        }
        catch (Exception ex) {
            if (withErrorLogging) {
                log.error("Failed to compile: " + ex.getMessage() + "\ncode:" + CodeGenerationUtil.codeWithLineNum(code));
            }
            throw new RuntimeException(ex);
        }
    }
}

