/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.util;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.annotation.BusEventType;
import com.espertech.esper.common.client.annotation.Private;
import com.espertech.esper.common.client.annotation.Protected;
import com.espertech.esper.common.client.annotation.Public;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerByteCode;
import com.espertech.esper.common.client.util.EventTypeBusModifier;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.ModuleAccessModifierService;
import com.espertech.esper.common.internal.compile.stage3.StatementBaseInfo;
import com.espertech.esper.common.internal.epl.annotation.AnnotationUtil;
import com.espertech.esper.compiler.client.CompilerOptions;
import com.espertech.esper.compiler.client.option.AccessModifierContextContext;
import com.espertech.esper.compiler.client.option.AccessModifierEventTypeContext;
import com.espertech.esper.compiler.client.option.AccessModifierExpressionContext;
import com.espertech.esper.compiler.client.option.AccessModifierNamedWindowContext;
import com.espertech.esper.compiler.client.option.AccessModifierScriptContext;
import com.espertech.esper.compiler.client.option.AccessModifierTableContext;
import com.espertech.esper.compiler.client.option.AccessModifierVariableContext;
import com.espertech.esper.compiler.client.option.BusModifierEventTypeContext;
import java.lang.annotation.Annotation;
import java.util.function.Function;

public class ModuleAccessModifierServiceImpl
implements ModuleAccessModifierService {
    private final CompilerOptions options;
    private final ConfigurationCompilerByteCode config;

    ModuleAccessModifierServiceImpl(CompilerOptions options, ConfigurationCompilerByteCode config) {
        this.options = options;
        this.config = config;
    }

    public NameAccessModifier getAccessModifierEventType(StatementRawInfo raw, String eventTypeName) {
        return this.getModifier(raw.getAnnotations(), opts -> opts.getAccessModifierEventType() == null ? null : opts.getAccessModifierEventType().getValue(new AccessModifierEventTypeContext(raw, eventTypeName)), ConfigurationCompilerByteCode::getAccessModifierEventType);
    }

    public NameAccessModifier getAccessModifierVariable(StatementBaseInfo base, String variableName) {
        return this.getModifier(base.getStatementRawInfo().getAnnotations(), opts -> opts.getAccessModifierVariable() == null ? null : opts.getAccessModifierVariable().getValue(new AccessModifierVariableContext(base, variableName)), ConfigurationCompilerByteCode::getAccessModifierVariable);
    }

    public NameAccessModifier getAccessModifierContext(StatementBaseInfo base, String contextName) {
        return this.getModifier(base.getStatementRawInfo().getAnnotations(), opts -> opts.getAccessModifierContext() == null ? null : opts.getAccessModifierContext().getValue(new AccessModifierContextContext(base, contextName)), ConfigurationCompilerByteCode::getAccessModifierContext);
    }

    public NameAccessModifier getAccessModifierExpression(StatementBaseInfo base, String expressionName) {
        return this.getModifier(base.getStatementRawInfo().getAnnotations(), opts -> opts.getAccessModifierExpression() == null ? null : opts.getAccessModifierExpression().getValue(new AccessModifierExpressionContext(base, expressionName)), ConfigurationCompilerByteCode::getAccessModifierExpression);
    }

    public NameAccessModifier getAccessModifierTable(StatementBaseInfo base, String tableName) {
        return this.getModifier(base.getStatementRawInfo().getAnnotations(), opts -> opts.getAccessModifierTable() == null ? null : opts.getAccessModifierTable().getValue(new AccessModifierTableContext(base, tableName)), ConfigurationCompilerByteCode::getAccessModifierTable);
    }

    public NameAccessModifier getAccessModifierNamedWindow(StatementBaseInfo base, String namedWindowName) {
        return this.getModifier(base.getStatementRawInfo().getAnnotations(), opts -> opts.getAccessModifierNamedWindow() == null ? null : opts.getAccessModifierNamedWindow().getValue(new AccessModifierNamedWindowContext(base, namedWindowName)), ConfigurationCompilerByteCode::getAccessModifierNamedWindow);
    }

    public NameAccessModifier getAccessModifierScript(StatementBaseInfo base, String scriptName, int numParameters) {
        return this.getModifier(base.getStatementRawInfo().getAnnotations(), opts -> opts.getAccessModifierScript() == null ? null : opts.getAccessModifierScript().getValue(new AccessModifierScriptContext(base, scriptName, numParameters)), ConfigurationCompilerByteCode::getAccessModifierScript);
    }

    public EventTypeBusModifier getBusModifierEventType(StatementRawInfo raw, String eventTypeName) {
        EventTypeBusModifier result;
        if (this.options.getBusModifierEventType() != null && (result = this.options.getBusModifierEventType().getValue(new BusModifierEventTypeContext(raw, eventTypeName))) != null) {
            return result;
        }
        boolean busEventType = AnnotationUtil.hasAnnotation((Annotation[])raw.getAnnotations(), BusEventType.class);
        if (busEventType) {
            return EventTypeBusModifier.BUS;
        }
        return this.config.getBusModifierEventType();
    }

    private <T> NameAccessModifier getModifier(Annotation[] annotations, Function<CompilerOptions, NameAccessModifier> optionsGet, Function<ConfigurationCompilerByteCode, NameAccessModifier> configGet) {
        NameAccessModifier result;
        if (this.options != null && (result = optionsGet.apply(this.options)) != null) {
            return result;
        }
        boolean isPrivate = AnnotationUtil.hasAnnotation((Annotation[])annotations, Private.class);
        boolean isProtected = AnnotationUtil.hasAnnotation((Annotation[])annotations, Protected.class);
        boolean isPublic = AnnotationUtil.hasAnnotation((Annotation[])annotations, Public.class);
        if (isPrivate) {
            if (isProtected) {
                throw new EPException("Encountered both the @private and the @protected annotation");
            }
            if (isPublic) {
                throw new EPException("Encountered both the @private and the @public annotation");
            }
        } else if (isProtected && isPublic) {
            throw new EPException("Encountered both the @protected and the @public annotation");
        }
        if (isPrivate) {
            return NameAccessModifier.PRIVATE;
        }
        if (isProtected) {
            return NameAccessModifier.PROTECTED;
        }
        if (isPublic) {
            return NameAccessModifier.PUBLIC;
        }
        return configGet.apply(this.config);
    }
}

