/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.util;

import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.compiler.internal.generated.EsperEPL2GrammarLexer;
import com.espertech.esper.compiler.internal.parse.CaseInsensitiveInputStream;
import com.espertech.esper.compiler.internal.parse.ParseHelper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLLexer {
    private static final Logger log = LoggerFactory.getLogger(SQLLexer.class);

    public static String lexSampleSQL(String querySQL) throws ExprValidationException {
        StringWriter changedSQL;
        int insertIndex;
        String text;
        Token token;
        querySQL = querySQL.replaceAll("\\s\\s+|\\n|\\r", " ");
        CaseInsensitiveInputStream input = new CaseInsensitiveInputStream(querySQL);
        int whereIndex = -1;
        int groupbyIndex = -1;
        int havingIndex = -1;
        int orderByIndex = -1;
        ArrayList<Integer> unionIndexes = new ArrayList<Integer>();
        EsperEPL2GrammarLexer lex = ParseHelper.newLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
        tokens.fill();
        List tokenList = tokens.getTokens();
        for (int i = 0; i < tokenList.size() && (token = (Token)tokenList.get(i)) != null && token.getText() != null; ++i) {
            text = token.getText().toLowerCase(Locale.ENGLISH).trim();
            if (text.equals("where")) {
                whereIndex = token.getCharPositionInLine() + 1;
            }
            if (text.equals("group")) {
                groupbyIndex = token.getCharPositionInLine() + 1;
            }
            if (text.equals("having")) {
                havingIndex = token.getCharPositionInLine() + 1;
            }
            if (text.equals("order")) {
                orderByIndex = token.getCharPositionInLine() + 1;
            }
            if (!text.equals("union")) continue;
            unionIndexes.add(token.getCharPositionInLine() + 1);
        }
        if (unionIndexes.size() != 0) {
            StringWriter changedSQL2 = new StringWriter();
            int lastIndex = 0;
            for (int i = 0; i < unionIndexes.size(); ++i) {
                int index = (Integer)unionIndexes.get(i);
                String fragment = i > 0 ? querySQL.substring(lastIndex + 5, index - 1) : querySQL.substring(lastIndex, index - 1);
                String lexedFragment = SQLLexer.lexSampleSQL(fragment);
                if (i > 0) {
                    changedSQL2.append("union ");
                }
                changedSQL2.append(lexedFragment);
                lastIndex = index - 1;
            }
            String fragment = querySQL.substring(lastIndex + 5, querySQL.length());
            String lexedFragment = SQLLexer.lexSampleSQL(fragment);
            changedSQL2.append("union ");
            changedSQL2.append(lexedFragment);
            return changedSQL2.toString();
        }
        if (whereIndex != -1) {
            StringWriter changedSQL3 = new StringWriter();
            String prefix = querySQL.substring(0, whereIndex + 5);
            String suffix = querySQL.substring(whereIndex + 5, querySQL.length());
            changedSQL3.write(prefix);
            changedSQL3.write("1=0 and ");
            changedSQL3.write(suffix);
            return changedSQL3.toString();
        }
        if (groupbyIndex != -1) {
            insertIndex = groupbyIndex;
        } else if (havingIndex != -1) {
            insertIndex = havingIndex;
        } else if (orderByIndex != -1) {
            insertIndex = orderByIndex;
        } else {
            changedSQL = new StringWriter();
            changedSQL.write(querySQL);
            changedSQL.write(" where 1=0 ");
            return changedSQL.toString();
        }
        try {
            changedSQL = new StringWriter();
            String prefix = querySQL.substring(0, insertIndex - 1);
            changedSQL.write(prefix);
            changedSQL.write("where 1=0 ");
            String suffix = querySQL.substring(insertIndex - 1, querySQL.length());
            changedSQL.write(suffix);
            return changedSQL.toString();
        }
        catch (Exception ex) {
            text = "Error constructing sample SQL to retrieve metadata for JDBC-drivers that don't support metadata, consider using the $ESPER-SAMPLE-WHERE placeholder or providing a sample SQL";
            log.error(text, (Throwable)ex);
            throw new ExprValidationException(text, (Throwable)ex);
        }
    }
}

