/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.client.util;

import com.espertech.esper.common.client.EPCompiled;
import com.espertech.esper.common.client.EPCompiledManifest;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class EPCompiledIOUtil {
    public static final String MANIFEST_COMPILER_VERSION = "Esper-CompilerVersion";
    public static final String MANIFEST_MODULEPROVIDERCLASSNAME = "Esper-ModuleProvider";
    public static final String MANIFEST_QUERYPROVIDERCLASSNAME = "Esper-QueryProvider";
    public static final String MANIFEST_TARGETHA = "Esper-TargetHA";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(EPCompiled compiled, File file) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(new Attributes.Name(MANIFEST_COMPILER_VERSION), compiled.getManifest().getCompilerVersion());
        manifest.getMainAttributes().put(new Attributes.Name(MANIFEST_MODULEPROVIDERCLASSNAME), compiled.getManifest().getModuleProviderClassName());
        manifest.getMainAttributes().put(new Attributes.Name(MANIFEST_QUERYPROVIDERCLASSNAME), compiled.getManifest().getQueryProviderClassName());
        if (compiled.getManifest().isTargetHA()) {
            manifest.getMainAttributes().put(new Attributes.Name(MANIFEST_TARGETHA), "true");
        }
        try (JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(file), manifest);){
            for (Map.Entry entry : compiled.getClasses().entrySet()) {
                EPCompiledIOUtil.write((String)entry.getKey(), (byte[])entry.getValue(), target);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EPCompiled read(File file) throws IOException {
        JarFile jarFile = new JarFile(file);
        Attributes attributes = jarFile.getManifest().getMainAttributes();
        String compilerVersion = EPCompiledIOUtil.getAttribute(attributes, MANIFEST_COMPILER_VERSION);
        if (compilerVersion == null) {
            throw new IOException("Manifest is missing Esper-CompilerVersion");
        }
        String moduleProvider = EPCompiledIOUtil.getAttribute(attributes, MANIFEST_MODULEPROVIDERCLASSNAME);
        String queryProvider = EPCompiledIOUtil.getAttribute(attributes, MANIFEST_QUERYPROVIDERCLASSNAME);
        if (moduleProvider == null && queryProvider == null) {
            throw new IOException("Manifest is missing both Esper-ModuleProvider and Esper-QueryProvider");
        }
        String targetHAStr = EPCompiledIOUtil.getAttribute(attributes, MANIFEST_TARGETHA);
        boolean targetHA = targetHAStr != null && Boolean.parseBoolean(targetHAStr);
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        try {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                EPCompiledIOUtil.read(jarFile, entries.nextElement(), classes);
            }
        }
        finally {
            jarFile.close();
        }
        return new EPCompiled(classes, new EPCompiledManifest(compilerVersion, moduleProvider, queryProvider, targetHA));
    }

    private static String getAttribute(Attributes attributes, String name) {
        Attributes.Name attr = new Attributes.Name(name);
        String value = attributes.getValue(attr);
        if (value == null || value.equals("null")) {
            return null;
        }
        return value;
    }

    private static void write(String name, byte[] value, JarOutputStream target) throws IOException {
        name = ((String)name).replace(".", "/") + ".class";
        JarEntry entry = new JarEntry((String)name);
        entry.setTime(System.currentTimeMillis());
        target.putNextEntry(entry);
        target.write(value, 0, value.length);
        target.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void read(JarFile jarFile, JarEntry jarEntry, Map<String, byte[]> classes) throws IOException {
        byte[] bytes;
        if (jarEntry.isDirectory() || jarEntry.getName().equals("META-INF/MANIFEST.MF")) {
            return;
        }
        long size = jarEntry.getSize();
        if (size > 0x7FFFFFFEL) {
            throw new IOException("Encountered jar entry with size " + size + " greater than max integer size");
        }
        try (InputStream in = jarFile.getInputStream(jarEntry);){
            int len;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
            bytes = os.toByteArray();
        }
        String className = jarEntry.getName().replace("/", ".");
        if (className.endsWith(".class")) {
            className = className.substring(0, className.length() - 6);
        }
        classes.put(className, bytes);
    }
}

