/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.compiler.abstraction;

import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationIDGenerator;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstraction;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionClassCollection;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionClassCollectionImpl;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionCompilationContext;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionCompileSourcesResult;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.compiler.internal.compiler.janino.JaninoCompiler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.commons.compiler.CompileException;

public class CompilerAbstractionJanino
implements CompilerAbstraction {
    public static final CompilerAbstractionJanino INSTANCE = new CompilerAbstractionJanino();

    private CompilerAbstractionJanino() {
    }

    public CompilerAbstractionClassCollection newClassCollection() {
        return new CompilerAbstractionClassCollectionImpl();
    }

    public void compileClasses(List<CodegenClass> classes, CompilerAbstractionCompilationContext context, CompilerAbstractionClassCollection state) {
        CompilerAbstractionClassCollectionImpl janino = (CompilerAbstractionClassCollectionImpl)state;
        for (CodegenClass clazz : classes) {
            JaninoCompiler.compile(clazz, janino.getClasses(), janino.getClasses(), context);
        }
    }

    public CompilerAbstractionCompileSourcesResult compileSources(List<String> sources, CompilerAbstractionCompilationContext context, CompilerAbstractionClassCollection state) {
        int index = -1;
        LinkedHashMap<String, List> names = new LinkedHashMap<String, List>(CollectionUtil.capacityHashMap((int)sources.size()));
        for (String classText : sources) {
            String filename = "provided_" + ++index + "_" + CodeGenerationIDGenerator.generateClassNameUUID();
            HashMap<String, byte[]> output = new HashMap<String, byte[]>();
            try {
                JaninoCompiler.compile(classText, filename, state.getClasses(), output, context.getCompileResultConsumer(), context.getServices());
            }
            catch (RuntimeException ex) {
                String message = ex.getMessage().replace(CompileException.class.getName() + ": ", "");
                throw new RuntimeException(message + " for class [\"\"\"" + classText + "\"\"\"]", ex);
            }
            for (Map.Entry entry : output.entrySet()) {
                if (state.getClasses().containsKey(entry.getKey())) {
                    throw new RuntimeException("Duplicate class by name '" + (String)entry.getKey() + "'");
                }
                List classNames = names.computeIfAbsent(classText, k -> new ArrayList(2));
                classNames.add((String)entry.getKey());
            }
            state.add(output);
        }
        return new CompilerAbstractionCompileSourcesResult(names);
    }
}

