/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.compiler.abstraction;

import com.espertech.esper.common.client.EPCompiled;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstraction;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionClassCollection;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionClassCollectionImpl;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionCompilationContext;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionCompileSourcesResult;
import com.espertech.esper.compiler.internal.compiler.toolprovider.JavaFileManagerForwarding;
import com.espertech.esper.compiler.internal.compiler.toolprovider.JavaFileObjectSource;
import com.espertech.esper.compiler.internal.util.CodeGenerationUtil;
import com.espertech.esper.compiler.internal.util.CodegenClassGenerator;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompilerAbstractionToolProvider
implements CompilerAbstraction {
    private static final Logger log = LoggerFactory.getLogger(CompilerAbstractionToolProvider.class);
    private static final String ID_PATTERN = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final Pattern FQCN = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    private final JavaCompiler javaCompiler;

    public CompilerAbstractionToolProvider(JavaCompiler javaCompiler) {
        if (javaCompiler == null) {
            throw new IllegalArgumentException("Compiler tool option expected " + JavaCompiler.class.getName() + " but received a null value (check tool presence in classpath i.e. JDK vs JRE)");
        }
        this.javaCompiler = javaCompiler;
    }

    public CompilerAbstractionClassCollection newClassCollection() {
        return new CompilerAbstractionClassCollectionImpl();
    }

    public void compileClasses(List<CodegenClass> classes, CompilerAbstractionCompilationContext context, CompilerAbstractionClassCollection state) {
        ArrayList<JavaFileObject> fileObjects = new ArrayList<JavaFileObject>(classes.size());
        for (CodegenClass clazz : classes) {
            String code = CodegenClassGenerator.generate(clazz);
            String filename = clazz.getClassName() + ".java";
            URI fileURI = URI.create(filename);
            fileObjects.add(new JavaFileObjectSource(fileURI, JavaFileObject.Kind.SOURCE, code));
        }
        this.compileFileObjects(fileObjects, state, true, context);
    }

    public CompilerAbstractionCompileSourcesResult compileSources(List<String> sources, CompilerAbstractionCompilationContext context, CompilerAbstractionClassCollection state) {
        ArrayList<JavaFileObject> fileObjects = new ArrayList<JavaFileObject>(sources.size());
        LinkedHashSet<CallSite> classNames = new LinkedHashSet<CallSite>();
        for (String code : sources) {
            String classNameNoPackage = this.findClassName(code);
            String classNameFull = context.getGeneratedCodePackageName() + "." + classNameNoPackage;
            if (classNames.contains(classNameFull)) {
                throw new RuntimeException("Class name '" + classNameFull + "' appears multiple times");
            }
            classNames.add((CallSite)((Object)classNameFull));
            String filename = classNameNoPackage + ".java";
            URI fileURI = URI.create(filename);
            String sourceWithPackage = this.buildSourceWithPackage(code, context.getGeneratedCodePackageName());
            JavaFileObjectSource sourceFile = new JavaFileObjectSource(fileURI, JavaFileObject.Kind.SOURCE, sourceWithPackage);
            fileObjects.add(sourceFile);
        }
        Map<String, List<String>> classNamesProduced = this.compileFileObjects(fileObjects, state, false, context);
        return new CompilerAbstractionCompileSourcesResult(classNamesProduced);
    }

    private String buildSourceWithPackage(String code, String generatedCodePackageName) {
        StringWriter writer = new StringWriter();
        writer.append("package ").append(generatedCodePackageName).append(";").append(System.lineSeparator()).append(code);
        return writer.toString();
    }

    private synchronized Map<String, List<String>> compileFileObjects(List<JavaFileObject> fileObjects, CompilerAbstractionClassCollection state, boolean logCodeOnError, CompilerAbstractionCompilationContext context) {
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>(state.getClasses());
        for (EPCompiled compiled : context.getPath()) {
            for (String clazz : context.getParentClassLoader().getClasses().keySet()) {
                byte[] bytes = (byte[])compiled.getClasses().get(clazz);
                if (bytes == null) continue;
                classes.put(clazz, bytes);
            }
        }
        DiagnosticCollector ds = new DiagnosticCollector();
        StandardJavaFileManager mgr = this.javaCompiler.getStandardFileManager(ds, null, null);
        JavaFileManagerForwarding fileManager = new JavaFileManagerForwarding(context.getGeneratedCodePackageName(), mgr, classes);
        JavaCompiler.CompilationTask task = this.javaCompiler.getTask(null, fileManager, ds, null, null, fileObjects);
        Boolean result = task.call();
        List<Diagnostic<? extends JavaFileObject>> diagnostics = ds.getDiagnostics();
        if (result == null || !result.booleanValue()) {
            if (diagnostics.isEmpty()) {
                throw new RuntimeException("Failed to compile (without diagnostics, please check the log and console output)");
            }
            if (logCodeOnError) {
                this.logCodeWithErrors(diagnostics);
            }
            Diagnostic<? extends JavaFileObject> d = diagnostics.get(0);
            String message = this.format(d);
            throw new RuntimeException("Failed to compile: " + message);
        }
        if (context.isLogging()) {
            for (JavaFileObject in : fileObjects) {
                log.info("Code:\n" + CodeGenerationUtil.codeWithLineNum(((JavaFileObjectSource)in).getCode()));
            }
        }
        fileManager.addClasses(state);
        return fileManager.getClassNamesProduced();
    }

    private void logCodeWithErrors(List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        LinkedHashMap<JavaFileObjectSource, List> perSource = new LinkedHashMap<JavaFileObjectSource, List>();
        for (Diagnostic<? extends JavaFileObject> diagnostic : diagnostics) {
            if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
            JavaFileObjectSource source = (JavaFileObjectSource)diagnostic.getSource();
            List existing = perSource.computeIfAbsent(source, k -> new ArrayList(2));
            existing.add(diagnostic);
        }
        for (Map.Entry entry : perSource.entrySet()) {
            List list = (List)entry.getValue();
            if (list.size() == 1) {
                log.error("Failed to compile: {}\ncode:{}", (Object)this.format((Diagnostic)list.get(0)), (Object)CodeGenerationUtil.codeWithLineNum(((JavaFileObjectSource)entry.getKey()).getCode()));
                continue;
            }
            int index = 1;
            for (Diagnostic diagnostic : (List)entry.getValue()) {
                log.error("Diagnostic #{}: {}", (Object)index, (Object)this.format(diagnostic));
                ++index;
            }
            log.error("Failed to compile with {} diagnostics is code: {}", (Object)((List)entry.getValue()).size(), (Object)CodeGenerationUtil.codeWithLineNum(((JavaFileObjectSource)entry.getKey()).getCode()));
        }
    }

    private String findClassName(String code) {
        String[] prefixes = new String[]{"public class ", "public interface ", "public @interface ", "public enum "};
        Supplier<RuntimeException> exceptionSupplier = () -> new RuntimeException("Failed to determine class name based on occurrence of " + Arrays.asList(prefixes) + " in source [" + code + "]");
        int indexFound = -1;
        String prefixFound = null;
        for (String prefix : prefixes) {
            int index = code.indexOf(prefix);
            if (index == -1) continue;
            indexFound = index;
            prefixFound = prefix;
            break;
        }
        if (indexFound == -1) {
            throw exceptionSupplier.get();
        }
        String begin = code.substring(indexFound + prefixFound.length());
        Matcher matcher = FQCN.matcher(begin);
        if (!matcher.find()) {
            throw exceptionSupplier.get();
        }
        return matcher.group();
    }

    private String format(Diagnostic<? extends JavaFileObject> d) {
        return String.format("Line: %d, %s in %s", d.getLineNumber(), d.getMessage(null), d.getSource().getName());
    }
}

