/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.compiler.toolprovider;

import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionClassCollection;
import com.espertech.esper.common.internal.serde.serdeset.builtin.FastByteArrayInputStream;
import com.espertech.esper.common.internal.serde.serdeset.builtin.FastByteArrayOutputStream;
import com.espertech.esper.compiler.internal.compiler.toolprovider.JavaFileObjectForInput;
import com.espertech.esper.compiler.internal.compiler.toolprovider.JavaFileObjectForOutput;
import com.espertech.esper.compiler.internal.compiler.toolprovider.JavaFileObjectSource;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class JavaFileManagerForwarding
extends ForwardingJavaFileManager<JavaFileManager> {
    private final String generatedCodePackageName;
    private final Map<String, byte[]> classpath;
    private final Map<String, FastByteArrayOutputStream> classes = new HashMap<String, FastByteArrayOutputStream>();
    private final Map<String, List<String>> codeToClassNames = new LinkedHashMap<String, List<String>>();

    public JavaFileManagerForwarding(String generatedCodePackageName, JavaFileManager fileManager, Map<String, byte[]> classpath) {
        super(fileManager);
        this.generatedCodePackageName = generatedCodePackageName;
        this.classpath = classpath;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        if (!location.equals(StandardLocation.CLASS_PATH) || this.classpath.isEmpty() || !packageName.equals(this.generatedCodePackageName)) {
            return super.list(location, packageName, kinds, recurse);
        }
        ArrayList<JavaFileObject> cp = new ArrayList<JavaFileObject>(this.classpath.size());
        String prefix = this.generatedCodePackageName + ".";
        for (Map.Entry<String, byte[]> entry : this.classpath.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            Object filename = entry.getKey() + ".class";
            filename = ((String)filename).replace(prefix, "");
            URI fileURI = URI.create((String)filename);
            FastByteArrayInputStream fis = new FastByteArrayInputStream(entry.getValue());
            cp.add(new JavaFileObjectForInput(fileURI, JavaFileObject.Kind.CLASS, entry.getKey(), fis));
        }
        return cp;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof JavaFileObjectForInput) {
            JavaFileObjectForInput input = (JavaFileObjectForInput)file;
            return input.getClassNameFull();
        }
        return super.inferBinaryName(location, file);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        String filename = className + ".class";
        URI fileURI = URI.create(filename);
        FastByteArrayOutputStream fos = new FastByteArrayOutputStream();
        this.classes.put(className, fos);
        JavaFileObjectSource src = (JavaFileObjectSource)sibling;
        List<String> classNames = this.codeToClassNames.get(src.getCode());
        if (classNames == null) {
            classNames = new ArrayList<String>(2);
            classNames.add(className);
            this.codeToClassNames.put(src.getCode(), classNames);
        } else if (!classNames.contains(className)) {
            classNames.add(className);
        }
        return new JavaFileObjectForOutput(fileURI, kind, fos);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        return super.getFileForOutput(location, packageName, relativeName, sibling);
    }

    public void addClasses(CompilerAbstractionClassCollection state) {
        for (Map.Entry<String, FastByteArrayOutputStream> entry : this.classes.entrySet()) {
            state.getClasses().put(entry.getKey(), entry.getValue().getByteArrayFast());
        }
    }

    public Map<String, List<String>> getClassNamesProduced() {
        return this.codeToClassNames;
    }
}

