/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.parse;

import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage1.spec.AnnotationDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.settings.ClasspathExtensionClass;
import com.espertech.esper.common.internal.settings.ClasspathExtensionClassEmpty;
import com.espertech.esper.common.internal.settings.ClasspathImportCompileTimeUtil;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceCompileTime;
import com.espertech.esper.common.internal.util.ValueAndFieldDesc;
import com.espertech.esper.compiler.internal.generated.EsperEPL2GrammarParser;
import com.espertech.esper.compiler.internal.parse.ASTConstantHelper;
import com.espertech.esper.compiler.internal.parse.ASTUtil;
import com.espertech.esper.compiler.internal.parse.ASTWalkException;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class ASTAnnotationHelper {
    public static AnnotationDesc walk(EsperEPL2GrammarParser.AnnotationEnumContext ctx, ClasspathImportServiceCompileTime classpathImportService) throws ASTWalkException {
        String name = ASTUtil.unescapeClassIdent(ctx.classIdentifier());
        ArrayList<Pair<String, Object>> values = new ArrayList<Pair<String, Object>>();
        if (ctx.elementValueEnum() != null) {
            Object value = ASTAnnotationHelper.walkValue(ctx.elementValueEnum(), classpathImportService);
            values.add((Pair<String, Object>)new Pair((Object)"value", value));
        } else if (ctx.elementValuePairsEnum() != null) {
            ASTAnnotationHelper.walkValuePairs(ctx.elementValuePairsEnum(), values, classpathImportService);
        }
        return new AnnotationDesc(name, values);
    }

    private static void walkValuePairs(EsperEPL2GrammarParser.ElementValuePairsEnumContext elementValuePairsEnumContext, List<Pair<String, Object>> values, ClasspathImportServiceCompileTime classpathImportService) {
        for (EsperEPL2GrammarParser.ElementValuePairEnumContext ctx : elementValuePairsEnumContext.elementValuePairEnum()) {
            Pair<String, Object> pair = ASTAnnotationHelper.walkValuePair(ctx, classpathImportService);
            values.add(pair);
        }
    }

    private static Object walkValue(EsperEPL2GrammarParser.ElementValueEnumContext ctx, ClasspathImportServiceCompileTime classpathImportService) {
        if (ctx.elementValueArrayEnum() != null) {
            return ASTAnnotationHelper.walkArray(ctx.elementValueArrayEnum(), classpathImportService);
        }
        if (ctx.annotationEnum() != null) {
            return ASTAnnotationHelper.walk(ctx.annotationEnum(), classpathImportService);
        }
        if (ctx.v != null) {
            return ctx.v.getText();
        }
        if (ctx.classIdentifier() != null) {
            return ASTAnnotationHelper.walkClassIdent(ctx.classIdentifier(), classpathImportService);
        }
        return ASTConstantHelper.parse((ParseTree)ctx.constant());
    }

    private static Pair<String, Object> walkValuePair(EsperEPL2GrammarParser.ElementValuePairEnumContext ctx, ClasspathImportServiceCompileTime classpathImportService) {
        String name = ctx.keywordAllowedIdent().getText();
        Object value = ASTAnnotationHelper.walkValue(ctx.elementValueEnum(), classpathImportService);
        return new Pair((Object)name, value);
    }

    private static Object walkClassIdent(EsperEPL2GrammarParser.ClassIdentifierContext ctx, ClasspathImportServiceCompileTime classpathImportService) {
        ValueAndFieldDesc enumValueAndField;
        String enumValueText = ctx.getText();
        try {
            enumValueAndField = ClasspathImportCompileTimeUtil.resolveIdentAsEnumConst((String)enumValueText, (ClasspathImportServiceCompileTime)classpathImportService, (ClasspathExtensionClass)ClasspathExtensionClassEmpty.INSTANCE, (boolean)true);
        }
        catch (ExprValidationException e) {
            throw ASTWalkException.from("Annotation value '" + enumValueText + "' is not recognized as an enumeration value, please check imports or use a primitive or string type");
        }
        if (enumValueAndField != null) {
            return enumValueAndField.getValue();
        }
        Class enumValue = null;
        if (enumValueText.endsWith(".class") && enumValueText.length() > 6) {
            try {
                String name = enumValueText.substring(0, enumValueText.length() - 6);
                enumValue = classpathImportService.resolveClass(name, true, (ClasspathExtensionClass)ClasspathExtensionClassEmpty.INSTANCE);
            }
            catch (ClasspathImportException classpathImportException) {
                // empty catch block
            }
        }
        if (enumValue != null) {
            return enumValue;
        }
        throw ASTWalkException.from("Annotation enumeration value '" + enumValueText + "' not recognized as an enumeration class, please check imports or type used");
    }

    private static Object[] walkArray(EsperEPL2GrammarParser.ElementValueArrayEnumContext ctx, ClasspathImportServiceCompileTime classpathImportService) {
        List<EsperEPL2GrammarParser.ElementValueEnumContext> elements = ctx.elementValueEnum();
        Object[] values = new Object[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            values[i] = ASTAnnotationHelper.walkValue(elements.get(i), classpathImportService);
        }
        return values;
    }
}

