/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.parse;

import com.espertech.esper.common.internal.type.ClassDescriptor;
import com.espertech.esper.compiler.internal.generated.EsperEPL2GrammarParser;
import com.espertech.esper.compiler.internal.parse.ASTUtil;
import com.espertech.esper.compiler.internal.parse.ASTWalkException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class ASTClassIdentifierHelper {
    public static ClassDescriptor walk(EsperEPL2GrammarParser.ClassIdentifierNoDimensionsContext ctx) throws ASTWalkException {
        if (ctx == null) {
            return null;
        }
        String name = ASTUtil.unescapeClassIdent(ctx.classIdentifier());
        if (ctx.typeParameters() == null) {
            return new ClassDescriptor(name);
        }
        List<ClassDescriptor> typeParameters = ASTClassIdentifierHelper.walkTypeParameters(ctx.typeParameters());
        return new ClassDescriptor(name, typeParameters, 0, false);
    }

    public static ClassDescriptor walk(EsperEPL2GrammarParser.ClassIdentifierWithDimensionsContext ctx) throws ASTWalkException {
        String keyword;
        if (ctx == null) {
            return null;
        }
        String name = ASTUtil.unescapeClassIdent(ctx.classIdentifier());
        List<EsperEPL2GrammarParser.DimensionsContext> dimensions = ctx.dimensions();
        if (dimensions.isEmpty() && ctx.typeParameters() == null) {
            return new ClassDescriptor(name);
        }
        List<ClassDescriptor> typeParameters = ASTClassIdentifierHelper.walkTypeParameters(ctx.typeParameters());
        if (dimensions.isEmpty()) {
            return new ClassDescriptor(name, typeParameters, 0, false);
        }
        EsperEPL2GrammarParser.DimensionsContext first = dimensions.get(0);
        String string = keyword = first.IDENT() != null ? first.IDENT().toString().trim().toLowerCase(Locale.ENGLISH) : null;
        if (keyword != null) {
            if (!keyword.equals("primitive")) {
                throw ASTWalkException.from("Invalid array keyword '" + keyword + "', expected 'primitive'");
            }
            if (!typeParameters.isEmpty()) {
                throw ASTWalkException.from("Cannot use the 'primitive' keyword with type parameters");
            }
        }
        return new ClassDescriptor(name, typeParameters, dimensions.size(), keyword != null);
    }

    private static List<ClassDescriptor> walkTypeParameters(EsperEPL2GrammarParser.TypeParametersContext typeParameters) {
        if (typeParameters == null) {
            return Collections.emptyList();
        }
        ArrayList<ClassDescriptor> result = new ArrayList<ClassDescriptor>(typeParameters.classIdentifierWithDimensions().size());
        for (EsperEPL2GrammarParser.ClassIdentifierWithDimensionsContext typeParamCtx : typeParameters.classIdentifierWithDimensions()) {
            ClassDescriptor typeParam = ASTClassIdentifierHelper.walk(typeParamCtx);
            result.add(typeParam);
        }
        return result;
    }
}

