/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.parse;

import com.espertech.esper.common.internal.util.BoolValue;
import com.espertech.esper.common.internal.util.LongValue;
import com.espertech.esper.common.internal.util.StringValue;
import com.espertech.esper.compiler.internal.parse.ASTUtil;
import com.espertech.esper.compiler.internal.parse.ASTWalkException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.Tree;

public class ASTConstantHelper {
    public static Object parse(ParseTree node) {
        if (node instanceof TerminalNode) {
            TerminalNode terminal = (TerminalNode)node;
            switch (terminal.getSymbol().getType()) {
                case 107: {
                    return BoolValue.parseString((String)terminal.getText());
                }
                case 108: {
                    return BoolValue.parseString((String)terminal.getText());
                }
                case 109: {
                    return null;
                }
            }
            throw ASTWalkException.from("Encountered unexpected constant type " + terminal.getSymbol().getType(), terminal.getSymbol());
        }
        RuleNode ruleNode = (RuleNode)node;
        int ruleIndex = ruleNode.getRuleContext().getRuleIndex();
        if (ruleIndex == 251) {
            return ASTConstantHelper.parseNumber(ruleNode, 1);
        }
        if (ruleIndex == 255) {
            RuleNode number = ASTConstantHelper.findChildRuleByType((Tree)ruleNode, 251);
            if (ruleNode.getChildCount() > 1) {
                if (ASTUtil.isTerminatedOfType((Tree)ruleNode.getChild(0), 162)) {
                    return ASTConstantHelper.parseNumber(number, -1);
                }
                return ASTConstantHelper.parseNumber(number, 1);
            }
            return ASTConstantHelper.parseNumber(number, 1);
        }
        if (ruleIndex == 256) {
            return StringValue.parseString((String)node.getText());
        }
        if (ruleIndex == 254) {
            return ASTConstantHelper.parse(ruleNode.getChild(0));
        }
        throw ASTWalkException.from("Encountered unrecognized constant", node.getText());
    }

    private static Object parseNumber(RuleNode number, int factor) {
        int tokenType = ASTConstantHelper.getSingleChildTokenType(number);
        if (tokenType == 198) {
            return ASTConstantHelper.parseIntLongByte(number.getText(), factor);
        }
        if (tokenType == 199) {
            String numberText = number.getText();
            if (numberText.endsWith("f") || numberText.endsWith("F")) {
                return Float.valueOf(Float.parseFloat(number.getText()) * (float)factor);
            }
            return Double.parseDouble(number.getText()) * (double)factor;
        }
        throw ASTWalkException.from("Encountered unrecognized constant", number.getText());
    }

    private static Object parseIntLongByte(String arg, int factor) {
        try {
            return Integer.parseInt(arg) * factor;
        }
        catch (NumberFormatException e1) {
            try {
                return LongValue.parseString((String)arg) * (long)factor;
            }
            catch (Exception e2) {
                try {
                    return Byte.decode(arg);
                }
                catch (Exception e3) {
                    throw e1;
                }
            }
        }
    }

    private static RuleNode findChildRuleByType(Tree node, int ruleNum) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree child = node.getChild(i);
            if (!ASTConstantHelper.isRuleOfType(child, ruleNum)) continue;
            return (RuleNode)child;
        }
        return null;
    }

    private static boolean isRuleOfType(Tree child, int ruleNum) {
        if (!(child instanceof RuleNode)) {
            return false;
        }
        RuleNode ruleNode = (RuleNode)child;
        return ruleNode.getRuleContext().getRuleIndex() == ruleNum;
    }

    private static int getSingleChildTokenType(RuleNode node) {
        return ((TerminalNode)node.getChild(0)).getSymbol().getType();
    }
}

