/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.parse;

import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSetAssignment;
import com.espertech.esper.common.internal.compile.stage1.spec.OutputLimitLimitType;
import com.espertech.esper.common.internal.compile.stage1.spec.OutputLimitRateType;
import com.espertech.esper.common.internal.compile.stage1.spec.OutputLimitSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.RowLimitSpec;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.time.node.ExprTimePeriod;
import com.espertech.esper.compiler.internal.generated.EsperEPL2GrammarParser;
import com.espertech.esper.compiler.internal.parse.ASTConstantHelper;
import com.espertech.esper.compiler.internal.parse.ASTExprHelper;
import com.espertech.esper.compiler.internal.parse.ASTWalkException;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.Tree;

public class ASTOutputLimitHelper {
    public static OutputLimitSpec buildOutputLimitSpec(CommonTokenStream tokenStream, EsperEPL2GrammarParser.OutputLimitContext ctx, Map<Tree, ExprNode> astExprNodeMap) {
        OutputLimitRateType rateType;
        OutputLimitLimitType displayLimit = OutputLimitLimitType.DEFAULT;
        if (ctx.k != null) {
            switch (ctx.k.getType()) {
                case 48: {
                    displayLimit = OutputLimitLimitType.FIRST;
                    break;
                }
                case 49: {
                    displayLimit = OutputLimitLimitType.LAST;
                    break;
                }
                case 79: {
                    displayLimit = OutputLimitLimitType.SNAPSHOT;
                    break;
                }
                case 43: {
                    displayLimit = OutputLimitLimitType.ALL;
                    break;
                }
                default: {
                    throw ASTWalkException.from("Encountered unrecognized token " + ctx.k.getText(), tokenStream, (RuleContext)ctx);
                }
            }
        }
        String variableName = null;
        Double rate = null;
        ExprNode whenExpression = null;
        List<ExprNode> crontabScheduleSpec = null;
        List<OnTriggerSetAssignment> thenExpressions = null;
        ExprTimePeriod timePeriodExpr = null;
        ExprNode andAfterTerminateExpr = null;
        List<OnTriggerSetAssignment> andAfterTerminateSetExpressions = null;
        if (ctx.t != null) {
            rateType = OutputLimitRateType.TERM;
            if (ctx.expression() != null) {
                andAfterTerminateExpr = ASTExprHelper.exprCollectSubNodes((Tree)ctx.expression(), 0, astExprNodeMap).get(0);
            }
            if (ctx.onSetExpr() != null) {
                andAfterTerminateSetExpressions = ASTExprHelper.getOnTriggerSetAssignments(ctx.onSetExpr().onSetAssignmentList(), astExprNodeMap);
            }
        } else if (ctx.wh != null) {
            rateType = OutputLimitRateType.WHEN_EXPRESSION;
            whenExpression = ASTExprHelper.exprCollectSubNodes((Tree)ctx.expression(), 0, astExprNodeMap).get(0);
            if (ctx.onSetExpr() != null) {
                thenExpressions = ASTExprHelper.getOnTriggerSetAssignments(ctx.onSetExpr().onSetAssignmentList(), astExprNodeMap);
            }
        } else if (ctx.at != null) {
            rateType = OutputLimitRateType.CRONTAB;
            crontabScheduleSpec = ASTExprHelper.exprCollectSubNodes((Tree)ctx.crontabLimitParameterSet(), 0, astExprNodeMap);
        } else if (ctx.ev != null) {
            OutputLimitRateType outputLimitRateType = rateType = ctx.e != null ? OutputLimitRateType.EVENTS : OutputLimitRateType.TIME_PERIOD;
            if (ctx.i != null) {
                variableName = ctx.i.getText();
            } else if (ctx.timePeriod() != null) {
                timePeriodExpr = (ExprTimePeriod)ASTExprHelper.exprCollectSubNodes((Tree)ctx.timePeriod(), 0, astExprNodeMap).get(0);
            } else {
                ASTExprHelper.exprCollectSubNodes((Tree)ctx.number(), 0, astExprNodeMap);
                rate = Double.parseDouble(ctx.number().getText());
            }
        } else {
            rateType = OutputLimitRateType.AFTER;
        }
        ExprTimePeriod afterTimePeriodExpr = null;
        Integer afterNumberOfEvents = null;
        if (ctx.outputLimitAfter() != null) {
            if (ctx.outputLimitAfter().timePeriod() != null) {
                ExprNode expression = ASTExprHelper.exprCollectSubNodes((Tree)ctx.outputLimitAfter(), 0, astExprNodeMap).get(0);
                afterTimePeriodExpr = (ExprTimePeriod)expression;
            } else {
                Object constant = ASTConstantHelper.parse((ParseTree)ctx.outputLimitAfter().number());
                afterNumberOfEvents = ((Number)constant).intValue();
            }
        }
        boolean andAfterTerminate = false;
        if (ctx.outputLimitAndTerm() != null) {
            andAfterTerminate = true;
            if (ctx.outputLimitAndTerm().expression() != null) {
                andAfterTerminateExpr = ASTExprHelper.exprCollectSubNodes((Tree)ctx.outputLimitAndTerm().expression(), 0, astExprNodeMap).get(0);
            }
            if (ctx.outputLimitAndTerm().onSetExpr() != null) {
                andAfterTerminateSetExpressions = ASTExprHelper.getOnTriggerSetAssignments(ctx.outputLimitAndTerm().onSetExpr().onSetAssignmentList(), astExprNodeMap);
            }
        }
        return new OutputLimitSpec(rate, variableName, rateType, displayLimit, whenExpression, thenExpressions, crontabScheduleSpec, timePeriodExpr, afterTimePeriodExpr, afterNumberOfEvents, andAfterTerminate, andAfterTerminateExpr, andAfterTerminateSetExpressions);
    }

    public static RowLimitSpec buildRowLimitSpec(EsperEPL2GrammarParser.RowLimitContext ctx) {
        Object offset;
        Object numRows;
        if (ctx.o != null) {
            numRows = ASTOutputLimitHelper.parseNumOrVariableIdent(ctx.n1, ctx.i1);
            offset = ASTOutputLimitHelper.parseNumOrVariableIdent(ctx.n2, ctx.i2);
        } else if (ctx.c != null) {
            offset = ASTOutputLimitHelper.parseNumOrVariableIdent(ctx.n1, ctx.i1);
            numRows = ASTOutputLimitHelper.parseNumOrVariableIdent(ctx.n2, ctx.i2);
        } else {
            numRows = ASTOutputLimitHelper.parseNumOrVariableIdent(ctx.n1, ctx.i1);
            offset = null;
        }
        Integer numRowsInt = null;
        String numRowsVariable = null;
        if (numRows instanceof String) {
            numRowsVariable = (String)numRows;
        } else {
            numRowsInt = (Integer)numRows;
        }
        Integer offsetInt = null;
        String offsetVariable = null;
        if (offset instanceof String) {
            offsetVariable = (String)offset;
        } else {
            offsetInt = (Integer)offset;
        }
        return new RowLimitSpec(numRowsInt, offsetInt, numRowsVariable, offsetVariable);
    }

    private static Object parseNumOrVariableIdent(EsperEPL2GrammarParser.NumberconstantContext num, Token ident) {
        if (ident != null) {
            return ident.getText();
        }
        return ASTConstantHelper.parse((ParseTree)num);
    }
}

