/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.parse;

import com.espertech.esper.common.internal.compile.stage1.spec.AnnotationDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.CreateTableColumn;
import com.espertech.esper.common.internal.compile.stage1.specmapper.StatementSpecMapEnv;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.type.ClassDescriptor;
import com.espertech.esper.compiler.internal.generated.EsperEPL2GrammarParser;
import com.espertech.esper.compiler.internal.parse.ASTAnnotationHelper;
import com.espertech.esper.compiler.internal.parse.ASTClassIdentifierHelper;
import com.espertech.esper.compiler.internal.parse.ASTExprHelper;
import com.espertech.esper.compiler.internal.parse.ASTWalkException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.antlr.v4.runtime.tree.Tree;

public class ASTTableHelper {
    public static List<CreateTableColumn> getColumns(List<EsperEPL2GrammarParser.CreateTableColumnContext> ctxs, Map<Tree, ExprNode> astExprNodeMap, StatementSpecMapEnv mapEnv) {
        ArrayList<CreateTableColumn> cols = new ArrayList<CreateTableColumn>(ctxs.size());
        for (EsperEPL2GrammarParser.CreateTableColumnContext colctx : ctxs) {
            cols.add(ASTTableHelper.getColumn(colctx, astExprNodeMap, mapEnv));
        }
        return cols;
    }

    private static CreateTableColumn getColumn(EsperEPL2GrammarParser.CreateTableColumnContext ctx, Map<Tree, ExprNode> astExprNodeMap, StatementSpecMapEnv mapEnv) {
        String columnName = ctx.n.getText();
        ExprNode optExpression = null;
        if (ctx.builtinFunc() != null || ctx.chainable() != null) {
            optExpression = ASTExprHelper.exprCollectSubNodes((Tree)ctx, 0, astExprNodeMap).get(0);
        }
        ClassDescriptor optType = ASTClassIdentifierHelper.walk(ctx.classIdentifierWithDimensions());
        Boolean primaryKey = false;
        if (ctx.p != null) {
            if (!ctx.p.getText().toLowerCase(Locale.ENGLISH).equals("primary")) {
                throw ASTWalkException.from("Invalid keyword '" + ctx.p.getText() + "' encountered, expected 'primary key'");
            }
            if (!ctx.k.getText().toLowerCase(Locale.ENGLISH).equals("key")) {
                throw ASTWalkException.from("Invalid keyword '" + ctx.k.getText() + "' encountered, expected 'primary key'");
            }
            primaryKey = true;
        }
        List annots = Collections.emptyList();
        if (ctx.annotationEnum() != null) {
            annots = new ArrayList(ctx.annotationEnum().size());
            for (EsperEPL2GrammarParser.AnnotationEnumContext anctx : ctx.annotationEnum()) {
                annots.add(ASTAnnotationHelper.walk(anctx, mapEnv.getClasspathImportService()));
            }
        }
        if (ctx.typeExpressionAnnotation() != null) {
            if (annots.isEmpty()) {
                annots = new ArrayList();
            }
            for (EsperEPL2GrammarParser.TypeExpressionAnnotationContext anno : ctx.typeExpressionAnnotation()) {
                annots.add(new AnnotationDesc(anno.n.getText(), anno.v.getText()));
            }
        }
        return new CreateTableColumn(columnName, optExpression, optType, annots, primaryKey);
    }
}

