/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.parse;

import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompileSyntaxException;
import com.espertech.esper.compiler.internal.generated.EsperEPL2GrammarParser;
import com.espertech.esper.compiler.internal.parse.ParseHelper;
import java.io.StringWriter;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionConvertor {
    private static final Logger log = LoggerFactory.getLogger(ExceptionConvertor.class);
    protected static final String END_OF_INPUT_TEXT = "end-of-input";

    public static StatementSpecCompileSyntaxException convertStatement(RecognitionException e, String expression, boolean addPleaseCheck, EsperEPL2GrammarParser parser) {
        UniformPair<String> pair = ExceptionConvertor.convert(e, expression, addPleaseCheck, parser);
        return new StatementSpecCompileSyntaxException((String)pair.getFirst(), (Throwable)e, (String)pair.getSecond());
    }

    public static PropertyAccessException convertProperty(RecognitionException e, String expression, boolean addPleaseCheck, EsperEPL2GrammarParser parser) {
        UniformPair<String> pair = ExceptionConvertor.convert(e, expression, addPleaseCheck, parser);
        return new PropertyAccessException((String)pair.getFirst(), (String)pair.getSecond());
    }

    public static UniformPair<String> convert(RecognitionException e, String expression, boolean addPleaseCheck, EsperEPL2GrammarParser parser) {
        boolean isSelect;
        Token t;
        int tIndex;
        if (expression.trim().length() == 0) {
            String message = "Unexpected end-of-input";
            return new UniformPair((Object)message, (Object)expression);
        }
        Token tBeforeBefore = null;
        Token tBefore = null;
        Token tAfter = null;
        int n = tIndex = e.getOffendingToken() != null ? e.getOffendingToken().getTokenIndex() : Integer.MAX_VALUE;
        if (tIndex < parser.getTokenStream().size()) {
            t = parser.getTokenStream().get(tIndex);
            if (tIndex + 1 < parser.getTokenStream().size()) {
                tAfter = parser.getTokenStream().get(tIndex + 1);
            }
            if (tIndex - 1 >= 0) {
                tBefore = parser.getTokenStream().get(tIndex - 1);
            }
            if (tIndex - 2 >= 0) {
                tBeforeBefore = parser.getTokenStream().get(tIndex - 2);
            }
        } else {
            if (parser.getTokenStream().size() >= 1) {
                tBeforeBefore = parser.getTokenStream().get(parser.getTokenStream().size() - 1);
            }
            if (parser.getTokenStream().size() >= 2) {
                tBefore = parser.getTokenStream().get(parser.getTokenStream().size() - 2);
            }
            t = parser.getTokenStream().get(parser.getTokenStream().size() - 1);
        }
        Token tEnd = null;
        if (parser.getTokenStream().size() > 0) {
            tEnd = parser.getTokenStream().get(parser.getTokenStream().size() - 1);
        }
        String positionInfo = ExceptionConvertor.getPositionInfo(t);
        Object token = t.getType() == -1 ? END_OF_INPUT_TEXT : "'" + t.getText() + "'";
        Stack stack = parser.getParaphrases();
        Object check = "";
        boolean bl = isSelect = stack.size() == 1 && stack.get(0).equals("select clause");
        if (stack.size() > 0 && addPleaseCheck) {
            String delimiter = "";
            StringBuilder checkList = new StringBuilder();
            checkList.append(", please check the ");
            while (stack.size() != 0) {
                checkList.append(delimiter);
                checkList.append(stack.pop());
                delimiter = " within the ";
            }
            check = checkList.toString();
        }
        Set<String> keywords = parser.getKeywords();
        boolean reservedKeyword = false;
        if (keywords.contains(((String)token).toLowerCase(Locale.ENGLISH))) {
            token = (String)token + " (a reserved keyword)";
            reservedKeyword = true;
        } else if (tAfter != null && keywords.contains("'" + tAfter.getText().toLowerCase(Locale.ENGLISH) + "'")) {
            token = (String)token + " ('" + tAfter.getText() + "' is a reserved keyword)";
            reservedKeyword = true;
        } else if (tBefore != null && tAfter != null && keywords.contains("'" + tBefore.getText().toLowerCase(Locale.ENGLISH) + "'") && keywords.contains("'" + tAfter.getText().toLowerCase(Locale.ENGLISH) + "'")) {
            token = (String)token + " ('" + tBefore.getText() + "' and '" + tAfter.getText() + "' are a reserved keyword)";
            reservedKeyword = true;
        } else if (tBefore != null && keywords.contains("'" + tBefore.getText().toLowerCase(Locale.ENGLISH) + "'")) {
            token = (String)token + " ('" + tBefore.getText() + "' is a reserved keyword)";
            reservedKeyword = true;
        } else if (tEnd != null && keywords.contains("'" + tEnd.getText().toLowerCase(Locale.ENGLISH) + "'")) {
            token = (String)token + " ('" + tEnd.getText() + "' is a reserved keyword)";
            reservedKeyword = true;
        }
        if (isSelect && !reservedKeyword) {
            check = (String)check + ExceptionConvertor.getSelectClauseAsText(tBeforeBefore, t);
        }
        String message = "Incorrect syntax near " + (String)token + positionInfo + (String)check;
        if (e instanceof NoViableAltException || e instanceof LexerNoViableAltException || ExceptionConvertor.checkForInputMismatchWithNoExpected(e)) {
            int nvaeTokenType;
            Token nvaeToken = e.getOffendingToken();
            int n2 = nvaeTokenType = nvaeToken != null ? nvaeToken.getType() : -1;
            if (nvaeTokenType == -1) {
                message = ((String)token).equals(END_OF_INPUT_TEXT) ? "Unexpected end-of-input" + positionInfo + (String)check : (ParseHelper.hasControlCharacters(expression) ? "Unrecognized control characters found in text" + positionInfo : "Unexpected end-of-input near " + (String)token + positionInfo + (String)check);
            } else if (parser.getParserTokenParaphrases().get(nvaeTokenType) != null) {
                message = "Incorrect syntax near " + (String)token + positionInfo + (String)check;
            } else {
                for (int currentIndex = tIndex + 1; currentIndex > 0 && currentIndex < parser.getTokenStream().size() - 1 && currentIndex < tIndex + 3; ++currentIndex) {
                    Token next = parser.getTokenStream().get(currentIndex);
                    String quotedToken = "'" + next.getText() + "'";
                    if (!parser.getKeywords().contains(quotedToken)) continue;
                    check = (String)check + " near reserved keyword '" + next.getText() + "'";
                    break;
                }
                message = "Incorrect syntax near " + (String)token + positionInfo + (String)check;
            }
        } else if (e instanceof InputMismatchException) {
            String expected;
            InputMismatchException mismatched = (InputMismatchException)e;
            if (mismatched.getExpectedTokens().size() > 1) {
                StringWriter writer = new StringWriter();
                writer.append("any of the following tokens {");
                String delimiter = "";
                for (int i = 0; i < mismatched.getExpectedTokens().size(); ++i) {
                    writer.append(delimiter);
                    if (i > 5) {
                        writer.append("...");
                        writer.append(Integer.toString(mismatched.getExpectedTokens().size() - 5));
                        writer.append(" more");
                        break;
                    }
                    delimiter = ", ";
                    writer.append(ExceptionConvertor.getTokenText(parser, mismatched.getExpectedTokens().get(i)));
                }
                writer.append("}");
                expected = writer.toString();
            } else {
                expected = ExceptionConvertor.getTokenText(parser, mismatched.getExpectedTokens().get(0));
            }
            int offendingTokenType = mismatched.getOffendingToken().getType();
            String unexpected = ExceptionConvertor.getTokenText(parser, offendingTokenType);
            String expecting = " expecting " + expected.trim() + " but found " + unexpected.trim();
            message = "Incorrect syntax near " + (String)token + expecting + positionInfo + (String)check;
        }
        return new UniformPair((Object)message, (Object)expression);
    }

    private static boolean checkForInputMismatchWithNoExpected(RecognitionException e) {
        if (!(e instanceof InputMismatchException)) {
            return false;
        }
        if (e.getExpectedTokens().size() > 1) {
            return false;
        }
        return e.getExpectedTokens().size() == 1 && e.getExpectedTokens().get(0) == -1;
    }

    private static String getTokenText(EsperEPL2GrammarParser parser, int tokenIndex) {
        String expected = END_OF_INPUT_TEXT;
        if (tokenIndex >= 0 && tokenIndex < parser.getTokenNames().length) {
            expected = parser.getTokenNames()[tokenIndex];
        }
        if (parser.getLexerTokenParaphrases().get(tokenIndex) != null) {
            expected = parser.getLexerTokenParaphrases().get(tokenIndex);
        }
        if (parser.getParserTokenParaphrases().get(tokenIndex) != null) {
            expected = parser.getParserTokenParaphrases().get(tokenIndex);
        }
        return expected;
    }

    private static String getPositionInfo(Token t) {
        return t.getLine() > 0 && t.getCharPositionInLine() > 0 ? " at line " + t.getLine() + " column " + t.getCharPositionInLine() : "";
    }

    private static String getSelectClauseAsText(Token tBeforeBefore, Token t) {
        if (tBeforeBefore != null && tBeforeBefore.getType() == 197 && t != null && t.getType() == 197) {
            return " (did you forget 'as'?)";
        }
        return "";
    }
}

