/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.parse;

import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompileSyntaxException;
import com.espertech.esper.compiler.internal.generated.EsperEPL2GrammarLexer;
import com.espertech.esper.compiler.internal.generated.EsperEPL2GrammarParser;
import com.espertech.esper.compiler.internal.parse.ASTUtil;
import com.espertech.esper.compiler.internal.parse.Antlr4ErrorListener;
import com.espertech.esper.compiler.internal.parse.Antlr4ErrorStrategy;
import com.espertech.esper.compiler.internal.parse.CaseChangingCharStreamFactory;
import com.espertech.esper.compiler.internal.parse.EPLTreeWalkerListener;
import com.espertech.esper.compiler.internal.parse.ExceptionConvertor;
import com.espertech.esper.compiler.internal.parse.ParseResult;
import com.espertech.esper.compiler.internal.parse.ParseRuleSelector;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseHelper {
    public static final String NEWLINE = System.getProperty("line.separator");
    private static final Logger log = LoggerFactory.getLogger(ParseHelper.class);

    public static void walk(Tree ast, EPLTreeWalkerListener listener, String expression, String eplStatementForErrorMsg) {
        if (log.isDebugEnabled()) {
            log.debug(".walk Walking AST using walker " + listener.getClass().getName());
        }
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)listener, (ParseTree)ast);
        listener.end();
    }

    public static ParseResult parse(String expression, String eplStatementErrorMsg, boolean addPleaseCheck, ParseRuleSelector parseRuleSelector, boolean rewriteScript) throws StatementSpecCompileSyntaxException {
        Tree tree;
        if (log.isDebugEnabled()) {
            log.debug(".parse Parsing expr=" + expression);
        }
        CharStream input = CaseChangingCharStreamFactory.make(expression);
        EsperEPL2GrammarLexer lex = ParseHelper.newLexer(input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
        EsperEPL2GrammarParser parser = ParseHelper.newParser(tokens);
        try {
            tree = parseRuleSelector.invokeParseRule(parser);
        }
        catch (RecognitionException ex) {
            tokens.fill();
            if (rewriteScript && ParseHelper.isContainsScriptOrClassExpression(tokens)) {
                return ParseHelper.handleScriptAndClassRewrite(tokens, eplStatementErrorMsg, addPleaseCheck, parseRuleSelector);
            }
            log.debug("Error parsing statement [" + expression + "]", (Throwable)ex);
            throw ExceptionConvertor.convertStatement(ex, eplStatementErrorMsg, addPleaseCheck, parser);
        }
        catch (RuntimeException e) {
            try {
                tokens.fill();
            }
            catch (RuntimeException ex) {
                log.debug("Token-fill produced exception: " + e.getMessage(), (Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug("Error parsing statement [" + eplStatementErrorMsg + "]", (Throwable)e);
            }
            if (e.getCause() instanceof RecognitionException) {
                if (rewriteScript && ParseHelper.isContainsScriptOrClassExpression(tokens)) {
                    return ParseHelper.handleScriptAndClassRewrite(tokens, eplStatementErrorMsg, addPleaseCheck, parseRuleSelector);
                }
                throw ExceptionConvertor.convertStatement((RecognitionException)e.getCause(), eplStatementErrorMsg, addPleaseCheck, parser);
            }
            throw e;
        }
        if (rewriteScript && ParseHelper.isContainsScriptOrClassExpression(tokens)) {
            return ParseHelper.handleScriptAndClassRewrite(tokens, eplStatementErrorMsg, addPleaseCheck, parseRuleSelector);
        }
        if (log.isDebugEnabled()) {
            log.debug(".parse Dumping AST...");
            ASTUtil.dumpAST(tree);
        }
        String expressionWithoutAnnotation = expression;
        if (tree instanceof EsperEPL2GrammarParser.StartEPLExpressionRuleContext) {
            EsperEPL2GrammarParser.StartEPLExpressionRuleContext epl = (EsperEPL2GrammarParser.StartEPLExpressionRuleContext)tree;
            expressionWithoutAnnotation = ParseHelper.getNoAnnotation(expression, epl.annotationEnum(), tokens);
        }
        return new ParseResult(tree, expressionWithoutAnnotation, tokens, Collections.emptyList(), Collections.emptyList());
    }

    private static ParseResult handleScriptAndClassRewrite(CommonTokenStream tokens, String eplStatementErrorMsg, boolean addPleaseCheck, ParseRuleSelector parseRuleSelector) throws StatementSpecCompileSyntaxException {
        ScriptOrClassResult rewriteExpression = ParseHelper.rewriteTokensScript(tokens);
        ParseResult result = ParseHelper.parse(rewriteExpression.getRewrittenEPL(), eplStatementErrorMsg, addPleaseCheck, parseRuleSelector, false);
        return new ParseResult(result.getTree(), result.getExpressionWithoutAnnotations(), result.getTokenStream(), rewriteExpression.getScripts(), rewriteExpression.getClasses());
    }

    private static String getNoAnnotation(String expression, List<EsperEPL2GrammarParser.AnnotationEnumContext> annos, CommonTokenStream tokens) {
        if (annos == null || annos.isEmpty()) {
            return expression;
        }
        Token lastAnnotationToken = annos.get(annos.size() - 1).getStop();
        if (lastAnnotationToken == null) {
            return null;
        }
        try {
            int line = lastAnnotationToken.getLine();
            int charpos = lastAnnotationToken.getCharPositionInLine();
            int fromChar = charpos + lastAnnotationToken.getText().length();
            if (line == 1) {
                return expression.substring(fromChar).trim();
            }
            String[] lines = expression.split("\r\n|\r|\n");
            StringBuilder buf = new StringBuilder();
            buf.append(lines[line - 1].substring(fromChar));
            for (int i = line; i < lines.length; ++i) {
                buf.append(lines[i]);
                if (i >= lines.length - 1) continue;
                buf.append(NEWLINE);
            }
            return buf.toString().trim();
        }
        catch (RuntimeException ex) {
            log.error("Error determining non-annotated expression sting: " + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private static ScriptOrClassResult rewriteTokensScript(CommonTokenStream tokens) {
        ArrayList<String> scripts = new ArrayList<String>(2);
        ArrayList<String> classes = new ArrayList<String>(2);
        ArrayList<UniformPair<Integer>> tokenIndexRanges = new ArrayList<UniformPair<Integer>>();
        for (int tokenIndex = 0; tokenIndex < tokens.size(); ++tokenIndex) {
            int endIndex;
            int startIndex;
            if (tokens.get(tokenIndex).getType() == 125) {
                int endIndex2;
                Token tokenBefore = ParseHelper.getTokenBefore(tokenIndex, tokens);
                boolean isCreateExpressionClause = tokenBefore != null && tokenBefore.getType() == 1;
                Pair<String, Integer> nameAndNameStart = ParseHelper.findScriptName(tokenIndex + 1, tokens);
                int startIndex2 = ParseHelper.findStartTokenScript((Integer)nameAndNameStart.getSecond(), tokens, 147);
                if (startIndex2 != -1 && (endIndex2 = ParseHelper.findEndTokenScript(startIndex2 + 1, tokens, 148, EsperEPL2GrammarParser.getAfterScriptTokens(), !isCreateExpressionClause)) != -1) {
                    StringWriter writer = new StringWriter();
                    for (int j = startIndex2 + 1; j < endIndex2; ++j) {
                        writer.append(tokens.get(j).getText());
                    }
                    scripts.add(writer.toString());
                    tokenIndexRanges.add((UniformPair<Integer>)new UniformPair((Object)startIndex2, (Object)endIndex2));
                    tokenIndex = endIndex2;
                }
            }
            if (tokens.get(tokenIndex).getType() != 126 || (startIndex = ParseHelper.findTokenClass(tokenIndex, tokens)) == -1 || (endIndex = ParseHelper.findTokenClass(startIndex + 1, tokens)) == -1) continue;
            StringWriter writer = new StringWriter();
            for (int j = startIndex + 1; j < endIndex; ++j) {
                writer.append(tokens.get(j).getText());
            }
            classes.add(writer.toString());
            tokenIndexRanges.add((UniformPair<Integer>)new UniformPair((Object)startIndex, (Object)endIndex));
            tokenIndex = endIndex;
        }
        String rewrittenEPL = ParseHelper.rewriteEPL(tokenIndexRanges, tokens);
        return new ScriptOrClassResult(rewrittenEPL, scripts, classes);
    }

    private static Token getTokenBefore(int i, CommonTokenStream tokens) {
        for (int position = i - 1; position >= 0; --position) {
            Token t = tokens.get(position);
            if (t.getChannel() == 99 || t.getType() == 190) continue;
            return t;
        }
        return null;
    }

    private static Pair<String, Integer> findScriptName(int start, CommonTokenStream tokens) {
        String lastIdent = null;
        int lastIdentIndex = 0;
        for (int i = start; i < tokens.size(); ++i) {
            if (tokens.get(i).getType() == 197) {
                lastIdent = tokens.get(i).getText();
                lastIdentIndex = i;
            }
            if (tokens.get(i).getType() == 145 || tokens.get(i).getType() == 147 && tokens.get(i + 1).getType() != 148) break;
        }
        if (lastIdent == null) {
            throw new IllegalStateException("Failed to parse expression name");
        }
        return new Pair(lastIdent, (Object)lastIdentIndex);
    }

    private static String rewriteEPL(List<UniformPair<Integer>> ranges, CommonTokenStream tokens) {
        Token t;
        if (ranges.isEmpty()) {
            return tokens.getText();
        }
        StringWriter writer = new StringWriter();
        int rangeIndex = 0;
        UniformPair current = ranges.get(rangeIndex);
        for (int i = 0; i < tokens.size() && (t = tokens.get(i)).getType() != -1; ++i) {
            if (i < (Integer)current.getFirst()) {
                writer.append(t.getText());
                continue;
            }
            if (i == (Integer)current.getFirst()) {
                writer.append(t.getText());
                writer.append("'");
                continue;
            }
            if (i == (Integer)current.getSecond()) {
                writer.append("'");
                writer.append(t.getText());
                if (ranges.size() > ++rangeIndex) {
                    current = ranges.get(rangeIndex);
                    continue;
                }
                current = new UniformPair((Object)-1, (Object)-1);
                continue;
            }
            if (t.getType() == 191 || t.getType() == 192) {
                ParseHelper.writeCommentEscapeSingleQuote(writer, t);
                continue;
            }
            if (t.getType() == 194 && i > (Integer)current.getFirst() && i < (Integer)current.getSecond()) {
                writer.append("\\'");
                writer.append(t.getText().substring(1, t.getText().length() - 1));
                writer.append("\\'");
                continue;
            }
            if (t.getType() == 195) {
                writer.append(t.getText().replace("'", "\\'"));
                continue;
            }
            writer.append(t.getText());
        }
        return writer.toString();
    }

    private static int findEndTokenScript(int startIndex, CommonTokenStream tokens, int tokenTypeSearch, Set<Integer> afterScriptTokens, boolean requireAfterScriptToken) {
        if (requireAfterScriptToken) {
            int found = -1;
            for (int i = startIndex; i < tokens.size(); ++i) {
                if (tokens.get(i).getType() == tokenTypeSearch) {
                    for (int j = i + 1; j < tokens.size(); ++j) {
                        Token next = tokens.get(j);
                        if (next.getChannel() != 0) continue;
                        if (!afterScriptTokens.contains(next.getType())) break;
                        found = i;
                        break;
                    }
                }
                if (found != -1) break;
            }
            return found;
        }
        int indexLast = -1;
        for (int i = startIndex; i < tokens.size(); ++i) {
            if (tokens.get(i).getType() != tokenTypeSearch) continue;
            indexLast = i;
        }
        return indexLast;
    }

    private static boolean isContainsScriptOrClassExpression(CommonTokenStream tokens) {
        for (int i = 0; i < tokens.size(); ++i) {
            int endTokenTripleQuote;
            int startTokenTripleQuote;
            if (tokens.get(i).getType() == 126 && (startTokenTripleQuote = ParseHelper.findTokenClass(i + 1, tokens)) != -1 && (endTokenTripleQuote = ParseHelper.findTokenClass(startTokenTripleQuote + 1, tokens)) != -1) {
                return true;
            }
            if (tokens.get(i).getType() != 125) continue;
            int startTokenLcurly = ParseHelper.findStartTokenScript(i + 1, tokens, 149);
            int startTokenLbrack = ParseHelper.findStartTokenScript(i + 1, tokens, 147);
            if (startTokenLbrack == -1 || startTokenLcurly != -1 && startTokenLcurly <= startTokenLbrack) continue;
            return true;
        }
        return false;
    }

    private static int findStartTokenScript(int startIndex, CommonTokenStream tokens, int tokenTypeSearch) {
        int found = -1;
        for (int i = startIndex; i < tokens.size(); ++i) {
            if (tokens.get(i).getType() != tokenTypeSearch) continue;
            return i;
        }
        return found;
    }

    private static int findTokenClass(int startIndex, CommonTokenStream tokens) {
        int found = -1;
        for (int i = startIndex; i < tokens.size(); ++i) {
            if (tokens.get(i).getType() != 196) continue;
            return i;
        }
        return found;
    }

    public static EsperEPL2GrammarLexer newLexer(CharStream input) {
        EsperEPL2GrammarLexer lex = new EsperEPL2GrammarLexer(input);
        lex.removeErrorListeners();
        lex.addErrorListener(Antlr4ErrorListener.INSTANCE);
        return lex;
    }

    public static EsperEPL2GrammarParser newParser(CommonTokenStream tokens) {
        EsperEPL2GrammarParser g = new EsperEPL2GrammarParser((TokenStream)tokens);
        g.removeErrorListeners();
        g.addErrorListener(Antlr4ErrorListener.INSTANCE);
        g.setErrorHandler((ANTLRErrorStrategy)new Antlr4ErrorStrategy());
        return g;
    }

    public static boolean hasControlCharacters(String text) {
        String textWithoutControlCharacters = text.replaceAll("\\p{Cc}", "");
        return !textWithoutControlCharacters.equals(text);
    }

    private static void writeCommentEscapeSingleQuote(StringWriter writer, Token t) {
        String text = t.getText();
        if (!text.contains("'")) {
            return;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\'') {
                writer.append('\\');
                writer.append(c);
                continue;
            }
            writer.append(c);
        }
    }

    private static class ScriptOrClassResult {
        private final String rewrittenEPL;
        private final List<String> scripts;
        private final List<String> classes;

        public ScriptOrClassResult(String rewrittenEPL, List<String> scripts, List<String> classes) {
            this.rewrittenEPL = rewrittenEPL;
            this.scripts = scripts;
            this.classes = classes;
        }

        public String getRewrittenEPL() {
            return this.rewrittenEPL;
        }

        public List<String> getScripts() {
            return this.scripts;
        }

        public List<String> getClasses() {
            return this.classes;
        }
    }
}

