/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.util;

import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenIndent;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenInnerClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenMethodWGraph;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenTypedParam;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenClassUtil;
import com.espertech.esper.compiler.internal.util.CodeGenerationUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CodegenClassGenerator {
    private static final CodegenIndent INDENT = new CodegenIndent(true);

    public static String generate(CodegenClass clazz) {
        Set classes = clazz.getReferencedClasses();
        Map<Class, String> imports = CodegenClassGenerator.compileImports(classes);
        return CodegenClassGenerator.generateCode(imports, clazz);
    }

    private static Map<Class, String> compileImports(Set<Class> classes) {
        HashMap<Class, String> imports = new HashMap<Class, String>();
        HashMap<String, Class> assignments = new HashMap<String, Class>();
        for (Class clazz : classes) {
            if (clazz == null || clazz.getEnclosingClass() != null || clazz.isPrimitive()) continue;
            Class target = clazz;
            if (clazz.isArray()) {
                target = CodegenClassUtil.getComponentTypeOutermost((Class)clazz);
            }
            if (target.isPrimitive() || target.getEnclosingClass() != null) continue;
            CodegenClassGenerator.compileImports(target, imports, assignments);
        }
        return imports;
    }

    private static void compileImports(Class clazz, Map<Class, String> imports, Map<String, Class> assignments) {
        if (clazz.getPackage() != null && clazz.getPackage().getName().equals("java.lang")) {
            imports.put(clazz, clazz.getSimpleName());
            return;
        }
        if (assignments.containsKey(clazz.getSimpleName())) {
            return;
        }
        imports.put(clazz, clazz.getSimpleName());
        assignments.put(clazz.getSimpleName(), clazz);
    }

    private static String generateCode(Map<Class, String> imports, CodegenClass clazz) {
        StringBuilder builder = new StringBuilder();
        CodeGenerationUtil.packagedecl(builder, clazz.getPackageName());
        CodeGenerationUtil.importsdecl(builder, imports.keySet());
        CodeGenerationUtil.classimplements(builder, clazz.getClassName(), clazz.getSupers(), true, false, imports);
        CodegenClassGenerator.generateCodeMembers(builder, clazz.getExplicitMembers(), clazz.getOptionalCtor(), imports, 1, false);
        CodegenClassGenerator.generateCodeCtor(builder, clazz.getClassName(), false, clazz.getOptionalCtor(), imports, 0);
        CodegenClassGenerator.generateCodeMethods(builder, false, clazz.getPublicMethods(), clazz.getPrivateMethods(), imports, 0);
        for (CodegenInnerClass inner : clazz.getInnerClasses()) {
            builder.append("\n");
            INDENT.indent(builder, 1);
            CodeGenerationUtil.classimplements(builder, inner.getClassName(), inner.getSupers(), true, true, imports);
            CodegenClassGenerator.generateCodeMembers(builder, inner.getExplicitMembers(), inner.getCtor(), imports, 2, true);
            CodegenClassGenerator.generateCodeCtor(builder, inner.getClassName(), true, inner.getCtor(), imports, 1);
            CodegenClassGenerator.generateCodeMethods(builder, true, inner.getMethods().getPublicMethods(), inner.getMethods().getPrivateMethods(), imports, 1);
            INDENT.indent(builder, 1);
            builder.append("}\n");
        }
        builder.append("}\n");
        return builder.toString();
    }

    protected static void generateCodeMethods(StringBuilder builder, boolean isInnerClass, List<CodegenMethodWGraph> publicMethods, List<CodegenMethodWGraph> privateMethods, Map<Class, String> imports, int additionalIndent) {
        String delimiter = "";
        for (CodegenMethodWGraph publicMethod : publicMethods) {
            builder.append(delimiter);
            publicMethod.render(builder, imports, true, isInnerClass, INDENT, additionalIndent);
            delimiter = "\n";
        }
        for (CodegenMethodWGraph method : privateMethods) {
            builder.append(delimiter);
            method.render(builder, imports, false, isInnerClass, INDENT, additionalIndent);
            delimiter = "\n";
        }
    }

    private static void generateCodeCtor(StringBuilder builder, String className, boolean isInnerClass, CodegenCtor optionalCtor, Map<Class, String> imports, int additionalIndent) {
        if (optionalCtor == null) {
            return;
        }
        boolean hasAssignments = false;
        for (CodegenTypedParam param : optionalCtor.getCtorParams()) {
            if (!param.isMemberWhenCtorParam()) continue;
            hasAssignments = true;
            break;
        }
        if (optionalCtor.getBlock().isEmpty() && !hasAssignments && optionalCtor.getCtorParams().isEmpty()) {
            return;
        }
        INDENT.indent(builder, 1 + additionalIndent);
        builder.append("public ").append(className).append("(");
        String delimiter = "";
        if (optionalCtor != null) {
            for (CodegenTypedParam param : optionalCtor.getCtorParams()) {
                builder.append(delimiter);
                param.renderAsParameter(builder, imports);
                delimiter = ",";
            }
        }
        builder.append("){\n");
        if (optionalCtor != null) {
            for (CodegenTypedParam param : optionalCtor.getCtorParams()) {
                if (!param.isMemberWhenCtorParam()) continue;
                INDENT.indent(builder, 2 + additionalIndent);
                builder.append("this.").append(param.getName()).append("=").append(param.getName()).append(";\n");
            }
        }
        if (optionalCtor != null) {
            optionalCtor.getBlock().render(builder, imports, isInnerClass, 2 + additionalIndent, INDENT);
        }
        INDENT.indent(builder, 1 + additionalIndent);
        builder.append("}\n");
        builder.append("\n");
    }

    private static void generateCodeMembers(StringBuilder builder, List<CodegenTypedParam> explicitMembers, CodegenCtor optionalCtor, Map<Class, String> imports, int indent, boolean isInnerClass) {
        if (optionalCtor != null) {
            for (CodegenTypedParam param : optionalCtor.getCtorParams()) {
                if (!param.isMemberWhenCtorParam()) continue;
                INDENT.indent(builder, indent);
                if (param.isFinal()) {
                    builder.append("final ");
                }
                param.renderAsMember(builder, imports);
                builder.append(";\n");
            }
        }
        for (CodegenTypedParam param : explicitMembers) {
            INDENT.indent(builder, indent);
            if (param.isPublic()) {
                builder.append("public ");
            }
            if (!param.isPublic() && param.isFinal()) {
                builder.append("final ");
            }
            if (param.isStatic()) {
                builder.append("static ");
            }
            param.renderType(builder, imports);
            builder.append(" ").append(param.getName());
            param.renderInitializer(builder, imports, isInnerClass);
            builder.append(";\n");
        }
        builder.append("\n");
    }
}

