/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.util;

import com.espertech.esper.common.client.EPCompiled;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstraction;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionClassCollection;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionCompilationContext;
import com.espertech.esper.common.internal.compile.stage3.ModuleCompileTimeServices;
import com.espertech.esper.compiler.internal.util.CompilableItem;
import com.espertech.esper.compiler.internal.util.CompilableItemResult;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;

public class CompileCallable
implements Callable<CompilableItemResult> {
    private final CompilableItem compilableItem;
    private final ModuleCompileTimeServices compileTimeServices;
    private final List<EPCompiled> path;
    private final Semaphore semaphore;
    private final CompilerAbstraction compilerAbstraction;
    private final CompilerAbstractionClassCollection compilationState;

    CompileCallable(CompilableItem compilableItem, ModuleCompileTimeServices compileTimeServices, List<EPCompiled> path, Semaphore semaphore, CompilerAbstraction compilerAbstraction, CompilerAbstractionClassCollection compilationState) {
        this.compilableItem = compilableItem;
        this.compileTimeServices = compileTimeServices;
        this.path = path;
        this.semaphore = semaphore;
        this.compilerAbstraction = compilerAbstraction;
        this.compilationState = compilationState;
    }

    @Override
    public CompilableItemResult call() throws Exception {
        try {
            CompilerAbstractionCompilationContext context = new CompilerAbstractionCompilationContext(this.compileTimeServices, this.path);
            this.compilerAbstraction.compileClasses(this.compilableItem.getClasses(), context, this.compilationState);
        }
        catch (Throwable t) {
            CompilableItemResult compilableItemResult = new CompilableItemResult(t);
            return compilableItemResult;
        }
        finally {
            this.semaphore.release();
            this.compilableItem.getPostCompileLatch().completed(this.compilationState.getClasses());
        }
        return new CompilableItemResult();
    }
}

