/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.util;

import com.espertech.esper.common.client.EPCompiled;
import com.espertech.esper.common.client.EPCompiledManifest;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.client.util.StatementType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationIDGenerator;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassType;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenTypedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenStackGenerator;
import com.espertech.esper.common.internal.bytecodemodel.util.IdentifierUtil;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionClassCollection;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionCompilationContext;
import com.espertech.esper.common.internal.compile.stage1.Compilable;
import com.espertech.esper.common.internal.compile.stage1.spec.FireAndForgetSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.FireAndForgetSpecDelete;
import com.espertech.esper.common.internal.compile.stage1.spec.FireAndForgetSpecUpdate;
import com.espertech.esper.common.internal.compile.stage1.spec.StatementSpecRaw;
import com.espertech.esper.common.internal.compile.stage2.StatementRawCompiler;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompileException;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompileSyntaxException;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompiledDesc;
import com.espertech.esper.common.internal.compile.stage3.ModuleCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StatementTypeUtil;
import com.espertech.esper.common.internal.context.compile.ContextCompileTimeDescriptor;
import com.espertech.esper.common.internal.context.compile.ContextMetaData;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.context.module.ModuleDependenciesRuntime;
import com.espertech.esper.common.internal.context.query.FAFProvider;
import com.espertech.esper.common.internal.context.util.ContextPropertyRegistry;
import com.espertech.esper.common.internal.epl.annotation.AnnotationUtil;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeSubselectDeclaredDotVisitor;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodForge;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodIUDDeleteForge;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodIUDInsertIntoForge;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodIUDUpdateForge;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodProvider;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelectDesc;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelectForge;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorFactoryProvider;
import com.espertech.esper.common.internal.epl.util.StatementSpecRawWalkerSubselectAndDeclaredDot;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceCompileTime;
import com.espertech.esper.compiler.client.CompilerArguments;
import com.espertech.esper.compiler.client.CompilerPath;
import com.espertech.esper.compiler.client.EPCompileException;
import com.espertech.esper.compiler.client.EPCompileExceptionItem;
import com.espertech.esper.compiler.client.EPCompileExceptionSyntaxItem;
import com.espertech.esper.compiler.internal.util.CompilerHelperFAFQuery;
import com.espertech.esper.compiler.internal.util.CompilerHelperModuleProvider;
import com.espertech.esper.compiler.internal.util.CompilerHelperSingleEPL;
import com.espertech.esper.compiler.internal.util.CompilerHelperSingleResult;
import com.espertech.esper.compiler.internal.util.CompilerHelperStatementProvider;
import com.espertech.esper.compiler.internal.util.CompilerHelperValidator;
import com.espertech.esper.compiler.internal.util.EPCompilerImpl;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompilerHelperFAFProvider {
    private static final String MEMBERNAME_QUERY_METHOD_PROVIDER = "provider";

    public static EPCompiled compile(Compilable compilable, ModuleCompileTimeServices services, CompilerArguments args) throws ExprValidationException, StatementSpecCompileException, EPCompileException {
        EPCompiledManifest manifest;
        FAFQueryMethodIUDInsertIntoForge query;
        String statementNameFromAnnotation;
        StatementCompileTimeServices compileTimeServices = new StatementCompileTimeServices(0, services);
        CompilerHelperSingleResult walkResult = CompilerHelperSingleEPL.parseCompileInlinedClassesWalk(compilable, args.getOptions() == null ? null : args.getOptions().getInlinedClassInspection(), compileTimeServices);
        StatementSpecRaw raw = walkResult.getStatementSpecRaw();
        StatementType statementType = StatementTypeUtil.getStatementType((StatementSpecRaw)raw);
        if (statementType != StatementType.SELECT) {
            throw new StatementSpecCompileException("Provided EPL expression is a continuous query expression (not an on-demand query)", compilable.toEPL());
        }
        Annotation[] annotations = AnnotationUtil.compileAnnotations((List)raw.getAnnotations(), (ClasspathImportServiceCompileTime)services.getClasspathImportServiceCompileTime(), (Compilable)compilable);
        ExprNodeSubselectDeclaredDotVisitor visitor = StatementSpecRawWalkerSubselectAndDeclaredDot.walkSubselectAndDeclaredDotExpr((StatementSpecRaw)raw);
        ContextCompileTimeDescriptor contextDescriptor = null;
        String optionalContextName = raw.getOptionalContextName();
        if (optionalContextName != null) {
            ContextMetaData detail = services.getContextCompileTimeResolver().getContextInfo(optionalContextName);
            if (detail == null) {
                throw new StatementSpecCompileException("Context by name '" + optionalContextName + "' could not be found", compilable.toEPL());
            }
            contextDescriptor = new ContextCompileTimeDescriptor(optionalContextName, detail.getContextModuleName(), detail.getContextVisibility(), new ContextPropertyRegistry(detail), detail.getValidationInfos());
        }
        String statementName = (statementNameFromAnnotation = CompilerHelperStatementProvider.getNameFromAnnotation(annotations)) == null ? "q0" : statementNameFromAnnotation.trim();
        StatementRawInfo statementRawInfo = new StatementRawInfo(0, statementName, annotations, statementType, contextDescriptor, null, compilable, null);
        StatementSpecCompiledDesc compiledDesc = StatementRawCompiler.compile((StatementSpecRaw)raw, (Compilable)compilable, (boolean)false, (boolean)true, (Annotation[])annotations, (List)visitor.getSubselects(), new ArrayList(raw.getTableExpressions()), (StatementRawInfo)statementRawInfo, (StatementCompileTimeServices)compileTimeServices);
        StatementSpecCompiled specCompiled = compiledDesc.getCompiled();
        FireAndForgetSpec fafSpec = specCompiled.getRaw().getFireAndForgetSpec();
        CompilerAbstractionClassCollection compilerState = services.getCompilerAbstraction().newClassCollection();
        compilerState.add(walkResult.getClassesInlined().getBytes());
        String classPostfix = IdentifierUtil.getIdentifierMayStartNumeric((String)statementName);
        if (specCompiled.getRaw().getInsertIntoDesc() != null) {
            query = new FAFQueryMethodIUDInsertIntoForge(specCompiled, compilable, statementRawInfo, compileTimeServices);
        } else if (fafSpec == null) {
            FAFQueryMethodSelectDesc desc = new FAFQueryMethodSelectDesc(specCompiled, compilable, statementRawInfo, compileTimeServices);
            String classNameResultSetProcessor = CodeGenerationIDGenerator.generateClassNameSimple(ResultSetProcessorFactoryProvider.class, (String)classPostfix);
            query = new FAFQueryMethodSelectForge(desc, classNameResultSetProcessor, statementRawInfo, services);
        } else if (fafSpec instanceof FireAndForgetSpecDelete) {
            query = new FAFQueryMethodIUDDeleteForge(specCompiled, compilable, statementRawInfo, compileTimeServices);
        } else if (fafSpec instanceof FireAndForgetSpecUpdate) {
            query = new FAFQueryMethodIUDUpdateForge(specCompiled, compilable, statementRawInfo, compileTimeServices);
        } else {
            throw new IllegalStateException("Unrecognized FAF code " + fafSpec);
        }
        CompilerHelperValidator.verifySubstitutionParams(raw.getSubstitutionParameters());
        try {
            manifest = CompilerHelperFAFProvider.compileToBytes((FAFQueryMethodForge)query, classPostfix, compilerState, services, args.getPath());
        }
        catch (EPCompileException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new EPCompileException("Unexpected exception compiling module: " + t.getMessage(), t, Collections.emptyList());
        }
        return new EPCompiled(compilerState.getClasses(), manifest);
    }

    private static EPCompiledManifest compileToBytes(FAFQueryMethodForge query, String classPostfix, CompilerAbstractionClassCollection compilerState, ModuleCompileTimeServices compileTimeServices, CompilerPath path) throws EPCompileException {
        String queryMethodProviderClassName;
        try {
            queryMethodProviderClassName = CompilerHelperFAFQuery.compileQuery(query, classPostfix, compilerState, compileTimeServices, path);
        }
        catch (StatementSpecCompileException ex) {
            EPCompileExceptionItem first = ex instanceof StatementSpecCompileSyntaxException ? new EPCompileExceptionSyntaxItem(ex.getMessage(), ex, ex.getExpression(), -1) : new EPCompileExceptionItem(ex.getMessage(), ex, ex.getExpression(), -1);
            List<EPCompileExceptionItem> items = Collections.singletonList(first);
            throw new EPCompileException(ex.getMessage() + " [" + ex.getExpression() + "]", ex, items);
        }
        String fafProviderClassName = CompilerHelperFAFProvider.makeFAFProvider(queryMethodProviderClassName, classPostfix, compilerState, compileTimeServices, path);
        return new EPCompiledManifest("9.0.0", null, fafProviderClassName, false);
    }

    private static String makeFAFProvider(String queryMethodProviderClassName, String classPostfix, CompilerAbstractionClassCollection compilerState, ModuleCompileTimeServices compileTimeServices, CompilerPath path) {
        CodegenPackageScope packageScope = new CodegenPackageScope(compileTimeServices.getPackageName(), null, compileTimeServices.isInstrumented(), compileTimeServices.getConfiguration().getCompiler().getByteCode());
        String fafProviderClassName = CodeGenerationIDGenerator.generateClassNameSimple(FAFProvider.class, (String)classPostfix);
        CodegenClassScope classScope = new CodegenClassScope(true, packageScope, fafProviderClassName);
        CodegenClassMethods methods = new CodegenClassMethods();
        CodegenMethod getModuleDependenciesMethod = CodegenMethod.makeParentNode((EPTypeClass)ModuleDependenciesRuntime.EPTYPE, EPCompilerImpl.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        compileTimeServices.getModuleDependencies().make(getModuleDependenciesMethod, classScope);
        CodegenMethod initializeEventTypesMethod = CompilerHelperModuleProvider.makeInitEventTypesOptional(classScope, compileTimeServices);
        CodegenMethod initializeQueryMethod = CodegenMethod.makeParentNode((EPTypeClass)EPTypePremade.VOID.getEPType(), EPCompilerImpl.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EPStatementInitServices.EPTYPE, EPStatementInitServices.REF.getRef());
        initializeQueryMethod.getBlock().assignMember(MEMBERNAME_QUERY_METHOD_PROVIDER, CodegenExpressionBuilder.newInstance((String)queryMethodProviderClassName, (CodegenExpression[])new CodegenExpression[]{EPStatementInitServices.REF}));
        CodegenMethod getQueryMethodProviderMethod = CodegenMethod.makeParentNode((EPTypeClass)FAFQueryMethodProvider.EPTYPE, EPCompilerImpl.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        getQueryMethodProviderMethod.getBlock().methodReturn((CodegenExpression)CodegenExpressionBuilder.ref((String)MEMBERNAME_QUERY_METHOD_PROVIDER));
        CodegenStackGenerator.recursiveBuildStack((CodegenMethod)getModuleDependenciesMethod, (String)"getModuleDependencies", (CodegenClassMethods)methods);
        if (initializeEventTypesMethod != null) {
            CodegenStackGenerator.recursiveBuildStack((CodegenMethod)initializeEventTypesMethod, (String)"initializeEventTypes", (CodegenClassMethods)methods);
        }
        CodegenStackGenerator.recursiveBuildStack((CodegenMethod)initializeQueryMethod, (String)"initializeQuery", (CodegenClassMethods)methods);
        CodegenStackGenerator.recursiveBuildStack((CodegenMethod)getQueryMethodProviderMethod, (String)"getQueryMethodProvider", (CodegenClassMethods)methods);
        ArrayList<CodegenTypedParam> members = new ArrayList<CodegenTypedParam>();
        members.add(new CodegenTypedParam(FAFQueryMethodProvider.EPTYPE, MEMBERNAME_QUERY_METHOD_PROVIDER).setFinal(false));
        CodegenClass clazz = new CodegenClass(CodegenClassType.FAFPROVIDER, FAFProvider.EPTYPE, fafProviderClassName, classScope, members, null, methods, Collections.emptyList());
        CompilerAbstractionCompilationContext context = new CompilerAbstractionCompilationContext(compileTimeServices, path.getCompileds());
        compileTimeServices.getCompilerAbstraction().compileClasses(Collections.singletonList(clazz), context, compilerState);
        return CodeGenerationIDGenerator.generateClassNameWithPackage((String)compileTimeServices.getPackageName(), FAFProvider.class, (String)classPostfix);
    }
}

