/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.util;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationIDGenerator;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionClassCollection;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionCompilationContext;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompileException;
import com.espertech.esper.common.internal.compile.stage3.ModuleCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableStmtFields;
import com.espertech.esper.common.internal.context.module.StatementFields;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodForge;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodProvider;
import com.espertech.esper.compiler.client.CompilerPath;
import java.util.ArrayList;
import java.util.List;

public class CompilerHelperFAFQuery {
    public static String compileQuery(FAFQueryMethodForge query, String classPostfix, CompilerAbstractionClassCollection compilerState, ModuleCompileTimeServices compileTimeServices, CompilerPath path) throws StatementSpecCompileException {
        String statementFieldsClassName = CodeGenerationIDGenerator.generateClassNameSimple(StatementFields.class, (String)classPostfix);
        CodegenPackageScope packageScope = new CodegenPackageScope(compileTimeServices.getPackageName(), statementFieldsClassName, compileTimeServices.isInstrumented(), compileTimeServices.getConfiguration().getCompiler().getByteCode());
        String queryMethodProviderClassName = CodeGenerationIDGenerator.generateClassNameSimple(FAFQueryMethodProvider.class, (String)classPostfix);
        List forgeablesQueryMethod = query.makeForgeables(queryMethodProviderClassName, classPostfix, packageScope);
        ArrayList<StmtClassForgeableStmtFields> forgeables = new ArrayList<StmtClassForgeableStmtFields>(forgeablesQueryMethod);
        forgeables.add(new StmtClassForgeableStmtFields(statementFieldsClassName, packageScope));
        ArrayList<CodegenClass> classes = new ArrayList<CodegenClass>(forgeables.size());
        for (StmtClassForgeable stmtClassForgeable : forgeables) {
            CodegenClass clazz = stmtClassForgeable.forge(true, true);
            if (clazz == null) continue;
            classes.add(clazz);
        }
        classes.sort((o1, o2) -> Integer.compare(o1.getClassType().getSortCode(), o2.getClassType().getSortCode()));
        packageScope.rewriteStatementFieldUse(classes);
        compileTimeServices.getClassProvidedCompileTimeResolver().addTo(arg_0 -> ((CompilerAbstractionClassCollection)compilerState).add(arg_0));
        CompilerAbstractionCompilationContext ctx = new CompilerAbstractionCompilationContext(compileTimeServices, path.getCompileds());
        compileTimeServices.getCompilerAbstraction().compileClasses(classes, ctx, compilerState);
        compileTimeServices.getClassProvidedCompileTimeResolver().removeFrom(arg_0 -> ((CompilerAbstractionClassCollection)compilerState).remove(arg_0));
        return queryMethodProviderClassName;
    }
}

