/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.util;

import com.espertech.esper.common.client.EPCompiled;
import com.espertech.esper.common.client.EPCompiledManifest;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.module.ModuleProperty;
import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationIDGenerator;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassType;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionEPType;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenRepetitiveValueBuilder;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenStackGenerator;
import com.espertech.esper.common.internal.bytecodemodel.util.IdentifierUtil;
import com.espertech.esper.common.internal.collection.PathException;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstraction;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionClassCollection;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionCompilationContext;
import com.espertech.esper.common.internal.compile.stage1.Compilable;
import com.espertech.esper.common.internal.compile.stage1.spec.ExpressionDeclItem;
import com.espertech.esper.common.internal.compile.stage1.spec.ExpressionScriptProvided;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompileException;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompileSyntaxException;
import com.espertech.esper.common.internal.compile.stage3.ModuleCompileTimeServices;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleClassProvidedInitializeSymbol;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleContextInitializeSymbol;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleEventTypeInitializeSymbol;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleExpressionDeclaredInitializeSymbol;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleIndexesInitializeSymbol;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleNamedWindowInitializeSymbol;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleScriptInitializeSymbol;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleTableInitializeSymbol;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleVariableInitializeSymbol;
import com.espertech.esper.common.internal.context.compile.ContextMetaData;
import com.espertech.esper.common.internal.context.module.EPModuleClassProvidedInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleContextInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleEventTypeInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleExprDeclaredInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleIndexInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleNamedWindowInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleScriptInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleTableInitServices;
import com.espertech.esper.common.internal.context.module.EPModuleVariableInitServices;
import com.espertech.esper.common.internal.context.module.ModuleDependenciesRuntime;
import com.espertech.esper.common.internal.context.module.ModuleProvider;
import com.espertech.esper.common.internal.epl.classprovided.core.ClassProvided;
import com.espertech.esper.common.internal.epl.index.compile.IndexCompileTimeKey;
import com.espertech.esper.common.internal.epl.index.compile.IndexDetail;
import com.espertech.esper.common.internal.epl.index.compile.IndexDetailForge;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowMetaData;
import com.espertech.esper.common.internal.epl.script.core.NameAndParamNum;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.epl.util.EPCompilerPathableImpl;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import com.espertech.esper.common.internal.event.avro.AvroSchemaEventType;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.core.BaseNestableEventType;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.core.TypeBeanOrUnderlying;
import com.espertech.esper.common.internal.event.core.WrapperEventType;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.event.map.MapEventType;
import com.espertech.esper.common.internal.event.path.EventTypeResolver;
import com.espertech.esper.common.internal.event.variant.VariantEventType;
import com.espertech.esper.common.internal.event.xml.BaseXMLEventType;
import com.espertech.esper.common.internal.event.xml.SchemaXMLEventType;
import com.espertech.esper.common.internal.fabric.FabricStatement;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.util.SerializerUtil;
import com.espertech.esper.compiler.client.CompilerOptions;
import com.espertech.esper.compiler.client.CompilerPath;
import com.espertech.esper.compiler.client.EPCompileException;
import com.espertech.esper.compiler.client.EPCompileExceptionItem;
import com.espertech.esper.compiler.client.EPCompileExceptionSyntaxItem;
import com.espertech.esper.compiler.internal.util.CompilableItem;
import com.espertech.esper.compiler.internal.util.CompilerHelperStatementProvider;
import com.espertech.esper.compiler.internal.util.CompilerPathCacheImpl;
import com.espertech.esper.compiler.internal.util.CompilerPool;
import com.espertech.esper.compiler.internal.util.EPCompilerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;

public class CompilerHelperModuleProvider {
    private static final int NUM_STATEMENT_NAMES_PER_BATCH = 1000;

    protected static EPCompiled compile(List<Compilable> compilables, String optionalModuleName, Map<ModuleProperty, Object> moduleProperties, ModuleCompileTimeServices compileTimeServices, CompilerOptions compilerOptions, CompilerPath path) throws EPCompileException {
        EPCompiledManifest manifest;
        CompilerAbstraction compilerAbstraction = compileTimeServices.getCompilerAbstraction();
        CompilerAbstractionClassCollection compilationState = compilerAbstraction.newClassCollection();
        try {
            manifest = CompilerHelperModuleProvider.compileToBytes(compilerAbstraction, compilationState, compilables, optionalModuleName, moduleProperties, compileTimeServices, compilerOptions, path);
        }
        catch (EPCompileException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new EPCompileException("Unexpected exception compiling module: " + t.getMessage(), t, Collections.emptyList());
        }
        Map classes = compilationState.getClasses();
        EPCompiled compiled = new EPCompiled(classes, manifest);
        if (compilerOptions.getPathCache() != null) {
            try {
                ((CompilerPathCacheImpl)compilerOptions.getPathCache()).put(compiled, CompilerHelperModuleProvider.toPathable(optionalModuleName, compileTimeServices, "cached-entry"));
            }
            catch (PathException ex) {
                throw new EPCompileException("Failed to add compiled to path cache: " + ex.getMessage(), ex);
            }
        }
        return compiled;
    }

    private static EPCompiledManifest compileToBytes(CompilerAbstraction compilerAbstraction, CompilerAbstractionClassCollection compilationState, List<Compilable> compilables, String optionalModuleName, Map<ModuleProperty, Object> moduleProperties, ModuleCompileTimeServices compileTimeServices, CompilerOptions compilerOptions, CompilerPath path) throws EPCompileException {
        String moduleAssignedName = optionalModuleName == null ? UUID.randomUUID().toString() : optionalModuleName;
        String moduleIdentPostfix = IdentifierUtil.getIdentifierMayStartNumeric((String)moduleAssignedName);
        ArrayList<String> statementClassNames = new ArrayList<String>();
        HashSet<String> statementNames = new HashSet<String>();
        ArrayList<EPCompileExceptionItem> exceptions = new ArrayList<EPCompileExceptionItem>();
        ArrayList<EPCompileExceptionItem> postLatchThrowables = new ArrayList<EPCompileExceptionItem>();
        CompilerPool compilerPool = new CompilerPool(compilables.size(), compileTimeServices, path.getCompileds(), compilerAbstraction, compilationState);
        boolean targetHA = compileTimeServices.getSerdeEventTypeRegistry().isTargetHA();
        ArrayList<FabricStatement> fabricStatements = targetHA ? new ArrayList<FabricStatement>() : Collections.emptyList();
        try {
            int statementNumber = 0;
            for (Compilable compilable : compilables) {
                String className = null;
                EPCompileExceptionItem exception = null;
                try {
                    CompilableItem compilableItem = CompilerHelperStatementProvider.compileItem(compilable, optionalModuleName, moduleIdentPostfix, statementNumber, statementNames, compileTimeServices, compilerOptions);
                    className = compilableItem.getProviderClassName();
                    if (targetHA) {
                        FabricStatement fabricStatement = compileTimeServices.getStateMgmtSettingsProvider().statement(statementNumber, compilableItem.getContextDescriptor(), compilableItem.getFabricCharge());
                        fabricStatements.add(fabricStatement);
                    }
                    compilerPool.submit(statementNumber, compilableItem);
                    try {
                        compilableItem.getPostCompileLatch().awaitAndRun();
                    }
                    catch (Throwable t) {
                        postLatchThrowables.add(new EPCompileExceptionItem(t.getMessage(), t, compilable.toEPL(), compilable.lineNumber()));
                    }
                }
                catch (StatementSpecCompileException ex) {
                    exception = ex instanceof StatementSpecCompileSyntaxException ? new EPCompileExceptionSyntaxItem(ex.getMessage(), ex, ex.getExpression(), compilable.lineNumber()) : new EPCompileExceptionItem(ex.getMessage(), ex, ex.getExpression(), compilable.lineNumber());
                    exceptions.add(exception);
                }
                catch (RuntimeException ex) {
                    exception = new EPCompileExceptionItem(ex.getMessage(), ex, compilable.toEPL(), compilable.lineNumber());
                    exceptions.add(exception);
                }
                if (exception == null) {
                    statementClassNames.add(className);
                }
                ++statementNumber;
            }
        }
        catch (InterruptedException | RuntimeException ex) {
            compilerPool.shutdownNow();
            throw new EPCompileException(ex.getMessage(), ex);
        }
        compilerPool.shutdownCollectResults();
        exceptions.addAll(postLatchThrowables);
        if (!exceptions.isEmpty()) {
            compilerPool.shutdown();
            EPCompileExceptionItem ex = (EPCompileExceptionItem)((Object)exceptions.get(0));
            throw new EPCompileException(ex.getMessage() + " [" + ex.getExpression() + "]", (Throwable)((Object)ex), exceptions);
        }
        String moduleProviderClassName = CompilerHelperModuleProvider.compileModule(optionalModuleName, moduleProperties, statementClassNames, moduleIdentPostfix, compilerAbstraction, compilationState, compileTimeServices, path.getCompileds());
        compileTimeServices.getClassProvidedCompileTimeResolver().removeFrom(arg_0 -> ((CompilerAbstractionClassCollection)compilationState).remove(arg_0));
        compileTimeServices.getClassProvidedCompileTimeRegistry().addTo(arg_0 -> ((CompilerAbstractionClassCollection)compilationState).add(arg_0));
        if (compileTimeServices.getSerdeEventTypeRegistry().isTargetHA()) {
            compileTimeServices.getStateMgmtSettingsProvider().spec(fabricStatements, compileTimeServices, compilationState.getClasses());
        }
        return new EPCompiledManifest("9.0.0", moduleProviderClassName, null, compileTimeServices.getSerdeResolver().isTargetHA());
    }

    private static String compileModule(String optionalModuleName, Map<ModuleProperty, Object> moduleProperties, List<String> statementClassNames, String moduleIdentPostfix, CompilerAbstraction compilerAbstraction, CompilerAbstractionClassCollection compilationState, ModuleCompileTimeServices compileTimeServices, List<EPCompiled> path) {
        CodegenPackageScope packageScope = new CodegenPackageScope(compileTimeServices.getPackageName(), null, compileTimeServices.isInstrumented(), compileTimeServices.getConfiguration().getCompiler().getByteCode());
        String moduleClassName = CodeGenerationIDGenerator.generateClassNameSimple(ModuleProvider.class, (String)moduleIdentPostfix);
        CodegenClassScope classScope = new CodegenClassScope(true, packageScope, moduleClassName);
        CodegenClassMethods methods = new CodegenClassMethods();
        CodegenMethod getModuleNameMethodOpt = null;
        if (optionalModuleName != null) {
            getModuleNameMethodOpt = CodegenMethod.makeParentNode((EPTypeClass)EPTypePremade.STRING.getEPType(), EPCompilerImpl.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
            getModuleNameMethodOpt.getBlock().methodReturn(CodegenExpressionBuilder.constant((Object)optionalModuleName));
        }
        CodegenMethod getModulePropertiesMethodOpt = null;
        if (!moduleProperties.isEmpty()) {
            getModulePropertiesMethodOpt = CodegenMethod.makeParentNode((EPTypeClass)EPTypePremade.MAP.getEPType(), EPCompilerImpl.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
            CompilerHelperModuleProvider.makeModuleProperties(moduleProperties, getModulePropertiesMethodOpt);
        }
        CodegenMethod getModuleDependenciesMethod = CodegenMethod.makeParentNode((EPTypeClass)ModuleDependenciesRuntime.EPTYPE, EPCompilerImpl.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        compileTimeServices.getModuleDependencies().make(getModuleDependenciesMethod, classScope);
        CodegenMethod initializeEventTypesMethodOpt = CompilerHelperModuleProvider.makeInitEventTypesOptional(classScope, compileTimeServices);
        CodegenMethod initializeNamedWindowsMethodOpt = CompilerHelperModuleProvider.makeInitNamedWindowsOptional(classScope, compileTimeServices);
        CodegenMethod initializeTablesMethodOpt = CompilerHelperModuleProvider.makeInitTablesOptional(classScope, compileTimeServices);
        CodegenMethod initializeIndexesMethodOpt = CompilerHelperModuleProvider.makeInitIndexesOptional(classScope, compileTimeServices);
        CodegenMethod initializeContextsMethodOpt = CompilerHelperModuleProvider.makeInitContextsOptional(classScope, compileTimeServices);
        CodegenMethod initializeVariablesMethodOpt = CompilerHelperModuleProvider.makeInitVariablesOptional(classScope, compileTimeServices);
        CodegenMethod initializeExprDeclaredMethodOpt = CompilerHelperModuleProvider.makeInitDeclExprOptional(classScope, compileTimeServices);
        CodegenMethod initializeScriptsMethodOpt = CompilerHelperModuleProvider.makeInitScriptsOptional(classScope, compileTimeServices);
        CodegenMethod initializeClassProvidedMethodOpt = CompilerHelperModuleProvider.makeInitClassProvidedOptional(classScope, compileTimeServices);
        CodegenMethod statementsMethod = CodegenMethod.makeParentNode((EPTypeClass)EPTypePremade.LIST.getEPType(), EPCompilerImpl.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        CompilerHelperModuleProvider.makeStatementsMethod(statementsMethod, statementClassNames, classScope);
        if (getModuleNameMethodOpt != null) {
            CodegenStackGenerator.recursiveBuildStack((CodegenMethod)getModuleNameMethodOpt, (String)"getModuleName", (CodegenClassMethods)methods);
        }
        if (getModulePropertiesMethodOpt != null) {
            CodegenStackGenerator.recursiveBuildStack((CodegenMethod)getModulePropertiesMethodOpt, (String)"getModuleProperties", (CodegenClassMethods)methods);
        }
        CodegenStackGenerator.recursiveBuildStack((CodegenMethod)getModuleDependenciesMethod, (String)"getModuleDependencies", (CodegenClassMethods)methods);
        if (initializeEventTypesMethodOpt != null) {
            CodegenStackGenerator.recursiveBuildStack((CodegenMethod)initializeEventTypesMethodOpt, (String)"initializeEventTypes", (CodegenClassMethods)methods);
        }
        if (initializeNamedWindowsMethodOpt != null) {
            CodegenStackGenerator.recursiveBuildStack((CodegenMethod)initializeNamedWindowsMethodOpt, (String)"initializeNamedWindows", (CodegenClassMethods)methods);
        }
        if (initializeTablesMethodOpt != null) {
            CodegenStackGenerator.recursiveBuildStack((CodegenMethod)initializeTablesMethodOpt, (String)"initializeTables", (CodegenClassMethods)methods);
        }
        if (initializeIndexesMethodOpt != null) {
            CodegenStackGenerator.recursiveBuildStack((CodegenMethod)initializeIndexesMethodOpt, (String)"initializeIndexes", (CodegenClassMethods)methods);
        }
        if (initializeContextsMethodOpt != null) {
            CodegenStackGenerator.recursiveBuildStack((CodegenMethod)initializeContextsMethodOpt, (String)"initializeContexts", (CodegenClassMethods)methods);
        }
        if (initializeVariablesMethodOpt != null) {
            CodegenStackGenerator.recursiveBuildStack((CodegenMethod)initializeVariablesMethodOpt, (String)"initializeVariables", (CodegenClassMethods)methods);
        }
        if (initializeExprDeclaredMethodOpt != null) {
            CodegenStackGenerator.recursiveBuildStack((CodegenMethod)initializeExprDeclaredMethodOpt, (String)"initializeExprDeclareds", (CodegenClassMethods)methods);
        }
        if (initializeScriptsMethodOpt != null) {
            CodegenStackGenerator.recursiveBuildStack((CodegenMethod)initializeScriptsMethodOpt, (String)"initializeScripts", (CodegenClassMethods)methods);
        }
        if (initializeClassProvidedMethodOpt != null) {
            CodegenStackGenerator.recursiveBuildStack((CodegenMethod)initializeClassProvidedMethodOpt, (String)"initializeClassProvided", (CodegenClassMethods)methods);
        }
        CodegenStackGenerator.recursiveBuildStack((CodegenMethod)statementsMethod, (String)"statements", (CodegenClassMethods)methods);
        CodegenClass clazz = new CodegenClass(CodegenClassType.MODULEPROVIDER, ModuleProvider.EPTYPE, moduleClassName, classScope, Collections.emptyList(), null, methods, Collections.emptyList());
        CompilerAbstractionCompilationContext context = new CompilerAbstractionCompilationContext(compileTimeServices, path);
        compilerAbstraction.compileClasses(Collections.singletonList(clazz), context, compilationState);
        return CodeGenerationIDGenerator.generateClassNameWithPackage((String)compileTimeServices.getPackageName(), ModuleProvider.class, (String)moduleIdentPostfix);
    }

    private static CodegenMethod makeInitClassProvidedOptional(CodegenClassScope classScope, ModuleCompileTimeServices compileTimeServices) {
        if (compileTimeServices.getClassProvidedCompileTimeRegistry().getClasses().isEmpty()) {
            return null;
        }
        ModuleClassProvidedInitializeSymbol symbols = new ModuleClassProvidedInitializeSymbol();
        CodegenMethod method = CodegenMethod.makeParentNode((EPTypeClass)EPTypePremade.VOID.getEPType(), EPCompilerImpl.class, (CodegenSymbolProvider)symbols, (CodegenScope)classScope).addParam(EPModuleClassProvidedInitServices.EPTYPE, ModuleClassProvidedInitializeSymbol.REF_INITSVC.getRef());
        for (Map.Entry<String, ClassProvided> entry : compileTimeServices.getClassProvidedCompileTimeRegistry().getClasses().entrySet()) {
            CodegenMethod addClassProvided = CompilerHelperModuleProvider.registerClassProvidedCodegen(entry, (CodegenMethodScope)method, classScope, symbols);
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)addClassProvided, (CodegenExpression[])new CodegenExpression[0]));
        }
        return method;
    }

    private static CodegenMethod makeInitScriptsOptional(CodegenClassScope classScope, ModuleCompileTimeServices compileTimeServices) {
        if (compileTimeServices.getScriptCompileTimeRegistry().getScripts().isEmpty()) {
            return null;
        }
        ModuleScriptInitializeSymbol symbols = new ModuleScriptInitializeSymbol();
        CodegenMethod method = CodegenMethod.makeParentNode((EPTypeClass)EPTypePremade.VOID.getEPType(), EPCompilerImpl.class, (CodegenSymbolProvider)symbols, (CodegenScope)classScope).addParam(EPModuleScriptInitServices.EPTYPE, ModuleScriptInitializeSymbol.REF_INITSVC.getRef());
        for (Map.Entry<NameAndParamNum, ExpressionScriptProvided> entry : compileTimeServices.getScriptCompileTimeRegistry().getScripts().entrySet()) {
            CodegenMethod addScript = CompilerHelperModuleProvider.registerScriptCodegen(entry, (CodegenMethodScope)method, classScope, symbols);
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)addScript, (CodegenExpression[])new CodegenExpression[0]));
        }
        return method;
    }

    private static CodegenMethod makeInitDeclExprOptional(CodegenClassScope classScope, ModuleCompileTimeServices compileTimeServices) {
        if (compileTimeServices.getExprDeclaredCompileTimeRegistry().getExpressions().isEmpty()) {
            return null;
        }
        ModuleExpressionDeclaredInitializeSymbol symbols = new ModuleExpressionDeclaredInitializeSymbol();
        CodegenMethod method = CodegenMethod.makeParentNode((EPTypeClass)EPTypePremade.VOID.getEPType(), EPCompilerImpl.class, (CodegenSymbolProvider)symbols, (CodegenScope)classScope).addParam(EPModuleExprDeclaredInitServices.EPTYPE, ModuleExpressionDeclaredInitializeSymbol.REF_INITSVC.getRef());
        for (Map.Entry<String, ExpressionDeclItem> entry : compileTimeServices.getExprDeclaredCompileTimeRegistry().getExpressions().entrySet()) {
            CodegenMethod addExpression = CompilerHelperModuleProvider.registerExprDeclaredCodegen(entry, method, classScope, symbols);
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)addExpression, (CodegenExpression[])new CodegenExpression[0]));
        }
        return method;
    }

    private static CodegenMethod makeInitVariablesOptional(CodegenClassScope classScope, ModuleCompileTimeServices compileTimeServices) {
        if (compileTimeServices.getVariableCompileTimeRegistry().getVariables().isEmpty()) {
            return null;
        }
        ModuleVariableInitializeSymbol symbols = new ModuleVariableInitializeSymbol();
        CodegenMethod method = CodegenMethod.makeParentNode((EPTypeClass)EPTypePremade.VOID.getEPType(), EPCompilerImpl.class, (CodegenSymbolProvider)symbols, (CodegenScope)classScope).addParam(EPModuleVariableInitServices.EPTYPE, ModuleVariableInitializeSymbol.REF_INITSVC.getRef());
        for (Map.Entry<String, VariableMetaData> entry : compileTimeServices.getVariableCompileTimeRegistry().getVariables().entrySet()) {
            CodegenMethod addVariable = CompilerHelperModuleProvider.registerVariableCodegen(entry, (CodegenMethodScope)method, classScope, symbols);
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)addVariable, (CodegenExpression[])new CodegenExpression[0]));
        }
        return method;
    }

    private static CodegenMethod makeInitContextsOptional(CodegenClassScope classScope, ModuleCompileTimeServices compileTimeServices) {
        if (compileTimeServices.getContextCompileTimeRegistry().getContexts().isEmpty()) {
            return null;
        }
        ModuleContextInitializeSymbol symbols = new ModuleContextInitializeSymbol();
        CodegenMethod method = CodegenMethod.makeParentNode((EPTypeClass)EPTypePremade.VOID.getEPType(), EPCompilerImpl.class, (CodegenSymbolProvider)symbols, (CodegenScope)classScope).addParam(EPModuleContextInitServices.EPTYPE, ModuleContextInitializeSymbol.REF_INITSVC.getRef());
        for (Map.Entry<String, ContextMetaData> entry : compileTimeServices.getContextCompileTimeRegistry().getContexts().entrySet()) {
            CodegenMethod addContext = CompilerHelperModuleProvider.registerContextCodegen(entry, method, classScope, symbols);
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)addContext, (CodegenExpression[])new CodegenExpression[0]));
        }
        return method;
    }

    private static CodegenMethod makeInitIndexesOptional(CodegenClassScope classScope, ModuleCompileTimeServices compileTimeServices) {
        if (compileTimeServices.getIndexCompileTimeRegistry().getIndexes().isEmpty()) {
            return null;
        }
        ModuleIndexesInitializeSymbol symbols = new ModuleIndexesInitializeSymbol();
        CodegenMethod method = CodegenMethod.makeParentNode((EPTypeClass)EPTypePremade.VOID.getEPType(), EPCompilerImpl.class, (CodegenSymbolProvider)symbols, (CodegenScope)classScope).addParam(EPModuleIndexInitServices.EPTYPE, EPModuleIndexInitServices.REF.getRef());
        for (Map.Entry<IndexCompileTimeKey, IndexDetailForge> entry : compileTimeServices.getIndexCompileTimeRegistry().getIndexes().entrySet()) {
            CodegenMethod addIndex = CompilerHelperModuleProvider.registerIndexCodegen(entry, (CodegenMethodScope)method, classScope, symbols);
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)addIndex, (CodegenExpression[])new CodegenExpression[0]));
        }
        return method;
    }

    private static CodegenMethod makeInitTablesOptional(CodegenClassScope classScope, ModuleCompileTimeServices compileTimeServices) {
        if (compileTimeServices.getTableCompileTimeRegistry().getTables().isEmpty()) {
            return null;
        }
        ModuleTableInitializeSymbol symbols = new ModuleTableInitializeSymbol();
        CodegenMethod method = CodegenMethod.makeParentNode((EPTypeClass)EPTypePremade.VOID.getEPType(), EPCompilerImpl.class, (CodegenSymbolProvider)symbols, (CodegenScope)classScope).addParam(EPModuleTableInitServices.EPTYPE, ModuleTableInitializeSymbol.REF_INITSVC.getRef());
        for (Map.Entry<String, TableMetaData> entry : compileTimeServices.getTableCompileTimeRegistry().getTables().entrySet()) {
            CodegenMethod addTable = CompilerHelperModuleProvider.registerTableCodegen(entry, (CodegenMethodScope)method, classScope, symbols);
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)addTable, (CodegenExpression[])new CodegenExpression[0]));
        }
        return method;
    }

    private static CodegenMethod makeInitNamedWindowsOptional(CodegenClassScope classScope, ModuleCompileTimeServices compileTimeServices) {
        if (compileTimeServices.getNamedWindowCompileTimeRegistry().getNamedWindows().isEmpty()) {
            return null;
        }
        ModuleNamedWindowInitializeSymbol symbols = new ModuleNamedWindowInitializeSymbol();
        CodegenMethod method = CodegenMethod.makeParentNode((EPTypeClass)EPTypePremade.VOID.getEPType(), EPCompilerImpl.class, (CodegenSymbolProvider)symbols, (CodegenScope)classScope).addParam(EPModuleNamedWindowInitServices.EPTYPE, ModuleNamedWindowInitializeSymbol.REF_INITSVC.getRef());
        for (Map.Entry<String, NamedWindowMetaData> entry : compileTimeServices.getNamedWindowCompileTimeRegistry().getNamedWindows().entrySet()) {
            CodegenMethod addNamedWindow = CompilerHelperModuleProvider.registerNamedWindowCodegen(entry, (CodegenMethodScope)method, classScope, symbols);
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)addNamedWindow, (CodegenExpression[])new CodegenExpression[0]));
        }
        return method;
    }

    private static void makeStatementsMethod(CodegenMethod statementsMethod, List<String> statementClassNames, CodegenClassScope classScope) {
        CodegenExpression returnValue;
        if (statementClassNames.isEmpty()) {
            returnValue = CodegenExpressionBuilder.staticMethod(Collections.class, (String)"emptyList", (CodegenExpression[])new CodegenExpression[0]);
        } else if (statementClassNames.size() == 1) {
            returnValue = CodegenExpressionBuilder.staticMethod(Collections.class, (String)"singletonList", (CodegenExpression[])new CodegenExpression[]{CodegenExpressionBuilder.newInstance((String)statementClassNames.get(0), (CodegenExpression[])new CodegenExpression[0])});
        } else {
            statementsMethod.getBlock().declareVar(EPTypePremade.LIST.getEPType(), "statements", CodegenExpressionBuilder.newInstance((EPTypeClass)EPTypePremade.ARRAYLIST.getEPType(), (CodegenExpression[])new CodegenExpression[]{CodegenExpressionBuilder.constant((Object)statementClassNames.size())}));
            if (statementClassNames.size() <= 1000) {
                CompilerHelperModuleProvider.makeStatementsAdd(statementsMethod, statementClassNames);
            } else {
                List lists = CollectionUtil.subdivide(statementClassNames, (int)1000);
                for (List names : lists) {
                    CodegenMethod sub = statementsMethod.makeChild(EPTypePremade.VOID.getEPType(), CompilerHelperModuleProvider.class, (CodegenScope)classScope).addParam(EPTypePremade.LIST.getEPType(), "statements");
                    CompilerHelperModuleProvider.makeStatementsAdd(sub, names);
                    statementsMethod.getBlock().localMethod(sub, new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"statements")});
                }
            }
            returnValue = CodegenExpressionBuilder.ref((String)"statements");
        }
        statementsMethod.getBlock().methodReturn(returnValue);
    }

    private static void makeStatementsAdd(CodegenMethod statementsMethod, Collection<String> statementClassNames) {
        for (String statementClassName : statementClassNames) {
            statementsMethod.getBlock().exprDotMethod((CodegenExpression)CodegenExpressionBuilder.ref((String)"statements"), "add", new CodegenExpression[]{CodegenExpressionBuilder.newInstance((String)statementClassName, (CodegenExpression[])new CodegenExpression[0])});
        }
    }

    private static void makeModuleProperties(Map<ModuleProperty, Object> props, CodegenMethod method) {
        if (props.isEmpty()) {
            method.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(Collections.class, (String)"emptyMap", (CodegenExpression[])new CodegenExpression[0]));
            return;
        }
        if (props.size() == 1) {
            Map.Entry<ModuleProperty, Object> entry = props.entrySet().iterator().next();
            method.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(Collections.class, (String)"singletonMap", (CodegenExpression[])new CodegenExpression[]{CompilerHelperModuleProvider.makeModulePropKey(entry.getKey()), CompilerHelperModuleProvider.makeModulePropValue(entry.getValue())}));
            return;
        }
        method.getBlock().declareVar(EPTypePremade.MAP.getEPType(), "props", CodegenExpressionBuilder.newInstance((EPTypeClass)EPTypePremade.HASHMAP.getEPType(), (CodegenExpression[])new CodegenExpression[]{CodegenExpressionBuilder.constant((Object)CollectionUtil.capacityHashMap((int)props.size()))}));
        for (Map.Entry<ModuleProperty, Object> entry : props.entrySet()) {
            method.getBlock().exprDotMethod((CodegenExpression)CodegenExpressionBuilder.ref((String)"props"), "put", new CodegenExpression[]{CompilerHelperModuleProvider.makeModulePropKey(entry.getKey()), CompilerHelperModuleProvider.makeModulePropValue(entry.getValue())});
        }
        method.getBlock().methodReturn((CodegenExpression)CodegenExpressionBuilder.ref((String)"props"));
    }

    private static CodegenExpression makeModulePropKey(ModuleProperty key) {
        return CodegenExpressionBuilder.enumValue(ModuleProperty.class, (String)key.name());
    }

    private static CodegenExpression makeModulePropValue(Object value) {
        return SerializerUtil.expressionForUserObject((Object)value);
    }

    private static CodegenMethod registerClassProvidedCodegen(Map.Entry<String, ClassProvided> classProvided, CodegenMethodScope parent, CodegenClassScope classScope, ModuleClassProvidedInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(EPTypePremade.VOID.getEPType(), EPCompilerImpl.class, (CodegenScope)classScope);
        method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getClassProvidedCollector", new CodegenExpression[0]).add("registerClass", new CodegenExpression[]{CodegenExpressionBuilder.constant((Object)classProvided.getKey()), classProvided.getValue().make((CodegenMethodScope)method, classScope)}));
        return method;
    }

    private static CodegenMethod registerScriptCodegen(Map.Entry<NameAndParamNum, ExpressionScriptProvided> script, CodegenMethodScope parent, CodegenClassScope classScope, ModuleScriptInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(EPTypePremade.VOID.getEPType(), EPCompilerImpl.class, (CodegenScope)classScope);
        method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getScriptCollector", new CodegenExpression[0]).add("registerScript", new CodegenExpression[]{CodegenExpressionBuilder.constant((Object)script.getKey().getName()), CodegenExpressionBuilder.constant((Object)script.getKey().getParamNum()), script.getValue().make((CodegenMethodScope)method, classScope)}));
        return method;
    }

    private static CodegenMethod registerExprDeclaredCodegen(Map.Entry<String, ExpressionDeclItem> expression, CodegenMethod parent, CodegenClassScope classScope, ModuleExpressionDeclaredInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(EPTypePremade.VOID.getEPType(), EPCompilerImpl.class, (CodegenScope)classScope);
        ExpressionDeclItem item = expression.getValue();
        byte[] bytes = SerializerUtil.objectToByteArr((Object)item.getOptionalSoda());
        item.setOptionalSodaBytes(() -> bytes);
        method.getBlock().declareVar(ExpressionDeclItem.EPTYPE, "detail", expression.getValue().make(method, symbols, classScope)).expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getExprDeclaredCollector", new CodegenExpression[0]).add("registerExprDeclared", new CodegenExpression[]{CodegenExpressionBuilder.constant((Object)expression.getKey()), CodegenExpressionBuilder.ref((String)"detail")}));
        return method;
    }

    protected static CodegenMethod makeInitEventTypesOptional(CodegenClassScope classScope, ModuleCompileTimeServices compileTimeServices) {
        if (!CompilerHelperModuleProvider.hasEventTypes(compileTimeServices)) {
            return null;
        }
        ModuleEventTypeInitializeSymbol symbolsEventTypeInit = new ModuleEventTypeInitializeSymbol();
        CodegenMethod initializeEventTypesMethod = CodegenMethod.makeParentNode((EPTypeClass)EPTypePremade.VOID.getEPType(), EPCompilerImpl.class, (CodegenSymbolProvider)symbolsEventTypeInit, (CodegenScope)classScope).addParam(EPModuleEventTypeInitServices.EPTYPE, ModuleEventTypeInitializeSymbol.REF_INITSVC.getRef());
        for (EventType eventType : compileTimeServices.getEventTypeCompileTimeRegistry().getNewTypesAdded()) {
            CodegenMethod addType = CompilerHelperModuleProvider.registerEventTypeCodegen(eventType, (CodegenMethodScope)initializeEventTypesMethod, classScope, symbolsEventTypeInit);
            initializeEventTypesMethod.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)addType, (CodegenExpression[])new CodegenExpression[0]));
        }
        if (compileTimeServices.getSerdeEventTypeRegistry().isTargetHA()) {
            for (Map.Entry entry : compileTimeServices.getSerdeEventTypeRegistry().getEventTypes().entrySet()) {
                CodegenMethod addSerde = CompilerHelperModuleProvider.registerEventTypeSerdeCodegen((EventType)entry.getKey(), (DataInputOutputSerdeForge)entry.getValue(), (CodegenMethodScope)initializeEventTypesMethod, classScope, symbolsEventTypeInit);
                initializeEventTypesMethod.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)addSerde, (CodegenExpression[])new CodegenExpression[0]));
            }
        }
        return initializeEventTypesMethod;
    }

    private static boolean hasEventTypes(ModuleCompileTimeServices compileTimeServices) {
        boolean has;
        boolean bl = has = !compileTimeServices.getEventTypeCompileTimeRegistry().getNewTypesAdded().isEmpty();
        if (!has) {
            has = !compileTimeServices.getSerdeEventTypeRegistry().getEventTypes().isEmpty();
        }
        return has;
    }

    private static CodegenMethod registerNamedWindowCodegen(Map.Entry<String, NamedWindowMetaData> namedWindow, CodegenMethodScope parent, CodegenClassScope classScope, ModuleNamedWindowInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(EPTypePremade.VOID.getEPType(), EPCompilerImpl.class, (CodegenScope)classScope);
        method.getBlock().declareVar(NamedWindowMetaData.EPTYPE, "detail", namedWindow.getValue().make(symbols.getAddInitSvc((CodegenMethodScope)method))).expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getNamedWindowCollector", new CodegenExpression[0]).add("registerNamedWindow", new CodegenExpression[]{CodegenExpressionBuilder.constant((Object)namedWindow.getKey()), CodegenExpressionBuilder.ref((String)"detail")}));
        return method;
    }

    private static CodegenMethod registerTableCodegen(Map.Entry<String, TableMetaData> table, CodegenMethodScope parent, CodegenClassScope classScope, ModuleTableInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(EPTypePremade.VOID.getEPType(), EPCompilerImpl.class, (CodegenScope)classScope);
        method.getBlock().declareVar(TableMetaData.EPTYPE, "detail", table.getValue().make(parent, symbols, classScope)).expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getTableCollector", new CodegenExpression[0]).add("registerTable", new CodegenExpression[]{CodegenExpressionBuilder.constant((Object)table.getKey()), CodegenExpressionBuilder.ref((String)"detail")}));
        return method;
    }

    private static CodegenMethod registerIndexCodegen(Map.Entry<IndexCompileTimeKey, IndexDetailForge> index, CodegenMethodScope parent, CodegenClassScope classScope, ModuleIndexesInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(EPTypePremade.VOID.getEPType(), EPCompilerImpl.class, (CodegenScope)classScope);
        method.getBlock().declareVar(IndexCompileTimeKey.EPTYPE, "key", index.getKey().make(symbols.getAddInitSvc((CodegenMethodScope)method))).declareVar(IndexDetail.EPTYPE, "detail", index.getValue().make((CodegenMethodScope)method, symbols, classScope)).expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getIndexCollector", new CodegenExpression[0]).add("registerIndex", new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"key"), CodegenExpressionBuilder.ref((String)"detail")}));
        return method;
    }

    private static CodegenMethod registerContextCodegen(Map.Entry<String, ContextMetaData> context, CodegenMethod parent, CodegenClassScope classScope, ModuleContextInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(EPTypePremade.VOID.getEPType(), EPCompilerImpl.class, (CodegenScope)classScope);
        method.getBlock().declareVar(ContextMetaData.EPTYPE, "detail", context.getValue().make(symbols.getAddInitSvc((CodegenMethodScope)method))).expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getContextCollector", new CodegenExpression[0]).add("registerContext", new CodegenExpression[]{CodegenExpressionBuilder.constant((Object)context.getKey()), CodegenExpressionBuilder.ref((String)"detail")}));
        return method;
    }

    private static CodegenMethod registerVariableCodegen(Map.Entry<String, VariableMetaData> variable, CodegenMethodScope parent, CodegenClassScope classScope, ModuleVariableInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(EPTypePremade.VOID.getEPType(), EPCompilerImpl.class, (CodegenScope)classScope);
        method.getBlock().declareVar(VariableMetaData.EPTYPE, "detail", variable.getValue().make(symbols.getAddInitSvc((CodegenMethodScope)method))).expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getVariableCollector", new CodegenExpression[0]).add("registerVariable", new CodegenExpression[]{CodegenExpressionBuilder.constant((Object)variable.getKey()), CodegenExpressionBuilder.ref((String)"detail")}));
        return method;
    }

    private static CodegenMethod registerEventTypeCodegen(EventType eventType, CodegenMethodScope parent, CodegenClassScope classScope, ModuleEventTypeInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(EPTypePremade.VOID.getEPType(), EPCompilerImpl.class, (CodegenScope)classScope);
        method.getBlock().declareVar(EventTypeMetadata.EPTYPE, "metadata", eventType.getMetadata().toExpression());
        if (eventType instanceof JsonEventType) {
            JsonEventType jsonEventType = (JsonEventType)eventType;
            method.getBlock().declareVar(EPTypePremade.LINKEDHASHMAP.getEPType(), "props", (CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)CompilerHelperModuleProvider.makePropsCodegen(jsonEventType.getTypes(), (CodegenMethodScope)method, symbols, classScope, () -> jsonEventType.getDeepSuperTypes()), (CodegenExpression[])new CodegenExpression[0]));
            String[] superTypeNames = CompilerHelperModuleProvider.getSupertypeNames((EventType)jsonEventType);
            CodegenExpression detailExpr = jsonEventType.getDetail().toExpression((CodegenMethodScope)method, classScope);
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getEventTypeCollector", new CodegenExpression[0]).add("registerJson", new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"metadata"), CodegenExpressionBuilder.ref((String)"props"), CodegenExpressionBuilder.constant((Object)superTypeNames), CodegenExpressionBuilder.constant((Object)jsonEventType.getStartTimestampPropertyName()), CodegenExpressionBuilder.constant((Object)jsonEventType.getEndTimestampPropertyName()), detailExpr}));
        } else if (eventType instanceof BaseNestableEventType) {
            BaseNestableEventType baseNestable = (BaseNestableEventType)eventType;
            method.getBlock().declareVar(EPTypePremade.LINKEDHASHMAP.getEPType(), "props", (CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)CompilerHelperModuleProvider.makePropsCodegen(baseNestable.getTypes(), (CodegenMethodScope)method, symbols, classScope, () -> baseNestable.getDeepSuperTypes()), (CodegenExpression[])new CodegenExpression[0]));
            String registerMethodName = eventType instanceof MapEventType ? "registerMap" : "registerObjectArray";
            String[] superTypeNames = CompilerHelperModuleProvider.getSupertypeNames((EventType)baseNestable);
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getEventTypeCollector", new CodegenExpression[0]).add(registerMethodName, new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"metadata"), CodegenExpressionBuilder.ref((String)"props"), CodegenExpressionBuilder.constant((Object)superTypeNames), CodegenExpressionBuilder.constant((Object)baseNestable.getStartTimestampPropertyName()), CodegenExpressionBuilder.constant((Object)baseNestable.getEndTimestampPropertyName())}));
        } else if (eventType instanceof WrapperEventType) {
            WrapperEventType wrapper = (WrapperEventType)eventType;
            method.getBlock().declareVar(EventType.EPTYPE, "inner", EventTypeUtility.resolveTypeCodegen((EventType)((WrapperEventType)eventType).getUnderlyingEventType(), (CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)));
            method.getBlock().declareVar(EPTypePremade.LINKEDHASHMAP.getEPType(), "props", (CodegenExpression)CodegenExpressionBuilder.localMethod((CodegenMethod)CompilerHelperModuleProvider.makePropsCodegen(wrapper.getUnderlyingMapType().getTypes(), (CodegenMethodScope)method, symbols, classScope, () -> wrapper.getUnderlyingMapType().getDeepSuperTypes()), (CodegenExpression[])new CodegenExpression[0]));
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getEventTypeCollector", new CodegenExpression[0]).add("registerWrapper", new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"metadata"), CodegenExpressionBuilder.ref((String)"inner"), CodegenExpressionBuilder.ref((String)"props")}));
        } else if (eventType instanceof BeanEventType) {
            BeanEventType beanType = (BeanEventType)eventType;
            CodegenExpression superTypes = CompilerHelperModuleProvider.makeSupertypes(beanType.getSuperTypes(), symbols.getAddInitSvc((CodegenMethodScope)method));
            CodegenExpression deepSuperTypes = CompilerHelperModuleProvider.makeDeepSupertypes(beanType.getDeepSuperTypesAsSet(), (CodegenMethodScope)method, symbols, classScope);
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getEventTypeCollector", new CodegenExpression[0]).add("registerBean", new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"metadata"), CodegenExpressionBuilder.constant((Object)beanType.getUnderlyingEPType()), CodegenExpressionBuilder.constant((Object)beanType.getStartTimestampPropertyName()), CodegenExpressionBuilder.constant((Object)beanType.getEndTimestampPropertyName()), superTypes, deepSuperTypes}));
        } else if (eventType instanceof SchemaXMLEventType && ((SchemaXMLEventType)eventType).getRepresentsFragmentOfProperty() != null) {
            SchemaXMLEventType xmlType = (SchemaXMLEventType)eventType;
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getEventTypeCollector", new CodegenExpression[0]).add("registerXML", new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"metadata"), CodegenExpressionBuilder.constant((Object)xmlType.getRepresentsFragmentOfProperty()), CodegenExpressionBuilder.constant((Object)xmlType.getRepresentsOriginalTypeName())}));
        } else if (eventType instanceof BaseXMLEventType) {
            BaseXMLEventType xmlType = (BaseXMLEventType)eventType;
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getEventTypeCollector", new CodegenExpression[0]).add("registerXMLNewType", new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"metadata"), xmlType.getConfigurationEventTypeXMLDOM().toExpression((CodegenMethodScope)method, classScope)}));
        } else if (eventType instanceof AvroSchemaEventType) {
            AvroSchemaEventType avroType = (AvroSchemaEventType)eventType;
            String[] superTypeNames = CompilerHelperModuleProvider.getSupertypeNames((EventType)avroType);
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getEventTypeCollector", new CodegenExpression[0]).add("registerAvro", new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"metadata"), CodegenExpressionBuilder.constant((Object)avroType.getSchema().toString()), CodegenExpressionBuilder.constant((Object)superTypeNames)}));
        } else if (eventType instanceof VariantEventType) {
            VariantEventType variantEventType = (VariantEventType)eventType;
            method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getEventTypeCollector", new CodegenExpression[0]).add("registerVariant", new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"metadata"), EventTypeUtility.resolveTypeArrayCodegen((EventType[])variantEventType.getVariants(), (CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)), CodegenExpressionBuilder.constant((Object)variantEventType.isVariantAny())}));
        } else {
            throw new IllegalStateException("Event type '" + eventType + "' cannot be registered");
        }
        return method;
    }

    private static String[] getSupertypeNames(EventType eventType) {
        if (eventType.getSuperTypes() != null && eventType.getSuperTypes().length > 0) {
            String[] superTypeNames = new String[eventType.getSuperTypes().length];
            for (int i = 0; i < eventType.getSuperTypes().length; ++i) {
                superTypeNames[i] = eventType.getSuperTypes()[i].getName();
            }
            return superTypeNames;
        }
        return new String[0];
    }

    private static CodegenMethod registerEventTypeSerdeCodegen(EventType eventType, DataInputOutputSerdeForge serdeForge, CodegenMethodScope parent, CodegenClassScope classScope, ModuleEventTypeInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(EPTypePremade.VOID.getEPType(), EPCompilerImpl.class, (CodegenScope)classScope);
        method.getBlock().declareVar(EventTypeMetadata.EPTYPE, "metadata", eventType.getMetadata().toExpression()).declareVar(EventTypeResolver.EPTYPE, "resolver", CodegenExpressionBuilder.exprDotMethod((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method), (String)"getEventTypeResolver", (CodegenExpression[])new CodegenExpression[0])).declareVar(DataInputOutputSerde.EPTYPE, "serde", serdeForge.codegen(method, classScope, (CodegenExpression)CodegenExpressionBuilder.ref((String)"resolver")));
        method.getBlock().expression((CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain((CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method)).add("getEventTypeCollector", new CodegenExpression[0]).add("registerSerde", new CodegenExpression[]{CodegenExpressionBuilder.ref((String)"metadata"), CodegenExpressionBuilder.ref((String)"serde"), CodegenExpressionBuilder.constant((Object)eventType.getUnderlyingEPType())}));
        return method;
    }

    private static CodegenExpression makeDeepSupertypes(Set<EventType> deepSuperTypes, CodegenMethodScope parent, ModuleEventTypeInitializeSymbol symbols, CodegenClassScope classScope) {
        if (deepSuperTypes == null || deepSuperTypes.isEmpty()) {
            return CodegenExpressionBuilder.staticMethod(Collections.class, (String)"emptySet", (CodegenExpression[])new CodegenExpression[0]);
        }
        if (deepSuperTypes.size() == 1) {
            return CodegenExpressionBuilder.staticMethod(Collections.class, (String)"singleton", (CodegenExpression[])new CodegenExpression[]{EventTypeUtility.resolveTypeCodegen((EventType)deepSuperTypes.iterator().next(), (CodegenExpression)symbols.getAddInitSvc(parent))});
        }
        CodegenMethod method = parent.makeChild(EPTypePremade.SET.getEPType(), CompilerHelperModuleProvider.class, (CodegenScope)classScope);
        method.getBlock().declareVar(EPTypePremade.SET.getEPType(), "dst", CodegenExpressionBuilder.newInstance((EPTypeClass)EPTypePremade.LINKEDHASHSET.getEPType(), (CodegenExpression[])new CodegenExpression[]{CodegenExpressionBuilder.constant((Object)CollectionUtil.capacityHashMap((int)deepSuperTypes.size()))}));
        for (EventType eventType : deepSuperTypes) {
            method.getBlock().exprDotMethod((CodegenExpression)CodegenExpressionBuilder.ref((String)"dst"), "add", new CodegenExpression[]{EventTypeUtility.resolveTypeCodegen((EventType)eventType, (CodegenExpression)symbols.getAddInitSvc((CodegenMethodScope)method))});
        }
        method.getBlock().methodReturn((CodegenExpression)CodegenExpressionBuilder.ref((String)"dst"));
        return CodegenExpressionBuilder.localMethod((CodegenMethod)method, (CodegenExpression[])new CodegenExpression[0]);
    }

    private static CodegenExpression makeSupertypes(EventType[] superTypes, CodegenExpressionRef initSvcRef) {
        if (superTypes == null || superTypes.length == 0) {
            return CodegenExpressionBuilder.constantNull();
        }
        CodegenExpression[] expressions = new CodegenExpression[superTypes.length];
        for (int i = 0; i < superTypes.length; ++i) {
            expressions[i] = EventTypeUtility.resolveTypeCodegen((EventType)superTypes[i], (CodegenExpression)initSvcRef);
        }
        return CodegenExpressionBuilder.newArrayWithInit((EPTypeClass)EventType.EPTYPE, (CodegenExpression[])expressions);
    }

    private static CodegenMethod makePropsCodegen(Map<String, Object> types, CodegenMethodScope parent, ModuleEventTypeInitializeSymbol symbols, CodegenClassScope classScope, Supplier<Iterator<EventType>> deepSuperTypes) {
        Collection<Map.Entry<String, Object>> entries;
        Iterator deepTypesIterator;
        CodegenMethod method = parent.makeChild(EPTypePremade.LINKEDHASHMAP.getEPType(), CompilerHelperModuleProvider.class, (CodegenScope)classScope);
        symbols.getAddInitSvc((CodegenMethodScope)method);
        method.getBlock().declareVar(EPTypePremade.LINKEDHASHMAP.getEPType(), "props", CodegenExpressionBuilder.newInstance((EPTypeClass)EPTypePremade.LINKEDHASHMAP.getEPType(), (CodegenExpression[])new CodegenExpression[0]));
        Iterator<Object> iterator = deepTypesIterator = deepSuperTypes == null ? Collections.emptyIterator() : deepSuperTypes.get();
        if (!deepTypesIterator.hasNext()) {
            entries = types.entrySet();
        } else {
            entries = new ArrayList();
            for (Map.Entry<String, Object> entry2 : types.entrySet()) {
                boolean propertyOfSupertype = CompilerHelperModuleProvider.isPropertyOfSupertype(deepSuperTypes, entry2.getKey());
                if (propertyOfSupertype) continue;
                entries.add(entry2);
            }
        }
        CodegenRepetitiveValueBuilder.ConsumerByValue consumer = (entry, index, leafMethod) -> {
            Object type = entry.getValue();
            CodegenExpression typeResolver = CompilerHelperModuleProvider.makeTypeResolver(type, (CodegenMethodScope)leafMethod, symbols, classScope);
            leafMethod.getBlock().exprDotMethod((CodegenExpression)CodegenExpressionBuilder.ref((String)"props"), "put", new CodegenExpression[]{CodegenExpressionBuilder.constant(entry.getKey()), typeResolver});
        };
        new CodegenRepetitiveValueBuilder(entries, method, classScope, CompilerHelperModuleProvider.class).addParam(EPTypePremade.LINKEDHASHMAP.getEPType(), "props").setConsumer(consumer).build();
        method.getBlock().methodReturn((CodegenExpression)CodegenExpressionBuilder.ref((String)"props"));
        return method;
    }

    private static CodegenExpression makeTypeResolver(Object type, CodegenMethodScope parent, ModuleEventTypeInitializeSymbol symbols, CodegenClassScope classScope) {
        if (type instanceof EPType) {
            EPType eptype = (EPType)type;
            return CodegenExpressionEPType.toExpression((EPType)eptype);
        }
        if (type instanceof EventType) {
            EventType innerType = (EventType)type;
            return EventTypeUtility.resolveTypeCodegen((EventType)innerType, (CodegenExpression)ModuleEventTypeInitializeSymbol.REF_INITSVC);
        }
        if (type instanceof EventType[]) {
            EventType[] innerType = (EventType[])type;
            CodegenExpression typeExpr = EventTypeUtility.resolveTypeCodegen((EventType)innerType[0], (CodegenExpression)ModuleEventTypeInitializeSymbol.REF_INITSVC);
            return CodegenExpressionBuilder.newArrayWithInit((EPTypeClass)EventType.EPTYPE, (CodegenExpression[])new CodegenExpression[]{typeExpr});
        }
        if (type == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        if (type instanceof TypeBeanOrUnderlying) {
            EventType innerType = ((TypeBeanOrUnderlying)type).getEventType();
            CodegenExpression innerTypeExpr = EventTypeUtility.resolveTypeCodegen((EventType)innerType, (CodegenExpression)ModuleEventTypeInitializeSymbol.REF_INITSVC);
            return CodegenExpressionBuilder.newInstance((EPTypeClass)TypeBeanOrUnderlying.EPTYPE, (CodegenExpression[])new CodegenExpression[]{innerTypeExpr});
        }
        if (type instanceof TypeBeanOrUnderlying[]) {
            EventType innerType = ((TypeBeanOrUnderlying[])type)[0].getEventType();
            CodegenExpression innerTypeExpr = EventTypeUtility.resolveTypeCodegen((EventType)innerType, (CodegenExpression)ModuleEventTypeInitializeSymbol.REF_INITSVC);
            return CodegenExpressionBuilder.newArrayWithInit((EPTypeClass)TypeBeanOrUnderlying.EPTYPE, (CodegenExpression[])new CodegenExpression[]{CodegenExpressionBuilder.newInstance((EPTypeClass)TypeBeanOrUnderlying.EPTYPE, (CodegenExpression[])new CodegenExpression[]{innerTypeExpr})});
        }
        if (type instanceof Map) {
            return CodegenExpressionBuilder.localMethod((CodegenMethod)CompilerHelperModuleProvider.makePropsCodegen((Map)type, parent, symbols, classScope, null), (CodegenExpression[])new CodegenExpression[0]);
        }
        throw new IllegalStateException("Unrecognized type '" + type + "'");
    }

    private static boolean isPropertyOfSupertype(Supplier<Iterator<EventType>> deepSuperTypes, String key) {
        if (deepSuperTypes == null) {
            return false;
        }
        Iterator<EventType> deepSuperTypesIterator = deepSuperTypes.get();
        while (deepSuperTypesIterator.hasNext()) {
            EventType type = deepSuperTypesIterator.next();
            if (!type.isProperty(key)) continue;
            return true;
        }
        return false;
    }

    private static EPCompilerPathableImpl toPathable(String moduleName, ModuleCompileTimeServices svc, String pathDeployId) throws PathException {
        EPCompilerPathableImpl pathable = new EPCompilerPathableImpl(moduleName);
        for (EventType eventType : svc.getEventTypeCompileTimeRegistry().getNewTypesAdded()) {
            if (!eventType.getMetadata().getAccessModifier().isNonPrivateNonTransient()) continue;
            pathable.getEventTypePathRegistry().add((Object)eventType.getName(), moduleName, (Object)eventType, pathDeployId);
        }
        for (Map.Entry entry : svc.getVariableCompileTimeRegistry().getVariables().entrySet()) {
            if (!((VariableMetaData)entry.getValue()).getVariableVisibility().isNonPrivateNonTransient()) continue;
            pathable.getVariablePathRegistry().add((Object)((String)entry.getKey()), moduleName, (Object)((VariableMetaData)entry.getValue()), pathDeployId);
        }
        for (Map.Entry entry : svc.getExprDeclaredCompileTimeRegistry().getExpressions().entrySet()) {
            if (!((ExpressionDeclItem)entry.getValue()).getVisibility().isNonPrivateNonTransient()) continue;
            pathable.getExprDeclaredPathRegistry().add((Object)((String)entry.getKey()), moduleName, (Object)((ExpressionDeclItem)entry.getValue()), pathDeployId);
        }
        for (Map.Entry entry : svc.getScriptCompileTimeRegistry().getScripts().entrySet()) {
            if (!((ExpressionScriptProvided)entry.getValue()).getVisibility().isNonPrivateNonTransient()) continue;
            pathable.getScriptPathRegistry().add((Object)((NameAndParamNum)entry.getKey()), moduleName, (Object)((ExpressionScriptProvided)entry.getValue()), pathDeployId);
        }
        for (Map.Entry entry : svc.getClassProvidedCompileTimeRegistry().getClasses().entrySet()) {
            if (!((ClassProvided)entry.getValue()).getVisibility().isNonPrivateNonTransient()) continue;
            pathable.getClassProvidedPathRegistry().add((Object)((String)entry.getKey()), moduleName, (Object)((ClassProvided)entry.getValue()), pathDeployId);
        }
        for (Map.Entry entry : svc.getNamedWindowCompileTimeRegistry().getNamedWindows().entrySet()) {
            if (!((NamedWindowMetaData)entry.getValue()).getEventType().getMetadata().getAccessModifier().isNonPrivateNonTransient()) continue;
            pathable.getNamedWindowPathRegistry().add((Object)((String)entry.getKey()), moduleName, (Object)((NamedWindowMetaData)entry.getValue()), pathDeployId);
        }
        for (Map.Entry entry : svc.getTableCompileTimeRegistry().getTables().entrySet()) {
            if (!((TableMetaData)entry.getValue()).getTableVisibility().isNonPrivateNonTransient()) continue;
            pathable.getTablePathRegistry().add((Object)((String)entry.getKey()), moduleName, (Object)((TableMetaData)entry.getValue()), pathDeployId);
        }
        for (Map.Entry entry : svc.getContextCompileTimeRegistry().getContexts().entrySet()) {
            if (!((ContextMetaData)entry.getValue()).getContextVisibility().isNonPrivateNonTransient()) continue;
            pathable.getContextPathRegistry().add((Object)((String)entry.getKey()), moduleName, (Object)((ContextMetaData)entry.getValue()), pathDeployId);
        }
        return pathable;
    }
}

