/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.util;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenInnerClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenMethodWGraph;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class CompilerHelperRefactorToStaticMethods {
    public static final int MAX_METHODS_PER_CLASS_MINIMUM = 100;

    public static void refactorMethods(List<CodegenClass> classes, int maxMethodsPerClass) {
        for (CodegenClass clazz : classes) {
            CompilerHelperRefactorToStaticMethods.refactorMethodsClass(clazz, maxMethodsPerClass);
        }
    }

    private static void refactorMethodsClass(CodegenClass clazz, int maxMethodsPerClass) {
        CodegenInnerClass[] inners;
        for (CodegenInnerClass inner : inners = clazz.getInnerClasses().toArray(new CodegenInnerClass[0])) {
            CompilerHelperRefactorToStaticMethods.refactorMethodsInnerClass(clazz, inner, maxMethodsPerClass);
        }
    }

    private static void refactorMethodsInnerClass(CodegenClass clazz, CodegenInnerClass inner, int maxMethodsPerClass) {
        if (maxMethodsPerClass < 100) {
            throw new EPException("Invalid value for maximum number of methods per class, expected a minimum of 100 but received " + maxMethodsPerClass);
        }
        int size = inner.getMethods().size();
        if (size <= maxMethodsPerClass) {
            return;
        }
        HashSet<CodegenMethodWGraph> collectedStaticMethods = new HashSet<CodegenMethodWGraph>();
        Function<CodegenMethod, Boolean> permittedMethods = method -> collectedStaticMethods.contains(method.getAssignedMethod());
        for (CodegenMethodWGraph publicMethod : inner.getMethods().getPublicMethods()) {
            CompilerHelperRefactorToStaticMethods.recursiveBottomUpCollectStatic(publicMethod.getOriginator(), collectedStaticMethods, permittedMethods);
        }
        ArrayList<CodegenMethodWGraph> staticMethods = new ArrayList<CodegenMethodWGraph>();
        int count = -1;
        for (CodegenMethodWGraph privateMethod : inner.getMethods().getPrivateMethods()) {
            if (++count < maxMethodsPerClass || !collectedStaticMethods.contains(privateMethod)) continue;
            staticMethods.add(privateMethod);
        }
        if (staticMethods.isEmpty()) {
            return;
        }
        List statics = CollectionUtil.subdivide(staticMethods, (int)maxMethodsPerClass);
        for (int i = 0; i < statics.size(); ++i) {
            List bucket = (List)statics.get(i);
            String className = inner.getClassName() + "util" + i;
            CodegenClassMethods methods = new CodegenClassMethods();
            methods.getPrivateMethods().addAll(bucket);
            for (CodegenMethodWGraph privateMethod : bucket) {
                privateMethod.setStatic(true);
            }
            CodegenInnerClass utilClass = new CodegenInnerClass(className, null, Collections.emptyList(), methods);
            clazz.addInnerClass(utilClass);
            for (CodegenMethodWGraph privateMethod : bucket) {
                privateMethod.getOriginator().setAssignedProviderClassName(className);
            }
            inner.getMethods().getPrivateMethods().removeAll(bucket);
        }
    }

    private static void recursiveBottomUpCollectStatic(CodegenMethod method, Set<CodegenMethodWGraph> collected, Function<CodegenMethod, Boolean> permittedMethods) {
        for (CodegenMethod child : method.getChildren()) {
            CompilerHelperRefactorToStaticMethods.recursiveBottomUpCollectStatic(child, collected, permittedMethods);
        }
        for (CodegenMethod child : method.getChildren()) {
            if (collected.contains(child.getAssignedMethod())) continue;
            return;
        }
        if (!method.getBlock().hasInstanceAccess(permittedMethods)) {
            collected.add(method.getAssignedMethod());
        }
    }
}

