/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.util;

import com.espertech.esper.common.client.soda.ClassProvidedExpression;
import com.espertech.esper.common.client.soda.EPStatementObjectModel;
import com.espertech.esper.common.client.soda.StreamSelector;
import com.espertech.esper.common.internal.compile.stage1.Compilable;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.common.internal.compile.stage1.spec.StatementSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.specmapper.StatementSpecMapEnv;
import com.espertech.esper.common.internal.compile.stage1.specmapper.StatementSpecMapper;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompileException;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.classprovided.compiletime.ClassProvidedPrecompileResult;
import com.espertech.esper.common.internal.epl.classprovided.compiletime.ClassProvidedPrecompileUtil;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.util.ValidationException;
import com.espertech.esper.compiler.client.option.InlinedClassInspectionContext;
import com.espertech.esper.compiler.client.option.InlinedClassInspectionOption;
import com.espertech.esper.compiler.internal.generated.EsperEPL2GrammarParser;
import com.espertech.esper.compiler.internal.parse.ASTUtil;
import com.espertech.esper.compiler.internal.parse.ASTWalkException;
import com.espertech.esper.compiler.internal.parse.EPLTreeWalkerListener;
import com.espertech.esper.compiler.internal.parse.ParseHelper;
import com.espertech.esper.compiler.internal.parse.ParseResult;
import com.espertech.esper.compiler.internal.parse.ParseRuleSelector;
import com.espertech.esper.compiler.internal.util.CompilableEPL;
import com.espertech.esper.compiler.internal.util.CompilableSODA;
import com.espertech.esper.compiler.internal.util.CompilerHelperSingleResult;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.tree.Tree;
import org.codehaus.janino.util.ClassFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompilerHelperSingleEPL {
    private static final ParseRuleSelector EPL_PARSE_RULE;
    private static final Logger log;

    protected static CompilerHelperSingleResult parseCompileInlinedClassesWalk(Compilable compilable, InlinedClassInspectionOption inlinedClassConsumer, StatementCompileTimeServices compileTimeServices) throws StatementSpecCompileException {
        CompilerHelperSingleResult result;
        block10: {
            try {
                if (compilable instanceof CompilableEPL) {
                    CompilableEPL compilableEPL = (CompilableEPL)compilable;
                    ParseResult parseResult = CompilerHelperSingleEPL.parse(compilableEPL.getEpl());
                    ClassProvidedPrecompileResult classesInlined = CompilerHelperSingleEPL.compileAddExtensions(parseResult.getClasses(), compilable, inlinedClassConsumer, compileTimeServices);
                    StatementSpecRaw raw = CompilerHelperSingleEPL.walk(parseResult, compilableEPL.getEpl(), compileTimeServices.getStatementSpecMapEnv());
                    result = new CompilerHelperSingleResult(raw, classesInlined);
                    break block10;
                }
                if (compilable instanceof CompilableSODA) {
                    ClassProvidedPrecompileResult classesInlined;
                    EPStatementObjectModel soda = ((CompilableSODA)compilable).getSoda();
                    if (soda.getClassProvidedExpressions() != null && !soda.getClassProvidedExpressions().isEmpty() || soda.getCreateClass() != null) {
                        ArrayList<String> classTexts = new ArrayList<String>();
                        if (soda.getClassProvidedExpressions() != null) {
                            for (ClassProvidedExpression inlined : soda.getClassProvidedExpressions()) {
                                classTexts.add(inlined.getClassText());
                            }
                        }
                        if (soda.getCreateClass() != null) {
                            classTexts.add(soda.getCreateClass().getClassProvidedExpression().getClassText());
                        }
                        classesInlined = CompilerHelperSingleEPL.compileAddExtensions(classTexts, compilable, inlinedClassConsumer, compileTimeServices);
                    } else {
                        classesInlined = ClassProvidedPrecompileResult.EMPTY;
                    }
                    StatementSpecRaw raw = StatementSpecMapper.map((EPStatementObjectModel)soda, (StatementSpecMapEnv)compileTimeServices.getStatementSpecMapEnv());
                    result = new CompilerHelperSingleResult(raw, classesInlined);
                    break block10;
                }
                throw new IllegalStateException("Unrecognized compilable " + compilable);
            }
            catch (StatementSpecCompileException ex) {
                throw ex;
            }
            catch (Throwable t) {
                throw new StatementSpecCompileException("Exception processing statement: " + t.getMessage(), t, compilable.toEPL());
            }
        }
        return result;
    }

    public static StatementSpecRaw parseWalk(String epl, StatementSpecMapEnv mapEnv) throws StatementSpecCompileException {
        ParseResult parseResult = CompilerHelperSingleEPL.parse(epl);
        return CompilerHelperSingleEPL.walk(parseResult, epl, mapEnv);
    }

    private static ClassProvidedPrecompileResult compileAddExtensions(List<String> classes, Compilable compilable, InlinedClassInspectionOption option, StatementCompileTimeServices compileTimeServices) throws StatementSpecCompileException {
        ClassProvidedPrecompileResult classesInlined;
        Consumer<Object> classFileConsumer = null;
        if (option != null) {
            classFileConsumer = compilerResult -> {
                ClassFile[] files = ((List)compilerResult).toArray(new ClassFile[0]);
                option.visit(new InlinedClassInspectionContext(files));
            };
        }
        try {
            classesInlined = ClassProvidedPrecompileUtil.compileClassProvided(classes, classFileConsumer, (StatementCompileTimeServices)compileTimeServices, null);
            compileTimeServices.getClassProvidedClasspathExtension().add(classesInlined.getClasses(), classesInlined.getBytes());
        }
        catch (ExprValidationException ex) {
            throw new StatementSpecCompileException(ex.getMessage(), (Throwable)ex, compilable.toEPL());
        }
        return classesInlined;
    }

    private static StatementSpecRaw walk(ParseResult parseResult, String epl, StatementSpecMapEnv mapEnv) throws StatementSpecCompileException {
        Tree ast = parseResult.getTree();
        SelectClauseStreamSelectorEnum defaultStreamSelector = StatementSpecMapper.mapFromSODA((StreamSelector)mapEnv.getConfiguration().getCompiler().getStreamSelection().getDefaultStreamSelector());
        EPLTreeWalkerListener walker = new EPLTreeWalkerListener(parseResult.getTokenStream(), defaultStreamSelector, parseResult.getScripts(), parseResult.getClasses(), mapEnv);
        try {
            ParseHelper.walk(ast, walker, epl, epl);
        }
        catch (ValidationException | ASTWalkException ex) {
            throw new StatementSpecCompileException(ex.getMessage(), ex, epl);
        }
        catch (RuntimeException ex) {
            String message = "Invalid expression encountered";
            throw new StatementSpecCompileException(CompilerHelperSingleEPL.getNullableErrortext(message, ex.getMessage()), (Throwable)ex, epl);
        }
        if (log.isDebugEnabled()) {
            ASTUtil.dumpAST(ast);
        }
        return walker.getStatementSpec();
    }

    private static ParseResult parse(String epl) throws StatementSpecCompileException {
        return ParseHelper.parse(epl, epl, true, EPL_PARSE_RULE, true);
    }

    private static String getNullableErrortext(String msg, String cause) {
        if (cause == null) {
            return msg;
        }
        return cause;
    }

    static {
        log = LoggerFactory.getLogger(CompilerHelperSingleEPL.class);
        EPL_PARSE_RULE = new ParseRuleSelector(){

            @Override
            public Tree invokeParseRule(EsperEPL2GrammarParser parser) throws RecognitionException {
                return parser.startEPLExpressionRule();
            }
        };
    }
}

