/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.util;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.annotation.HookType;
import com.espertech.esper.common.client.annotation.Name;
import com.espertech.esper.common.client.util.StatementType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationIDGenerator;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.bytecodemodel.util.IdentifierUtil;
import com.espertech.esper.common.internal.compile.stage1.Compilable;
import com.espertech.esper.common.internal.compile.stage1.spec.ExpressionDeclDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.FilterSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.FilterStreamSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.common.internal.compile.stage1.spec.StatementSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecOptions;
import com.espertech.esper.common.internal.compile.stage1.spec.ViewSpec;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecTracked;
import com.espertech.esper.common.internal.compile.stage2.StatementCompileHook;
import com.espertech.esper.common.internal.compile.stage2.StatementRawCompiler;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompileException;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompiledDesc;
import com.espertech.esper.common.internal.compile.stage3.ModuleCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StatementBaseInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StatementTypeUtil;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableType;
import com.espertech.esper.common.internal.compile.stage3.StmtForgeMethodResult;
import com.espertech.esper.common.internal.context.aifactory.createclass.StmtForgeMethodCreateClass;
import com.espertech.esper.common.internal.context.aifactory.createcontext.StmtForgeMethodCreateContext;
import com.espertech.esper.common.internal.context.aifactory.createdataflow.StmtForgeMethodCreateDataflow;
import com.espertech.esper.common.internal.context.aifactory.createexpression.StmtForgeMethodCreateExpression;
import com.espertech.esper.common.internal.context.aifactory.createindex.StmtForgeMethodCreateIndex;
import com.espertech.esper.common.internal.context.aifactory.createschema.StmtForgeMethodCreateSchema;
import com.espertech.esper.common.internal.context.aifactory.createtable.StmtForgeMethodCreateTable;
import com.espertech.esper.common.internal.context.aifactory.createvariable.StmtForgeMethodCreateVariable;
import com.espertech.esper.common.internal.context.aifactory.createwindow.StmtForgeMethodCreateWindow;
import com.espertech.esper.common.internal.context.aifactory.ontrigger.core.StmtForgeMethodOnTrigger;
import com.espertech.esper.common.internal.context.aifactory.select.StmtForgeMethodSelect;
import com.espertech.esper.common.internal.context.aifactory.update.StmtForgeMethodUpdate;
import com.espertech.esper.common.internal.context.compile.ContextCompileTimeDescriptor;
import com.espertech.esper.common.internal.context.compile.ContextMetaData;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerPortableInfo;
import com.espertech.esper.common.internal.context.module.StatementProvider;
import com.espertech.esper.common.internal.context.util.ContextPropertyRegistry;
import com.espertech.esper.common.internal.epl.annotation.AnnotationUtil;
import com.espertech.esper.common.internal.epl.classprovided.compiletime.ClassProvidedPrecompileResult;
import com.espertech.esper.common.internal.epl.expression.chain.Chainable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredNode;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprAndNodeImpl;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectRowNode;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeSubselectDeclaredDotVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeTableAccessVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitor;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowCompileTimeResolver;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowMetaData;
import com.espertech.esper.common.internal.epl.script.core.ScriptValidationPrecompileUtil;
import com.espertech.esper.common.internal.epl.util.StatementSpecRawWalkerSubselectAndDeclaredDot;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.fabric.FabricCharge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamExprNodeForge;
import com.espertech.esper.common.internal.schedule.ScheduleHandleTracked;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceCompileTime;
import com.espertech.esper.common.internal.settings.ClasspathImportUtil;
import com.espertech.esper.compiler.client.CompilerOptions;
import com.espertech.esper.compiler.client.option.StatementNameContext;
import com.espertech.esper.compiler.client.option.StatementUserObjectContext;
import com.espertech.esper.compiler.internal.util.CompilableItem;
import com.espertech.esper.compiler.internal.util.CompilableItemPostCompileLatch;
import com.espertech.esper.compiler.internal.util.CompilableItemPostCompileLatchDefault;
import com.espertech.esper.compiler.internal.util.CompilableItemPostCompileLatchJson;
import com.espertech.esper.compiler.internal.util.CompilerHelperRefactorToStaticMethods;
import com.espertech.esper.compiler.internal.util.CompilerHelperSingleEPL;
import com.espertech.esper.compiler.internal.util.CompilerHelperSingleResult;
import com.espertech.esper.compiler.internal.util.CompilerHelperValidator;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CompilerHelperStatementProvider {
    static CompilableItem compileItem(Compilable compilable, String optionalModuleName, String moduleIdentPostfix, int statementNumber, Set<String> statementNames, ModuleCompileTimeServices moduleCompileTimeServices, CompilerOptions compilerOptions) throws StatementSpecCompileException {
        StatementCompileTimeServices compileTimeServices = new StatementCompileTimeServices(statementNumber, moduleCompileTimeServices);
        FabricCharge fabricCharge = compileTimeServices.getStateMgmtSettingsProvider().newCharge();
        CompilerHelperSingleResult walked = CompilerHelperSingleEPL.parseCompileInlinedClassesWalk(compilable, compilerOptions.getInlinedClassInspection(), compileTimeServices);
        StatementSpecRaw raw = walked.getStatementSpecRaw();
        String classNameCreateClass = null;
        if (raw.getCreateClassProvided() != null) {
            classNameCreateClass = CompilerHelperStatementProvider.determineClassNameCreateClass(walked.getClassesInlined());
        } else {
            compileTimeServices.getStateMgmtSettingsProvider().inlinedClassesLocal(fabricCharge, walked.getClassesInlined());
        }
        try {
            Object statementName;
            String assignedName;
            ExprNodeSubselectDeclaredDotVisitor visitor;
            Annotation[] annotations = AnnotationUtil.compileAnnotations((List)raw.getAnnotations(), (ClasspathImportServiceCompileTime)compileTimeServices.getClasspathImportServiceCompileTime(), (Compilable)compilable);
            try {
                visitor = StatementSpecRawWalkerSubselectAndDeclaredDot.walkSubselectAndDeclaredDotExpr((StatementSpecRaw)raw);
            }
            catch (ExprValidationException ex) {
                throw new StatementSpecCompileException(ex.getMessage(), compilable.toEPL());
            }
            List subselectNodes = visitor.getSubselects();
            String statementNameProvided = CompilerHelperStatementProvider.getNameFromAnnotation(annotations);
            if (compilerOptions.getStatementName() != null && (assignedName = compilerOptions.getStatementName().getValue(new StatementNameContext(() -> compilable.toEPL(), statementNameProvided, optionalModuleName, annotations, statementNumber))) != null) {
                statementNameProvided = assignedName;
            }
            Object object = statementName = statementNameProvided == null ? "stmt-" + statementNumber : statementNameProvided;
            if (statementNames.contains(statementName)) {
                int count = 1;
                String newStatementName = (String)statementName + "-" + count;
                while (statementNames.contains(newStatementName)) {
                    newStatementName = (String)statementName + "-" + ++count;
                }
                statementName = newStatementName;
            }
            statementName = ((String)statementName).trim();
            statementNames.add((String)statementName);
            List<ExprTableAccessNode> tableAccessNodes = CompilerHelperStatementProvider.determineTableAccessNodes(raw.getTableExpressions(), visitor);
            ScriptValidationPrecompileUtil.validateScripts((List)raw.getScriptExpressions(), (ExpressionDeclDesc)raw.getExpressionDeclDesc(), (StatementCompileTimeServices)compileTimeServices);
            if (!visitor.getChainedExpressionsDot().isEmpty()) {
                CompilerHelperStatementProvider.rewriteNamedWindowSubselect(visitor.getChainedExpressionsDot(), subselectNodes, compileTimeServices.getNamedWindowCompileTimeResolver());
            }
            ContextCompileTimeDescriptor contextDescriptor = null;
            String optionalContextName = raw.getOptionalContextName();
            if (optionalContextName != null) {
                ContextMetaData detail = compileTimeServices.getContextCompileTimeResolver().getContextInfo(optionalContextName);
                if (detail == null) {
                    throw new StatementSpecCompileException("Context by name '" + optionalContextName + "' could not be found", compilable.toEPL());
                }
                contextDescriptor = new ContextCompileTimeDescriptor(optionalContextName, detail.getContextModuleName(), detail.getContextVisibility(), new ContextPropertyRegistry(detail), detail.getValidationInfos());
            }
            StatementType statementType = StatementTypeUtil.getStatementType((StatementSpecRaw)raw);
            StatementRawInfo statementRawInfo = new StatementRawInfo(statementNumber, (String)statementName, annotations, statementType, contextDescriptor, raw.getIntoTableSpec() == null ? null : raw.getIntoTableSpec().getName(), compilable, optionalModuleName);
            StatementSpecCompiledDesc compiledDesc = StatementRawCompiler.compile((StatementSpecRaw)raw, (Compilable)compilable, (boolean)false, (boolean)false, (Annotation[])annotations, (List)subselectNodes, tableAccessNodes, (StatementRawInfo)statementRawInfo, (StatementCompileTimeServices)compileTimeServices);
            StatementSpecCompiled specCompiled = compiledDesc.getCompiled();
            String statementIdentPostfix = IdentifierUtil.getIdentifierMayStartNumeric((String)statementName);
            Serializable userObjectCompileTime = null;
            if (compilerOptions.getStatementUserObject() != null) {
                userObjectCompileTime = compilerOptions.getStatementUserObject().getValue(new StatementUserObjectContext(() -> compilable.toEPL(), (String)statementName, optionalModuleName, annotations, statementNumber));
            }
            CompilerHelperStatementProvider.handleStatementCompileHook(annotations, compileTimeServices, specCompiled);
            StatementBaseInfo base = new StatementBaseInfo(compilable, specCompiled, userObjectCompileTime, statementRawInfo, optionalModuleName);
            Object forgeMethod = raw.getUpdateDesc() != null ? new StmtForgeMethodUpdate(base) : (raw.getOnTriggerDesc() != null ? new StmtForgeMethodOnTrigger(base) : (raw.getCreateIndexDesc() != null ? new StmtForgeMethodCreateIndex(base) : (raw.getCreateVariableDesc() != null ? new StmtForgeMethodCreateVariable(base) : (raw.getCreateDataFlowDesc() != null ? new StmtForgeMethodCreateDataflow(base) : (raw.getCreateTableDesc() != null ? new StmtForgeMethodCreateTable(base) : (raw.getCreateExpressionDesc() != null ? new StmtForgeMethodCreateExpression(base) : (raw.getCreateClassProvided() != null ? new StmtForgeMethodCreateClass(base, walked.getClassesInlined(), classNameCreateClass) : (raw.getCreateWindowDesc() != null ? new StmtForgeMethodCreateWindow(base) : (raw.getCreateContextDesc() != null ? new StmtForgeMethodCreateContext(base) : (raw.getCreateSchemaDesc() != null ? new StmtForgeMethodCreateSchema(base) : new StmtForgeMethodSelect(base)))))))))));
            if (contextDescriptor != null) {
                try {
                    for (ContextControllerPortableInfo validator : contextDescriptor.getValidationInfos()) {
                        validator.validateStatement(contextDescriptor.getContextName(), specCompiled, compileTimeServices);
                    }
                }
                catch (ExprValidationException ex) {
                    throw new StatementSpecCompileException(ex.getMessage(), (Throwable)ex, compilable.toEPL());
                }
            }
            String classPostfix = moduleIdentPostfix + "_" + statementIdentPostfix;
            ArrayList<StmtClassForgeable> forgeables = new ArrayList<StmtClassForgeable>();
            for (StmtClassForgeableFactory additional : compiledDesc.getAdditionalForgeables()) {
                CodegenPackageScope packageScope = new CodegenPackageScope(compileTimeServices.getPackageName(), null, false, compileTimeServices.getConfiguration().getCompiler().getByteCode());
                forgeables.add(additional.make(packageScope, classPostfix));
            }
            ArrayList filterSpecCompileds = new ArrayList();
            ArrayList scheduleHandleCallbackProviders = new ArrayList();
            ArrayList namedWindowConsumers = new ArrayList();
            ArrayList filterBooleanExpressions = new ArrayList();
            StmtForgeMethodResult result = forgeMethod.make(compileTimeServices.getPackageName(), classPostfix, compileTimeServices);
            forgeables.addAll(result.getForgeables());
            fabricCharge.add(result.getFabricCharge());
            CompilerHelperStatementProvider.verifyForgeables(forgeables);
            filterSpecCompileds.addAll(result.getFiltereds());
            scheduleHandleCallbackProviders.addAll(result.getScheduleds());
            namedWindowConsumers.addAll(result.getNamedWindowConsumers());
            filterBooleanExpressions.addAll(result.getFilterBooleanExpressions());
            int filterId = -1;
            for (Object provider : filterSpecCompileds) {
                int assigned = ++filterId;
                provider.getFilterSpecCompiled().setFilterCallbackId(assigned);
            }
            int scheduleId = 0;
            for (ScheduleHandleTracked provider : scheduleHandleCallbackProviders) {
                provider.getProvider().setScheduleCallbackId(scheduleId++);
            }
            compileTimeServices.getStateMgmtSettingsProvider().schedules(fabricCharge, scheduleHandleCallbackProviders);
            int namedWindowConsumerId = 0;
            for (Object provider : namedWindowConsumers) {
                provider.setNamedWindowConsumerId(namedWindowConsumerId++);
            }
            int filterBooleanExprNum = 0;
            for (FilterSpecParamExprNodeForge expr : filterBooleanExpressions) {
                expr.setFilterBoolExprId(filterBooleanExprNum++);
            }
            CompilerHelperValidator.verifySubstitutionParams(raw.getSubstitutionParameters());
            for (Object provider : filterSpecCompileds) {
                compileTimeServices.getStateMgmtSettingsProvider().filterNonContext(fabricCharge, (FilterSpecTracked)provider);
            }
            if (contextDescriptor != null) {
                compileTimeServices.getStateMgmtSettingsProvider().filterSubtypes(fabricCharge, filterSpecCompileds, contextDescriptor, compiledDesc.getCompiled());
            }
            ArrayList<CodegenClass> classes = new ArrayList<CodegenClass>(forgeables.size());
            for (StmtClassForgeable stmtClassForgeable : forgeables) {
                CodegenClass clazz = stmtClassForgeable.forge(true, false);
                if (clazz == null) continue;
                classes.add(clazz);
            }
            result.getPackageScope().rewriteStatementFieldUse(classes);
            CompilerHelperRefactorToStaticMethods.refactorMethods(classes, compileTimeServices.getConfiguration().getCompiler().getByteCode().getMaxMethodsPerClass());
            classes.sort((o1, o2) -> Integer.compare(o1.getClassType().getSortCode(), o2.getClassType().getSortCode()));
            CompilableItemPostCompileLatch postCompile = CompilableItemPostCompileLatchDefault.INSTANCE;
            for (EventType eventType : compileTimeServices.getEventTypeCompileTimeRegistry().getNewTypesAdded()) {
                if (!(eventType instanceof JsonEventType)) continue;
                postCompile = new CompilableItemPostCompileLatchJson(compileTimeServices.getEventTypeCompileTimeRegistry().getNewTypesAdded(), compileTimeServices.getParentClassLoader());
                break;
            }
            String string = CodeGenerationIDGenerator.generateClassNameWithPackage((String)compileTimeServices.getPackageName(), StatementProvider.class, (String)classPostfix);
            HashMap<String, byte[]> additionalClasses = new HashMap<String, byte[]>(walked.getClassesInlined().getBytes());
            compileTimeServices.getClassProvidedCompileTimeResolver().addTo(additionalClasses);
            compileTimeServices.getClassProvidedCompileTimeRegistry().addTo(additionalClasses);
            return new CompilableItem(string, classes, postCompile, additionalClasses, contextDescriptor, fabricCharge);
        }
        catch (StatementSpecCompileException ex) {
            throw ex;
        }
        catch (ExprValidationException ex) {
            throw new StatementSpecCompileException(ex.getMessage(), (Throwable)ex, compilable.toEPL());
        }
        catch (EPException ex) {
            throw new StatementSpecCompileException(ex.getMessage(), (Throwable)ex, compilable.toEPL());
        }
        catch (Throwable t) {
            String text = t.getMessage() == null ? t.getClass().getSimpleName() : t.getMessage();
            throw new StatementSpecCompileException(text, t, compilable.toEPL());
        }
    }

    private static String determineClassNameCreateClass(ClassProvidedPrecompileResult classesInlined) {
        for (int i = classesInlined.getClasses().size() - 1; i >= 0; --i) {
            Class clazz = (Class)classesInlined.getClasses().get(i);
            if (clazz.getName().contains("$")) continue;
            return clazz.getName();
        }
        throw new IllegalStateException("Could not determine class name, entries are: " + classesInlined.getBytes().keySet());
    }

    private static void verifyForgeables(List<StmtClassForgeable> forgeables) {
        HashSet<String> names = new HashSet<String>();
        for (StmtClassForgeable forgeable : forgeables) {
            if (names.contains(forgeable.getClassName())) {
                throw new IllegalStateException("Class name '" + forgeable.getClassName() + "' appears twice");
            }
            names.add(forgeable.getClassName());
        }
        StmtClassForgeable stmtProvider = null;
        for (StmtClassForgeable forgeable : forgeables) {
            if (forgeable.getForgeableType() != StmtClassForgeableType.STMTPROVIDER) continue;
            if (stmtProvider != null) {
                throw new IllegalStateException("Multiple stmt-provider classes");
            }
            stmtProvider = forgeable;
        }
    }

    private static void handleStatementCompileHook(Annotation[] annotations, StatementCompileTimeServices compileTimeServices, StatementSpecCompiled specCompiled) {
        StatementCompileHook compileHook = null;
        try {
            compileHook = (StatementCompileHook)ClasspathImportUtil.getAnnotationHook((Annotation[])annotations, (HookType)HookType.INTERNAL_COMPILE, StatementCompileHook.class, (ClasspathImportService)compileTimeServices.getClasspathImportServiceCompileTime());
        }
        catch (ExprValidationException e) {
            throw new EPException("Failed to obtain hook for " + HookType.INTERNAL_QUERY_PLAN);
        }
        if (compileHook != null) {
            compileHook.compiled(specCompiled);
        }
    }

    protected static String getNameFromAnnotation(Annotation[] annotations) {
        if (annotations != null && annotations.length != 0) {
            for (Annotation annotation : annotations) {
                Name name;
                if (!(annotation instanceof Name) || (name = (Name)annotation).value() == null) continue;
                return name.value();
            }
        }
        return null;
    }

    private static void rewriteNamedWindowSubselect(List<ExprDotNode> chainedExpressionsDot, List<ExprSubselectNode> subselects, NamedWindowCompileTimeResolver service) {
        for (ExprDotNode dotNode : chainedExpressionsDot) {
            String proposedWindow;
            NamedWindowMetaData namedWindowDetail;
            if (dotNode.getChainSpec().isEmpty() || (namedWindowDetail = service.resolve(proposedWindow = ((Chainable)dotNode.getChainSpec().get(0)).getRootNameOrEmptyString())) == null) continue;
            StatementSpecRaw raw = new StatementSpecRaw(SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
            FilterSpecRaw filter = new FilterSpecRaw(proposedWindow, Collections.emptyList(), null);
            raw.getStreamSpecs().add(new FilterStreamSpecRaw(filter, ViewSpec.EMPTY_VIEWSPEC_ARRAY, proposedWindow, StreamSpecOptions.DEFAULT));
            ArrayList modified = new ArrayList(dotNode.getChainSpec());
            Chainable firstChain = (Chainable)modified.remove(0);
            List firstChainParams = firstChain.getParametersOrEmpty();
            if (!firstChainParams.isEmpty()) {
                if (firstChainParams.size() == 1) {
                    raw.setWhereClause((ExprNode)firstChainParams.get(0));
                } else {
                    ExprAndNodeImpl andNode = new ExprAndNodeImpl();
                    for (ExprNode node : firstChainParams) {
                        andNode.addChildNode(node);
                    }
                    raw.setWhereClause((ExprNode)andNode);
                }
            }
            ExprSubselectRowNode subselect = new ExprSubselectRowNode(raw);
            subselects.add((ExprSubselectNode)subselect);
            dotNode.setChildNodes(new ExprNode[]{subselect});
            dotNode.setChainSpec(modified);
        }
    }

    private static List<ExprTableAccessNode> determineTableAccessNodes(Set<ExprTableAccessNode> statementDirectTableAccess, ExprNodeSubselectDeclaredDotVisitor visitor) {
        HashSet<ExprTableAccessNode> tableAccessNodes = new HashSet<ExprTableAccessNode>();
        if (statementDirectTableAccess != null) {
            tableAccessNodes.addAll(statementDirectTableAccess);
        }
        ExprNodeTableAccessVisitor tableAccessVisitor = new ExprNodeTableAccessVisitor(tableAccessNodes);
        for (ExprDeclaredNode declared : visitor.getDeclaredExpressions()) {
            declared.getBody().accept((ExprNodeVisitor)tableAccessVisitor);
        }
        for (ExprSubselectNode subselectNode : visitor.getSubselects()) {
            tableAccessNodes.addAll(subselectNode.getStatementSpecRaw().getTableExpressions());
        }
        return new ArrayList<ExprTableAccessNode>(tableAccessNodes);
    }
}

