/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.util;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.epl.expression.core.ExprSubstitutionNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CompilerHelperValidator {
    public static void verifySubstitutionParams(List<ExprSubstitutionNode> substitutionParameters) throws ExprValidationException {
        if (substitutionParameters.isEmpty()) {
            return;
        }
        HashMap<String, EPTypeClass> named = new HashMap<String, EPTypeClass>();
        ArrayList<EPTypeClass> unnamed = new ArrayList<EPTypeClass>();
        for (ExprSubstitutionNode node : substitutionParameters) {
            if (node.getOptionalName() != null) {
                String name = node.getOptionalName();
                EPTypeClass existing = (EPTypeClass)named.get(name);
                if (existing == null) {
                    named.put(name, node.getResolvedType());
                    continue;
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface((EPType)node.getResolvedType(), (EPTypeClass)existing)) continue;
                throw new ExprValidationException("Substitution parameter '" + name + "' incompatible type assignment between types '" + existing + "' and '" + node.getResolvedType() + "'");
            }
            unnamed.add(node.getResolvedType());
        }
        if (!unnamed.isEmpty() && !named.isEmpty()) {
            throw new ExprValidationException("Inconsistent use of substitution parameters, expecting all substitutions to either all provide a name or provide no name");
        }
    }
}

