/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.util;

import com.espertech.esper.common.client.EPCompiled;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerByteCode;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstraction;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionClassCollection;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionCompilationContext;
import com.espertech.esper.common.internal.compile.stage3.ModuleCompileTimeServices;
import com.espertech.esper.compiler.client.EPCompileException;
import com.espertech.esper.compiler.internal.util.CompilableItem;
import com.espertech.esper.compiler.internal.util.CompilableItemResult;
import com.espertech.esper.compiler.internal.util.CompileCallable;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

class CompilerPool {
    private final ModuleCompileTimeServices compileTimeServices;
    private final List<EPCompiled> path;
    private final CompilerAbstraction compilerAbstraction;
    private final CompilerAbstractionClassCollection compilationState;
    private ExecutorService compilerThreadPool;
    private Future<CompilableItemResult>[] futures;
    private Semaphore semaphore;

    CompilerPool(int size, ModuleCompileTimeServices compileTimeServices, List<EPCompiled> path, CompilerAbstraction compilerAbstraction, CompilerAbstractionClassCollection compilationState) {
        this.compileTimeServices = compileTimeServices;
        this.path = path;
        this.compilerAbstraction = compilerAbstraction;
        this.compilationState = compilationState;
        ConfigurationCompilerByteCode config = compileTimeServices.getConfiguration().getCompiler().getByteCode();
        int numThreads = config.getThreadPoolCompilerNumThreads();
        if (numThreads > 0 && size > 1) {
            this.compilerThreadPool = Executors.newFixedThreadPool(numThreads);
            this.futures = new Future[size];
            Integer capacity = config.getThreadPoolCompilerCapacity();
            this.semaphore = new Semaphore(capacity == null ? Integer.MAX_VALUE : Math.max(1, capacity));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void submit(int statementNumber, CompilableItem item) throws InterruptedException {
        this.compilationState.add(item.getClassesProvided());
        if (this.compilerThreadPool == null) {
            try {
                CompilerAbstractionCompilationContext context = new CompilerAbstractionCompilationContext(this.compileTimeServices, this.path);
                this.compilerAbstraction.compileClasses(item.getClasses(), context, this.compilationState);
            }
            finally {
                item.getPostCompileLatch().completed(this.compilationState.getClasses());
            }
            return;
        }
        CompileCallable callable = new CompileCallable(item, this.compileTimeServices, this.path, this.semaphore, this.compilerAbstraction, this.compilationState);
        this.semaphore.acquire();
        this.futures[statementNumber] = this.compilerThreadPool.submit(callable);
    }

    void shutdownCollectResults() throws EPCompileException {
        if (this.compilerThreadPool == null) {
            return;
        }
        this.compilerThreadPool.shutdown();
        try {
            this.compilerThreadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        for (Future<CompilableItemResult> future : this.futures) {
            CompilableItemResult result;
            if (future == null) continue;
            try {
                result = future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new EPCompileException(e.getMessage(), e);
            }
            if (result.getException() == null) continue;
            throw new EPCompileException(result.getException().getMessage(), result.getException());
        }
    }

    void shutdownNow() {
        if (this.compilerThreadPool == null) {
            return;
        }
        this.compilerThreadPool.shutdownNow();
    }

    public void shutdown() {
        if (this.compilerThreadPool == null) {
            return;
        }
        this.compilerThreadPool.shutdown();
    }
}

