/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.util;

import com.espertech.esper.common.client.EPCompiled;
import com.espertech.esper.common.client.configuration.Configuration;
import com.espertech.esper.common.client.module.Module;
import com.espertech.esper.common.client.module.ModuleItem;
import com.espertech.esper.common.client.module.ModuleProperty;
import com.espertech.esper.common.client.module.ParseException;
import com.espertech.esper.common.client.soda.EPStatementObjectModel;
import com.espertech.esper.common.internal.compile.stage1.Compilable;
import com.espertech.esper.common.internal.compile.stage1.CompilerServices;
import com.espertech.esper.common.internal.compile.stage1.spec.StatementSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.specmapper.StatementSpecMapEnv;
import com.espertech.esper.common.internal.compile.stage1.specmapper.StatementSpecMapper;
import com.espertech.esper.common.internal.compile.stage1.specmapper.StatementSpecUnMapResult;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompileException;
import com.espertech.esper.common.internal.compile.stage3.ModuleCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.context.compile.ContextCompileTimeResolver;
import com.espertech.esper.common.internal.context.compile.ContextCompileTimeResolverEmpty;
import com.espertech.esper.common.internal.epl.classprovided.compiletime.ClassProvidedClasspathExtension;
import com.espertech.esper.common.internal.epl.classprovided.compiletime.ClassProvidedClasspathExtensionImpl;
import com.espertech.esper.common.internal.epl.classprovided.compiletime.ClassProvidedCompileTimeResolver;
import com.espertech.esper.common.internal.epl.classprovided.compiletime.ClassProvidedCompileTimeResolverEmpty;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredCompileTimeResolver;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredCompileTimeResolverEmpty;
import com.espertech.esper.common.internal.epl.script.compiletime.ScriptCompileTimeResolver;
import com.espertech.esper.common.internal.epl.script.compiletime.ScriptCompileTimeResolverEmpty;
import com.espertech.esper.common.internal.epl.table.compiletime.TableCompileTimeResolver;
import com.espertech.esper.common.internal.epl.table.compiletime.TableCompileTimeResolverEmpty;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableCompileTimeResolver;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableCompileTimeResolverEmpty;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.compiler.client.CompilerArguments;
import com.espertech.esper.compiler.client.CompilerOptions;
import com.espertech.esper.compiler.client.EPCompileException;
import com.espertech.esper.compiler.client.option.InlinedClassInspectionOption;
import com.espertech.esper.compiler.client.option.ModuleNameContext;
import com.espertech.esper.compiler.client.option.ModuleUsesContext;
import com.espertech.esper.compiler.internal.util.CompilableEPL;
import com.espertech.esper.compiler.internal.util.CompilableSODA;
import com.espertech.esper.compiler.internal.util.CompilerHelperFAFProvider;
import com.espertech.esper.compiler.internal.util.CompilerHelperModuleProvider;
import com.espertech.esper.compiler.internal.util.CompilerHelperServices;
import com.espertech.esper.compiler.internal.util.CompilerHelperSingleEPL;
import com.espertech.esper.compiler.internal.util.CompilerServicesImpl;
import com.espertech.esper.compiler.internal.util.EPCompilerSPI;
import com.espertech.esper.compiler.internal.util.EPCompilerSPIExpression;
import com.espertech.esper.compiler.internal.util.EPCompilerSPIExpressionImpl;
import com.espertech.esper.compiler.internal.util.EPLModuleUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPCompilerImpl
implements EPCompilerSPI {
    private static final Logger log = LoggerFactory.getLogger(EPCompilerImpl.class);

    @Override
    public EPCompiled compileQuery(String fireAndForgetEPLQuery, CompilerArguments arguments) throws EPCompileException {
        return this.compileQueryInternal(new CompilableEPL(fireAndForgetEPLQuery, 1), arguments);
    }

    @Override
    public EPCompiled compileQuery(EPStatementObjectModel fireAndForgetEPLQueryModel, CompilerArguments arguments) throws EPCompileException {
        return this.compileQueryInternal(new CompilableSODA(fireAndForgetEPLQueryModel, 1), arguments);
    }

    @Override
    public EPCompiled compile(String epl, CompilerArguments arguments) throws EPCompileException {
        if (arguments == null) {
            arguments = new CompilerArguments(new Configuration());
        }
        try {
            Module module = EPLModuleUtil.parseInternal(epl, null);
            ArrayList<Compilable> compilables = new ArrayList<Compilable>();
            for (ModuleItem item : module.getItems()) {
                if (item.isCommentOnly()) continue;
                String stmtEpl = item.getExpression();
                compilables.add(new CompilableEPL(stmtEpl, item.getLineNumber()));
            }
            String moduleName = this.determineModuleName(arguments.getOptions(), module);
            Set<String> moduleUses = this.determineModuleUses(moduleName, arguments.getOptions(), module);
            ModuleCompileTimeServices compileTimeServices = CompilerHelperServices.getCompileTimeServices(arguments, moduleName, moduleUses, false);
            this.addModuleImports(module.getImports(), compileTimeServices);
            Map<ModuleProperty, Object> moduleProperties = Collections.emptyMap();
            if (arguments.getConfiguration().getCompiler().getByteCode().isAttachModuleEPL()) {
                moduleProperties = new HashMap(CollectionUtil.capacityHashMap((int)1));
                moduleProperties.put(ModuleProperty.MODULETEXT, epl);
            }
            return CompilerHelperModuleProvider.compile(compilables, moduleName, moduleProperties, compileTimeServices, arguments.getOptions(), arguments.getPath());
        }
        catch (EPCompileException ex) {
            throw ex;
        }
        catch (ParseException t) {
            throw new EPCompileException("Failed to parse: " + t.getMessage(), t, Collections.emptyList());
        }
        catch (Throwable t) {
            throw new EPCompileException(t.getMessage(), t, Collections.emptyList());
        }
    }

    @Override
    public EPCompilerSPIExpression expressionCompiler(Configuration configuration) throws EPCompileException {
        CompilerArguments arguments = new CompilerArguments(configuration);
        arguments.setConfiguration(configuration);
        ModuleCompileTimeServices compileTimeServices = CompilerHelperServices.getCompileTimeServices(arguments, null, null, false);
        return new EPCompilerSPIExpressionImpl(compileTimeServices);
    }

    @Override
    public EPStatementObjectModel eplToModel(String stmtText, Configuration configuration) throws EPCompileException {
        try {
            StatementSpecMapEnv mapEnv = new StatementSpecMapEnv(CompilerHelperServices.makeClasspathImportService(configuration), (VariableCompileTimeResolver)VariableCompileTimeResolverEmpty.INSTANCE, configuration, (ExprDeclaredCompileTimeResolver)ExprDeclaredCompileTimeResolverEmpty.INSTANCE, (ContextCompileTimeResolver)ContextCompileTimeResolverEmpty.INSTANCE, (TableCompileTimeResolver)TableCompileTimeResolverEmpty.INSTANCE, (ScriptCompileTimeResolver)ScriptCompileTimeResolverEmpty.INSTANCE, (CompilerServices)new CompilerServicesImpl(), (ClassProvidedClasspathExtension)new ClassProvidedClasspathExtensionImpl((ClassProvidedCompileTimeResolver)ClassProvidedCompileTimeResolverEmpty.INSTANCE));
            StatementSpecRaw statementSpec = CompilerHelperSingleEPL.parseWalk(stmtText, mapEnv);
            StatementSpecUnMapResult unmapped = StatementSpecMapper.unmap((StatementSpecRaw)statementSpec);
            return unmapped.getObjectModel();
        }
        catch (StatementSpecCompileException ex) {
            throw new EPCompileException(ex.getMessage(), ex, Collections.emptyList());
        }
        catch (Throwable t) {
            throw new EPCompileException(t.getMessage(), t, Collections.emptyList());
        }
    }

    @Override
    public Module parseModule(String eplModuleText) throws IOException, ParseException {
        return EPLModuleUtil.parseInternal(eplModuleText, null);
    }

    @Override
    public EPCompiled compile(Module module, CompilerArguments arguments) throws EPCompileException {
        if (arguments == null) {
            arguments = new CompilerArguments(new Configuration());
        }
        String moduleName = this.determineModuleName(arguments.getOptions(), module);
        Set<String> moduleUses = this.determineModuleUses(moduleName, arguments.getOptions(), module);
        ModuleCompileTimeServices compileTimeServices = CompilerHelperServices.getCompileTimeServices(arguments, moduleName, moduleUses, false);
        this.addModuleImports(module.getImports(), compileTimeServices);
        ArrayList<Compilable> compilables = new ArrayList<Compilable>();
        for (ModuleItem item : module.getItems()) {
            if (item.isCommentOnly()) continue;
            if (item.getExpression() != null && item.getModel() != null) {
                throw new EPCompileException("Module item has both an EPL expression and a statement object model");
            }
            if (item.getExpression() != null) {
                compilables.add(new CompilableEPL(item.getExpression(), item.getLineNumber()));
                continue;
            }
            if (item.getModel() != null) {
                compilables.add(new CompilableSODA(item.getModel(), item.getLineNumber()));
                continue;
            }
            throw new EPCompileException("Module item has neither an EPL expression nor a statement object model");
        }
        HashMap<ModuleProperty, Object> moduleProperties = new HashMap<ModuleProperty, Object>();
        this.addModuleProperty(moduleProperties, ModuleProperty.ARCHIVENAME, module.getArchiveName());
        this.addModuleProperty(moduleProperties, ModuleProperty.URI, module.getUri());
        if (arguments.getConfiguration().getCompiler().getByteCode().isAttachModuleEPL()) {
            this.addModuleProperty(moduleProperties, ModuleProperty.MODULETEXT, module.getModuleText());
        }
        this.addModuleProperty(moduleProperties, ModuleProperty.USEROBJECT, module.getModuleUserObjectCompileTime());
        this.addModuleProperty(moduleProperties, ModuleProperty.USES, this.toNullOrArray(module.getUses()));
        this.addModuleProperty(moduleProperties, ModuleProperty.IMPORTS, this.toNullOrArray(module.getImports()));
        return CompilerHelperModuleProvider.compile(compilables, moduleName, moduleProperties, compileTimeServices, arguments.getOptions(), arguments.getPath());
    }

    @Override
    public Module readModule(InputStream stream, String uri) throws IOException, ParseException {
        if (log.isDebugEnabled()) {
            log.debug("Reading module from input stream");
        }
        return EPLModuleUtil.readInternal(stream, uri);
    }

    @Override
    public Module readModule(File file) throws IOException, ParseException {
        if (log.isDebugEnabled()) {
            log.debug("Reading resource '" + file.getAbsolutePath() + "'");
        }
        return EPLModuleUtil.readFile(file);
    }

    @Override
    public Module readModule(URL url) throws IOException, ParseException {
        if (log.isDebugEnabled()) {
            log.debug("Reading resource from url: " + url.toString());
        }
        return EPLModuleUtil.readInternal(url.openStream(), url.toString());
    }

    @Override
    public Module readModule(String resource, ClassLoader classLoader) throws IOException, ParseException {
        if (log.isDebugEnabled()) {
            log.debug("Reading resource '" + resource + "'");
        }
        return EPLModuleUtil.readResource(resource, classLoader);
    }

    @Override
    public void syntaxValidate(Module module, CompilerArguments arguments) throws EPCompileException {
        if (arguments == null) {
            arguments = new CompilerArguments(new Configuration());
        }
        String moduleName = this.determineModuleName(arguments.getOptions(), module);
        Set<String> moduleUses = this.determineModuleUses(moduleName, arguments.getOptions(), module);
        ModuleCompileTimeServices moduleCompileTimeServices = CompilerHelperServices.getCompileTimeServices(arguments, moduleName, moduleUses, false);
        int statementNumber = 0;
        try {
            for (ModuleItem item : module.getItems()) {
                InlinedClassInspectionOption inlinedClassInspection;
                StatementCompileTimeServices services = new StatementCompileTimeServices(statementNumber, moduleCompileTimeServices);
                if (item.isCommentOnly()) continue;
                if (item.getExpression() != null && item.getModel() != null) {
                    throw new EPCompileException("Module item has both an EPL expression and a statement object model");
                }
                InlinedClassInspectionOption inlinedClassInspectionOption = inlinedClassInspection = arguments.getOptions() == null ? null : arguments.getOptions().getInlinedClassInspection();
                if (item.getExpression() != null) {
                    CompilerHelperSingleEPL.parseCompileInlinedClassesWalk(new CompilableEPL(item.getExpression(), item.getLineNumber()), inlinedClassInspection, services);
                } else if (item.getModel() != null) {
                    CompilerHelperSingleEPL.parseCompileInlinedClassesWalk(new CompilableSODA(item.getModel(), item.getLineNumber()), inlinedClassInspection, services);
                    item.getModel().toEPL();
                } else {
                    throw new EPCompileException("Module item has neither an EPL expression nor a statement object model");
                }
                ++statementNumber;
            }
        }
        catch (Throwable ex) {
            throw new EPCompileException(ex.getMessage(), ex);
        }
    }

    private EPCompiled compileQueryInternal(Compilable compilable, CompilerArguments arguments) throws EPCompileException {
        if (arguments == null) {
            arguments = new CompilerArguments(new Configuration());
        }
        String moduleName = arguments.getOptions().getModuleName() == null ? null : arguments.getOptions().getModuleName().getValue(new ModuleNameContext(null));
        Set<String> moduleUses = arguments.getOptions().getModuleUses() == null ? null : arguments.getOptions().getModuleUses().getValue(new ModuleUsesContext(moduleName, null));
        ModuleCompileTimeServices compileTimeServices = CompilerHelperServices.getCompileTimeServices(arguments, moduleName, moduleUses, true);
        try {
            return CompilerHelperFAFProvider.compile(compilable, compileTimeServices, arguments);
        }
        catch (Throwable t) {
            throw new EPCompileException(t.getMessage() + " [" + compilable.toEPL() + "]", t, Collections.emptyList());
        }
    }

    private void addModuleProperty(Map<ModuleProperty, Object> moduleProperties, ModuleProperty key, Object value) {
        if (value == null) {
            return;
        }
        moduleProperties.put(key, value);
    }

    private String determineModuleName(CompilerOptions options, Module module) {
        return options.getModuleName() != null ? options.getModuleName().getValue(new ModuleNameContext(module.getName())) : module.getName();
    }

    private Set<String> determineModuleUses(String moduleName, CompilerOptions options, Module module) {
        return options.getModuleUses() != null ? options.getModuleUses().getValue(new ModuleUsesContext(moduleName, module.getUses())) : module.getUses();
    }

    private Object toNullOrArray(Set<String> values) {
        return values == null || values.isEmpty() ? null : values.toArray(new String[0]);
    }

    private void addModuleImports(Set<String> imports, ModuleCompileTimeServices compileTimeServices) throws EPCompileException {
        if (imports != null) {
            for (String imported : imports) {
                try {
                    compileTimeServices.getClasspathImportServiceCompileTime().addImport(imported);
                }
                catch (ClasspathImportException e) {
                    throw new EPCompileException("Invalid module import: " + e.getMessage(), e);
                }
            }
        }
    }
}

