/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.compiler.internal.util;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.util.StatementType;
import com.espertech.esper.common.internal.compile.stage1.Compilable;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.ModuleCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContextBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.compiler.client.EPCompileException;
import com.espertech.esper.compiler.internal.util.CompilableEPL;
import com.espertech.esper.compiler.internal.util.EPCompilerSPIExpression;
import java.util.Arrays;
import java.util.Collections;

public class EPCompilerSPIExpressionImpl
implements EPCompilerSPIExpression {
    private final ModuleCompileTimeServices moduleServices;

    public EPCompilerSPIExpressionImpl(ModuleCompileTimeServices moduleServices) {
        this.moduleServices = moduleServices;
    }

    public ExprNode compileExpression(String epl, EventType[] eventTypes, String[] streamNames) throws EPException {
        try {
            return this.compileValidate(epl, eventTypes, streamNames);
        }
        catch (Throwable t) {
            throw new EPException(t.getMessage(), t);
        }
    }

    @Override
    public ExprNode compileValidate(String expression) throws EPCompileException {
        return this.compileValidate(expression, null, null);
    }

    @Override
    public ExprNode compileValidate(String expression, EventType[] eventTypes, String[] streamNnames) throws EPCompileException {
        ExprNode node;
        StatementCompileTimeServices services = new StatementCompileTimeServices(0, this.moduleServices);
        try {
            node = services.getCompilerServices().compileExpression(expression, services);
        }
        catch (ExprValidationException e) {
            throw new EPCompileException("Failed to compile expression '" + expression + "': " + e.getMessage(), e, Collections.emptyList());
        }
        try {
            StreamTypeServiceImpl streamTypeService;
            ExprNodeUtilityValidate.validatePlainExpression((ExprNodeOrigin)ExprNodeOrigin.API, (ExprNode)node);
            if (eventTypes == null || eventTypes.length == 0) {
                streamTypeService = new StreamTypeServiceImpl(true);
            } else {
                boolean[] istreamOnly = new boolean[eventTypes.length];
                Arrays.fill(istreamOnly, true);
                streamTypeService = new StreamTypeServiceImpl(eventTypes, streamNnames, istreamOnly, true, false);
            }
            StatementRawInfo statementRawInfo = new StatementRawInfo(0, "API-provided", null, StatementType.INTERNAL_USE_API_COMPILE_EXPR, null, null, (Compilable)new CompilableEPL(expression, 1), "API-provided");
            ExprValidationContext validationContext = new ExprValidationContextBuilder((StreamTypeService)streamTypeService, statementRawInfo, services).build();
            node = ExprNodeUtilityValidate.getValidatedSubtree((ExprNodeOrigin)ExprNodeOrigin.API, (ExprNode)node, (ExprValidationContext)validationContext);
        }
        catch (ExprValidationException e) {
            throw new EPCompileException("Failed to validate expression '" + expression + "': " + e.getMessage(), e, Collections.emptyList());
        }
        return node;
    }
}

