/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.ExpressionBase;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;

public class CompareListExpression
extends ExpressionBase {
    private String operator;
    private boolean all;
    private static final long serialVersionUID = 2915262248687901526L;

    public CompareListExpression() {
    }

    public CompareListExpression(boolean all, String operator) {
        this.all = all;
        this.operator = operator;
    }

    public boolean isAll() {
        return this.all;
    }

    public boolean getAll() {
        return this.all;
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.RELATIONAL_BETWEEN_IN;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildren().get(0).toEPL(writer, this.getPrecedence());
        writer.write(this.operator);
        if (this.all) {
            writer.write("all(");
        } else {
            writer.write("any(");
        }
        String delimiter = "";
        for (int i = 1; i < this.getChildren().size(); ++i) {
            writer.write(delimiter);
            this.getChildren().get(i).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            delimiter = ",";
        }
        writer.write(41);
    }
}

