/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.ContextDescriptor;
import com.espertech.esper.client.soda.ContextDescriptorHashSegmentedItem;
import com.espertech.esper.client.soda.EPStatementFormatter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class ContextDescriptorHashSegmented
implements ContextDescriptor {
    private static final long serialVersionUID = 5131255287304974685L;
    private List<ContextDescriptorHashSegmentedItem> items;
    private int granularity;
    private boolean preallocate;

    public ContextDescriptorHashSegmented() {
        this.items = new ArrayList<ContextDescriptorHashSegmentedItem>();
    }

    public ContextDescriptorHashSegmented(List<ContextDescriptorHashSegmentedItem> items, int granularity, boolean preallocate) {
        this.items = items;
        this.granularity = granularity;
        this.preallocate = preallocate;
    }

    public List<ContextDescriptorHashSegmentedItem> getItems() {
        return this.items;
    }

    public int getGranularity() {
        return this.granularity;
    }

    public void setGranularity(int granularity) {
        this.granularity = granularity;
    }

    public boolean isPreallocate() {
        return this.preallocate;
    }

    public void setPreallocate(boolean preallocate) {
        this.preallocate = preallocate;
    }

    public void setItems(List<ContextDescriptorHashSegmentedItem> items) {
        this.items = items;
    }

    @Override
    public void toEPL(StringWriter writer, EPStatementFormatter formatter) {
        writer.append("coalesce ");
        String delimiter = "";
        for (ContextDescriptorHashSegmentedItem item : this.items) {
            writer.append(delimiter);
            item.toEPL(writer, formatter);
            delimiter = ", ";
        }
        writer.append(" granularity ");
        writer.append(Integer.toString(this.granularity));
        if (this.preallocate) {
            writer.append(" preallocate");
        }
    }
}

