/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.client.soda.ProjectedStream;
import com.espertech.esper.client.soda.SchemaColumnDesc;
import com.espertech.esper.client.soda.View;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CreateWindowClause
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String windowName;
    private List<View> views = new ArrayList<View>();
    private boolean insert;
    private Expression insertWhereClause;
    private List<SchemaColumnDesc> columns = new ArrayList<SchemaColumnDesc>();

    public CreateWindowClause() {
    }

    public static CreateWindowClause create(String windowName, View view) {
        return new CreateWindowClause(windowName, new View[]{view});
    }

    public static CreateWindowClause create(String windowName, View ... views) {
        return new CreateWindowClause(windowName, views);
    }

    public CreateWindowClause addView(String namespace, String name) {
        this.views.add(View.create(namespace, name));
        return this;
    }

    public CreateWindowClause addView(String namespace, String name, List<Expression> parameters) {
        this.views.add(View.create(namespace, name, parameters));
        return this;
    }

    public CreateWindowClause addView(String namespace, String name, Expression ... parameters) {
        this.views.add(View.create(namespace, name, parameters));
        return this;
    }

    public CreateWindowClause(String windowName, View[] viewArr) {
        this.windowName = windowName;
        this.views = new ArrayList<View>();
        if (viewArr != null) {
            this.views.addAll(Arrays.asList(viewArr));
        }
    }

    public CreateWindowClause(String windowName, List<View> views) {
        this.windowName = windowName;
        this.views = views;
    }

    public void toEPL(StringWriter writer) {
        writer.write("create window ");
        writer.write(this.windowName);
        ProjectedStream.toEPLViews(writer, this.views);
    }

    public void toEPLInsertPart(StringWriter writer) {
        if (this.insert) {
            writer.write(" insert");
            if (this.insertWhereClause != null) {
                writer.write(" where ");
                this.insertWhereClause.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            }
        }
    }

    public String getWindowName() {
        return this.windowName;
    }

    public void setWindowName(String windowName) {
        this.windowName = windowName;
    }

    public List<View> getViews() {
        return this.views;
    }

    public boolean isInsert() {
        return this.insert;
    }

    public boolean getInsert() {
        return this.insert;
    }

    public Expression getInsertWhereClause() {
        return this.insertWhereClause;
    }

    public CreateWindowClause insert(boolean insert) {
        this.insert = insert;
        return this;
    }

    public void setInsert(boolean insert) {
        this.insert = insert;
    }

    public CreateWindowClause insertWhereClause(Expression insertWhereClause) {
        this.insertWhereClause = insertWhereClause;
        return this;
    }

    public void setInsertWhereClause(Expression insertWhereClause) {
        this.insertWhereClause = insertWhereClause;
    }

    public void setViews(List<View> views) {
        this.views = views;
    }

    public List<SchemaColumnDesc> getColumns() {
        return this.columns;
    }

    public void addColumn(SchemaColumnDesc col) {
        this.columns.add(col);
    }

    public void setColumns(List<SchemaColumnDesc> columns) {
        this.columns = columns;
    }

    public void toEPLCreateTablePart(StringWriter writer) {
        String delimiter = "";
        writer.write(40);
        for (SchemaColumnDesc col : this.columns) {
            writer.append(delimiter);
            col.toEPL(writer);
            delimiter = ", ";
        }
        writer.write(41);
    }
}

