/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;

public abstract class EPBaseNamedObject
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String namespace;
    private String name;
    private List<Expression> parameters;

    public EPBaseNamedObject() {
    }

    public EPBaseNamedObject(String namespace, String name, List<Expression> parameters) {
        this.namespace = namespace;
        this.name = name;
        this.parameters = parameters;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Expression> parameters) {
        this.parameters = parameters;
    }

    public void toEPL(StringWriter writer) {
        writer.write(this.namespace);
        writer.write(58);
        writer.write(this.name);
        String delimiter = "";
        writer.write(40);
        for (Expression param : this.parameters) {
            writer.write(delimiter);
            param.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            delimiter = ",";
        }
        writer.write(41);
    }
}

