/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionBase;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;

public class MinProjectionExpression
extends ExpressionBase {
    private boolean distinct;
    private static final long serialVersionUID = -5521787388585609418L;
    private boolean ever;

    public MinProjectionExpression() {
    }

    public MinProjectionExpression(boolean isDistinct) {
        this.distinct = isDistinct;
    }

    public MinProjectionExpression(boolean isDistinct, boolean isEver) {
        this.distinct = isDistinct;
        this.ever = isEver;
    }

    public MinProjectionExpression(Expression expression, boolean isDistinct) {
        this.distinct = isDistinct;
        this.getChildren().add(expression);
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.UNARY;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        String name = this.getChildren().size() > 1 ? "fmin" : (this.ever ? "minever" : "min");
        ExpressionBase.renderAggregation(writer, name, this.distinct, this.getChildren());
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public boolean getDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isEver() {
        return this.ever;
    }

    public void setEver(boolean ever) {
        this.ever = ever;
    }
}

