/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionBase;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;

public class RegExpExpression
extends ExpressionBase {
    private boolean not;
    private static final long serialVersionUID = -3147750744100550487L;

    public RegExpExpression(boolean isNot) {
        this.not = isNot;
    }

    public RegExpExpression(Expression left, Expression right, boolean isNot) {
        this(left, right, null, isNot);
    }

    public RegExpExpression(Expression left, Expression right, Expression escape, boolean isNot) {
        this.getChildren().add(left);
        this.getChildren().add(right);
        if (escape != null) {
            this.getChildren().add(escape);
        }
        this.not = isNot;
    }

    public RegExpExpression() {
        this.not = false;
    }

    public RegExpExpression(Expression left, Expression right) {
        this(left, right, null);
    }

    public RegExpExpression(Expression left, Expression right, Expression escape) {
        this.getChildren().add(left);
        this.getChildren().add(right);
        if (escape != null) {
            this.getChildren().add(escape);
        }
        this.not = false;
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.RELATIONAL_BETWEEN_IN;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildren().get(0).toEPL(writer, this.getPrecedence());
        if (this.not) {
            writer.write(" not");
        }
        writer.write(" regexp ");
        this.getChildren().get(1).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        if (this.getChildren().size() > 2) {
            writer.write(" escape ");
            this.getChildren().get(2).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
    }

    public boolean isNot() {
        return this.not;
    }
}

