/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.factory;

import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactory;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryResult;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.util.AuditPath;
import com.espertech.esper.util.StopCallback;
import java.lang.annotation.Annotation;

public abstract class StatementAgentInstanceFactoryBase
implements StatementAgentInstanceFactory {
    private final boolean audit;

    public StatementAgentInstanceFactoryBase(Annotation[] annotations) {
        this.audit = AuditEnum.CONTEXTPARTITION.getAudit(annotations) != null;
    }

    protected abstract StatementAgentInstanceFactoryResult newContextInternal(AgentInstanceContext var1, boolean var2);

    @Override
    public StatementAgentInstanceFactoryResult newContext(final AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        if (!this.audit || agentInstanceContext.getAgentInstanceId() == -1) {
            return this.newContextInternal(agentInstanceContext, isRecoveringResilient);
        }
        AuditPath.auditContextPartition(agentInstanceContext.getEngineURI(), agentInstanceContext.getStatementName(), true, agentInstanceContext.getAgentInstanceId());
        StatementAgentInstanceFactoryResult result = this.newContextInternal(agentInstanceContext, isRecoveringResilient);
        final StopCallback stopCallback = result.getStopCallback();
        result.setStopCallback(new StopCallback(){

            @Override
            public void stop() {
                AuditPath.auditContextPartition(agentInstanceContext.getEngineURI(), agentInstanceContext.getStatementName(), false, agentInstanceContext.getAgentInstanceId());
                stopCallback.stop();
            }
        });
        return result;
    }
}

