/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.factory;

import com.espertech.esper.client.EPException;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactory;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryCreateIndexResult;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryResult;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.named.NamedWindowProcessorInstance;
import com.espertech.esper.epl.spec.CreateIndexDesc;
import com.espertech.esper.epl.table.mgmt.TableStateInstance;
import com.espertech.esper.epl.virtualdw.VirtualDWView;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.Viewable;

public class StatementAgentInstanceFactoryCreateIndex
implements StatementAgentInstanceFactory {
    private final EPServicesContext services;
    private final CreateIndexDesc spec;
    private final Viewable finalView;
    private final NamedWindowProcessor namedWindowProcessor;
    private final String tableName;

    public StatementAgentInstanceFactoryCreateIndex(EPServicesContext services, CreateIndexDesc spec, Viewable finalView, NamedWindowProcessor namedWindowProcessor, String tableName) {
        this.services = services;
        this.spec = spec;
        this.finalView = finalView;
        this.namedWindowProcessor = namedWindowProcessor;
        this.tableName = tableName;
    }

    @Override
    public StatementAgentInstanceFactoryCreateIndexResult newContext(AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        StopCallback stopCallback;
        if (this.namedWindowProcessor != null) {
            NamedWindowProcessorInstance processorInstance = this.namedWindowProcessor.getProcessorInstance(agentInstanceContext);
            if (this.namedWindowProcessor.isVirtualDataWindow()) {
                final VirtualDWView virtualDWView = processorInstance.getRootViewInstance().getVirtualDataWindow();
                virtualDWView.handleStartIndex(this.spec);
                stopCallback = new StopCallback(){

                    @Override
                    public void stop() {
                        virtualDWView.handleStopIndex(StatementAgentInstanceFactoryCreateIndex.this.spec);
                    }
                };
            } else {
                try {
                    processorInstance.getRootViewInstance().addExplicitIndex(this.spec.isUnique(), this.spec.getIndexName(), this.spec.getColumns());
                }
                catch (ExprValidationException e) {
                    throw new EPException("Failed to create index: " + e.getMessage(), e);
                }
                stopCallback = new StopCallback(){

                    @Override
                    public void stop() {
                    }
                };
            }
        } else {
            try {
                TableStateInstance instance = this.services.getTableService().getState(this.tableName, agentInstanceContext.getAgentInstanceId());
                instance.addExplicitIndex(this.spec);
            }
            catch (ExprValidationException ex) {
                throw new EPException("Failed to create index: " + ex.getMessage(), ex);
            }
            stopCallback = new StopCallback(){

                @Override
                public void stop() {
                }
            };
        }
        return new StatementAgentInstanceFactoryCreateIndexResult(this.finalView, stopCallback, agentInstanceContext);
    }

    @Override
    public void assignExpressions(StatementAgentInstanceFactoryResult result) {
    }

    @Override
    public void unassignExpressions() {
    }
}

