/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.core.context.mgr.ContextControllerFactory;
import com.espertech.esper.core.context.mgr.ContextControllerFactoryContext;
import com.espertech.esper.core.context.mgr.ContextControllerFactoryServiceContext;
import com.espertech.esper.core.context.mgr.ContextStateCache;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.ContextDetail;
import com.espertech.esper.epl.spec.ContextDetailNested;
import com.espertech.esper.epl.spec.CreateContextDesc;
import com.espertech.esper.filter.FilterSpecCompiled;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ContextControllerFactoryHelper {
    public static ContextControllerFactory[] getFactory(ContextControllerFactoryServiceContext serviceContext, ContextStateCache contextStateCache) throws ExprValidationException {
        if (!(serviceContext.getDetail() instanceof ContextDetailNested)) {
            ContextControllerFactory factory = ContextControllerFactoryHelper.buildContextFactory(serviceContext, serviceContext.getContextName(), serviceContext.getDetail(), 1, null, contextStateCache);
            factory.validateFactory();
            return new ContextControllerFactory[]{factory};
        }
        return ContextControllerFactoryHelper.buildNestedContextFactories(serviceContext, contextStateCache);
    }

    private static ContextControllerFactory[] buildNestedContextFactories(ContextControllerFactoryServiceContext serviceContext, ContextStateCache contextStateCache) throws ExprValidationException {
        ContextDetailNested nestedSpec = (ContextDetailNested)serviceContext.getDetail();
        HashMap<CreateContextDesc, List<FilterSpecCompiled>> filtersPerNestedContext = null;
        for (int i = 0; i < nestedSpec.getContexts().size(); ++i) {
            CreateContextDesc contextParent = nestedSpec.getContexts().get(i);
            for (int j = i + 1; j < nestedSpec.getContexts().size(); ++j) {
                List existing;
                CreateContextDesc contextControlled = nestedSpec.getContexts().get(j);
                List<FilterSpecCompiled> specs = contextControlled.getFilterSpecs();
                if (specs == null) continue;
                if (filtersPerNestedContext == null) {
                    filtersPerNestedContext = new HashMap<CreateContextDesc, List<FilterSpecCompiled>>();
                }
                if ((existing = (List)filtersPerNestedContext.get(contextParent)) != null) {
                    existing.addAll(specs);
                    continue;
                }
                filtersPerNestedContext.put(contextParent, specs);
            }
        }
        HashSet<String> namesUsed = new HashSet<String>();
        ContextControllerFactory[] hierarchy = new ContextControllerFactory[nestedSpec.getContexts().size()];
        for (int i = 0; i < nestedSpec.getContexts().size(); ++i) {
            CreateContextDesc context = nestedSpec.getContexts().get(i);
            if (namesUsed.contains(context.getContextName())) {
                throw new ExprValidationException("Context by name '" + context.getContextName() + "' has already been declared within nested context '" + serviceContext.getContextName() + "'");
            }
            namesUsed.add(context.getContextName());
            int nestingLevel = i + 1;
            List optFiltersNested = null;
            if (filtersPerNestedContext != null) {
                optFiltersNested = (List)filtersPerNestedContext.get(context);
            }
            hierarchy[i] = ContextControllerFactoryHelper.buildContextFactory(serviceContext, context.getContextName(), context.getContextDetail(), nestingLevel, optFiltersNested, contextStateCache);
            hierarchy[i].validateFactory();
        }
        return hierarchy;
    }

    private static ContextControllerFactory buildContextFactory(ContextControllerFactoryServiceContext serviceContext, String contextName, ContextDetail detail, int nestingLevel, List<FilterSpecCompiled> optFiltersNested, ContextStateCache contextStateCache) throws ExprValidationException {
        ContextControllerFactoryContext factoryContext = new ContextControllerFactoryContext(serviceContext.getContextName(), contextName, serviceContext.getServicesContext(), serviceContext.getAgentInstanceContextCreate(), nestingLevel, serviceContext.isRecoveringResilient());
        return ContextControllerFactoryHelper.buildContextFactory(factoryContext, detail, optFiltersNested, contextStateCache);
    }

    private static ContextControllerFactory buildContextFactory(ContextControllerFactoryContext factoryContext, ContextDetail detail, List<FilterSpecCompiled> optFiltersNested, ContextStateCache contextStateCache) throws ExprValidationException {
        return factoryContext.getServicesContext().getContextControllerFactoryFactorySvc().make(factoryContext, detail, optFiltersNested, contextStateCache);
    }
}

