/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.context.ContextPartitionIdentifier;
import com.espertech.esper.client.context.ContextPartitionIdentifierHash;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.mgr.ContextController;
import com.espertech.esper.core.context.mgr.ContextControllerAddendumUtil;
import com.espertech.esper.core.context.mgr.ContextControllerFactory;
import com.espertech.esper.core.context.mgr.ContextControllerFactoryBase;
import com.espertech.esper.core.context.mgr.ContextControllerFactoryContext;
import com.espertech.esper.core.context.mgr.ContextControllerHash;
import com.espertech.esper.core.context.mgr.ContextControllerHashedGetterCRC32Serialized;
import com.espertech.esper.core.context.mgr.ContextControllerHashedGetterCRC32Single;
import com.espertech.esper.core.context.mgr.ContextControllerHashedGetterHashMultiple;
import com.espertech.esper.core.context.mgr.ContextControllerHashedGetterHashSingle;
import com.espertech.esper.core.context.mgr.ContextControllerHashedGetterSingleRow;
import com.espertech.esper.core.context.mgr.ContextControllerLifecycleCallback;
import com.espertech.esper.core.context.mgr.ContextControllerPartitionedUtil;
import com.espertech.esper.core.context.mgr.ContextControllerStatementBase;
import com.espertech.esper.core.context.mgr.ContextControllerStatementCtxCache;
import com.espertech.esper.core.context.mgr.ContextControllerStatementCtxCacheFilters;
import com.espertech.esper.core.context.mgr.ContextControllerStatementDesc;
import com.espertech.esper.core.context.mgr.ContextInternalFilterAddendum;
import com.espertech.esper.core.context.mgr.ContextPropertyEventType;
import com.espertech.esper.core.context.mgr.ContextStateCache;
import com.espertech.esper.core.context.mgr.ContextStatePathValueBinding;
import com.espertech.esper.core.context.stmt.AIRegistryAggregationMap;
import com.espertech.esper.core.context.stmt.AIRegistryAggregationMultiPerm;
import com.espertech.esper.core.context.stmt.AIRegistryExprMap;
import com.espertech.esper.core.context.stmt.AIRegistryExprMultiPerm;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistry;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistryFactory;
import com.espertech.esper.epl.core.EngineImportSingleRowDesc;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.ContextDetail;
import com.espertech.esper.epl.spec.ContextDetailHash;
import com.espertech.esper.epl.spec.ContextDetailHashItem;
import com.espertech.esper.epl.spec.ContextDetailPartitionItem;
import com.espertech.esper.epl.spec.util.StatementSpecCompiledAnalyzer;
import com.espertech.esper.epl.spec.util.StatementSpecCompiledAnalyzerResult;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecLookupable;
import com.espertech.esper.filter.FilterValueSetParam;
import com.espertech.esper.filter.FilterValueSetParamImpl;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class ContextControllerHashFactory
extends ContextControllerFactoryBase
implements ContextControllerFactory {
    private final ContextDetailHash hashedSpec;
    private final List<FilterSpecCompiled> filtersSpecsNestedContexts;
    private final ContextStateCache stateCache;
    private final ContextStatePathValueBinding binding;
    private Map<String, Object> contextBuiltinProps;

    public ContextControllerHashFactory(ContextControllerFactoryContext factoryContext, ContextDetailHash hashedSpec, List<FilterSpecCompiled> filtersSpecsNestedContexts, ContextStateCache stateCache) {
        super(factoryContext);
        this.hashedSpec = hashedSpec;
        this.filtersSpecsNestedContexts = filtersSpecsNestedContexts;
        this.stateCache = stateCache;
        this.binding = stateCache.getBinding(Integer.class);
    }

    public boolean hasFiltersSpecsNestedContexts() {
        return this.filtersSpecsNestedContexts != null && !this.filtersSpecsNestedContexts.isEmpty();
    }

    @Override
    public ContextStateCache getStateCache() {
        return this.stateCache;
    }

    public ContextStatePathValueBinding getBinding() {
        return this.binding;
    }

    @Override
    public void validateFactory() throws ExprValidationException {
        this.validatePopulateContextDesc();
        this.contextBuiltinProps = ContextPropertyEventType.getHashType();
    }

    @Override
    public ContextControllerStatementCtxCache validateStatement(ContextControllerStatementBase statement) throws ExprValidationException {
        StatementSpecCompiledAnalyzerResult streamAnalysis = StatementSpecCompiledAnalyzer.analyzeFilters(statement.getStatementSpec());
        ContextControllerPartitionedUtil.validateStatementForContext(this.factoryContext.getContextName(), statement, streamAnalysis, this.getItemEventTypes(this.hashedSpec), this.factoryContext.getServicesContext().getNamedWindowService());
        return new ContextControllerStatementCtxCacheFilters(streamAnalysis.getFilters());
    }

    @Override
    public void populateFilterAddendums(IdentityHashMap<FilterSpecCompiled, FilterValueSetParam[][]> filterAddendum, ContextControllerStatementDesc statement, Object key, int contextId) {
        ContextControllerStatementCtxCacheFilters statementInfo = (ContextControllerStatementCtxCacheFilters)statement.getCaches()[this.factoryContext.getNestingLevel() - 1];
        int assignedContextPartition = (Integer)key;
        int code = assignedContextPartition % this.hashedSpec.getGranularity();
        ContextControllerHashFactory.getAddendumFilters(filterAddendum, code, statementInfo.getFilterSpecs(), this.hashedSpec, statement);
    }

    public void populateContextInternalFilterAddendums(ContextInternalFilterAddendum filterAddendum, Object key) {
        int assignedContextPartition = (Integer)key;
        int code = assignedContextPartition % this.hashedSpec.getGranularity();
        ContextControllerHashFactory.getAddendumFilters(filterAddendum.getFilterAddendum(), code, this.filtersSpecsNestedContexts, this.hashedSpec, null);
    }

    @Override
    public FilterSpecLookupable getFilterLookupable(EventType eventType) {
        for (ContextDetailHashItem hashItem : this.hashedSpec.getItems()) {
            if (hashItem.getFilterSpecCompiled().getFilterForEventType() != eventType) continue;
            return hashItem.getLookupable();
        }
        return null;
    }

    @Override
    public boolean isSingleInstanceContext() {
        return false;
    }

    @Override
    public StatementAIResourceRegistryFactory getStatementAIResourceRegistryFactory() {
        if (this.hashedSpec.getGranularity() <= 65536) {
            return new StatementAIResourceRegistryFactory(){

                @Override
                public StatementAIResourceRegistry make() {
                    return new StatementAIResourceRegistry(new AIRegistryAggregationMultiPerm(), new AIRegistryExprMultiPerm());
                }
            };
        }
        return new StatementAIResourceRegistryFactory(){

            @Override
            public StatementAIResourceRegistry make() {
                return new StatementAIResourceRegistry(new AIRegistryAggregationMap(), new AIRegistryExprMap());
            }
        };
    }

    @Override
    public List<ContextDetailPartitionItem> getContextDetailPartitionItems() {
        return Collections.emptyList();
    }

    @Override
    public ContextDetail getContextDetail() {
        return this.hashedSpec;
    }

    public ContextDetailHash getHashedSpec() {
        return this.hashedSpec;
    }

    @Override
    public Map<String, Object> getContextBuiltinProps() {
        return this.contextBuiltinProps;
    }

    @Override
    public ContextController createNoCallback(int pathId, ContextControllerLifecycleCallback callback) {
        return new ContextControllerHash(pathId, callback, this);
    }

    @Override
    public ContextPartitionIdentifier keyPayloadToIdentifier(Object payload) {
        return new ContextPartitionIdentifierHash((Integer)payload);
    }

    private Collection<EventType> getItemEventTypes(ContextDetailHash hashedSpec) {
        ArrayList<EventType> itemEventTypes = new ArrayList<EventType>();
        for (ContextDetailHashItem item : hashedSpec.getItems()) {
            itemEventTypes.add(item.getFilterSpecCompiled().getFilterForEventType());
        }
        return itemEventTypes;
    }

    private void validatePopulateContextDesc() throws ExprValidationException {
        if (this.hashedSpec.getItems().isEmpty()) {
            throw new ExprValidationException("Empty list of hash items");
        }
        for (ContextDetailHashItem item : this.hashedSpec.getItems()) {
            EventPropertyGetter getter;
            if (item.getFunction().getParameters().isEmpty()) {
                throw new ExprValidationException("For context '" + this.factoryContext.getContextName() + "' expected one or more parameters to the hash function, but found no parameter list");
            }
            String hashFuncName = item.getFunction().getName();
            HashFunctionEnum hashFunction = HashFunctionEnum.determine(this.factoryContext.getContextName(), hashFuncName);
            Pair<Class, EngineImportSingleRowDesc> hashSingleRowFunction = null;
            if (hashFunction == null) {
                try {
                    hashSingleRowFunction = this.factoryContext.getAgentInstanceContextCreate().getStatementContext().getMethodResolutionService().resolveSingleRow(hashFuncName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (hashSingleRowFunction == null) {
                    throw new ExprValidationException("For context '" + this.factoryContext.getContextName() + "' expected a hash function that is any of {" + HashFunctionEnum.getStringList() + "} or a plug-in single-row function or script but received '" + hashFuncName + "'");
                }
            }
            ExprNode paramExpr = item.getFunction().getParameters().get(0);
            ExprEvaluator eval = paramExpr.getExprEvaluator();
            Class paramType = eval.getType();
            if (hashFunction == HashFunctionEnum.CONSISTENT_HASH_CRC32) {
                getter = item.getFunction().getParameters().size() > 1 || paramType != String.class ? new ContextControllerHashedGetterCRC32Serialized(this.factoryContext.getAgentInstanceContextCreate().getStatementContext().getStatementName(), item.getFunction().getParameters(), this.hashedSpec.getGranularity()) : new ContextControllerHashedGetterCRC32Single(eval, this.hashedSpec.getGranularity());
            } else if (hashFunction == HashFunctionEnum.HASH_CODE) {
                getter = item.getFunction().getParameters().size() > 1 ? new ContextControllerHashedGetterHashMultiple(item.getFunction().getParameters(), this.hashedSpec.getGranularity()) : new ContextControllerHashedGetterHashSingle(eval, this.hashedSpec.getGranularity());
            } else if (hashSingleRowFunction != null) {
                getter = new ContextControllerHashedGetterSingleRow(this.factoryContext.getAgentInstanceContextCreate().getStatementContext().getStatementName(), hashFuncName, hashSingleRowFunction, item.getFunction().getParameters(), this.hashedSpec.getGranularity(), this.factoryContext.getAgentInstanceContextCreate().getStatementContext().getMethodResolutionService(), item.getFilterSpecCompiled().getFilterForEventType(), this.factoryContext.getAgentInstanceContextCreate().getStatementContext().getEventAdapterService(), this.factoryContext.getAgentInstanceContextCreate().getStatementId(), this.factoryContext.getServicesContext().getTableService());
            } else {
                throw new IllegalArgumentException("Unrecognized hash code function '" + hashFuncName + "'");
            }
            String expression = item.getFunction().getName() + "(" + paramExpr + ")";
            FilterSpecLookupable lookupable = new FilterSpecLookupable(expression, getter, Integer.class);
            item.setLookupable(lookupable);
        }
    }

    private static void getAddendumFilters(IdentityHashMap<FilterSpecCompiled, FilterValueSetParam[][]> addendums, int agentInstanceId, List<FilterSpecCompiled> filtersSpecs, ContextDetailHash hashSpec, ContextControllerStatementDesc statementDesc) {
        block7: {
            block6: {
                boolean isCreateWindow;
                boolean bl = isCreateWindow = statementDesc != null && statementDesc.getStatement().getStatementSpec().getCreateWindowDesc() != null;
                if (isCreateWindow) break block6;
                for (FilterSpecCompiled filtersSpec : filtersSpecs) {
                    FilterValueSetParam[][] existing;
                    ContextDetailHashItem foundPartition = ContextControllerHashFactory.findHashItemSpec(hashSpec, filtersSpec);
                    if (foundPartition == null) continue;
                    FilterValueSetParamImpl filter = new FilterValueSetParamImpl(foundPartition.getLookupable(), FilterOperator.EQUAL, agentInstanceId);
                    FilterValueSetParam[][] addendum = new FilterValueSetParam[][]{{filter}};
                    FilterValueSetParam[][] partitionFilters = foundPartition.getParametersCompiled();
                    if (partitionFilters != null) {
                        addendum = ContextControllerAddendumUtil.addAddendum(partitionFilters, filter);
                    }
                    if ((existing = addendums.get(filtersSpec)) != null) {
                        addendum = ContextControllerAddendumUtil.multiplyAddendum(existing, addendum);
                    }
                    addendums.put(filtersSpec, addendum);
                }
                break block7;
            }
            String declaredAsName = statementDesc.getStatement().getStatementSpec().getCreateWindowDesc().getAsEventTypeName();
            if (declaredAsName == null) break block7;
            for (FilterSpecCompiled filterSpec : filtersSpecs) {
                ContextDetailHashItem foundPartition = null;
                for (ContextDetailHashItem partitionItem : hashSpec.getItems()) {
                    if (!partitionItem.getFilterSpecCompiled().getFilterForEventType().getName().equals(declaredAsName)) continue;
                    foundPartition = partitionItem;
                    break;
                }
                if (foundPartition == null) continue;
                FilterValueSetParamImpl filter = new FilterValueSetParamImpl(foundPartition.getLookupable(), FilterOperator.EQUAL, agentInstanceId);
                FilterValueSetParam[][] addendum = new FilterValueSetParam[][]{{filter}};
                FilterValueSetParam[][] existing = addendums.get(filterSpec);
                if (existing != null) {
                    addendum = ContextControllerAddendumUtil.multiplyAddendum(existing, addendum);
                }
                addendums.put(filterSpec, addendum);
            }
        }
    }

    public static ContextDetailHashItem findHashItemSpec(ContextDetailHash hashSpec, FilterSpecCompiled filterSpec) {
        ContextDetailHashItem foundPartition = null;
        for (ContextDetailHashItem partitionItem : hashSpec.getItems()) {
            boolean typeOrSubtype = EventTypeUtility.isTypeOrSubTypeOf(filterSpec.getFilterForEventType(), partitionItem.getFilterSpecCompiled().getFilterForEventType());
            if (!typeOrSubtype) continue;
            foundPartition = partitionItem;
        }
        return foundPartition;
    }

    public static enum HashFunctionEnum {
        CONSISTENT_HASH_CRC32,
        HASH_CODE;

        private static String stringList;

        public static HashFunctionEnum determine(String contextName, String name) throws ExprValidationException {
            String nameTrim = name.toLowerCase().trim();
            for (HashFunctionEnum val : HashFunctionEnum.values()) {
                if (!val.name().toLowerCase().trim().equals(nameTrim)) continue;
                return val;
            }
            return null;
        }

        public static String getStringList() {
            StringWriter message = new StringWriter();
            String delimiter = "";
            for (HashFunctionEnum val : HashFunctionEnum.values()) {
                message.append(delimiter);
                message.append(val.name().toLowerCase().trim());
                delimiter = ", ";
            }
            return message.toString();
        }
    }
}

