/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.SafeIterator;
import com.espertech.esper.client.context.ContextPartitionDescriptor;
import com.espertech.esper.client.context.ContextPartitionSelector;
import com.espertech.esper.client.context.ContextPartitionSelectorAll;
import com.espertech.esper.client.context.ContextPartitionSelectorById;
import com.espertech.esper.client.context.ContextPartitionState;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryResult;
import com.espertech.esper.core.context.mgr.AgentInstance;
import com.espertech.esper.core.context.mgr.AgentInstanceArrayIterator;
import com.espertech.esper.core.context.mgr.AgentInstanceArraySafeIterator;
import com.espertech.esper.core.context.mgr.AgentInstanceFilterProxyImpl;
import com.espertech.esper.core.context.mgr.AgentInstanceSelector;
import com.espertech.esper.core.context.mgr.ContextController;
import com.espertech.esper.core.context.mgr.ContextControllerFactory;
import com.espertech.esper.core.context.mgr.ContextControllerFactoryServiceContext;
import com.espertech.esper.core.context.mgr.ContextControllerInstanceHandle;
import com.espertech.esper.core.context.mgr.ContextControllerLifecycleCallback;
import com.espertech.esper.core.context.mgr.ContextControllerState;
import com.espertech.esper.core.context.mgr.ContextControllerStatementBase;
import com.espertech.esper.core.context.mgr.ContextControllerStatementCtxCache;
import com.espertech.esper.core.context.mgr.ContextControllerStatementDesc;
import com.espertech.esper.core.context.mgr.ContextControllerTreeAgentInstanceList;
import com.espertech.esper.core.context.mgr.ContextInternalFilterAddendum;
import com.espertech.esper.core.context.mgr.ContextManager;
import com.espertech.esper.core.context.mgr.ContextPartitionIdManager;
import com.espertech.esper.core.context.mgr.ContextPartitionVisitorAgentInstanceId;
import com.espertech.esper.core.context.mgr.ContextPartitionVisitorState;
import com.espertech.esper.core.context.mgr.ContextPropertyRegistryImpl;
import com.espertech.esper.core.context.mgr.ContextStatePathDescriptor;
import com.espertech.esper.core.context.mgr.ContextStatePathKey;
import com.espertech.esper.core.context.mgr.ContextStatePathValue;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistryFactory;
import com.espertech.esper.core.context.util.ContextDescriptor;
import com.espertech.esper.core.context.util.ContextIteratorHandler;
import com.espertech.esper.core.context.util.StatementAgentInstanceUtil;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.event.MappedEventBean;
import com.espertech.esper.filter.FilterFaultHandler;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecLookupable;
import com.espertech.esper.filter.FilterValueSetParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContextManagerImpl
implements ContextManager,
ContextControllerLifecycleCallback,
ContextIteratorHandler,
FilterFaultHandler {
    private final String contextName;
    private final EPServicesContext servicesContext;
    private final ContextControllerFactory factory;
    private final Map<String, ContextControllerStatementDesc> statements = new LinkedHashMap<String, ContextControllerStatementDesc>();
    private final ContextDescriptor contextDescriptor;
    private final Map<Integer, ContextControllerTreeAgentInstanceList> agentInstances = new LinkedHashMap<Integer, ContextControllerTreeAgentInstanceList>();
    private ContextController rootContext;
    private final ContextPartitionIdManager contextPartitionIdManager;

    public ContextManagerImpl(ContextControllerFactoryServiceContext factoryServiceContext) throws ExprValidationException {
        this.contextName = factoryServiceContext.getContextName();
        this.servicesContext = factoryServiceContext.getServicesContext();
        this.factory = factoryServiceContext.getAgentInstanceContextCreate().getStatementContext().getContextControllerFactoryService().getFactory(factoryServiceContext)[0];
        this.rootContext = this.factory.createNoCallback(0, this);
        this.contextPartitionIdManager = factoryServiceContext.getAgentInstanceContextCreate().getStatementContext().getContextControllerFactoryService().allocatePartitionIdMgr(this.contextName, factoryServiceContext.getAgentInstanceContextCreate().getStatementContext().getStatementId());
        StatementAIResourceRegistryFactory resourceRegistryFactory = this.factory.getStatementAIResourceRegistryFactory();
        Map<String, Object> contextProps = this.factory.getContextBuiltinProps();
        EventType contextPropsType = this.servicesContext.getEventAdapterService().createAnonymousMapType(this.contextName, contextProps);
        ContextPropertyRegistryImpl registry = new ContextPropertyRegistryImpl(this.factory.getContextDetailPartitionItems(), contextPropsType);
        this.contextDescriptor = new ContextDescriptor(this.contextName, this.factory.isSingleInstanceContext(), registry, resourceRegistryFactory, this, this.factory.getContextDetail());
    }

    @Override
    public int getNumNestingLevels() {
        return 1;
    }

    @Override
    public Map<String, ContextControllerStatementDesc> getStatements() {
        return this.statements;
    }

    @Override
    public ContextDescriptor getContextDescriptor() {
        return this.contextDescriptor;
    }

    @Override
    public void addStatement(ContextControllerStatementBase statement, boolean isRecoveringResilient) throws ExprValidationException {
        ContextControllerStatementCtxCache caches = this.factory.validateStatement(statement);
        ContextControllerStatementDesc desc = new ContextControllerStatementDesc(statement, new ContextControllerStatementCtxCache[]{caches});
        this.statements.put(statement.getStatementContext().getStatementId(), desc);
        if (this.statements.size() == 1) {
            this.activate();
        } else {
            for (Map.Entry<Integer, ContextControllerTreeAgentInstanceList> entry : this.agentInstances.entrySet()) {
                if (entry.getValue().getState() != ContextPartitionState.STARTED) continue;
                AgentInstance agentInstance = this.startStatement(entry.getKey(), desc, this.rootContext, entry.getValue().getInitPartitionKey(), entry.getValue().getInitContextProperties(), isRecoveringResilient);
                entry.getValue().getAgentInstances().add(agentInstance);
            }
        }
    }

    @Override
    public synchronized void stopStatement(String statementName, String statementId) {
        this.destroyStatement(statementName, statementId);
    }

    @Override
    public synchronized void destroyStatement(String statementName, String statementId) {
        if (!this.statements.containsKey(statementId)) {
            return;
        }
        if (this.statements.size() == 1) {
            this.safeDestroy();
        } else {
            this.removeStatement(statementId);
        }
    }

    @Override
    public void safeDestroy() {
        if (this.rootContext != null) {
            this.rootContext.deactivate();
            this.factory.getStateCache().removeContext(this.contextName);
            for (Map.Entry<Integer, ContextControllerTreeAgentInstanceList> entryCP : this.agentInstances.entrySet()) {
                StatementAgentInstanceUtil.stopAgentInstances(entryCP.getValue().getAgentInstances(), null, this.servicesContext, true, false);
            }
            this.agentInstances.clear();
            this.contextPartitionIdManager.clear();
            this.statements.clear();
        }
    }

    @Override
    public synchronized ContextControllerInstanceHandle contextPartitionInstantiate(Integer optionalContextPartitionId, int subPathId, Integer importSubpathId, ContextController originator, EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, Object partitionKey, Map<String, Object> contextProperties, ContextControllerState states, ContextInternalFilterAddendum filterAddendum, boolean isRecoveringResilient, ContextPartitionState state) {
        int assignedContextId;
        if (optionalContextPartitionId != null && !states.isImported()) {
            assignedContextId = optionalContextPartitionId;
            this.contextPartitionIdManager.addExisting(optionalContextPartitionId);
        } else {
            assignedContextId = this.contextPartitionIdManager.allocateId();
            if (states != null && states.getPartitionImportCallback() != null && optionalContextPartitionId != null) {
                states.getPartitionImportCallback().allocated(assignedContextId, optionalContextPartitionId);
            }
        }
        ArrayList<AgentInstance> newInstances = new ArrayList<AgentInstance>();
        if (state == ContextPartitionState.STARTED) {
            for (Map.Entry<String, ContextControllerStatementDesc> statementEntry : this.statements.entrySet()) {
                ContextControllerStatementDesc statementDesc = statementEntry.getValue();
                AgentInstance instance = this.startStatement(assignedContextId, statementDesc, originator, partitionKey, contextProperties, isRecoveringResilient);
                newInstances.add(instance);
            }
        }
        if (optionalTriggeringEvent != null || optionalTriggeringPattern != null) {
            StatementAgentInstanceUtil.evaluateEventForStatement(this.servicesContext, optionalTriggeringEvent, optionalTriggeringPattern, newInstances);
        }
        long filterVersion = this.servicesContext.getFilterService().getFiltersVersion();
        ContextControllerTreeAgentInstanceList agentInstanceList = new ContextControllerTreeAgentInstanceList(filterVersion, partitionKey, contextProperties, newInstances, state);
        this.agentInstances.put(assignedContextId, agentInstanceList);
        this.factory.getFactoryContext().getAgentInstanceContextCreate().getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(filterVersion);
        return new ContextNestedHandleImpl(subPathId, assignedContextId, agentInstanceList);
    }

    @Override
    public synchronized void contextPartitionTerminate(ContextControllerInstanceHandle contextNestedHandle, Map<String, Object> terminationProperties, boolean leaveLocksAcquired, List<AgentInstance> agentInstancesCollected) {
        ContextNestedHandleImpl handle = (ContextNestedHandleImpl)contextNestedHandle;
        ContextControllerTreeAgentInstanceList entry = this.agentInstances.remove(handle.getContextPartitionOrPathId());
        if (entry != null) {
            StatementAgentInstanceUtil.stopAgentInstances(entry.getAgentInstances(), terminationProperties, this.servicesContext, false, leaveLocksAcquired);
            if (agentInstancesCollected != null) {
                agentInstancesCollected.addAll(entry.getAgentInstances());
            }
            entry.getAgentInstances().clear();
            this.contextPartitionIdManager.removeId(contextNestedHandle.getContextPartitionOrPathId());
        }
    }

    @Override
    public void contextPartitionNavigate(ContextControllerInstanceHandle existingHandle, ContextController originator, ContextControllerState controllerState, int exportedCPOrPathId, ContextInternalFilterAddendum filterAddendum, AgentInstanceSelector agentInstanceSelector, byte[] payload) {
        ContextControllerTreeAgentInstanceList entry = this.agentInstances.get(existingHandle.getContextPartitionOrPathId());
        if (entry == null) {
            return;
        }
        if (entry.getState() == ContextPartitionState.STOPPED) {
            entry.setState(ContextPartitionState.STARTED);
            entry.getAgentInstances().clear();
            for (Map.Entry<String, ContextControllerStatementDesc> statement : this.statements.entrySet()) {
                AgentInstance instance = this.startStatement(existingHandle.getContextPartitionOrPathId(), statement.getValue(), originator, entry.getInitPartitionKey(), entry.getInitContextProperties(), false);
                entry.getAgentInstances().add(instance);
            }
            ContextStatePathKey key = new ContextStatePathKey(1, 0, existingHandle.getSubPathId());
            ContextStatePathValue value = new ContextStatePathValue(existingHandle.getContextPartitionOrPathId(), payload, ContextPartitionState.STARTED);
            this.rootContext.getFactory().getStateCache().updateContextPath(this.contextName, key, value);
        } else {
            ArrayList<AgentInstance> removed = new ArrayList<AgentInstance>(2);
            ArrayList<AgentInstance> added = new ArrayList<AgentInstance>(2);
            for (AgentInstance agentInstance : entry.getAgentInstances()) {
                if (!agentInstanceSelector.select(agentInstance)) continue;
                StatementAgentInstanceUtil.stopAgentInstance(agentInstance, null, this.servicesContext, false, false);
                removed.add(agentInstance);
                ContextControllerStatementDesc statementDesc = this.statements.get(agentInstance.getAgentInstanceContext().getStatementId());
                AgentInstance instance = this.startStatement(existingHandle.getContextPartitionOrPathId(), statementDesc, originator, entry.getInitPartitionKey(), entry.getInitContextProperties(), false);
                added.add(instance);
                if (controllerState.getPartitionImportCallback() == null) continue;
                controllerState.getPartitionImportCallback().existing(existingHandle.getContextPartitionOrPathId(), exportedCPOrPathId);
            }
            entry.getAgentInstances().removeAll(removed);
            entry.getAgentInstances().addAll(added);
        }
    }

    @Override
    public FilterSpecLookupable getFilterLookupable(EventType eventType) {
        return this.factory.getFilterLookupable(eventType);
    }

    @Override
    public synchronized Iterator<EventBean> iterator(String statementId) {
        AgentInstance[] instances = this.getAgentInstancesForStmt(statementId);
        return new AgentInstanceArrayIterator(instances);
    }

    @Override
    public synchronized SafeIterator<EventBean> safeIterator(String statementId) {
        AgentInstance[] instances = this.getAgentInstancesForStmt(statementId);
        return new AgentInstanceArraySafeIterator(instances);
    }

    @Override
    public synchronized Iterator<EventBean> iterator(String statementId, ContextPartitionSelector selector) {
        AgentInstance[] instances = this.getAgentInstancesForStmt(statementId, selector);
        return new AgentInstanceArrayIterator(instances);
    }

    @Override
    public synchronized SafeIterator<EventBean> safeIterator(String statementId, ContextPartitionSelector selector) {
        AgentInstance[] instances = this.getAgentInstancesForStmt(statementId, selector);
        return new AgentInstanceArraySafeIterator(instances);
    }

    @Override
    public Collection<Integer> getAgentInstanceIds(ContextPartitionSelector selector) {
        if (selector instanceof ContextPartitionSelectorById) {
            ContextPartitionSelectorById byId = (ContextPartitionSelectorById)selector;
            Set<Integer> ids = byId.getContextPartitionIds();
            if (ids == null || ids.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Integer> agentInstanceIds = new ArrayList<Integer>(ids);
            agentInstanceIds.retainAll(this.agentInstances.keySet());
            return agentInstanceIds;
        }
        if (selector instanceof ContextPartitionSelectorAll) {
            return new ArrayList<Integer>(this.agentInstances.keySet());
        }
        ContextPartitionVisitorAgentInstanceId visitor = new ContextPartitionVisitorAgentInstanceId(1);
        this.rootContext.visitSelectedPartitions(selector, visitor);
        return visitor.getAgentInstanceIds();
    }

    @Override
    public ContextStatePathDescriptor extractPaths(ContextPartitionSelector selector) {
        ContextPartitionVisitorState visitor = new ContextPartitionVisitorState();
        this.rootContext.visitSelectedPartitions(selector, visitor);
        return new ContextStatePathDescriptor(visitor.getStates(), visitor.getContextPartitionInfo());
    }

    @Override
    public ContextStatePathDescriptor extractStopPaths(ContextPartitionSelector selector) {
        ContextStatePathDescriptor states = this.extractPaths(selector);
        for (Map.Entry<ContextStatePathKey, ContextStatePathValue> entry : states.getPaths().entrySet()) {
            int agentInstanceId = entry.getValue().getOptionalContextPartitionId();
            ContextControllerTreeAgentInstanceList list = this.agentInstances.get(agentInstanceId);
            list.setState(ContextPartitionState.STOPPED);
            StatementAgentInstanceUtil.stopAgentInstances(list.getAgentInstances(), null, this.servicesContext, false, false);
            list.clearAgentInstances();
            entry.getValue().setState(ContextPartitionState.STOPPED);
            this.rootContext.getFactory().getStateCache().updateContextPath(this.contextName, entry.getKey(), entry.getValue());
        }
        return states;
    }

    @Override
    public ContextStatePathDescriptor extractDestroyPaths(ContextPartitionSelector selector) {
        ContextStatePathDescriptor states = this.extractPaths(selector);
        for (Map.Entry<ContextStatePathKey, ContextStatePathValue> entry : states.getPaths().entrySet()) {
            int agentInstanceId = entry.getValue().getOptionalContextPartitionId();
            ContextPartitionDescriptor descriptor = states.getContextPartitionInformation().get(agentInstanceId);
            this.rootContext.deletePath(descriptor.getIdentifier());
            ContextControllerTreeAgentInstanceList list = this.agentInstances.remove(agentInstanceId);
            StatementAgentInstanceUtil.stopAgentInstances(list.getAgentInstances(), null, this.servicesContext, false, false);
            list.clearAgentInstances();
            this.rootContext.getFactory().getStateCache().removeContextPath(this.contextName, entry.getKey().getLevel(), entry.getKey().getParentPath(), entry.getKey().getSubPath());
        }
        return states;
    }

    @Override
    public Map<Integer, ContextPartitionDescriptor> startPaths(ContextPartitionSelector selector) {
        ContextStatePathDescriptor states = this.extractPaths(selector);
        for (Map.Entry<ContextStatePathKey, ContextStatePathValue> entry : states.getPaths().entrySet()) {
            int agentInstanceId = entry.getValue().getOptionalContextPartitionId();
            ContextControllerTreeAgentInstanceList list = this.agentInstances.get(agentInstanceId);
            if (list.getState() == ContextPartitionState.STARTED) continue;
            list.setState(ContextPartitionState.STARTED);
            entry.getValue().setState(ContextPartitionState.STARTED);
            for (Map.Entry<String, ContextControllerStatementDesc> statement : this.statements.entrySet()) {
                AgentInstance instance = this.startStatement(agentInstanceId, statement.getValue(), this.rootContext, list.getInitPartitionKey(), list.getInitContextProperties(), false);
                list.getAgentInstances().add(instance);
            }
            this.rootContext.getFactory().getStateCache().updateContextPath(this.contextName, entry.getKey(), entry.getValue());
        }
        ContextManagerImpl.setState(states.getContextPartitionInformation(), ContextPartitionState.STARTED);
        return states.getContextPartitionInformation();
    }

    @Override
    public void importStartPaths(ContextControllerState state, AgentInstanceSelector agentInstanceSelector) {
        this.rootContext.importContextPartitions(state, 0, null, agentInstanceSelector);
    }

    @Override
    public synchronized boolean handleFilterFault(EventBean theEvent, long version) {
        StatementAgentInstanceUtil.handleFilterFault(theEvent, version, this.servicesContext, this.agentInstances);
        return false;
    }

    private void activate() {
        this.rootContext.activate(null, null, null, null, null);
    }

    private AgentInstance[] getAgentInstancesForStmt(String statementId, ContextPartitionSelector selector) {
        Collection<Integer> agentInstanceIds = this.getAgentInstanceIds(selector);
        if (agentInstanceIds == null || agentInstanceIds.isEmpty()) {
            return new AgentInstance[0];
        }
        ArrayList<AgentInstance> instances = new ArrayList<AgentInstance>(agentInstanceIds.size());
        for (Integer agentInstanceId : agentInstanceIds) {
            ContextControllerTreeAgentInstanceList instancesList = this.agentInstances.get(agentInstanceId);
            if (instancesList == null) continue;
            for (AgentInstance instance : instancesList.getAgentInstances()) {
                if (!instance.getAgentInstanceContext().getStatementContext().getStatementId().equals(statementId)) continue;
                instances.add(instance);
            }
        }
        return instances.toArray(new AgentInstance[instances.size()]);
    }

    private AgentInstance[] getAgentInstancesForStmt(String statementId) {
        ArrayList<AgentInstance> instances = new ArrayList<AgentInstance>();
        for (Map.Entry<Integer, ContextControllerTreeAgentInstanceList> contextPartitionEntry : this.agentInstances.entrySet()) {
            for (AgentInstance instance : contextPartitionEntry.getValue().getAgentInstances()) {
                if (!instance.getAgentInstanceContext().getStatementContext().getStatementId().equals(statementId)) continue;
                instances.add(instance);
            }
        }
        return instances.toArray(new AgentInstance[instances.size()]);
    }

    private void removeStatement(String statementId) {
        ContextControllerStatementDesc statementDesc = this.statements.get(statementId);
        if (statementDesc == null) {
            return;
        }
        for (Map.Entry<Integer, ContextControllerTreeAgentInstanceList> contextPartitionEntry : this.agentInstances.entrySet()) {
            Iterator<AgentInstance> instanceIt = contextPartitionEntry.getValue().getAgentInstances().iterator();
            while (instanceIt.hasNext()) {
                AgentInstance instance = instanceIt.next();
                if (!instance.getAgentInstanceContext().getStatementContext().getStatementId().equals(statementId)) continue;
                StatementAgentInstanceUtil.stop(instance.getStopCallback(), instance.getAgentInstanceContext(), instance.getFinalView(), this.servicesContext, true, false);
                instanceIt.remove();
            }
        }
        this.statements.remove(statementId);
    }

    private AgentInstance startStatement(int contextId, ContextControllerStatementDesc statementDesc, ContextController originator, Object partitionKey, Map<String, Object> contextProperties, boolean isRecoveringResilient) {
        IdentityHashMap<FilterSpecCompiled, FilterValueSetParam[][]> filterAddendum = new IdentityHashMap<FilterSpecCompiled, FilterValueSetParam[][]>();
        originator.getFactory().populateFilterAddendums(filterAddendum, statementDesc, partitionKey, contextId);
        AgentInstanceFilterProxyImpl proxy = new AgentInstanceFilterProxyImpl(filterAddendum);
        contextProperties.put("name", this.contextName);
        contextProperties.put("id", contextId);
        MappedEventBean contextBean = (MappedEventBean)this.servicesContext.getEventAdapterService().adapterForTypedMap(contextProperties, this.contextDescriptor.getContextPropertyRegistry().getContextEventType());
        StatementAgentInstanceFactoryResult result = StatementAgentInstanceUtil.start(this.servicesContext, statementDesc.getStatement(), false, contextId, contextBean, proxy, isRecoveringResilient);
        return new AgentInstance(result.getStopCallback(), result.getAgentInstanceContext(), result.getFinalView());
    }

    protected static void setState(Map<Integer, ContextPartitionDescriptor> original, ContextPartitionState state) {
        for (Map.Entry<Integer, ContextPartitionDescriptor> entry : original.entrySet()) {
            entry.getValue().setState(state);
        }
    }

    public static class ContextNestedHandleImpl
    implements ContextControllerInstanceHandle {
        private final int subPathId;
        private final int contextPartitionId;
        private final ContextControllerTreeAgentInstanceList instances;

        public ContextNestedHandleImpl(int subPathId, int contextPartitionId, ContextControllerTreeAgentInstanceList instances) {
            this.subPathId = subPathId;
            this.contextPartitionId = contextPartitionId;
            this.instances = instances;
        }

        @Override
        public Integer getContextPartitionOrPathId() {
            return this.contextPartitionId;
        }

        @Override
        public ContextControllerTreeAgentInstanceList getInstances() {
            return this.instances;
        }

        @Override
        public int getSubPathId() {
            return this.subPathId;
        }
    }
}

