/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.SafeIterator;
import com.espertech.esper.client.context.ContextPartitionDescriptor;
import com.espertech.esper.client.context.ContextPartitionIdentifier;
import com.espertech.esper.client.context.ContextPartitionIdentifierNested;
import com.espertech.esper.client.context.ContextPartitionSelector;
import com.espertech.esper.client.context.ContextPartitionSelectorAll;
import com.espertech.esper.client.context.ContextPartitionSelectorById;
import com.espertech.esper.client.context.ContextPartitionSelectorNested;
import com.espertech.esper.client.context.ContextPartitionState;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryResult;
import com.espertech.esper.core.context.mgr.AgentInstance;
import com.espertech.esper.core.context.mgr.AgentInstanceArrayIterator;
import com.espertech.esper.core.context.mgr.AgentInstanceArraySafeIterator;
import com.espertech.esper.core.context.mgr.AgentInstanceFilterProxy;
import com.espertech.esper.core.context.mgr.AgentInstanceFilterProxyImpl;
import com.espertech.esper.core.context.mgr.AgentInstanceSelector;
import com.espertech.esper.core.context.mgr.ContextController;
import com.espertech.esper.core.context.mgr.ContextControllerFactory;
import com.espertech.esper.core.context.mgr.ContextControllerFactoryServiceContext;
import com.espertech.esper.core.context.mgr.ContextControllerInstanceHandle;
import com.espertech.esper.core.context.mgr.ContextControllerLifecycleCallback;
import com.espertech.esper.core.context.mgr.ContextControllerState;
import com.espertech.esper.core.context.mgr.ContextControllerStatementBase;
import com.espertech.esper.core.context.mgr.ContextControllerStatementCtxCache;
import com.espertech.esper.core.context.mgr.ContextControllerStatementDesc;
import com.espertech.esper.core.context.mgr.ContextControllerTreeAgentInstanceList;
import com.espertech.esper.core.context.mgr.ContextControllerTreeEntry;
import com.espertech.esper.core.context.mgr.ContextInternalFilterAddendum;
import com.espertech.esper.core.context.mgr.ContextManager;
import com.espertech.esper.core.context.mgr.ContextManagerImpl;
import com.espertech.esper.core.context.mgr.ContextManagerNestedInstanceHandle;
import com.espertech.esper.core.context.mgr.ContextPartitionIdManager;
import com.espertech.esper.core.context.mgr.ContextPartitionVisitorAgentInstanceIdWPath;
import com.espertech.esper.core.context.mgr.ContextPartitionVisitorStateWithPath;
import com.espertech.esper.core.context.mgr.ContextPartitionVisitorWithPath;
import com.espertech.esper.core.context.mgr.ContextPropertyEventType;
import com.espertech.esper.core.context.mgr.ContextPropertyRegistryImpl;
import com.espertech.esper.core.context.mgr.ContextStatePathDescriptor;
import com.espertech.esper.core.context.mgr.ContextStatePathKey;
import com.espertech.esper.core.context.mgr.ContextStatePathValue;
import com.espertech.esper.core.context.stmt.AIRegistryAggregationMap;
import com.espertech.esper.core.context.stmt.AIRegistryExprMap;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistry;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistryFactory;
import com.espertech.esper.core.context.util.ContextControllerSelectorUtil;
import com.espertech.esper.core.context.util.ContextDescriptor;
import com.espertech.esper.core.context.util.ContextIteratorHandler;
import com.espertech.esper.core.context.util.StatementAgentInstanceUtil;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.ContextDetailPartitionItem;
import com.espertech.esper.event.MappedEventBean;
import com.espertech.esper.filter.FilterFaultHandler;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecLookupable;
import com.espertech.esper.filter.FilterValueSetParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContextManagerNested
implements ContextManager,
ContextControllerLifecycleCallback,
ContextIteratorHandler,
FilterFaultHandler {
    private static final Log log = LogFactory.getLog(ContextManagerNested.class);
    private final String contextName;
    private final EPServicesContext servicesContext;
    private final ContextControllerFactory[] nestedContextFactories;
    private final Map<String, ContextControllerStatementDesc> statements = new LinkedHashMap<String, ContextControllerStatementDesc>();
    private final ContextDescriptor contextDescriptor;
    private ContextController rootContext;
    private final Map<ContextController, ContextControllerTreeEntry> subcontexts = new HashMap<ContextController, ContextControllerTreeEntry>();
    private final ContextPartitionIdManager contextPartitionIdManager;

    public ContextManagerNested(ContextControllerFactoryServiceContext factoryServiceContext) throws ExprValidationException {
        this.contextName = factoryServiceContext.getContextName();
        this.servicesContext = factoryServiceContext.getServicesContext();
        this.contextPartitionIdManager = factoryServiceContext.getAgentInstanceContextCreate().getStatementContext().getContextControllerFactoryService().allocatePartitionIdMgr(this.contextName, factoryServiceContext.getAgentInstanceContextCreate().getStatementContext().getStatementId());
        this.nestedContextFactories = factoryServiceContext.getAgentInstanceContextCreate().getStatementContext().getContextControllerFactoryService().getFactory(factoryServiceContext);
        StatementAIResourceRegistryFactory resourceRegistryFactory = new StatementAIResourceRegistryFactory(){

            @Override
            public StatementAIResourceRegistry make() {
                return new StatementAIResourceRegistry(new AIRegistryAggregationMap(), new AIRegistryExprMap());
            }
        };
        Map<String, Object> contextProps = ContextPropertyEventType.getNestedTypeBase();
        for (ContextControllerFactory factory : this.nestedContextFactories) {
            contextProps.put(factory.getFactoryContext().getContextName(), factory.getContextBuiltinProps());
        }
        EventType contextPropsType = this.servicesContext.getEventAdapterService().createAnonymousMapType(this.contextName, contextProps);
        ContextPropertyRegistryImpl registry = new ContextPropertyRegistryImpl(Collections.<ContextDetailPartitionItem>emptyList(), contextPropsType);
        this.contextDescriptor = new ContextDescriptor(this.contextName, false, registry, resourceRegistryFactory, this, factoryServiceContext.getDetail());
    }

    @Override
    public Map<String, ContextControllerStatementDesc> getStatements() {
        return this.statements;
    }

    @Override
    public ContextDescriptor getContextDescriptor() {
        return this.contextDescriptor;
    }

    @Override
    public int getNumNestingLevels() {
        return this.nestedContextFactories.length;
    }

    @Override
    public synchronized Iterator<EventBean> iterator(String statementId, ContextPartitionSelector selector) {
        AgentInstance[] instances = this.getAgentInstancesForStmt(statementId, selector);
        return new AgentInstanceArrayIterator(instances);
    }

    @Override
    public synchronized SafeIterator<EventBean> safeIterator(String statementId, ContextPartitionSelector selector) {
        AgentInstance[] instances = this.getAgentInstancesForStmt(statementId, selector);
        return new AgentInstanceArraySafeIterator(instances);
    }

    @Override
    public Collection<Integer> getAgentInstanceIds(ContextPartitionSelector contextPartitionSelector) {
        return this.getAgentInstancesForSelector(contextPartitionSelector);
    }

    @Override
    public void importStartPaths(ContextControllerState state, AgentInstanceSelector agentInstanceSelector) {
        this.rootContext.importContextPartitions(state, 0, null, agentInstanceSelector);
    }

    protected static ContextPartitionIdentifier[] getTreeCompositeKey(ContextControllerFactory[] nestedContextFactories, Object initPartitionKey, ContextControllerTreeEntry treeEntry, Map<ContextController, ContextControllerTreeEntry> subcontexts) {
        int length = nestedContextFactories.length;
        ContextPartitionIdentifier[] keys = new ContextPartitionIdentifier[length];
        keys[length - 1] = nestedContextFactories[length - 1].keyPayloadToIdentifier(initPartitionKey);
        keys[length - 2] = nestedContextFactories[length - 2].keyPayloadToIdentifier(treeEntry.getInitPartitionKey());
        if (length > 2) {
            ContextController parent = treeEntry.getParent();
            ContextControllerTreeEntry parentEntry = subcontexts.get(parent);
            for (int i = 0; i < length - 2; ++i) {
                keys[length - 2 - i] = nestedContextFactories[length - 2 - i].keyPayloadToIdentifier(parentEntry.getInitPartitionKey());
                parent = parentEntry.getParent();
                parentEntry = subcontexts.get(parent);
            }
        }
        return keys;
    }

    @Override
    public ContextStatePathDescriptor extractPaths(ContextPartitionSelector selector) {
        ContextPartitionVisitorStateWithPath visitor = this.getContextPartitionPathsInternal(selector);
        return new ContextStatePathDescriptor(visitor.getStates(), visitor.getAgentInstanceInfo());
    }

    @Override
    public ContextStatePathDescriptor extractStopPaths(ContextPartitionSelector selector) {
        ContextPartitionVisitorStateWithPath visitor = this.getContextPartitionPathsInternal(selector);
        for (Map.Entry<ContextController, List<ContextPartitionVisitorStateWithPath.LeafDesc>> entry : visitor.getControllerAgentInstances().entrySet()) {
            ContextControllerTreeEntry treeEntry = this.subcontexts.get(entry.getKey());
            for (ContextPartitionVisitorStateWithPath.LeafDesc leaf : entry.getValue()) {
                int agentInstanceId = leaf.getValue().getOptionalContextPartitionId();
                ContextControllerTreeAgentInstanceList list = treeEntry.getAgentInstances().get(agentInstanceId);
                list.setState(ContextPartitionState.STOPPED);
                StatementAgentInstanceUtil.stopAgentInstances(list.getAgentInstances(), null, this.servicesContext, false, false);
                list.clearAgentInstances();
                leaf.getValue().setState(ContextPartitionState.STOPPED);
                this.rootContext.getFactory().getStateCache().updateContextPath(this.contextName, leaf.getKey(), leaf.getValue());
            }
        }
        return new ContextStatePathDescriptor(visitor.getStates(), visitor.getAgentInstanceInfo());
    }

    @Override
    public ContextStatePathDescriptor extractDestroyPaths(ContextPartitionSelector selector) {
        ContextPartitionVisitorStateWithPath visitor = this.getContextPartitionPathsInternal(selector);
        for (Map.Entry<ContextController, List<ContextPartitionVisitorStateWithPath.LeafDesc>> entry : visitor.getControllerAgentInstances().entrySet()) {
            ContextControllerTreeEntry treeEntry = this.subcontexts.get(entry.getKey());
            for (ContextPartitionVisitorStateWithPath.LeafDesc leaf : entry.getValue()) {
                int agentInstanceId = leaf.getValue().getOptionalContextPartitionId();
                ContextControllerTreeAgentInstanceList list = treeEntry.getAgentInstances().get(agentInstanceId);
                StatementAgentInstanceUtil.stopAgentInstances(list.getAgentInstances(), null, this.servicesContext, false, false);
                this.rootContext.getFactory().getStateCache().removeContextPath(this.contextName, leaf.getKey().getLevel(), leaf.getKey().getParentPath(), leaf.getKey().getSubPath());
                ContextPartitionDescriptor descriptor = visitor.getAgentInstanceInfo().get(agentInstanceId);
                ContextPartitionIdentifierNested nestedIdent = (ContextPartitionIdentifierNested)descriptor.getIdentifier();
                entry.getKey().deletePath(nestedIdent.getIdentifiers()[this.nestedContextFactories.length - 1]);
            }
        }
        return new ContextStatePathDescriptor(visitor.getStates(), visitor.getAgentInstanceInfo());
    }

    @Override
    public Map<Integer, ContextPartitionDescriptor> startPaths(ContextPartitionSelector selector) {
        ContextPartitionVisitorStateWithPath visitor = this.getContextPartitionPathsInternal(selector);
        for (Map.Entry<ContextController, List<ContextPartitionVisitorStateWithPath.LeafDesc>> entry : visitor.getControllerAgentInstances().entrySet()) {
            ContextControllerTreeEntry treeEntry = this.subcontexts.get(entry.getKey());
            for (ContextPartitionVisitorStateWithPath.LeafDesc leaf : entry.getValue()) {
                int agentInstanceId = leaf.getValue().getOptionalContextPartitionId();
                ContextControllerTreeAgentInstanceList list = treeEntry.getAgentInstances().get(agentInstanceId);
                if (list.getState() == ContextPartitionState.STARTED) continue;
                for (Map.Entry<String, ContextControllerStatementDesc> statement : this.statements.entrySet()) {
                    AgentInstance instance = this.startStatement(agentInstanceId, statement.getValue(), this.rootContext, list.getInitPartitionKey(), list.getInitContextProperties(), false);
                    list.getAgentInstances().add(instance);
                }
                list.setState(ContextPartitionState.STARTED);
                leaf.getValue().setState(ContextPartitionState.STARTED);
                this.rootContext.getFactory().getStateCache().updateContextPath(this.contextName, leaf.getKey(), leaf.getValue());
            }
        }
        ContextManagerImpl.setState(visitor.getAgentInstanceInfo(), ContextPartitionState.STARTED);
        return visitor.getAgentInstanceInfo();
    }

    public ContextPartitionVisitorStateWithPath getContextPartitionPathsInternal(ContextPartitionSelector selector) {
        List<Object[]> selectors;
        ContextPartitionVisitorStateWithPath visitor = new ContextPartitionVisitorStateWithPath(this.nestedContextFactories, this.subcontexts);
        if (selector instanceof ContextPartitionSelectorNested) {
            ContextPartitionSelectorNested nested = (ContextPartitionSelectorNested)selector;
            selectors = nested.getSelectors();
        } else if (selector instanceof ContextPartitionSelectorAll) {
            Object[] all = new ContextPartitionSelector[this.getNumNestingLevels()];
            Arrays.fill(all, selector);
            selectors = Collections.singletonList(all);
        } else {
            throw new IllegalArgumentException("Invalid selector for nested context");
        }
        for (ContextPartitionSelector[] item : selectors) {
            this.recursivePopulateSelector(this.rootContext, 1, item, visitor);
        }
        return visitor;
    }

    @Override
    public void addStatement(ContextControllerStatementBase statement, boolean isRecoveringResilient) throws ExprValidationException {
        ContextControllerStatementCtxCache[] caches = new ContextControllerStatementCtxCache[this.nestedContextFactories.length];
        for (int i = 0; i < this.nestedContextFactories.length; ++i) {
            ContextControllerFactory nested = this.nestedContextFactories[i];
            caches[i] = nested.validateStatement(statement);
        }
        ContextControllerStatementDesc desc = new ContextControllerStatementDesc(statement, caches);
        this.statements.put(statement.getStatementContext().getStatementId(), desc);
        if (this.statements.size() == 1) {
            this.activate();
        } else {
            for (Map.Entry<ContextController, ContextControllerTreeEntry> subcontext : this.subcontexts.entrySet()) {
                if (subcontext.getKey().getFactory().getFactoryContext().getNestingLevel() != this.nestedContextFactories.length || subcontext.getValue().getAgentInstances() == null || subcontext.getValue().getAgentInstances().isEmpty()) continue;
                for (Map.Entry<Integer, ContextControllerTreeAgentInstanceList> entry : subcontext.getValue().getAgentInstances().entrySet()) {
                    if (entry.getValue().getState() != ContextPartitionState.STARTED) continue;
                    AgentInstance agentInstance = this.startStatement(entry.getKey(), desc, subcontext.getKey(), entry.getValue().getInitPartitionKey(), entry.getValue().getInitContextProperties(), isRecoveringResilient);
                    entry.getValue().getAgentInstances().add(agentInstance);
                }
            }
        }
    }

    @Override
    public synchronized void stopStatement(String statementName, String statementId) {
        this.destroyStatement(statementName, statementId);
    }

    @Override
    public synchronized void destroyStatement(String statementName, String statementId) {
        if (!this.statements.containsKey(statementId)) {
            return;
        }
        if (this.statements.size() == 1) {
            this.safeDestroy();
        } else {
            this.removeStatement(statementId);
        }
    }

    @Override
    public void safeDestroy() {
        if (this.rootContext != null) {
            this.recursiveDeactivateStop(this.rootContext, false, null);
            this.nestedContextFactories[0].getStateCache().removeContext(this.contextName);
            this.rootContext = null;
            this.statements.clear();
            this.subcontexts.clear();
            this.contextPartitionIdManager.clear();
        }
    }

    @Override
    public FilterSpecLookupable getFilterLookupable(EventType eventType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void contextPartitionNavigate(ContextControllerInstanceHandle existingHandle, ContextController originator, ContextControllerState controllerState, int exportedCPOrPathId, ContextInternalFilterAddendum filterAddendum, AgentInstanceSelector agentInstanceSelector, byte[] payload) {
        ContextManagerNestedInstanceHandle nestedHandle = (ContextManagerNestedInstanceHandle)existingHandle;
        int nestingLevel = originator.getFactory().getFactoryContext().getNestingLevel();
        if (nestingLevel < this.nestedContextFactories.length) {
            nestedHandle.getController().importContextPartitions(controllerState, exportedCPOrPathId, filterAddendum, agentInstanceSelector);
            return;
        }
        ContextControllerTreeEntry entry = this.subcontexts.get(originator);
        if (entry == null) {
            return;
        }
        for (Map.Entry<Integer, ContextControllerTreeAgentInstanceList> cpEntry : entry.getAgentInstances().entrySet()) {
            if (cpEntry.getValue().getState() == ContextPartitionState.STOPPED) {
                cpEntry.getValue().setState(ContextPartitionState.STARTED);
                entry.getAgentInstances().clear();
                for (Map.Entry<String, ContextControllerStatementDesc> statement : this.statements.entrySet()) {
                    AgentInstance instance = this.startStatement(existingHandle.getContextPartitionOrPathId(), statement.getValue(), originator, cpEntry.getValue().getInitPartitionKey(), entry.getInitContextProperties(), false);
                    cpEntry.getValue().getAgentInstances().add(instance);
                }
                ContextStatePathKey key = new ContextStatePathKey(this.nestedContextFactories.length, originator.getPathId(), existingHandle.getSubPathId());
                ContextStatePathValue value = new ContextStatePathValue(existingHandle.getContextPartitionOrPathId(), payload, ContextPartitionState.STARTED);
                originator.getFactory().getStateCache().updateContextPath(this.contextName, key, value);
                continue;
            }
            ArrayList<AgentInstance> removed = new ArrayList<AgentInstance>(2);
            ArrayList<AgentInstance> added = new ArrayList<AgentInstance>(2);
            List<AgentInstance> current = cpEntry.getValue().getAgentInstances();
            for (AgentInstance agentInstance : current) {
                if (!agentInstanceSelector.select(agentInstance)) continue;
                StatementAgentInstanceUtil.stopAgentInstance(agentInstance, null, this.servicesContext, false, false);
                removed.add(agentInstance);
                ContextControllerStatementDesc statementDesc = this.statements.get(agentInstance.getAgentInstanceContext().getStatementId());
                AgentInstance instance = this.startStatement(cpEntry.getKey(), statementDesc, originator, cpEntry.getValue().getInitPartitionKey(), entry.getInitContextProperties(), false);
                added.add(instance);
                if (controllerState.getPartitionImportCallback() == null) continue;
                controllerState.getPartitionImportCallback().existing(existingHandle.getContextPartitionOrPathId(), exportedCPOrPathId);
            }
            current.removeAll(removed);
            current.addAll(added);
        }
    }

    @Override
    public synchronized ContextControllerInstanceHandle contextPartitionInstantiate(Integer optionalContextPartitionId, int subPathId, Integer importSubpathId, ContextController originator, EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, Object partitionKey, Map<String, Object> contextProperties, ContextControllerState states, ContextInternalFilterAddendum filterAddendum, boolean isRecoveringResilient, ContextPartitionState state) {
        ContextControllerTreeEntry entry;
        int assignedContextId;
        int nestingLevel = originator.getFactory().getFactoryContext().getNestingLevel();
        if (nestingLevel < this.nestedContextFactories.length) {
            ContextControllerFactory nextFactory = this.nestedContextFactories[originator.getFactory().getFactoryContext().getNestingLevel()];
            ContextController nextContext = nextFactory.createNoCallback(subPathId, this);
            ContextControllerTreeEntry branch = this.subcontexts.get(originator);
            if (branch.getChildContexts() == null) {
                branch.setChildContexts(new HashMap<Integer, ContextController>());
            }
            branch.getChildContexts().put(subPathId, nextContext);
            ContextControllerTreeEntry entry2 = new ContextControllerTreeEntry(originator, null, partitionKey, contextProperties);
            this.subcontexts.put(nextContext, entry2);
            nextContext.activate(optionalTriggeringEvent, optionalTriggeringPattern, states, filterAddendum, importSubpathId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Instantiating branch context path for " + this.contextName + " from level " + originator.getFactory().getFactoryContext().getNestingLevel() + "(" + originator.getFactory().getFactoryContext().getContextName() + ")" + " parentPath " + originator.getPathId() + " for level " + nextContext.getFactory().getFactoryContext().getNestingLevel() + "(" + nextContext.getFactory().getFactoryContext().getContextName() + ")" + " childPath " + subPathId));
            }
            return new ContextManagerNestedInstanceHandle(subPathId, nextContext, subPathId, true, null);
        }
        if (optionalContextPartitionId != null && !states.isImported()) {
            assignedContextId = optionalContextPartitionId;
            this.contextPartitionIdManager.addExisting(optionalContextPartitionId);
        } else {
            assignedContextId = this.contextPartitionIdManager.allocateId();
            if (states != null && states.getPartitionImportCallback() != null && optionalContextPartitionId != null) {
                states.getPartitionImportCallback().allocated(assignedContextId, optionalContextPartitionId);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Instantiating agent instance for " + this.contextName + " from level " + originator.getFactory().getFactoryContext().getNestingLevel() + "(" + originator.getFactory().getFactoryContext().getContextName() + ")" + " parentPath " + originator.getPathId() + " contextPartId " + assignedContextId));
        }
        ArrayList<AgentInstance> newInstances = new ArrayList<AgentInstance>();
        if (state == ContextPartitionState.STARTED) {
            for (Map.Entry<String, ContextControllerStatementDesc> statementEntry : this.statements.entrySet()) {
                ContextControllerStatementDesc statementDesc = statementEntry.getValue();
                AgentInstance instance = this.startStatement(assignedContextId, statementDesc, originator, partitionKey, contextProperties, isRecoveringResilient);
                newInstances.add(instance);
            }
        }
        if (optionalTriggeringEvent != null) {
            StatementAgentInstanceUtil.evaluateEventForStatement(this.servicesContext, optionalTriggeringEvent, optionalTriggeringPattern, newInstances);
        }
        if ((entry = this.subcontexts.get(originator)).getAgentInstances() == null) {
            entry.setAgentInstances(new LinkedHashMap<Integer, ContextControllerTreeAgentInstanceList>());
        }
        long filterVersion = this.servicesContext.getFilterService().getFiltersVersion();
        ContextControllerTreeAgentInstanceList agentInstanceList = new ContextControllerTreeAgentInstanceList(filterVersion, partitionKey, contextProperties, newInstances, state);
        entry.getAgentInstances().put(assignedContextId, agentInstanceList);
        return new ContextManagerNestedInstanceHandle(subPathId, originator, assignedContextId, false, agentInstanceList);
    }

    @Override
    public synchronized boolean handleFilterFault(EventBean theEvent, long version) {
        for (Map.Entry<ContextController, ContextControllerTreeEntry> entry : this.subcontexts.entrySet()) {
            if (entry.getValue().getAgentInstances() == null) continue;
            StatementAgentInstanceUtil.handleFilterFault(theEvent, version, this.servicesContext, entry.getValue().getAgentInstances());
        }
        return false;
    }

    @Override
    public void contextPartitionTerminate(ContextControllerInstanceHandle contextNestedHandle, Map<String, Object> terminationProperties, boolean leaveLocksAcquired, List<AgentInstance> agentInstances) {
        ContextManagerNestedInstanceHandle handle = (ContextManagerNestedInstanceHandle)contextNestedHandle;
        if (handle.isBranch()) {
            ContextManagerNestedInstanceHandle branchHandle = handle;
            ContextController branch = branchHandle.getController();
            this.recursiveDeactivateStop(branch, leaveLocksAcquired, agentInstances);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Terminated context branch for " + this.contextName + " from level " + branch.getFactory().getFactoryContext().getNestingLevel() + "(" + branch.getFactory().getFactoryContext().getContextName() + ")" + " parentPath " + branch.getPathId()));
            }
        } else {
            ContextManagerNestedInstanceHandle leafHandle = handle;
            ContextController leaf = leafHandle.getController();
            ContextControllerTreeEntry leafEntry = this.subcontexts.get(leaf);
            if (leafEntry != null) {
                ContextControllerTreeAgentInstanceList ailist = leafEntry.getAgentInstances().get(leafHandle.getContextPartitionOrPathId());
                if (ailist != null) {
                    StatementAgentInstanceUtil.stopAgentInstances(ailist.getAgentInstances(), null, this.servicesContext, false, false);
                    this.contextPartitionIdManager.removeId(leafHandle.getContextPartitionOrPathId());
                    ailist.getAgentInstances().clear();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Terminated context leaf for " + this.contextName + " from level " + leaf.getFactory().getFactoryContext().getNestingLevel() + "(" + leaf.getFactory().getFactoryContext().getContextName() + ")" + " parentPath " + leaf.getPathId() + " contextPartId " + leafHandle.getContextPartitionOrPathId()));
                }
            }
        }
    }

    @Override
    public synchronized Iterator<EventBean> iterator(String statementId) {
        AgentInstance[] instances = this.getAgentInstancesForStmt(statementId);
        return new AgentInstanceArrayIterator(instances);
    }

    @Override
    public synchronized SafeIterator<EventBean> safeIterator(String statementId) {
        AgentInstance[] instances = this.getAgentInstancesForStmt(statementId);
        return new AgentInstanceArraySafeIterator(instances);
    }

    private AgentInstance startStatement(int contextId, ContextControllerStatementDesc statementDesc, ContextController originator, Object partitionKey, Map<String, Object> contextProperties, boolean isRecoveringResilient) {
        AgentInstanceFilterProxy proxy = this.getMergedFilterAddendums(statementDesc, originator, partitionKey, contextId);
        Map<String, Object> properties = ContextPropertyEventType.getNestedBeanBase(this.contextName, contextId);
        properties.put(this.nestedContextFactories[this.nestedContextFactories.length - 1].getFactoryContext().getContextName(), contextProperties);
        this.recursivePopulateBuiltinProps(originator, properties);
        properties.put("name", this.contextName);
        properties.put("id", contextId);
        MappedEventBean contextBean = (MappedEventBean)this.servicesContext.getEventAdapterService().adapterForTypedMap(properties, this.contextDescriptor.getContextPropertyRegistry().getContextEventType());
        StatementAgentInstanceFactoryResult result = StatementAgentInstanceUtil.start(this.servicesContext, statementDesc.getStatement(), false, contextId, contextBean, proxy, isRecoveringResilient);
        return new AgentInstance(result.getStopCallback(), result.getAgentInstanceContext(), result.getFinalView());
    }

    private void recursivePopulateBuiltinProps(ContextController originator, Map<String, Object> properties) {
        ContextControllerTreeEntry entry = this.subcontexts.get(originator);
        if (entry.getInitContextProperties() != null) {
            properties.put(entry.getParent().getFactory().getFactoryContext().getContextName(), entry.getInitContextProperties());
        }
        if (entry.getParent() != null && entry.getParent().getFactory().getFactoryContext().getNestingLevel() > 1) {
            this.recursivePopulateBuiltinProps(entry.getParent(), properties);
        }
    }

    private AgentInstanceFilterProxy getMergedFilterAddendums(ContextControllerStatementDesc statement, ContextController originator, Object partitionKey, int contextId) {
        IdentityHashMap<FilterSpecCompiled, FilterValueSetParam[][]> result = new IdentityHashMap<FilterSpecCompiled, FilterValueSetParam[][]>();
        originator.getFactory().populateFilterAddendums(result, statement, partitionKey, contextId);
        ContextControllerTreeEntry originatorEntry = this.subcontexts.get(originator);
        if (originatorEntry != null) {
            this.recursivePopulateFilterAddendum(statement, originatorEntry, contextId, result);
        }
        return new AgentInstanceFilterProxyImpl(result);
    }

    private void recursivePopulateFilterAddendum(ContextControllerStatementDesc statement, ContextControllerTreeEntry originatorEntry, int contextId, IdentityHashMap<FilterSpecCompiled, FilterValueSetParam[][]> result) {
        if (originatorEntry.getParent() == null) {
            return;
        }
        originatorEntry.getParent().getFactory().populateFilterAddendums(result, statement, originatorEntry.getInitPartitionKey(), contextId);
        ContextControllerTreeEntry parentEntry = this.subcontexts.get(originatorEntry.getParent());
        if (parentEntry != null) {
            this.recursivePopulateFilterAddendum(statement, parentEntry, contextId, result);
        }
    }

    private void activate() {
        this.rootContext = this.nestedContextFactories[0].createNoCallback(0, this);
        this.subcontexts.put(this.rootContext, new ContextControllerTreeEntry(null, null, null, null));
        this.rootContext.activate(null, null, null, null, null);
    }

    private void removeStatement(String statementId) {
        ContextControllerStatementDesc statementDesc = this.statements.get(statementId);
        if (statementDesc == null) {
            return;
        }
        for (Map.Entry<ContextController, ContextControllerTreeEntry> entry : this.subcontexts.entrySet()) {
            if (entry.getKey().getFactory().getFactoryContext().getNestingLevel() < this.nestedContextFactories.length || entry.getValue().getAgentInstances() == null || entry.getValue().getAgentInstances().isEmpty()) continue;
            for (Map.Entry<Integer, ContextControllerTreeAgentInstanceList> contextPartitionEntry : entry.getValue().getAgentInstances().entrySet()) {
                Iterator<AgentInstance> instanceIt = contextPartitionEntry.getValue().getAgentInstances().iterator();
                while (instanceIt.hasNext()) {
                    AgentInstance instance = instanceIt.next();
                    if (!instance.getAgentInstanceContext().getStatementContext().getStatementId().equals(statementId)) continue;
                    StatementAgentInstanceUtil.stop(instance.getStopCallback(), instance.getAgentInstanceContext(), instance.getFinalView(), this.servicesContext, true, false);
                    instanceIt.remove();
                }
            }
        }
        this.statements.remove(statementId);
    }

    private void recursiveDeactivateStop(ContextController currentContext, boolean leaveLocksAcquired, List<AgentInstance> agentInstancesCollected) {
        currentContext.deactivate();
        ContextControllerTreeEntry entry = this.subcontexts.remove(currentContext);
        if (entry == null) {
            return;
        }
        ContextControllerTreeEntry parent = this.subcontexts.get(entry.getParent());
        if (parent != null) {
            parent.getChildContexts().remove(currentContext.getPathId());
        }
        if (entry.getAgentInstances() != null) {
            for (Map.Entry<Integer, ContextControllerTreeAgentInstanceList> entryCP : entry.getAgentInstances().entrySet()) {
                StatementAgentInstanceUtil.stopAgentInstances(entryCP.getValue().getAgentInstances(), null, this.servicesContext, false, leaveLocksAcquired);
                if (agentInstancesCollected != null) {
                    agentInstancesCollected.addAll(entryCP.getValue().getAgentInstances());
                }
                this.contextPartitionIdManager.removeId(entryCP.getKey());
            }
        }
        if (entry.getChildContexts() == null || entry.getChildContexts().isEmpty()) {
            return;
        }
        for (ContextController inner : entry.getChildContexts().values()) {
            this.recursiveDeactivateStop(inner, leaveLocksAcquired, agentInstancesCollected);
        }
    }

    private AgentInstance[] getAgentInstancesForStmt(String statementId) {
        ArrayList<AgentInstance> instances = new ArrayList<AgentInstance>();
        for (Map.Entry<ContextController, ContextControllerTreeEntry> subcontext : this.subcontexts.entrySet()) {
            if (subcontext.getKey().getFactory().getFactoryContext().getNestingLevel() != this.nestedContextFactories.length || subcontext.getValue().getAgentInstances() == null || subcontext.getValue().getAgentInstances().isEmpty()) continue;
            for (Map.Entry<Integer, ContextControllerTreeAgentInstanceList> entry : subcontext.getValue().getAgentInstances().entrySet()) {
                for (AgentInstance ai : entry.getValue().getAgentInstances()) {
                    if (!ai.getAgentInstanceContext().getStatementContext().getStatementId().equals(statementId)) continue;
                    instances.add(ai);
                }
            }
        }
        return instances.toArray(new AgentInstance[instances.size()]);
    }

    private AgentInstance[] getAgentInstancesForStmt(String statementId, ContextPartitionSelector selector) {
        Collection<Integer> agentInstanceIds = this.getAgentInstancesForSelector(selector);
        if (agentInstanceIds == null || agentInstanceIds.isEmpty()) {
            return new AgentInstance[0];
        }
        ArrayList<AgentInstance> instances = new ArrayList<AgentInstance>(agentInstanceIds.size());
        for (Map.Entry<ContextController, ContextControllerTreeEntry> subcontext : this.subcontexts.entrySet()) {
            if (subcontext.getKey().getFactory().getFactoryContext().getNestingLevel() != this.nestedContextFactories.length || subcontext.getValue().getAgentInstances() == null || subcontext.getValue().getAgentInstances().isEmpty()) continue;
            for (Integer agentInstanceId : agentInstanceIds) {
                ContextControllerTreeAgentInstanceList instancesList = subcontext.getValue().getAgentInstances().get(agentInstanceId);
                if (instancesList == null) continue;
                for (AgentInstance instance : instancesList.getAgentInstances()) {
                    if (!instance.getAgentInstanceContext().getStatementContext().getStatementId().equals(statementId)) continue;
                    instances.add(instance);
                }
            }
        }
        return instances.toArray(new AgentInstance[instances.size()]);
    }

    private Collection<Integer> getAgentInstancesForSelector(ContextPartitionSelector selector) {
        if (selector instanceof ContextPartitionSelectorById) {
            ContextPartitionSelectorById byId = (ContextPartitionSelectorById)selector;
            Set<Integer> ids = byId.getContextPartitionIds();
            if (ids == null || ids.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Integer> agentInstanceIds = new ArrayList<Integer>(ids);
            agentInstanceIds.retainAll(this.contextPartitionIdManager.getIds());
            return agentInstanceIds;
        }
        if (selector instanceof ContextPartitionSelectorAll) {
            return new ArrayList<Integer>(this.contextPartitionIdManager.getIds());
        }
        if (selector instanceof ContextPartitionSelectorNested) {
            ContextPartitionSelectorNested nested = (ContextPartitionSelectorNested)selector;
            ContextPartitionVisitorAgentInstanceIdWPath visitor = new ContextPartitionVisitorAgentInstanceIdWPath(this.nestedContextFactories.length);
            for (ContextPartitionSelector[] item : nested.getSelectors()) {
                this.recursivePopulateSelector(this.rootContext, 1, item, visitor);
            }
            return visitor.getAgentInstanceIds();
        }
        throw ContextControllerSelectorUtil.getInvalidSelector(new Class[]{ContextPartitionSelectorNested.class}, selector, true);
    }

    private void recursivePopulateSelector(ContextController currentContext, int level, ContextPartitionSelector[] selectorStack, ContextPartitionVisitorWithPath visitor) {
        ContextControllerTreeEntry entry = this.subcontexts.get(currentContext);
        if (entry == null) {
            return;
        }
        ContextPartitionSelector selector = selectorStack[level - 1];
        if (level < this.nestedContextFactories.length) {
            visitor.resetSubPaths();
            currentContext.visitSelectedPartitions(selector, visitor);
            ArrayList<Integer> selectedPaths = new ArrayList<Integer>(visitor.getSubpaths());
            for (Integer path : selectedPaths) {
                ContextController controller = entry.getChildContexts().get(path);
                if (controller == null) continue;
                this.recursivePopulateSelector(controller, level + 1, selectorStack, visitor);
            }
        } else {
            currentContext.visitSelectedPartitions(selector, visitor);
        }
    }
}

