/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.subselect;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.factory.StatementAgentInstancePostLoad;
import com.espertech.esper.core.context.factory.StatementAgentInstancePostLoadIndexVisitor;
import com.espertech.esper.core.context.subselect.SubSelectActivationHolder;
import com.espertech.esper.core.context.subselect.SubSelectStrategyFactory;
import com.espertech.esper.core.context.subselect.SubSelectStrategyRealization;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.start.EPStatementStartMethodHelperPrevious;
import com.espertech.esper.core.start.EPStatementStartMethodHelperPrior;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.agg.service.AggregationServiceFactoryDesc;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.core.ViewResourceDelegateVerified;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.prev.ExprPreviousEvalStrategy;
import com.espertech.esper.epl.expression.prev.ExprPreviousNode;
import com.espertech.esper.epl.expression.prior.ExprPriorEvalStrategy;
import com.espertech.esper.epl.expression.prior.ExprPriorNode;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableFactory;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategy;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategyFactory;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategyNullRow;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.named.NamedWindowProcessorInstance;
import com.espertech.esper.epl.named.NamedWindowTailViewInstance;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.subquery.SubqueryStopCallback;
import com.espertech.esper.epl.subquery.SubselectAggregationPreprocessorBase;
import com.espertech.esper.epl.subquery.SubselectAggregationPreprocessorFilteredGrouped;
import com.espertech.esper.epl.subquery.SubselectAggregationPreprocessorFilteredUngrouped;
import com.espertech.esper.epl.subquery.SubselectAggregationPreprocessorUnfilteredGrouped;
import com.espertech.esper.epl.subquery.SubselectAggregationPreprocessorUnfilteredUngrouped;
import com.espertech.esper.epl.subquery.SubselectAggregatorViewBase;
import com.espertech.esper.epl.subquery.SubselectAggregatorViewFilteredGrouped;
import com.espertech.esper.epl.subquery.SubselectAggregatorViewFilteredUngrouped;
import com.espertech.esper.epl.subquery.SubselectAggregatorViewUnfilteredGrouped;
import com.espertech.esper.epl.subquery.SubselectAggregatorViewUnfilteredUngrouped;
import com.espertech.esper.epl.subquery.SubselectBufferObserver;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecCompiler;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewServiceCreateResult;
import com.espertech.esper.view.Viewable;
import com.espertech.esper.view.internal.BufferView;
import com.espertech.esper.view.internal.PriorEventViewFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SubSelectStrategyFactoryLocalViewPreloaded
implements SubSelectStrategyFactory {
    private static Log log = LogFactory.getLog(SubSelectStrategyFactoryLocalViewPreloaded.class);
    private static final SubordTableLookupStrategyNullRow NULL_ROW_STRATEGY = new SubordTableLookupStrategyNullRow();
    private final int subqueryNumber;
    private final SubSelectActivationHolder subSelectHolder;
    private final Pair<EventTableFactory, SubordTableLookupStrategyFactory> pair;
    private final ExprNode filterExprNode;
    private final ExprEvaluator filterExprEval;
    private final boolean correlatedSubquery;
    private final AggregationServiceFactoryDesc aggregationServiceFactory;
    private final ViewResourceDelegateVerified viewResourceDelegate;
    private final ExprEvaluator[] groupKeys;

    public SubSelectStrategyFactoryLocalViewPreloaded(int subqueryNumber, SubSelectActivationHolder subSelectHolder, Pair<EventTableFactory, SubordTableLookupStrategyFactory> pair, ExprNode filterExprNode, ExprEvaluator filterExprEval, boolean correlatedSubquery, AggregationServiceFactoryDesc aggregationServiceFactory, ViewResourceDelegateVerified viewResourceDelegate, ExprEvaluator[] groupKeys) {
        this.subqueryNumber = subqueryNumber;
        this.subSelectHolder = subSelectHolder;
        this.pair = pair;
        this.filterExprNode = filterExprNode;
        this.filterExprEval = filterExprEval;
        this.correlatedSubquery = correlatedSubquery;
        this.aggregationServiceFactory = aggregationServiceFactory;
        this.viewResourceDelegate = viewResourceDelegate;
        this.groupKeys = groupKeys;
    }

    @Override
    public SubSelectStrategyRealization instantiate(final EPServicesContext services, Viewable viewableRoot, final AgentInstanceContext agentInstanceContext, List<StopCallback> stopCallbackList) {
        boolean hasPrior;
        List<ViewFactory> viewFactoryChain = this.subSelectHolder.getViewFactoryChain().getViewFactoryChain();
        boolean bl = hasPrior = this.viewResourceDelegate.getPerStream()[0].getPriorRequests() != null && !this.viewResourceDelegate.getPerStream()[0].getPriorRequests().isEmpty();
        if (hasPrior) {
            PriorEventViewFactory priorEventViewFactory = EPStatementStartMethodHelperPrior.getPriorEventViewFactory(agentInstanceContext.getStatementContext(), 1024 + this.subqueryNumber, viewFactoryChain.size() + 1, viewFactoryChain.isEmpty());
            viewFactoryChain = new ArrayList<ViewFactory>(viewFactoryChain);
            viewFactoryChain.add(priorEventViewFactory);
        }
        AgentInstanceViewFactoryChainContext viewFactoryChainContext = AgentInstanceViewFactoryChainContext.create(viewFactoryChain, agentInstanceContext, this.viewResourceDelegate.getPerStream()[0]);
        ViewServiceCreateResult createResult = services.getViewService().createViews(viewableRoot, viewFactoryChain, viewFactoryChainContext, false);
        final Viewable subselectView = createResult.getFinalViewable();
        final EventTable[] index = this.pair.getFirst().makeEventTables();
        stopCallbackList.add(new SubqueryStopCallback(index));
        SubordTableLookupStrategy strategy = this.pair.getSecond().makeStrategy(index, null);
        SubselectAggregationPreprocessorBase subselectAggregationPreprocessor = null;
        Map<ExprPriorNode, ExprPriorEvalStrategy> priorNodeStrategies = EPStatementStartMethodHelperPrior.compilePriorNodeStrategies(this.viewResourceDelegate, new AgentInstanceViewFactoryChainContext[]{viewFactoryChainContext});
        Map<ExprPreviousNode, ExprPreviousEvalStrategy> previousNodeStrategies = EPStatementStartMethodHelperPrevious.compilePreviousNodeStrategies(this.viewResourceDelegate, new AgentInstanceViewFactoryChainContext[]{viewFactoryChainContext});
        AggregationService aggregationService = null;
        if (this.aggregationServiceFactory != null) {
            aggregationService = this.aggregationServiceFactory.getAggregationServiceFactory().makeService(agentInstanceContext, agentInstanceContext.getStatementContext().getMethodResolutionService());
            if (!this.correlatedSubquery) {
                SubselectAggregatorViewBase aggregatorView = this.groupKeys == null ? (this.filterExprEval == null ? new SubselectAggregatorViewUnfilteredUngrouped(aggregationService, this.filterExprEval, agentInstanceContext, null) : new SubselectAggregatorViewFilteredUngrouped(aggregationService, this.filterExprEval, agentInstanceContext, null, this.filterExprNode)) : (this.filterExprEval == null ? new SubselectAggregatorViewUnfilteredGrouped(aggregationService, this.filterExprEval, agentInstanceContext, this.groupKeys) : new SubselectAggregatorViewFilteredGrouped(aggregationService, this.filterExprEval, agentInstanceContext, this.groupKeys, this.filterExprNode));
                subselectView.addView(aggregatorView);
                this.preload(services, null, aggregatorView, agentInstanceContext);
                return new SubSelectStrategyRealization(NULL_ROW_STRATEGY, null, aggregationService, priorNodeStrategies, previousNodeStrategies, subselectView, null);
            }
            subselectAggregationPreprocessor = this.groupKeys == null ? (this.filterExprEval == null ? new SubselectAggregationPreprocessorUnfilteredUngrouped(aggregationService, this.filterExprEval, null) : new SubselectAggregationPreprocessorFilteredUngrouped(aggregationService, this.filterExprEval, null)) : (this.filterExprEval == null ? new SubselectAggregationPreprocessorUnfilteredGrouped(aggregationService, this.filterExprEval, this.groupKeys) : new SubselectAggregationPreprocessorFilteredGrouped(aggregationService, this.filterExprEval, this.groupKeys));
        }
        this.preload(services, index, subselectView, agentInstanceContext);
        StatementAgentInstancePostLoad postLoad = new StatementAgentInstancePostLoad(){

            @Override
            public void executePostLoad() {
                SubSelectStrategyFactoryLocalViewPreloaded.this.preload(services, index, subselectView, agentInstanceContext);
            }

            @Override
            public void acceptIndexVisitor(StatementAgentInstancePostLoadIndexVisitor visitor) {
                for (EventTable table : index) {
                    visitor.visit(table);
                }
            }
        };
        BufferView bufferView = new BufferView(this.subSelectHolder.getStreamNumber());
        bufferView.setObserver(new SubselectBufferObserver(index));
        subselectView.addView(bufferView);
        return new SubSelectStrategyRealization(strategy, subselectAggregationPreprocessor, aggregationService, priorNodeStrategies, previousNodeStrategies, subselectView, postLoad);
    }

    private void preload(EPServicesContext services, EventTable[] eventIndex, Viewable subselectView, AgentInstanceContext agentInstanceContext) {
        block14: {
            block13: {
                ArrayList<EventBean> eventsInWindow;
                if (!(this.subSelectHolder.getStreamSpecCompiled() instanceof NamedWindowConsumerStreamSpec)) break block13;
                NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)this.subSelectHolder.getStreamSpecCompiled();
                NamedWindowProcessor processor = services.getNamedWindowService().getProcessor(namedSpec.getWindowName());
                if (processor == null) {
                    throw new RuntimeException("Failed to find named window by name '" + namedSpec.getWindowName() + "'");
                }
                NamedWindowProcessorInstance processorInstance = processor.getProcessorInstance(agentInstanceContext);
                if (processorInstance == null) {
                    throw new EPException("Named window '" + namedSpec.getWindowName() + "' is associated to context '" + processor.getContextName() + "' that is not available for querying");
                }
                NamedWindowTailViewInstance consumerView = processorInstance.getTailViewInstance();
                if (namedSpec.getFilterExpressions() != null && !namedSpec.getFilterExpressions().isEmpty()) {
                    try {
                        StreamTypeServiceImpl types = new StreamTypeServiceImpl(consumerView.getEventType(), consumerView.getEventType().getName(), false, services.getEngineURI());
                        LinkedHashMap<String, Pair<EventType, String>> tagged = new LinkedHashMap<String, Pair<EventType, String>>();
                        FilterSpecCompiled filterSpecCompiled = FilterSpecCompiler.makeFilterSpec(types.getEventTypes()[0], types.getStreamNames()[0], namedSpec.getFilterExpressions(), null, tagged, tagged, types, null, agentInstanceContext.getStatementContext(), Collections.singleton(0));
                        Collection<EventBean> snapshot = consumerView.snapshotNoLock(filterSpecCompiled, agentInstanceContext.getStatementContext().getAnnotations());
                        eventsInWindow = new ArrayList(snapshot.size());
                        ExprNodeUtility.applyFilterExpressionsIterable(snapshot, namedSpec.getFilterExpressions(), agentInstanceContext, eventsInWindow);
                    }
                    catch (Exception ex) {
                        log.warn((Object)("Unexpected exception analyzing filter paths: " + ex.getMessage()), (Throwable)ex);
                        eventsInWindow = new ArrayList();
                        ExprNodeUtility.applyFilterExpressionsIterable(consumerView, namedSpec.getFilterExpressions(), agentInstanceContext, eventsInWindow);
                    }
                } else {
                    eventsInWindow = new ArrayList<EventBean>();
                    Iterator<EventBean> it = consumerView.iterator();
                    while (it.hasNext()) {
                        eventsInWindow.add(it.next());
                    }
                }
                EventBean[] newEvents = eventsInWindow.toArray(new EventBean[eventsInWindow.size()]);
                if (subselectView != null) {
                    ((View)subselectView).update(newEvents, null);
                }
                if (eventIndex == null) break block14;
                for (EventTable table : eventIndex) {
                    table.add(newEvents);
                }
                break block14;
            }
            Iterator<EventBean> it = subselectView.iterator();
            if (it != null && it.hasNext()) {
                ArrayList<EventBean> preloadEvents = new ArrayList<EventBean>();
                while (it.hasNext()) {
                    preloadEvents.add(it.next());
                }
                if (eventIndex != null) {
                    for (EventTable table : eventIndex) {
                        table.add(preloadEvents.toArray(new EventBean[preloadEvents.size()]));
                    }
                }
            }
        }
    }
}

