/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.deploy;

import com.espertech.esper.client.EventType;
import com.espertech.esper.client.deploy.Module;
import com.espertech.esper.client.deploy.ModuleItem;
import com.espertech.esper.client.deploy.ParseException;
import com.espertech.esper.core.deploy.EPDeploymentAdminImpl;
import com.espertech.esper.core.deploy.EPLModuleParseItem;
import com.espertech.esper.core.deploy.ParseNode;
import com.espertech.esper.core.deploy.ParseNodeComment;
import com.espertech.esper.core.deploy.ParseNodeExpression;
import com.espertech.esper.core.deploy.ParseNodeImport;
import com.espertech.esper.core.deploy.ParseNodeModule;
import com.espertech.esper.core.deploy.ParseNodeUses;
import com.espertech.esper.core.service.StatementEventTypeRef;
import com.espertech.esper.epl.generated.EsperEPL2GrammarLexer;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import com.espertech.esper.epl.parse.NoCaseSensitiveStream;
import com.espertech.esper.epl.parse.ParseHelper;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.filter.FilterService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPLModuleUtil {
    private static Log log = LogFactory.getLog(EPLModuleUtil.class);
    public static final String newline = System.getProperty("line.separator");

    public static Module readInternal(InputStream stream, String resourceName) throws IOException, ParseException {
        String strLine;
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        StringWriter buffer = new StringWriter();
        while ((strLine = br.readLine()) != null) {
            buffer.append(strLine);
            buffer.append(newline);
        }
        stream.close();
        return EPLModuleUtil.parseInternal(buffer.toString(), resourceName);
    }

    public static Module parseInternal(String buffer, String resourceName) throws IOException, ParseException {
        List<EPLModuleParseItem> semicolonSegments = EPLModuleUtil.parse(buffer.toString());
        ArrayList<ParseNode> nodes = new ArrayList<ParseNode>();
        for (EPLModuleParseItem segment : semicolonSegments) {
            nodes.add(EPLModuleUtil.getModule(segment, resourceName));
        }
        String moduleName = null;
        int count = 0;
        for (ParseNode node : nodes) {
            if (node instanceof ParseNodeComment) continue;
            if (node instanceof ParseNodeModule) {
                if (moduleName != null) {
                    throw new ParseException("Duplicate use of the 'module' keyword for resource '" + resourceName + "'");
                }
                if (count > 0) {
                    throw new ParseException("The 'module' keyword must be the first declaration in the module file for resource '" + resourceName + "'");
                }
                moduleName = ((ParseNodeModule)node).getModuleName();
            }
            ++count;
        }
        LinkedHashSet<String> uses = new LinkedHashSet<String>();
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        count = 0;
        for (ParseNode node : nodes) {
            if (node instanceof ParseNodeComment || node instanceof ParseNodeModule) continue;
            String message = "The 'uses' and 'import' keywords must be the first declaration in the module file or follow the 'module' declaration";
            if (node instanceof ParseNodeUses) {
                if (count > 0) {
                    throw new ParseException(message);
                }
                uses.add(((ParseNodeUses)node).getUses());
                continue;
            }
            if (node instanceof ParseNodeImport) {
                if (count > 0) {
                    throw new ParseException(message);
                }
                imports.add(((ParseNodeImport)node).getImported());
                continue;
            }
            ++count;
        }
        ArrayList<ModuleItem> items = new ArrayList<ModuleItem>();
        for (ParseNode node : nodes) {
            if (!(node instanceof ParseNodeComment) && !(node instanceof ParseNodeExpression)) continue;
            boolean isComments = node instanceof ParseNodeComment;
            items.add(new ModuleItem(node.getItem().getExpression(), isComments, node.getItem().getLineNum(), node.getItem().getStartChar(), node.getItem().getEndChar()));
        }
        return new Module(moduleName, resourceName, uses, imports, items, buffer);
    }

    public static List<EventType> undeployTypes(Set<String> referencedTypes, StatementEventTypeRef statementEventTypeRef, EventAdapterService eventAdapterService, FilterService filterService) {
        ArrayList<EventType> undeployedTypes = new ArrayList<EventType>();
        for (String typeName : referencedTypes) {
            EventTypeSPI spi;
            EventType type;
            boolean typeInUse = statementEventTypeRef.isInUse(typeName);
            if (typeInUse) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Event type '" + typeName + "' is in use, not removing type"));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Event type '" + typeName + "' is no longer in use, removing type"));
            }
            if ((type = eventAdapterService.getExistsTypeByName(typeName)) == null || (spi = (EventTypeSPI)type).getMetadata().isApplicationPreConfigured()) continue;
            eventAdapterService.removeType(typeName);
            undeployedTypes.add(spi);
            filterService.removeType(spi);
        }
        return undeployedTypes;
    }

    public static ParseNode getModule(EPLModuleParseItem item, String resourceName) throws ParseException, IOException {
        Token t;
        Token t2;
        NoCaseSensitiveStream input = new NoCaseSensitiveStream(new StringReader(item.getExpression()));
        EsperEPL2GrammarLexer lex = ParseHelper.newLexer((CharStream)input);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lex);
        tokenStream.fill();
        List tokens = tokenStream.getTokens();
        boolean isMeta = false;
        boolean isModule = false;
        boolean isUses = false;
        boolean isExpression = false;
        for (int beginIndex = 0; beginIndex < tokens.size() && (t2 = (Token)tokens.get(beginIndex)).getType() != -1; ++beginIndex) {
            if (t2.getType() == 185 || t2.getType() == 186 || t2.getType() == 187) {
                continue;
            }
            String tokenText = t2.getText().trim().toLowerCase();
            if (tokenText.equals("module")) {
                isModule = true;
                isMeta = true;
            } else if (tokenText.equals("uses")) {
                isUses = true;
                isMeta = true;
            } else if (tokenText.equals("import")) {
                isMeta = true;
            } else {
                isExpression = true;
                break;
            }
            ++beginIndex;
            ++beginIndex;
            break;
        }
        if (isExpression) {
            return new ParseNodeExpression(item);
        }
        if (!isMeta) {
            return new ParseNodeComment(item);
        }
        StringWriter buffer = new StringWriter();
        for (int i = beginIndex; i < tokens.size() && (t = (Token)tokens.get(i)).getType() != -1; ++i) {
            if (t.getType() != 191 && t.getType() != 178 && t.getType() != 161 && !t.getText().matches("[a-zA-Z]*")) {
                throw EPLModuleUtil.getMessage(isModule, isUses, resourceName, t.getType());
            }
            buffer.append(t.getText().trim());
        }
        String result = buffer.toString().trim();
        if (result.length() == 0) {
            throw EPLModuleUtil.getMessage(isModule, isUses, resourceName, -1);
        }
        if (isModule) {
            return new ParseNodeModule(item, result);
        }
        if (isUses) {
            return new ParseNodeUses(item, result);
        }
        return new ParseNodeImport(item, result);
    }

    private static ParseException getMessage(boolean module, boolean uses, String resourceName, int type) {
        String message = "Keyword '";
        message = module ? message + "module" : (uses ? message + "uses" : message + "import");
        message = message + "' must be followed by a name or package name (set of names separated by dots) for resource '" + resourceName + "'";
        if (type != -1) {
            String tokenName = EsperEPL2GrammarParser.getLexerTokenParaphrases().get(type);
            if (tokenName == null) {
                tokenName = EsperEPL2GrammarParser.getParserTokenParaphrases().get(type);
            }
            if (tokenName != null) {
                message = message + ", unexpected reserved keyword " + tokenName + " was encountered as part of the name";
            }
        }
        return new ParseException(message);
    }

    public static List<EPLModuleParseItem> parse(String module) throws ParseException {
        NoCaseSensitiveStream input;
        try {
            input = new NoCaseSensitiveStream(new StringReader(module));
        }
        catch (IOException ex) {
            log.error((Object)("Exception reading module expression: " + ex.getMessage()), (Throwable)ex);
            return null;
        }
        EsperEPL2GrammarLexer lex = ParseHelper.newLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
        try {
            tokens.fill();
        }
        catch (RuntimeException ex) {
            String message = "Unexpected exception recognizing module text";
            if (ex instanceof LexerNoViableAltException) {
                message = ParseHelper.hasControlCharacters(module) ? "Unrecognized control characters found in text, failed to parse text" : message + ", recognition failed for " + ex.toString();
            } else if (ex instanceof RecognitionException) {
                RecognitionException recog = (RecognitionException)ex;
                message = message + ", recognition failed for " + recog.toString();
            } else if (ex.getMessage() != null) {
                message = message + ": " + ex.getMessage();
            }
            message = message + " [" + module + "]";
            log.error((Object)message, (Throwable)ex);
            throw new ParseException(message);
        }
        ArrayList<EPLModuleParseItem> statements = new ArrayList<EPLModuleParseItem>();
        StringWriter current = new StringWriter();
        Integer lineNum = null;
        int charPosStart = 0;
        int charPos = 0;
        List tokenList = tokens.getTokens();
        Set<Integer> skippedSemicolonIndexes = EPLModuleUtil.getSkippedSemicolons(tokenList);
        int index = -1;
        for (Token token : tokenList) {
            boolean semi;
            Token t = token;
            boolean bl = semi = t.getType() == 177 && !skippedSemicolonIndexes.contains(++index);
            if (semi) {
                if (current.toString().trim().length() > 0) {
                    statements.add(new EPLModuleParseItem(current.toString().trim(), lineNum == null ? 0 : lineNum, charPosStart, charPos));
                    lineNum = null;
                }
                current = new StringWriter();
                continue;
            }
            if (lineNum == null && t.getType() != 185) {
                lineNum = t.getLine();
                charPosStart = charPos;
            }
            if (t.getType() == -1) continue;
            current.append(t.getText());
            charPos += t.getText().length();
        }
        if (current.toString().trim().length() > 0) {
            statements.add(new EPLModuleParseItem(current.toString().trim(), lineNum == null ? 0 : lineNum, 0, 0));
        }
        return statements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Module readFile(File file) throws IOException, ParseException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            Module module = EPLModuleUtil.readInternal(inputStream, file.getAbsolutePath());
            return module;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Error closing input stream", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Module readResource(String resource) throws IOException, ParseException {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            stream = EPDeploymentAdminImpl.class.getResourceAsStream(resource);
        }
        if (stream == null) {
            stream = EPDeploymentAdminImpl.class.getClassLoader().getResourceAsStream(stripped);
        }
        if (stream == null) {
            throw new IOException("Failed to find resource '" + resource + "' in classpath");
        }
        try {
            Module module = EPLModuleUtil.readInternal(stream, resource);
            return module;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                log.debug((Object)"Error closing input stream", (Throwable)e);
            }
        }
    }

    private static Set<Integer> getSkippedSemicolons(List<Token> tokens) {
        HashSet<Integer> result = null;
        int index = -1;
        for (Token token : tokens) {
            ++index;
            Token t = token;
            if (t.getType() != 122) continue;
            if (result == null) {
                result = new HashSet<Integer>();
            }
            EPLModuleUtil.getSkippedSemicolonsBetweenSquareBrackets(index, tokens, result);
        }
        return result == null ? Collections.emptySet() : result;
    }

    private static void getSkippedSemicolonsBetweenSquareBrackets(int index, List<Token> tokens, Set<Integer> result) {
        int indexFirstCurly = EPLModuleUtil.indexFirstToken(index, tokens, 145);
        int indexFirstSquare = EPLModuleUtil.indexFirstToken(index, tokens, 143);
        if (indexFirstSquare == -1) {
            return;
        }
        if (indexFirstCurly != -1 && indexFirstCurly < indexFirstSquare) {
            return;
        }
        int indexCloseSquare = EPLModuleUtil.findEndSquareBrackets(indexFirstSquare, tokens);
        if (indexCloseSquare == -1) {
            return;
        }
        for (int current = indexFirstSquare; current < indexCloseSquare; ++current) {
            Token t = tokens.get(current);
            if (t.getType() != 177) continue;
            result.add(current);
        }
    }

    private static int findEndSquareBrackets(int startIndex, List<Token> tokens) {
        int squareBracketDepth = 0;
        for (int index = startIndex + 1; index < tokens.size(); ++index) {
            Token t = tokens.get(index);
            if (t.getType() == 144) {
                if (squareBracketDepth == 0) {
                    return index;
                }
                --squareBracketDepth;
            }
            if (t.getType() != 143) continue;
            ++squareBracketDepth;
        }
        return -1;
    }

    private static int indexFirstToken(int startIndex, List<Token> tokens, int tokenType) {
        for (int index = startIndex; index < tokens.size(); ++index) {
            Token t = tokens.get(index);
            if (t.getType() != tokenType) continue;
            return index;
        }
        return -1;
    }
}

