/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EPServiceIsolationException;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.core.service.EPAdministratorHelper;
import com.espertech.esper.core.service.EPAdministratorIsolatedSPI;
import com.espertech.esper.core.service.EPIsolationUnitServices;
import com.espertech.esper.core.service.EPRuntimeIsolatedImpl;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.EPStatementSPI;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import com.espertech.esper.filter.FilterSet;
import com.espertech.esper.schedule.ScheduleSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPAdministratorIsolatedImpl
implements EPAdministratorIsolatedSPI {
    private static Log log = LogFactory.getLog(EPAdministratorIsolatedImpl.class);
    private final String isolatedServiceName;
    private final EPIsolationUnitServices services;
    private final EPServicesContext unisolatedServices;
    private final EPRuntimeIsolatedImpl isolatedRuntime;
    private final Set<String> statementNames = Collections.synchronizedSet(new HashSet());

    public EPAdministratorIsolatedImpl(String isolatedServiceName, EPIsolationUnitServices services, EPServicesContext unisolatedServices, EPRuntimeIsolatedImpl isolatedRuntime) {
        this.isolatedServiceName = isolatedServiceName;
        this.services = services;
        this.unisolatedServices = unisolatedServices;
        this.isolatedRuntime = isolatedRuntime;
    }

    @Override
    public EPStatement createEPL(String eplStatement, String statementName, Object userObject) throws EPException {
        return this.createEPLStatementId(eplStatement, statementName, userObject, null);
    }

    @Override
    public EPStatement createEPLStatementId(String eplStatement, String statementName, Object userObject, String statementId) throws EPException {
        SelectClauseStreamSelectorEnum defaultStreamSelector = SelectClauseStreamSelectorEnum.mapFromSODA(this.unisolatedServices.getConfigSnapshot().getEngineDefaults().getStreamSelection().getDefaultStreamSelector());
        StatementSpecRaw statementSpec = EPAdministratorHelper.compileEPL(eplStatement, eplStatement, true, statementName, this.unisolatedServices, defaultStreamSelector);
        EPStatement statement = this.unisolatedServices.getStatementLifecycleSvc().createAndStart(statementSpec, eplStatement, false, statementName, userObject, this.services, statementId, null);
        EPStatementSPI stmtSpi = (EPStatementSPI)statement;
        stmtSpi.getStatementContext().setInternalEventEngineRouteDest(this.isolatedRuntime);
        stmtSpi.setServiceIsolated(this.isolatedServiceName);
        this.statementNames.add(stmtSpi.getName());
        return statement;
    }

    @Override
    public String[] getStatementNames() {
        return this.statementNames.toArray(new String[this.statementNames.size()]);
    }

    @Override
    public void addStatement(String name) {
        this.statementNames.add(name);
    }

    @Override
    public void addStatement(EPStatement stmt) {
        this.addStatement(new EPStatement[]{stmt});
    }

    @Override
    public void addStatement(EPStatement[] stmt) {
        this.unisolatedServices.getEventProcessingRWLock().acquireWriteLock();
        try {
            long fromTime = this.unisolatedServices.getSchedulingService().getTime();
            long toTime = this.services.getSchedulingService().getTime();
            long delta = toTime - fromTime;
            HashSet<String> statementIds = new HashSet<String>();
            for (EPStatement aStmt : stmt) {
                if (aStmt == null) {
                    throw new EPServiceIsolationException("Illegal argument, a null value was provided in the statement list");
                }
                EPStatementSPI stmtSpi = (EPStatementSPI)aStmt;
                statementIds.add(stmtSpi.getStatementId());
                if (aStmt.getServiceIsolated() == null) continue;
                throw new EPServiceIsolationException("Statement named '" + aStmt.getName() + "' already in service isolation under '" + stmtSpi.getServiceIsolated() + "'");
            }
            this.unisolatedServices.getStatementIsolationService().beginIsolatingStatements(this.isolatedServiceName, this.services.getUnitId(), stmt);
            FilterSet filters = this.unisolatedServices.getFilterService().take(statementIds);
            ScheduleSet schedules = this.unisolatedServices.getSchedulingService().take(statementIds);
            this.services.getFilterService().apply(filters);
            this.services.getSchedulingService().apply(schedules);
            for (EPStatement aStmt : stmt) {
                EPStatementSPI stmtSpi = (EPStatementSPI)aStmt;
                stmtSpi.getStatementContext().setFilterService(this.services.getFilterService());
                stmtSpi.getStatementContext().setSchedulingService(this.services.getSchedulingService());
                stmtSpi.getStatementContext().setInternalEventEngineRouteDest(this.isolatedRuntime);
                stmtSpi.getStatementContext().getScheduleAdjustmentService().adjust(delta);
                this.statementNames.add(stmtSpi.getName());
                stmtSpi.setServiceIsolated(this.isolatedServiceName);
            }
            this.unisolatedServices.getStatementIsolationService().commitIsolatingStatements(this.isolatedServiceName, this.services.getUnitId(), stmt);
        }
        catch (EPServiceIsolationException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            this.unisolatedServices.getStatementIsolationService().rollbackIsolatingStatements(this.isolatedServiceName, this.services.getUnitId(), stmt);
            String message = "Unexpected exception taking statements: " + ex.getMessage();
            log.error((Object)message, (Throwable)ex);
            throw new EPException(message, ex);
        }
        finally {
            this.unisolatedServices.getEventProcessingRWLock().releaseWriteLock();
        }
    }

    @Override
    public void removeStatement(EPStatement stmt) {
        this.removeStatement(new EPStatement[]{stmt});
    }

    @Override
    public void removeStatement(EPStatement[] stmt) {
        this.unisolatedServices.getEventProcessingRWLock().acquireWriteLock();
        try {
            long fromTime = this.services.getSchedulingService().getTime();
            long toTime = this.unisolatedServices.getSchedulingService().getTime();
            long delta = toTime - fromTime;
            HashSet<String> statementIds = new HashSet<String>();
            for (EPStatement aStmt : stmt) {
                if (aStmt == null) {
                    throw new EPServiceIsolationException("Illegal argument, a null value was provided in the statement list");
                }
                EPStatementSPI stmtSpi = (EPStatementSPI)aStmt;
                statementIds.add(stmtSpi.getStatementId());
                if (aStmt.getServiceIsolated() == null) {
                    throw new EPServiceIsolationException("Statement named '" + aStmt.getName() + "' is not currently in service isolation");
                }
                if (aStmt.getServiceIsolated().equals(this.isolatedServiceName)) continue;
                throw new EPServiceIsolationException("Statement named '" + aStmt.getName() + "' not in this service isolation but under service isolation '" + aStmt.getName() + "'");
            }
            this.unisolatedServices.getStatementIsolationService().beginUnisolatingStatements(this.isolatedServiceName, this.services.getUnitId(), stmt);
            FilterSet filters = this.services.getFilterService().take(statementIds);
            ScheduleSet schedules = this.services.getSchedulingService().take(statementIds);
            this.unisolatedServices.getFilterService().apply(filters);
            this.unisolatedServices.getSchedulingService().apply(schedules);
            for (EPStatement aStmt : stmt) {
                EPStatementSPI stmtSpi = (EPStatementSPI)aStmt;
                stmtSpi.getStatementContext().setFilterService(this.unisolatedServices.getFilterService());
                stmtSpi.getStatementContext().setSchedulingService(this.unisolatedServices.getSchedulingService());
                stmtSpi.getStatementContext().setInternalEventEngineRouteDest(this.unisolatedServices.getInternalEventEngineRouteDest());
                stmtSpi.getStatementContext().getScheduleAdjustmentService().adjust(delta);
                this.statementNames.remove(stmtSpi.getName());
                stmtSpi.setServiceIsolated(null);
            }
            this.unisolatedServices.getStatementIsolationService().commitUnisolatingStatements(this.isolatedServiceName, this.services.getUnitId(), stmt);
        }
        catch (EPServiceIsolationException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            this.unisolatedServices.getStatementIsolationService().rollbackUnisolatingStatements(this.isolatedServiceName, this.services.getUnitId(), stmt);
            String message = "Unexpected exception taking statements: " + ex.getMessage();
            log.error((Object)message, (Throwable)ex);
            throw new EPException(message, ex);
        }
        finally {
            this.unisolatedServices.getEventProcessingRWLock().releaseWriteLock();
        }
    }

    public void removeAllStatements() {
        ArrayList<EPStatement> statements = new ArrayList<EPStatement>();
        for (String stmtName : this.statementNames) {
            EPStatement stmt = this.unisolatedServices.getStatementLifecycleSvc().getStatementByName(stmtName);
            if (stmt == null) {
                log.debug((Object)("Statement '" + stmtName + "', the statement could not be found"));
                continue;
            }
            if (stmt.getServiceIsolated() != null && !stmt.getServiceIsolated().equals(this.isolatedServiceName)) {
                log.error((Object)("Error returning statement '" + stmtName + "', the internal isolation information is incorrect, isolated service for statement is currently '" + stmt.getServiceIsolated() + "' and mismatches this isolated services named '" + this.isolatedServiceName + "'"));
                continue;
            }
            statements.add(stmt);
        }
        this.removeStatement(statements.toArray(new EPStatement[statements.size()]));
    }
}

